/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.ageingmobs.registry.ageing.criteria;

import com.shynieke.ageingmobs.registry.AgeingRegistry;
import com.shynieke.ageingmobs.registry.ageing.criteria.BaseCriteria;
import com.shynieke.ageingmobs.registry.ageing.iAgeing;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class EntityCriteria
extends BaseCriteria {
    private EntityType<? extends Entity> nearbyEntity;
    private CompoundTag nearbyEntityData;
    private int radius;

    public EntityCriteria(iAgeing ageing, EntityType<? extends Entity> nearbyEntity, CompoundTag nearbyEntityData, int radius) {
        super(ageing);
        this.nearbyEntity = nearbyEntity;
        this.nearbyEntityData = nearbyEntityData;
        this.radius = radius;
    }

    public EntityType<? extends Entity> getNearbyEntity() {
        return this.nearbyEntity;
    }

    public void setNearbyEntity(EntityType<? extends Entity> nearbyEntity) {
        this.nearbyEntity = nearbyEntity;
    }

    public CompoundTag getNearbyEntityData() {
        return this.nearbyEntityData;
    }

    public void setNearbyEntityData(CompoundTag nearbyEntityData) {
        this.nearbyEntityData = nearbyEntityData;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    @Override
    public boolean checkCriteria(Level level, Entity entityIn) {
        BlockPos entityPos = entityIn.blockPosition();
        int nearbyEntityAmount = 0;
        AABB areaHitbox = new AABB((double)((float)entityPos.getX() - 0.5f), (double)((float)entityPos.getY() - 0.5f), (double)((float)entityPos.getZ() - 0.5f), (double)((float)entityPos.getX() + 0.5f), (double)((float)entityPos.getY() + 0.5f), (double)((float)entityPos.getZ() + 0.5f)).expandTowards((double)(-this.getRadius()), (double)(-this.getRadius()), (double)(-this.getRadius())).expandTowards((double)this.getRadius(), (double)this.getRadius(), (double)this.getRadius());
        if (!level.getEntitiesOfClass(Entity.class, areaHitbox).isEmpty()) {
            for (Entity foundEntity : level.getEntitiesOfClass(Entity.class, areaHitbox)) {
                if (foundEntity instanceof Player || !foundEntity.getType().equals(this.getTransformedEntity())) continue;
                if (!this.getTransformedEntityData().isEmpty()) {
                    CompoundTag entityTag = AgeingRegistry.entityToNBT(foundEntity);
                    CompoundTag entityTag2 = this.getNearbyEntityData();
                    if (NbtUtils.compareNbt((Tag)entityTag2, (Tag)entityTag, (boolean)true)) continue;
                    ++nearbyEntityAmount;
                    continue;
                }
                ++nearbyEntityAmount;
            }
        }
        return nearbyEntityAmount != 0;
    }
}

