/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.ageingmobs.registry.ageing.criteria;

import com.shynieke.ageingmobs.registry.ageing.criteria.BaseCriteria;
import com.shynieke.ageingmobs.registry.ageing.iAgeing;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class LightCriteria
extends BaseCriteria {
    private int lightLevelMin;
    private int lightLevelMax;
    private boolean aloneBased;
    private boolean reversible;
    private boolean isReversing;

    public LightCriteria(iAgeing ageing, int lightLevelMin, int lightLevelMax, boolean aloneBased, boolean reversible) {
        super(ageing);
        this.lightLevelMin = lightLevelMin;
        this.lightLevelMax = lightLevelMax;
        this.aloneBased = aloneBased;
        this.reversible = reversible;
        this.isReversing = false;
    }

    public int getLightLevelMin() {
        return this.lightLevelMin;
    }

    public void setLightLevelMin(int lightLevelMin) {
        this.lightLevelMin = lightLevelMin;
    }

    public int getLightLevelMax() {
        return this.lightLevelMax;
    }

    public void setLightLevelMax(int lightLevelMax) {
        this.lightLevelMax = lightLevelMax;
    }

    public boolean isAloneBased() {
        return this.aloneBased;
    }

    public void setAloneBased(boolean aloneBased) {
        this.aloneBased = aloneBased;
    }

    public boolean isReversible() {
        return this.reversible;
    }

    public void setReversible(boolean reversible) {
        this.reversible = reversible;
    }

    @Override
    public boolean checkCriteria(Level level, Entity entityIn) {
        BlockPos entityPos = entityIn.blockPosition();
        int entityLight = level.getMaxLocalRawBrightness(entityPos);
        if (entityLight >= this.getLightLevelMin() && entityLight <= this.getLightLevelMax()) {
            if (this.isAloneBased()) {
                AABB areaHitbox = new AABB((double)((float)entityPos.getX() - 0.5f), (double)((float)entityPos.getY() - 0.5f), (double)((float)entityPos.getZ() - 0.5f), (double)((float)entityPos.getX() + 0.5f), (double)((float)entityPos.getY() + 0.5f), (double)((float)entityPos.getZ() + 0.5f)).expandTowards(-5.0, -5.0, -5.0).expandTowards(5.0, 5.0, 5.0);
                if (!level.getEntitiesOfClass(entityIn.getClass(), areaHitbox).contains(this.getEntity().create(level, EntitySpawnReason.CONVERSION))) {
                    this.isReversing = false;
                    return true;
                }
                if (this.isReversible()) {
                    this.isReversing = true;
                }
                return false;
            }
            this.isReversing = false;
            return true;
        }
        if (this.isReversible()) {
            this.isReversing = true;
        }
        return false;
    }

    @Override
    public boolean isReversing() {
        return this.isReversing;
    }
}

