/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.ageingmobs.registry.ageing.criteria;

import com.shynieke.ageingmobs.registry.ageing.criteria.BaseCriteria;
import com.shynieke.ageingmobs.registry.ageing.iAgeing;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class LiquidBasedCriteria
extends BaseCriteria {
    private String liquid;
    private boolean reversible;
    private boolean isReversing;

    public LiquidBasedCriteria(iAgeing ageing, String liquid, Boolean reversible) {
        super(ageing);
        this.liquid = liquid;
        this.reversible = reversible;
        this.isReversing = false;
    }

    public String getLiquid() {
        return this.liquid;
    }

    public void setLiquid(String liquid) {
        this.liquid = liquid;
    }

    public boolean isReversible() {
        return this.reversible;
    }

    public void setReversible(boolean reversible) {
        this.reversible = reversible;
    }

    @Override
    public boolean checkCriteria(Level level, Entity entityIn) {
        boolean inFluid = entityIn.isFree(entityIn.getX(), entityIn.getY() - 1.0, entityIn.getZ());
        if (inFluid) {
            Optional fluidLoc = BuiltInRegistries.FLUID.getResourceKey((Object)level.getFluidState(entityIn.blockPosition().offset(0, -1, 0)).getType());
            if (fluidLoc.isPresent() && ((ResourceKey)fluidLoc.get()).location().equals((Object)ResourceLocation.tryParse((String)this.getLiquid()))) {
                this.isReversing = false;
                return true;
            }
            if (this.isReversible()) {
                this.isReversing = true;
            }
            return false;
        }
        if (this.isReversible()) {
            this.isReversing = true;
        }
        return false;
    }

    @Override
    public boolean isReversing() {
        return this.isReversing;
    }
}

