/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.ageingmobs.registry.ageing.criteria;

import com.shynieke.ageingmobs.AgeingMobs;
import com.shynieke.ageingmobs.registry.AgeingRegistry;
import com.shynieke.ageingmobs.registry.ageing.criteria.BaseCriteria;
import com.shynieke.ageingmobs.registry.ageing.iAgeing;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class MagicCriteria
extends BaseCriteria {
    private int range;

    public MagicCriteria(iAgeing ageing, int range) {
        super(ageing);
        this.range = range;
    }

    public int getRange() {
        return this.range;
    }

    public void setRange(int range) {
        this.range = range;
    }

    @Override
    public boolean checkCriteria(Level level, Entity entityIn) {
        BlockPos entityPos = entityIn.blockPosition();
        HashMap<Block, Double> magicMap = AgeingRegistry.INSTANCE.getMagicMap();
        if (!magicMap.isEmpty()) {
            double totalImportance = 0.0;
            BlockPos downPos = new BlockPos((Vec3i)entityPos.offset(-this.getRange(), -this.getRange(), -this.getRange()));
            BlockPos upPos = new BlockPos((Vec3i)entityPos.offset(this.getRange(), this.getRange(), this.getRange()));
            Iterator posIterator = BlockPos.betweenClosedStream((BlockPos)downPos, (BlockPos)upPos).iterator();
            while (posIterator.hasNext()) {
                BlockPos pos = (BlockPos)posIterator.next();
                Block foundState = level.getBlockState(pos).getBlock();
                if (!magicMap.containsKey(foundState)) continue;
                double importanceFound = magicMap.getOrDefault(foundState, 0.0);
                totalImportance += importanceFound;
            }
            return totalImportance > 0.0;
        }
        AgeingMobs.LOGGER.error("An error has occured. A criteria is using Magical Blocks but your config has no magical blocks specified.");
        return false;
    }
}

