/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.ageingmobs.registry.ageing.criteria;

import com.shynieke.ageingmobs.AgeingMobs;
import com.shynieke.ageingmobs.registry.ageing.criteria.BaseCriteria;
import com.shynieke.ageingmobs.registry.ageing.iAgeing;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class WeatherCriteria
extends BaseCriteria {
    private String weather;

    public WeatherCriteria(iAgeing ageing, String weather) {
        super(ageing);
        this.weather = weather;
    }

    public String getWeather() {
        return this.weather;
    }

    public void setWeather(String weather) {
        this.weather = weather;
    }

    @Override
    public boolean checkCriteria(Level level, Entity entityIn) {
        int wantedWeather = this.weatherPhaseFromString(this.getWeather());
        if (wantedWeather == 0) {
            return !level.isRaining();
        }
        if (wantedWeather == 1) {
            return level.isRaining() && !level.isThundering();
        }
        if (wantedWeather == 2) {
            return level.isThundering();
        }
        AgeingMobs.LOGGER.error("An error has occured. Criteria for ageing ID: {} is using the wrong syntax.", (Object)this.getUniqueID());
        return false;
    }

    public int weatherPhaseFromString(String weatherPhase) {
        return switch (weatherPhase) {
            default -> 0;
            case "rain" -> 1;
            case "thunder" -> 2;
        };
    }
}

