/*
 * Decompiled with CFR 0.152.
 */
package labs.ice.discordbridge;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.json.simple.JSONObject;

public class DiscordBridge
extends JavaPlugin
implements Listener {
    private String webhookUrl;

    public void onEnable() {
        this.saveDefaultConfig();
        this.webhookUrl = this.getConfig().getString("webhook-url");
        if (this.webhookUrl == null || this.webhookUrl.isEmpty()) {
            this.getLogger().severe("Webhook URL is not set in the config file!");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    public void onDisable() {
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        String playerName = event.getPlayer().getName();
        String message = playerName + ": " + event.getMessage();
        this.sendToDiscord("`" + message + "`");
    }

    private void sendToDiscord(String message) {
        try {
            URL url = new URL(this.webhookUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            JSONObject json = new JSONObject();
            json.put((Object)"content", (Object)message);
            try (OutputStream os = connection.getOutputStream();){
                os.write(json.toString().getBytes("UTF-8"));
                os.flush();
            }
            int responseCode = connection.getResponseCode();
            if (responseCode != 204) {
                this.getLogger().severe("Failed to send message to Discord: " + responseCode);
            }
        }
        catch (IOException e) {
            this.getLogger().severe("Error sending message to Discord: " + e.getMessage());
        }
    }
}

