# id compare
data modify storage superenchants:storage storage.compareTo set from entity @s Item.id
execute store success score #var1 superenchants run data modify storage superenchants:storage storage.compareTo set from entity @n[predicate=superenchants:valid_item,tag=!superenchants.enchant_to,tag=!superenchants.enchant_from,distance=0.001..0.5] Item.id
# if the items are different, they aren't combined
execute if score #var1 superenchants matches 1 run return 0

# tags
tag @s add superenchants.enchant_to
tag @n[predicate=superenchants:valid_item,tag=!superenchants.enchant_to,tag=!superenchants.enchant_from,distance=0.001..0.5] add superenchants.enchant_from

# the item's components are put into storage, then the enchantments are put into the scoreboard
data modify storage superenchants:storage storage.firstComponents set value {}
data modify storage superenchants:storage storage.firstComponents set from entity @s Item.components
function superenchants:internal/store/first_item_enchants

# the book's components are put into storage, then the enchantments are put into the scoreboard
data modify storage superenchants:storage storage.secondComponents set value {}
data modify storage superenchants:storage storage.secondComponents set from entity @n[tag=superenchants.enchant_from,distance=0.001..0.5] Item.components
execute as @n[tag=superenchants.enchant_from,distance=0.001..0.5] run function superenchants:internal/store/second_item_enchants

# applies the highest levels, if the levels are equal, that level is increased by one
execute if score $use_vanilla_max superenchants matches 0 run function superenchants:internal/apply_to/item
execute if score $use_vanilla_max superenchants matches 1 run function superenchants:internal/apply_to/item_vanilla

# the player's xp level is stored in the scoreboard
execute on origin store result score $origin superenchants.xp_levels run data get entity @s XpLevel

# whether the player is in creative is stored in the scoreboard
execute on origin store success score #var1 superenchants if entity @s[gamemode=creative]

# if vanilla max levels are disabled and the player's xp levels are less than needed, then a fail function is returned
execute if score #var1 superenchants matches 0 if score $use_vanilla_max superenchants matches 0 if score @s superenchants.xp_levels > $origin superenchants.xp_levels run return run function superenchants:internal/fail/not_enough_levels

# the player's xp levels are decreased
scoreboard players operation $origin superenchants.xp_levels -= @s superenchants.xp_levels
execute store result storage superenchants:storage storage.macro.value1 int 1 run scoreboard players get $origin superenchants.xp_levels
function superenchants:internal/macro/set_origin_levels with storage superenchants:storage storage.macro

# the durability of the items are combined
item modify entity @s container.0 {function:"set_damage",damage:0}
execute store result score #var3 superenchants run data get entity @s Item.components."minecraft:damage" 1
execute store result score #var1 superenchants run data get storage superenchants:storage storage.firstComponents."minecraft:damage"
execute store result score #var2 superenchants run data get storage superenchants:storage storage.secondComponents."minecraft:damage"

# var1 = first item durability
scoreboard players operation #var1 superenchants -= #var3 superenchants
scoreboard players operation #var1 superenchants *= #-1 superenchants

# var2 = second item durability
scoreboard players operation #var2 superenchants -= #var3 superenchants
scoreboard players operation #var2 superenchants *= #-1 superenchants

# var1 = first + second item durability
scoreboard players operation #var1 superenchants += #var2 superenchants

# var2 = max durability * 0.12
execute store result storage superenchants:storage storage.macro.value1 int 0.12 run scoreboard players get #var3 superenchants
execute store result score #var2 superenchants run data get storage superenchants:storage storage.macro.value1

# var1 += min(12% of max durability, max durability)
scoreboard players operation #var1 superenchants += #var2 superenchants
scoreboard players operation #var1 superenchants < #var3 superenchants

# var1 = new item uses
scoreboard players operation #var1 superenchants -= #var3 superenchants
scoreboard players operation #var1 superenchants *= #-1 superenchants

# new damage value is put into storage
execute store result storage superenchants:storage storage.firstComponents."minecraft:damage" int 1 run scoreboard players get #var1 superenchants

# the item's components are set from storage
data modify entity @s Item.components set from storage superenchants:storage storage.firstComponents

# score resetting
function superenchants:internal/reset_scores
execute as @n[tag=superenchants.enchant_from,distance=0.001..0.5] run function superenchants:internal/reset_scores

# kills the book that is being applied
kill @n[tag=superenchants.enchant_from,distance=0.001..0.5]

# particles and sound
particle minecraft:firework ~ ~0.5 ~ 0.15 0.15 0.15 0.025 64
playsound minecraft:block.anvil.use master @a ~ ~ ~ 1 1

tag @s remove superenchants.enchant_to
