# tags
tag @s add superenchants.enchant_to
tag @e[sort=nearest,limit=1,predicate=superenchants:valid_book,tag=!superenchants.enchant_to,tag=!superenchants.enchant_from,distance=0.001..0.5] add superenchants.enchant_from

# the item's tag are put into storage, then the enchantments are put into the scoreboard
data modify storage superenchants:storage storage.firstComponents set value {}
data modify storage superenchants:storage storage.firstComponents set from entity @s Item.tag
function superenchants:internal/store/first_item_enchants

# the book's tag are put into storage, then the enchantments are put into the scoreboard
data modify storage superenchants:storage storage.secondComponents set value {}
data modify storage superenchants:storage storage.secondComponents set from entity @e[sort=nearest,limit=1,tag=superenchants.enchant_from,distance=0.001..0.5] Item.tag
execute as @e[sort=nearest,limit=1,tag=superenchants.enchant_from,distance=0.001..0.5] run function superenchants:internal/store/second_book_enchants

# applies the highest levels, if the levels are equal, that level is increased by one
execute if score $use_vanilla_max superenchants matches 0 run function superenchants:internal/apply_to/item
execute if score $use_vanilla_max superenchants matches 1 run function superenchants:internal/apply_to/item_vanilla

# the player's xp level is stored in the scoreboard
execute on origin store result score $origin superenchants.xp_levels run data get entity @s XpLevel

# whether the player is in creative is stored in the scoreboard
scoreboard players set #var1 superenchants 0
execute on origin store success score #var1 superenchants if entity @s[gamemode=creative]
scoreboard players set #var2 superenchants 0

# if vanilla max levels are disabled and the player's xp levels are less than needed, then a fail function is returned
execute if score #var1 superenchants matches 0 if score $use_vanilla_max superenchants matches 0 if score @s superenchants.xp_levels > $origin superenchants.xp_levels run function superenchants:internal/fail/not_enough_levels
execute if score #var2 superenchants matches 1 run return 0

# the player's xp levels are decreased
execute if score #var1 superenchants matches 0 run scoreboard players operation $stored superenchants.xp_levels = @s superenchants.xp_levels
execute if score #var1 superenchants matches 0 on origin run function superenchants:internal/remove_levels/loop

# the item's tag are set from storage
data modify entity @s Item.tag set from storage superenchants:storage storage.firstComponents

# score resetting
function superenchants:internal/reset_scores
execute as @e[sort=nearest,limit=1,tag=superenchants.enchant_from,distance=0.001..0.5] run function superenchants:internal/reset_scores

# kills the book that is being applied
kill @e[sort=nearest,limit=1,tag=superenchants.enchant_from,distance=0.001..0.5]

# particles and sound
particle minecraft:firework ~ ~0.5 ~ 0.15 0.15 0.15 0.025 64
playsound minecraft:block.anvil.use master @a ~ ~ ~ 1 1

tag @s remove superenchants.enchant_to
