# tags
tag @s add superenchants.enchant_to
tag @e[sort=nearest,limit=1,predicate=superenchants:valid_book,tag=!superenchants.enchant_to,tag=!superenchants.enchant_from,distance=0.001..0.5] add superenchants.enchant_from

# the item's components are put into storage, then the enchantments are put into the scoreboard
data modify storage superenchants:storage storage.firstComponents set value {}
data modify storage superenchants:storage storage.firstComponents set from entity @s Item.components
function superenchants:internal/store/first_book_enchants

# the book's components are put into storage, then the enchantments are put into the scoreboard
data modify storage superenchants:storage storage.secondComponents set value {}
data modify storage superenchants:storage storage.secondComponents set from entity @e[sort=nearest,limit=1,tag=superenchants.enchant_from,distance=0.001..0.5] Item.components
execute as @e[sort=nearest,limit=1,tag=superenchants.enchant_from,distance=0.001..0.5] run function superenchants:internal/store/second_book_enchants

# applies the highest levels, if the levels are equal, that level is increased by one
execute if score $use_vanilla_max superenchants matches 0 run function superenchants:internal/apply_to/book
execute if score $use_vanilla_max superenchants matches 1 run function superenchants:internal/apply_to/book_vanilla

# the player's xp level is stored in the scoreboard
execute on origin store result score $origin superenchants.xp_levels run data get entity @s XpLevel

# if vanilla max levels are disabled and the player's xp levels are less than needed, then a fail function is returned
execute if score $require_xp_levels superenchants matches 1 unless function superenchants:internal/return/origin_in_creative if score $use_vanilla_max superenchants matches 0 if score @s superenchants.xp_levels > $origin superenchants.xp_levels run return run function superenchants:internal/fail/not_enough_levels

# the player's xp levels are decreased
scoreboard players operation $origin superenchants.xp_levels -= @s superenchants.xp_levels
execute store result storage superenchants:storage storage.macro.value1 int 1 run scoreboard players get $origin superenchants.xp_levels
execute if score $require_xp_levels superenchants matches 1 run function superenchants:internal/macro/set_origin_levels with storage superenchants:storage storage.macro

# the item's components are set from storage
data modify entity @s Item.components set from storage superenchants:storage storage.firstComponents

# score resetting
function superenchants:internal/reset_scores
execute as @e[sort=nearest,limit=1,tag=superenchants.enchant_from,distance=0.001..0.5] run function superenchants:internal/reset_scores

# kills the book that is being applied
kill @e[sort=nearest,limit=1,tag=superenchants.enchant_from,distance=0.001..0.5]

# particles and sound
particle minecraft:firework ~ ~0.5 ~ 0.15 0.15 0.15 0.025 64
playsound minecraft:block.anvil.use master @a ~ ~ ~ 1 1

tag @s remove superenchants.enchant_to