/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.armorstand.debug;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.table.DefaultTableModel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import top.fifthlight.armorstand.state.ModelInstanceManager;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0002J\b\u0010\u000f\u001a\u00020\rH\u0002J\b\u0010\u0010\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ltop/fifthlight/armorstand/debug/ModelManagerDebugFrame;", "Ljavax/swing/JFrame;", "<init>", "()V", "itemTableItem", "Ljavax/swing/table/DefaultTableModel;", "modelTableItem", "itemTable", "Ljavax/swing/JTable;", "modelTable", "updateTimer", "Ljavax/swing/Timer;", "setupUI", "", "setupListeners", "startTracking", "updateData", "top_fifthlight_armorstand"})
@SourceDebugExtension(value={"SMAP\nModelManagerDebugFrame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelManagerDebugFrame.kt\ntop/fifthlight/armorstand/debug/ModelManagerDebugFrame\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,102:1\n216#2,2:103\n216#2,2:105\n*S KotlinDebug\n*F\n+ 1 ModelManagerDebugFrame.kt\ntop/fifthlight/armorstand/debug/ModelManagerDebugFrame\n*L\n62#1:103,2\n90#1:105,2\n*E\n"})
public final class ModelManagerDebugFrame
extends JFrame {
    @NotNull
    private final DefaultTableModel itemTableItem;
    @NotNull
    private final DefaultTableModel modelTableItem;
    @NotNull
    private final JTable itemTable;
    @NotNull
    private final JTable modelTable;
    @NotNull
    private final Timer updateTimer;

    public ModelManagerDebugFrame() {
        super("Model Manager Status");
        Object[] objectArray = new String[]{"UUID", "Status", "Last Access", "Time Left"};
        this.itemTableItem = new DefaultTableModel(objectArray, 0);
        objectArray = new String[]{"Path", "Status", "Is favorited"};
        this.modelTableItem = new DefaultTableModel(objectArray, 0);
        this.itemTable = new JTable(this.itemTableItem);
        this.modelTable = new JTable(this.modelTableItem);
        this.updateTimer = new Timer(1000, new ActionListener(this){
            final /* synthetic */ ModelManagerDebugFrame this$0;
            {
                this.this$0 = $receiver;
            }

            public final void actionPerformed(ActionEvent it) {
                ModelManagerDebugFrame.access$updateData(this.this$0);
            }
        });
        this.setupUI();
        this.setupListeners();
        this.startTracking();
    }

    private final void setupUI() {
        this.setDefaultCloseOperation(2);
        this.setPreferredSize(new Dimension(600, 400));
        this.setLayout(new BorderLayout());
        this.itemTable.setFillsViewportHeight(true);
        JSplitPane splitPane = new JSplitPane(0);
        this.add((Component)splitPane, "Center");
        splitPane.add((Component)new JScrollPane(this.itemTable), "top");
        splitPane.add((Component)new JScrollPane(this.modelTable), "bottom");
        this.pack();
        splitPane.setDividerLocation(0.5);
    }

    private final void setupListeners() {
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ ModelManagerDebugFrame this$0;
            {
                this.this$0 = $receiver;
            }

            public void windowClosed(WindowEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ModelManagerDebugFrame.access$getUpdateTimer$p(this.this$0).stop();
            }
        });
    }

    private final void startTracking() {
        this.updateData();
        this.updateTimer.start();
    }

    private final void updateData() {
        Object[] objectArray;
        Object[] item;
        boolean i;
        Map.Entry<UUID, ModelInstanceManager.ModelInstanceItem> entry;
        Map.Entry<Comparable<UUID>, Object> element$iv;
        long now = System.nanoTime();
        this.itemTableItem.setRowCount(0);
        Map<Comparable<UUID>, Object> $this$forEach$iv = ModelInstanceManager.INSTANCE.getModelInstanceItems();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Comparable<UUID>, Object>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            String lastAccessTime;
            String string;
            entry = element$iv = iterator.next();
            i = false;
            UUID uuid = entry.getKey();
            item = entry.getValue();
            objectArray = item;
            if (objectArray instanceof ModelInstanceManager.ModelInstanceItem.Failed) {
                string = "Empty";
            } else if (objectArray instanceof ModelInstanceManager.ModelInstanceItem.Model) {
                string = "Loaded";
            } else {
                throw new NoWhenBranchMatchedException();
            }
            String status = string;
            Object object2 = item instanceof ModelInstanceManager.ModelInstanceItem.Model ? (((ModelInstanceManager.ModelInstanceItem.Model)item).getLastAccessTime() == -1L ? "Self item" : (now - ((ModelInstanceManager.ModelInstanceItem.Model)item).getLastAccessTime()) / 1000000000L + "s") : (lastAccessTime = "N/A");
            if (item instanceof ModelInstanceManager.ModelInstanceItem.Model) {
                long expireTime = now - ((ModelInstanceManager.ModelInstanceItem.Model)item).getLastAccessTime();
                object = (30000000000L - expireTime) / 1000000000L + "s";
            } else {
                object = "N/A";
            }
            String timeLeft = object;
            Object[] objectArray2 = new String[]{uuid.toString(), status, lastAccessTime, timeLeft};
            this.itemTableItem.addRow(objectArray2);
        }
        this.modelTableItem.setRowCount(0);
        $this$forEach$iv = ModelInstanceManager.INSTANCE.getModelCaches();
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            String string;
            entry = element$iv = iterator.next();
            i = false;
            Path path2 = (Path)((Object)entry.getKey());
            item = (ModelInstanceManager.ModelCache)((Object)entry.getValue());
            objectArray = new Comparable[3];
            objectArray[0] = path2;
            Object[] objectArray3 = item;
            if (Intrinsics.areEqual((Object)objectArray3, (Object)ModelInstanceManager.ModelCache.Failed.INSTANCE)) {
                string = "Failed";
            } else if (objectArray3 instanceof ModelInstanceManager.ModelCache.Loaded) {
                string = "Loaded";
            } else {
                throw new NoWhenBranchMatchedException();
            }
            objectArray[1] = string;
            objectArray[2] = String.valueOf(ModelInstanceManager.INSTANCE.getFavoriteModelPaths().contains(path2));
            this.modelTableItem.addRow(objectArray);
        }
    }

    public static final /* synthetic */ Timer access$getUpdateTimer$p(ModelManagerDebugFrame $this) {
        return $this.updateTimer;
    }

    public static final /* synthetic */ void access$updateData(ModelManagerDebugFrame $this) {
        $this.updateData();
    }
}

