/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.armorstand.state;

import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.class_10055;
import net.minecraft.class_1299;
import net.minecraft.class_1496;
import net.minecraft.class_4050;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.fifthlight.armorstand.config.ConfigHolder;
import top.fifthlight.armorstand.config.GlobalConfig;
import top.fifthlight.armorstand.extension.internal.PlayerEntityRenderStateExtInternal;
import top.fifthlight.armorstand.state.FullAnimationSet;
import top.fifthlight.armorstand.ui.model.AnimationViewModel;
import top.fifthlight.armorstand.util.MathUtilKt;
import top.fifthlight.blazerod.animation.AnimationItem;
import top.fifthlight.blazerod.animation.Timeline;
import top.fifthlight.blazerod.model.Expression;
import top.fifthlight.blazerod.model.HumanoidTag;
import top.fifthlight.blazerod.model.ModelInstance;
import top.fifthlight.blazerod.model.NodeTransform;
import top.fifthlight.blazerod.model.RenderScene;
import top.fifthlight.blazerod.model.TransformId;
import top.fifthlight.blazerod.model.node.RenderNode;
import top.fifthlight.blazerod.model.resource.RenderExpression;
import top.fifthlight.blazerod.model.resource.RenderExpressionGroup;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u000f2\u00020\u0001:\u0006\r\u000e\u000f\u0010\u0011\u0012B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH&\u0082\u0001\u0003\u0013\u0014\u0015\u00a8\u0006\u0016"}, d2={"Ltop/fifthlight/armorstand/state/ModelController;", "", "<init>", "()V", "update", "", "uuid", "Ljava/util/UUID;", "vanillaState", "Lnet/minecraft/client/render/entity/state/PlayerEntityRenderState;", "apply", "instance", "Ltop/fifthlight/blazerod/model/ModelInstance;", "JointItem", "ExpressionItem", "Companion", "LiveUpdated", "Predefined", "LiveSwitched", "Ltop/fifthlight/armorstand/state/ModelController$LiveSwitched;", "Ltop/fifthlight/armorstand/state/ModelController$LiveUpdated;", "Ltop/fifthlight/armorstand/state/ModelController$Predefined;", "top_fifthlight_armorstand"})
public abstract sealed class ModelController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final long NANOSECONDS_PER_SECOND = 1000000000L;

    private ModelController() {
    }

    public void update(@NotNull UUID uuid, @NotNull class_10055 vanillaState) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)vanillaState, (String)"vanillaState");
    }

    public abstract void apply(@NotNull ModelInstance var1);

    public /* synthetic */ ModelController(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000bH\u0002J&\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\rJ&\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\rR\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Ltop/fifthlight/armorstand/state/ModelController$Companion;", "", "<init>", "()V", "getBone", "Ltop/fifthlight/armorstand/state/ModelController$JointItem;", "Ltop/fifthlight/blazerod/model/RenderScene;", "tag", "Ltop/fifthlight/blazerod/model/HumanoidTag;", "getExpression", "Ltop/fifthlight/armorstand/state/ModelController$ExpressionItem;", "Ltop/fifthlight/blazerod/model/Expression$Tag;", "NANOSECONDS_PER_SECOND", "", "invertHeadDirection", "", "getInvertHeadDirection", "()Z", "calculateBlinkProgress", "", "playerUuid", "Ljava/util/UUID;", "averageBlinkInterval", "blinkDuration", "currentTime", "", "top_fifthlight_armorstand"})
    @SourceDebugExtension(value={"SMAP\nModelController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelController.kt\ntop/fifthlight/armorstand/state/ModelController$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,320:1\n1#2:321\n295#3,2:322\n295#3,2:324\n*S KotlinDebug\n*F\n+ 1 ModelController.kt\ntop/fifthlight/armorstand/state/ModelController$Companion\n*L\n63#1:322,2\n64#1:324,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final JointItem getBone(RenderScene $this$getBone, HumanoidTag tag) {
            JointItem jointItem;
            RenderNode renderNode = (RenderNode)$this$getBone.getHumanoidTagMap().get(tag);
            if (renderNode != null) {
                RenderNode node = renderNode;
                boolean i = false;
                jointItem = new JointItem(node.getNodeIndex());
            } else {
                jointItem = null;
            }
            return jointItem;
        }

        private final ExpressionItem getExpression(RenderScene $this$getExpression, Expression.Tag tag) {
            ExpressionItem expressionItem;
            Object v0;
            block6: {
                Iterable $this$firstOrNull$iv = $this$getExpression.getExpressions();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    RenderExpression it = (RenderExpression)element$iv;
                    boolean i = false;
                    if (!(it.getTag() == tag)) continue;
                    v0 = element$iv;
                    break block6;
                }
                v0 = null;
            }
            RenderExpression renderExpression = v0;
            if (renderExpression != null) {
                RenderExpression it = renderExpression;
                boolean $i$f$firstOrNull = false;
                expressionItem = new ExpressionItem.Expression(it);
            } else {
                Object v3;
                block7: {
                    Iterable $this$firstOrNull$iv = $this$getExpression.getExpressionGroups();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        RenderExpressionGroup it = (RenderExpressionGroup)element$iv;
                        boolean j = false;
                        if (!(it.getTag() == tag)) continue;
                        v3 = element$iv;
                        break block7;
                    }
                    v3 = null;
                }
                RenderExpressionGroup renderExpressionGroup = v3;
                if (renderExpressionGroup != null) {
                    RenderExpressionGroup it = renderExpressionGroup;
                    boolean k = false;
                    expressionItem = new ExpressionItem.Group(it);
                } else {
                    expressionItem = null;
                }
            }
            return expressionItem;
        }

        private final boolean getInvertHeadDirection() {
            return ((GlobalConfig)ConfigHolder.INSTANCE.getConfig().getValue()).getInvertHeadDirection();
        }

        public final float calculateBlinkProgress(@NotNull UUID playerUuid, long averageBlinkInterval, long blinkDuration, long currentTime) {
            float f;
            Intrinsics.checkNotNullParameter((Object)playerUuid, (String)"playerUuid");
            long seed1 = playerUuid.getMostSignificantBits();
            long seed2 = playerUuid.getLeastSignificantBits();
            long seed = seed1 ^ seed2;
            long offsetMillis = RangesKt.coerceAtLeast((long)(seed % (averageBlinkInterval * (long)2)), (long)0L);
            long effectiveTime = currentTime + offsetMillis;
            long cycleProgress = effectiveTime % averageBlinkInterval;
            if (cycleProgress < blinkDuration) {
                float phase = (float)cycleProgress / (float)blinkDuration * (float)Math.PI;
                f = (float)Math.sin(phase);
            } else {
                f = 0.0f;
            }
            return f;
        }

        public final float calculateBlinkProgress(@NotNull UUID playerUuid, double averageBlinkInterval, double blinkDuration, long currentTime) {
            Intrinsics.checkNotNullParameter((Object)playerUuid, (String)"playerUuid");
            return this.calculateBlinkProgress(playerUuid, (long)(averageBlinkInterval * (double)1000000000L), (long)(blinkDuration * (double)1000000000L), currentTime);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0002\u000b\fB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J\u001a\u0010\u0004\u001a\u00020\u0005*\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u0082\u0001\u0002\r\u000e\u00a8\u0006\u000f"}, d2={"Ltop/fifthlight/armorstand/state/ModelController$ExpressionItem;", "", "<init>", "()V", "apply", "", "instance", "Ltop/fifthlight/blazerod/model/ModelInstance;", "weight", "", "Ltop/fifthlight/blazerod/model/resource/RenderExpression;", "Expression", "Group", "Ltop/fifthlight/armorstand/state/ModelController$ExpressionItem$Expression;", "Ltop/fifthlight/armorstand/state/ModelController$ExpressionItem$Group;", "top_fifthlight_armorstand"})
    @SourceDebugExtension(value={"SMAP\nModelController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelController.kt\ntop/fifthlight/armorstand/state/ModelController$ExpressionItem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,320:1\n1863#2,2:321\n*S KotlinDebug\n*F\n+ 1 ModelController.kt\ntop/fifthlight/armorstand/state/ModelController$ExpressionItem\n*L\n34#1:321,2\n*E\n"})
    private static abstract sealed class ExpressionItem {
        private ExpressionItem() {
        }

        public abstract void apply(@NotNull ModelInstance var1, float var2);

        public final void apply(@NotNull RenderExpression $this$apply, @NotNull ModelInstance instance, float weight) {
            Intrinsics.checkNotNullParameter((Object)$this$apply, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
            Iterable $this$forEach$iv = $this$apply.getBindings();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RenderExpression.Binding binding = (RenderExpression.Binding)element$iv;
                boolean i = false;
                if (binding instanceof RenderExpression.Binding.MorphTarget) {
                    instance.setGroupWeight(((RenderExpression.Binding.MorphTarget)binding).getMorphedPrimitiveIndex(), ((RenderExpression.Binding.MorphTarget)binding).getGroupIndex(), weight);
                    continue;
                }
                throw new NoWhenBranchMatchedException();
            }
        }

        public /* synthetic */ ExpressionItem(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Ltop/fifthlight/armorstand/state/ModelController$ExpressionItem$Expression;", "Ltop/fifthlight/armorstand/state/ModelController$ExpressionItem;", "expression", "Ltop/fifthlight/blazerod/model/resource/RenderExpression;", "<init>", "(Ltop/fifthlight/blazerod/model/resource/RenderExpression;)V", "getExpression", "()Ltop/fifthlight/blazerod/model/resource/RenderExpression;", "apply", "", "instance", "Ltop/fifthlight/blazerod/model/ModelInstance;", "weight", "", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "top_fifthlight_armorstand"})
        public static final class Expression
        extends ExpressionItem {
            @NotNull
            private final RenderExpression expression;

            public Expression(@NotNull RenderExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                super(null);
                this.expression = expression;
            }

            @NotNull
            public final RenderExpression getExpression() {
                return this.expression;
            }

            @Override
            public void apply(@NotNull ModelInstance instance, float weight) {
                Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
                this.apply(this.expression, instance, weight);
            }

            @NotNull
            public final RenderExpression component1() {
                return this.expression;
            }

            @NotNull
            public final Expression copy(@NotNull RenderExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                return new Expression(expression);
            }

            public static /* synthetic */ Expression copy$default(Expression expression, RenderExpression renderExpression, int i, Object object) {
                if ((i & 1) != 0) {
                    renderExpression = expression.expression;
                }
                return expression.copy(renderExpression);
            }

            @NotNull
            public String toString() {
                return "Expression(expression=" + this.expression + ")";
            }

            public int hashCode() {
                return this.expression.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Expression)) {
                    return false;
                }
                Expression expression = (Expression)other;
                return Intrinsics.areEqual((Object)this.expression, (Object)expression.expression);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Ltop/fifthlight/armorstand/state/ModelController$ExpressionItem$Group;", "Ltop/fifthlight/armorstand/state/ModelController$ExpressionItem;", "group", "Ltop/fifthlight/blazerod/model/resource/RenderExpressionGroup;", "<init>", "(Ltop/fifthlight/blazerod/model/resource/RenderExpressionGroup;)V", "getGroup", "()Ltop/fifthlight/blazerod/model/resource/RenderExpressionGroup;", "apply", "", "instance", "Ltop/fifthlight/blazerod/model/ModelInstance;", "weight", "", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "top_fifthlight_armorstand"})
        @SourceDebugExtension(value={"SMAP\nModelController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelController.kt\ntop/fifthlight/armorstand/state/ModelController$ExpressionItem$Group\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,320:1\n1863#2,2:321\n*S KotlinDebug\n*F\n+ 1 ModelController.kt\ntop/fifthlight/armorstand/state/ModelController$ExpressionItem$Group\n*L\n51#1:321,2\n*E\n"})
        public static final class Group
        extends ExpressionItem {
            @NotNull
            private final RenderExpressionGroup group;

            public Group(@NotNull RenderExpressionGroup group) {
                Intrinsics.checkNotNullParameter((Object)group, (String)"group");
                super(null);
                this.group = group;
            }

            @NotNull
            public final RenderExpressionGroup getGroup() {
                return this.group;
            }

            @Override
            public void apply(@NotNull ModelInstance instance, float weight) {
                Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
                Iterable $this$forEach$iv = this.group.getItems();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    RenderExpressionGroup.Item item = (RenderExpressionGroup.Item)element$iv;
                    boolean i = false;
                    RenderExpression expression = (RenderExpression)instance.getScene().getExpressions().get(item.getExpressionIndex());
                    this.apply(expression, instance, weight * item.getInfluence());
                }
            }

            @NotNull
            public final RenderExpressionGroup component1() {
                return this.group;
            }

            @NotNull
            public final Group copy(@NotNull RenderExpressionGroup group) {
                Intrinsics.checkNotNullParameter((Object)group, (String)"group");
                return new Group(group);
            }

            public static /* synthetic */ Group copy$default(Group group, RenderExpressionGroup renderExpressionGroup, int i, Object object) {
                if ((i & 1) != 0) {
                    renderExpressionGroup = group.group;
                }
                return group.copy(renderExpressionGroup);
            }

            @NotNull
            public String toString() {
                return "Group(group=" + this.group + ")";
            }

            public int hashCode() {
                return this.group.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Group)) {
                    return false;
                }
                Group group = (Group)other;
                return Intrinsics.areEqual((Object)this.group, (Object)group.group);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0017\u0010\n\u001a\u0013\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00070\u000b\u00a2\u0006\u0002\b\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ltop/fifthlight/armorstand/state/ModelController$JointItem;", "", "nodeIndex", "", "<init>", "(I)V", "update", "", "instance", "Ltop/fifthlight/blazerod/model/ModelInstance;", "func", "Lkotlin/Function1;", "Ltop/fifthlight/blazerod/model/NodeTransform$Decomposed;", "Lkotlin/ExtensionFunctionType;", "top_fifthlight_armorstand"})
    private static final class JointItem {
        private final int nodeIndex;

        public JointItem(int nodeIndex) {
            this.nodeIndex = nodeIndex;
        }

        public final void update(@NotNull ModelInstance instance, @NotNull Function1<? super NodeTransform.Decomposed, Unit> func) {
            Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
            Intrinsics.checkNotNullParameter(func, (String)"func");
            instance.setTransformDecomposed(this.nodeIndex, TransformId.RELATIVE_ANIMATION, func);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 %2\u00020\u0001:\u0002$%B%\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\fJ\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Ltop/fifthlight/armorstand/state/ModelController$LiveSwitched;", "Ltop/fifthlight/armorstand/state/ModelController;", "animationSet", "Ltop/fifthlight/armorstand/state/FullAnimationSet;", "head", "Ltop/fifthlight/armorstand/state/ModelController$JointItem;", "blinkExpression", "Ltop/fifthlight/armorstand/state/ModelController$ExpressionItem;", "<init>", "(Ltop/fifthlight/armorstand/state/FullAnimationSet;Ltop/fifthlight/armorstand/state/ModelController$JointItem;Ltop/fifthlight/armorstand/state/ModelController$ExpressionItem;)V", "scene", "Ltop/fifthlight/blazerod/model/RenderScene;", "(Ltop/fifthlight/blazerod/model/RenderScene;Ltop/fifthlight/armorstand/state/FullAnimationSet;)V", "state", "Ltop/fifthlight/armorstand/state/ModelController$LiveSwitched$State;", "item", "Ltop/fifthlight/blazerod/animation/AnimationItem;", "timeline", "Ltop/fifthlight/blazerod/animation/Timeline;", "reset", "", "bodyYaw", "", "headYaw", "headPitch", "blinkProgress", "getState", "vanillaState", "Lnet/minecraft/client/render/entity/state/PlayerEntityRenderState;", "update", "", "uuid", "Ljava/util/UUID;", "apply", "instance", "Ltop/fifthlight/blazerod/model/ModelInstance;", "State", "Companion", "top_fifthlight_armorstand"})
    public static final class LiveSwitched
    extends ModelController {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final FullAnimationSet animationSet;
        @Nullable
        private final JointItem head;
        @Nullable
        private final ExpressionItem blinkExpression;
        @NotNull
        private State state;
        @Nullable
        private AnimationItem item;
        @Nullable
        private Timeline timeline;
        private boolean reset;
        private float bodyYaw;
        private float headYaw;
        private float headPitch;
        private float blinkProgress;
        @NotNull
        private static final List<class_1299<? extends class_1496>> horseEntityTypes;

        private LiveSwitched(FullAnimationSet animationSet, JointItem head, ExpressionItem blinkExpression) {
            super(null);
            this.animationSet = animationSet;
            this.head = head;
            this.blinkExpression = blinkExpression;
            this.state = State.Idle.INSTANCE;
        }

        public LiveSwitched(@NotNull RenderScene scene, @NotNull FullAnimationSet animationSet) {
            Intrinsics.checkNotNullParameter((Object)scene, (String)"scene");
            Intrinsics.checkNotNullParameter((Object)animationSet, (String)"animationSet");
            this(animationSet, Companion.getBone(scene, HumanoidTag.HEAD), Companion.getExpression(scene, Expression.Tag.BLINK));
        }

        private final State getState(class_10055 vanillaState) {
            class_4050 class_40502 = vanillaState.field_53465;
            return switch (class_40502 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[class_40502.ordinal()]) {
                case 1 -> {
                    if (LiveSwitched.Companion.isSprinting(vanillaState)) {
                        yield State.Sprinting.INSTANCE;
                    }
                    if ((double)vanillaState.field_53405 > 0.2) {
                        yield State.Walking.INSTANCE;
                    }
                    yield State.Idle.INSTANCE;
                }
                case 2 -> {
                    if (CollectionsKt.contains((Iterable)horseEntityTypes, (Object)LiveSwitched.Companion.getVehicleType(vanillaState))) {
                        yield State.OnHorse.INSTANCE;
                    }
                    yield State.Riding.INSTANCE;
                }
                case 3 -> State.Sneaking.INSTANCE;
                case 4 -> State.ElytraFly.INSTANCE;
                case 5 -> State.Sleeping.INSTANCE;
                case 6 -> State.Swimming.INSTANCE;
                case 7 -> State.Dying.INSTANCE;
                default -> State.Idle.INSTANCE;
            };
        }

        @Override
        public void update(@NotNull UUID uuid, @NotNull class_10055 vanillaState) {
            AnimationItem newItem;
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Intrinsics.checkNotNullParameter((Object)vanillaState, (String)"vanillaState");
            this.bodyYaw = (float)Math.PI - MathUtilKt.toRadian(vanillaState.field_53446);
            this.headYaw = -MathUtilKt.toRadian(vanillaState.field_53447);
            this.headPitch = Companion.getInvertHeadDirection() ? MathUtilKt.toRadian(vanillaState.field_53448) : -MathUtilKt.toRadian(vanillaState.field_53448);
            this.blinkProgress = Companion.calculateBlinkProgress(uuid, 4.0, 0.25, System.nanoTime());
            State newState = this.getState(vanillaState);
            if (!Intrinsics.areEqual((Object)newState, (Object)this.state)) {
                this.state = newState;
            }
            if (!Intrinsics.areEqual((Object)(newItem = newState.getItem(this.animationSet)), (Object)this.item) || this.timeline == null) {
                double d = newItem.getDuration();
                double d2 = ((Number)AnimationViewModel.Companion.getPlaySpeed().getValue()).doubleValue();
                this.timeline = new Timeline(d, true, d2);
                this.item = newItem;
                this.reset = true;
            }
        }

        @Override
        public void apply(@NotNull ModelInstance instance) {
            block4: {
                Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
                Timeline timeline = this.timeline;
                if (timeline == null) {
                    return;
                }
                Timeline timeline2 = timeline;
                AnimationItem animationItem = this.item;
                if (animationItem == null) {
                    return;
                }
                AnimationItem item = animationItem;
                if (this.reset) {
                    instance.clearTransform();
                    this.reset = false;
                }
                double time2 = timeline2.getCurrentTime(System.nanoTime());
                item.apply(instance, (float)time2);
                instance.setTransformDecomposed(instance.getScene().getRootNode().getNodeIndex(), TransformId.RELATIVE_ANIMATION, (Function1)new Function1<NodeTransform.Decomposed, Unit>(this){
                    final /* synthetic */ LiveSwitched this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(NodeTransform.Decomposed $this$setTransformDecomposed) {
                        Intrinsics.checkNotNullParameter((Object)$this$setTransformDecomposed, (String)"$this$setTransformDecomposed");
                        $this$setTransformDecomposed.getRotation().rotationY(LiveSwitched.access$getBodyYaw$p(this.this$0));
                    }
                });
                JointItem jointItem = this.head;
                if (jointItem != null) {
                    jointItem.update(instance, (Function1<? super NodeTransform.Decomposed, Unit>)((Function1)new Function1<NodeTransform.Decomposed, Unit>(this){
                        final /* synthetic */ LiveSwitched this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(NodeTransform.Decomposed $this$update) {
                            Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
                            $this$update.getRotation().rotationYXZ(LiveSwitched.access$getHeadYaw$p(this.this$0), LiveSwitched.access$getHeadPitch$p(this.this$0), 0.0f);
                        }
                    }));
                }
                ExpressionItem expressionItem = this.blinkExpression;
                if (expressionItem == null) break block4;
                expressionItem.apply(instance, this.blinkProgress);
            }
        }

        public static final /* synthetic */ float access$getBodyYaw$p(LiveSwitched $this) {
            return $this.bodyYaw;
        }

        public static final /* synthetic */ float access$getHeadYaw$p(LiveSwitched $this) {
            return $this.headYaw;
        }

        public static final /* synthetic */ float access$getHeadPitch$p(LiveSwitched $this) {
            return $this.headPitch;
        }

        static {
            Object[] objectArray = new class_1299[]{class_1299.field_6139, class_1299.field_6067, class_1299.field_6057, class_1299.field_6074, class_1299.field_6075, class_1299.field_6048};
            horseEntityTypes = CollectionsKt.listOf((Object[])objectArray);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001e\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u00020\n*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR<\u0010\f\u001a0\u0012,\u0012*\u0012\u000e\b\u0001\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e \u000f*\u0014\u0012\u000e\b\u0001\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u00050\u00050\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ltop/fifthlight/armorstand/state/ModelController$LiveSwitched$Companion;", "", "<init>", "()V", "vehicleType", "Lnet/minecraft/entity/EntityType;", "Lnet/minecraft/client/render/entity/state/PlayerEntityRenderState;", "getVehicleType", "(Lnet/minecraft/client/render/entity/state/PlayerEntityRenderState;)Lnet/minecraft/entity/EntityType;", "isSprinting", "", "(Lnet/minecraft/client/render/entity/state/PlayerEntityRenderState;)Z", "horseEntityTypes", "", "Lnet/minecraft/entity/passive/AbstractHorseEntity;", "kotlin.jvm.PlatformType", "top_fifthlight_armorstand"})
        public static final class Companion {
            private Companion() {
            }

            private final class_1299<?> getVehicleType(class_10055 $this$vehicleType) {
                Intrinsics.checkNotNull((Object)$this$vehicleType, (String)"null cannot be cast to non-null type top.fifthlight.armorstand.extension.internal.PlayerEntityRenderStateExtInternal");
                return ((PlayerEntityRenderStateExtInternal)$this$vehicleType).armorStand$getRidingEntityType();
            }

            private final boolean isSprinting(class_10055 $this$isSprinting) {
                Intrinsics.checkNotNull((Object)$this$isSprinting, (String)"null cannot be cast to non-null type top.fifthlight.armorstand.extension.internal.PlayerEntityRenderStateExtInternal");
                return ((PlayerEntityRenderStateExtInternal)$this$isSprinting).armorStand$isSprinting();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\n\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u0082\u0001\n\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u00a8\u0006\u001c"}, d2={"Ltop/fifthlight/armorstand/state/ModelController$LiveSwitched$State;", "", "<init>", "()V", "getItem", "Ltop/fifthlight/blazerod/animation/AnimationItem;", "set", "Ltop/fifthlight/armorstand/state/FullAnimationSet;", "Idle", "Walking", "ElytraFly", "Swimming", "Sleeping", "Riding", "OnHorse", "Dying", "Sprinting", "Sneaking", "Ltop/fifthlight/armorstand/state/ModelController$LiveSwitched$State$Dying;", "Ltop/fifthlight/armorstand/state/ModelController$LiveSwitched$State$ElytraFly;", "Ltop/fifthlight/armorstand/state/ModelController$LiveSwitched$State$Idle;", "Ltop/fifthlight/armorstand/state/ModelController$LiveSwitched$State$OnHorse;", "Ltop/fifthlight/armorstand/state/ModelController$LiveSwitched$State$Riding;", "Ltop/fifthlight/armorstand/state/ModelController$LiveSwitched$State$Sleeping;", "Ltop/fifthlight/armorstand/state/ModelController$LiveSwitched$State$Sneaking;", "Ltop/fifthlight/armorstand/state/ModelController$LiveSwitched$State$Sprinting;", "Ltop/fifthlight/armorstand/state/ModelController$LiveSwitched$State$Swimming;", "Ltop/fifthlight/armorstand/state/ModelController$LiveSwitched$State$Walking;", "top_fifthlight_armorstand"})
        public static abstract sealed class State {
            private State() {
            }

            @NotNull
            public abstract AnimationItem getItem(@NotNull FullAnimationSet var1);

            public /* synthetic */ State(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001\u00a8\u0006\u0010"}, d2={"Ltop/fifthlight/armorstand/state/ModelController$LiveSwitched$State$Dying;", "Ltop/fifthlight/armorstand/state/ModelController$LiveSwitched$State;", "<init>", "()V", "getItem", "Ltop/fifthlight/blazerod/animation/AnimationItem;", "set", "Ltop/fifthlight/armorstand/state/FullAnimationSet;", "equals", "", "other", "", "hashCode", "", "toString", "", "top_fifthlight_armorstand"})
            public static final class Dying
            extends State {
                @NotNull
                public static final Dying INSTANCE = new Dying();

                private Dying() {
                    super(null);
                }

                @Override
                @NotNull
                public AnimationItem getItem(@NotNull FullAnimationSet set) {
                    Intrinsics.checkNotNullParameter((Object)set, (String)"set");
                    return set.getDie();
                }

                @NotNull
                public String toString() {
                    return "Dying";
                }

                public int hashCode() {
                    return 1209639240;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Dying)) {
                        return false;
                    }
                    Dying cfr_ignored_0 = (Dying)other;
                    return true;
                }
            }

            @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001\u00a8\u0006\u0010"}, d2={"Ltop/fifthlight/armorstand/state/ModelController$LiveSwitched$State$ElytraFly;", "Ltop/fifthlight/armorstand/state/ModelController$LiveSwitched$State;", "<init>", "()V", "getItem", "Ltop/fifthlight/blazerod/animation/AnimationItem;", "set", "Ltop/fifthlight/armorstand/state/FullAnimationSet;", "equals", "", "other", "", "hashCode", "", "toString", "", "top_fifthlight_armorstand"})
            public static final class ElytraFly
            extends State {
                @NotNull
                public static final ElytraFly INSTANCE = new ElytraFly();

                private ElytraFly() {
                    super(null);
                }

                @Override
                @NotNull
                public AnimationItem getItem(@NotNull FullAnimationSet set) {
                    Intrinsics.checkNotNullParameter((Object)set, (String)"set");
                    return set.getElytraFly();
                }

                @NotNull
                public String toString() {
                    return "ElytraFly";
                }

                public int hashCode() {
                    return 462805917;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof ElytraFly)) {
                        return false;
                    }
                    ElytraFly cfr_ignored_0 = (ElytraFly)other;
                    return true;
                }
            }

            @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001\u00a8\u0006\u0010"}, d2={"Ltop/fifthlight/armorstand/state/ModelController$LiveSwitched$State$Idle;", "Ltop/fifthlight/armorstand/state/ModelController$LiveSwitched$State;", "<init>", "()V", "getItem", "Ltop/fifthlight/blazerod/animation/AnimationItem;", "set", "Ltop/fifthlight/armorstand/state/FullAnimationSet;", "equals", "", "other", "", "hashCode", "", "toString", "", "top_fifthlight_armorstand"})
            public static final class Idle
            extends State {
                @NotNull
                public static final Idle INSTANCE = new Idle();

                private Idle() {
                    super(null);
                }

                @Override
                @NotNull
                public AnimationItem getItem(@NotNull FullAnimationSet set) {
                    Intrinsics.checkNotNullParameter((Object)set, (String)"set");
                    return set.getIdle();
                }

                @NotNull
                public String toString() {
                    return "Idle";
                }

                public int hashCode() {
                    return 1840264793;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Idle)) {
                        return false;
                    }
                    Idle cfr_ignored_0 = (Idle)other;
                    return true;
                }
            }

            @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001\u00a8\u0006\u0010"}, d2={"Ltop/fifthlight/armorstand/state/ModelController$LiveSwitched$State$OnHorse;", "Ltop/fifthlight/armorstand/state/ModelController$LiveSwitched$State;", "<init>", "()V", "getItem", "Ltop/fifthlight/blazerod/animation/AnimationItem;", "set", "Ltop/fifthlight/armorstand/state/FullAnimationSet;", "equals", "", "other", "", "hashCode", "", "toString", "", "top_fifthlight_armorstand"})
            public static final class OnHorse
            extends State {
                @NotNull
                public static final OnHorse INSTANCE = new OnHorse();

                private OnHorse() {
                    super(null);
                }

                @Override
                @NotNull
                public AnimationItem getItem(@NotNull FullAnimationSet set) {
                    Intrinsics.checkNotNullParameter((Object)set, (String)"set");
                    return set.getOnHorse();
                }

                @NotNull
                public String toString() {
                    return "OnHorse";
                }

                public int hashCode() {
                    return -645574503;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof OnHorse)) {
                        return false;
                    }
                    OnHorse cfr_ignored_0 = (OnHorse)other;
                    return true;
                }
            }

            @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001\u00a8\u0006\u0010"}, d2={"Ltop/fifthlight/armorstand/state/ModelController$LiveSwitched$State$Riding;", "Ltop/fifthlight/armorstand/state/ModelController$LiveSwitched$State;", "<init>", "()V", "getItem", "Ltop/fifthlight/blazerod/animation/AnimationItem;", "set", "Ltop/fifthlight/armorstand/state/FullAnimationSet;", "equals", "", "other", "", "hashCode", "", "toString", "", "top_fifthlight_armorstand"})
            public static final class Riding
            extends State {
                @NotNull
                public static final Riding INSTANCE = new Riding();

                private Riding() {
                    super(null);
                }

                @Override
                @NotNull
                public AnimationItem getItem(@NotNull FullAnimationSet set) {
                    Intrinsics.checkNotNullParameter((Object)set, (String)"set");
                    return set.getRide();
                }

                @NotNull
                public String toString() {
                    return "Riding";
                }

                public int hashCode() {
                    return -770010886;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Riding)) {
                        return false;
                    }
                    Riding cfr_ignored_0 = (Riding)other;
                    return true;
                }
            }

            @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001\u00a8\u0006\u0010"}, d2={"Ltop/fifthlight/armorstand/state/ModelController$LiveSwitched$State$Sleeping;", "Ltop/fifthlight/armorstand/state/ModelController$LiveSwitched$State;", "<init>", "()V", "getItem", "Ltop/fifthlight/blazerod/animation/AnimationItem;", "set", "Ltop/fifthlight/armorstand/state/FullAnimationSet;", "equals", "", "other", "", "hashCode", "", "toString", "", "top_fifthlight_armorstand"})
            public static final class Sleeping
            extends State {
                @NotNull
                public static final Sleeping INSTANCE = new Sleeping();

                private Sleeping() {
                    super(null);
                }

                @Override
                @NotNull
                public AnimationItem getItem(@NotNull FullAnimationSet set) {
                    Intrinsics.checkNotNullParameter((Object)set, (String)"set");
                    return set.getSleep();
                }

                @NotNull
                public String toString() {
                    return "Sleeping";
                }

                public int hashCode() {
                    return -1110732368;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Sleeping)) {
                        return false;
                    }
                    Sleeping cfr_ignored_0 = (Sleeping)other;
                    return true;
                }
            }

            @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001\u00a8\u0006\u0010"}, d2={"Ltop/fifthlight/armorstand/state/ModelController$LiveSwitched$State$Sneaking;", "Ltop/fifthlight/armorstand/state/ModelController$LiveSwitched$State;", "<init>", "()V", "getItem", "Ltop/fifthlight/blazerod/animation/AnimationItem;", "set", "Ltop/fifthlight/armorstand/state/FullAnimationSet;", "equals", "", "other", "", "hashCode", "", "toString", "", "top_fifthlight_armorstand"})
            public static final class Sneaking
            extends State {
                @NotNull
                public static final Sneaking INSTANCE = new Sneaking();

                private Sneaking() {
                    super(null);
                }

                @Override
                @NotNull
                public AnimationItem getItem(@NotNull FullAnimationSet set) {
                    Intrinsics.checkNotNullParameter((Object)set, (String)"set");
                    return set.getSneak();
                }

                @NotNull
                public String toString() {
                    return "Sneaking";
                }

                public int hashCode() {
                    return 660431955;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Sneaking)) {
                        return false;
                    }
                    Sneaking cfr_ignored_0 = (Sneaking)other;
                    return true;
                }
            }

            @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001\u00a8\u0006\u0010"}, d2={"Ltop/fifthlight/armorstand/state/ModelController$LiveSwitched$State$Sprinting;", "Ltop/fifthlight/armorstand/state/ModelController$LiveSwitched$State;", "<init>", "()V", "getItem", "Ltop/fifthlight/blazerod/animation/AnimationItem;", "set", "Ltop/fifthlight/armorstand/state/FullAnimationSet;", "equals", "", "other", "", "hashCode", "", "toString", "", "top_fifthlight_armorstand"})
            public static final class Sprinting
            extends State {
                @NotNull
                public static final Sprinting INSTANCE = new Sprinting();

                private Sprinting() {
                    super(null);
                }

                @Override
                @NotNull
                public AnimationItem getItem(@NotNull FullAnimationSet set) {
                    Intrinsics.checkNotNullParameter((Object)set, (String)"set");
                    return set.getSprint();
                }

                @NotNull
                public String toString() {
                    return "Sprinting";
                }

                public int hashCode() {
                    return 1368947747;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Sprinting)) {
                        return false;
                    }
                    Sprinting cfr_ignored_0 = (Sprinting)other;
                    return true;
                }
            }

            @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001\u00a8\u0006\u0010"}, d2={"Ltop/fifthlight/armorstand/state/ModelController$LiveSwitched$State$Swimming;", "Ltop/fifthlight/armorstand/state/ModelController$LiveSwitched$State;", "<init>", "()V", "getItem", "Ltop/fifthlight/blazerod/animation/AnimationItem;", "set", "Ltop/fifthlight/armorstand/state/FullAnimationSet;", "equals", "", "other", "", "hashCode", "", "toString", "", "top_fifthlight_armorstand"})
            public static final class Swimming
            extends State {
                @NotNull
                public static final Swimming INSTANCE = new Swimming();

                private Swimming() {
                    super(null);
                }

                @Override
                @NotNull
                public AnimationItem getItem(@NotNull FullAnimationSet set) {
                    Intrinsics.checkNotNullParameter((Object)set, (String)"set");
                    return set.getSwim();
                }

                @NotNull
                public String toString() {
                    return "Swimming";
                }

                public int hashCode() {
                    return 183688930;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Swimming)) {
                        return false;
                    }
                    Swimming cfr_ignored_0 = (Swimming)other;
                    return true;
                }
            }

            @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001\u00a8\u0006\u0010"}, d2={"Ltop/fifthlight/armorstand/state/ModelController$LiveSwitched$State$Walking;", "Ltop/fifthlight/armorstand/state/ModelController$LiveSwitched$State;", "<init>", "()V", "getItem", "Ltop/fifthlight/blazerod/animation/AnimationItem;", "set", "Ltop/fifthlight/armorstand/state/FullAnimationSet;", "equals", "", "other", "", "hashCode", "", "toString", "", "top_fifthlight_armorstand"})
            public static final class Walking
            extends State {
                @NotNull
                public static final Walking INSTANCE = new Walking();

                private Walking() {
                    super(null);
                }

                @Override
                @NotNull
                public AnimationItem getItem(@NotNull FullAnimationSet set) {
                    Intrinsics.checkNotNullParameter((Object)set, (String)"set");
                    return set.getWalk();
                }

                @NotNull
                public String toString() {
                    return "Walking";
                }

                public int hashCode() {
                    return 1820427476;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Walking)) {
                        return false;
                    }
                    Walking cfr_ignored_0 = (Walking)other;
                    return true;
                }
            }
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[class_4050.values().length];
                try {
                    nArray[class_4050.field_18076.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[class_4050.field_40118.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[class_4050.field_18081.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[class_4050.field_18077.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[class_4050.field_18078.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[class_4050.field_18079.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[class_4050.field_18082.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ltop/fifthlight/armorstand/state/ModelController$LiveUpdated;", "Ltop/fifthlight/armorstand/state/ModelController;", "center", "Ltop/fifthlight/armorstand/state/ModelController$JointItem;", "head", "blinkExpression", "Ltop/fifthlight/armorstand/state/ModelController$ExpressionItem;", "<init>", "(Ltop/fifthlight/armorstand/state/ModelController$JointItem;Ltop/fifthlight/armorstand/state/ModelController$JointItem;Ltop/fifthlight/armorstand/state/ModelController$ExpressionItem;)V", "scene", "Ltop/fifthlight/blazerod/model/RenderScene;", "(Ltop/fifthlight/blazerod/model/RenderScene;)V", "bodyYaw", "", "headYaw", "headPitch", "blinkProgress", "update", "", "uuid", "Ljava/util/UUID;", "vanillaState", "Lnet/minecraft/client/render/entity/state/PlayerEntityRenderState;", "apply", "instance", "Ltop/fifthlight/blazerod/model/ModelInstance;", "top_fifthlight_armorstand"})
    public static final class LiveUpdated
    extends ModelController {
        @Nullable
        private final JointItem center;
        @Nullable
        private final JointItem head;
        @Nullable
        private final ExpressionItem blinkExpression;
        private float bodyYaw;
        private float headYaw;
        private float headPitch;
        private float blinkProgress;

        private LiveUpdated(JointItem center, JointItem head, ExpressionItem blinkExpression) {
            super(null);
            this.center = center;
            this.head = head;
            this.blinkExpression = blinkExpression;
        }

        public LiveUpdated(@NotNull RenderScene scene) {
            Intrinsics.checkNotNullParameter((Object)scene, (String)"scene");
            this(Companion.getBone(scene, HumanoidTag.CENTER), Companion.getBone(scene, HumanoidTag.HEAD), Companion.getExpression(scene, Expression.Tag.BLINK));
        }

        @Override
        public void update(@NotNull UUID uuid, @NotNull class_10055 vanillaState) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Intrinsics.checkNotNullParameter((Object)vanillaState, (String)"vanillaState");
            this.bodyYaw = (float)Math.PI - MathUtilKt.toRadian(vanillaState.field_53446);
            this.headYaw = -MathUtilKt.toRadian(vanillaState.field_53447);
            this.headPitch = Companion.getInvertHeadDirection() ? MathUtilKt.toRadian(vanillaState.field_53448) : -MathUtilKt.toRadian(vanillaState.field_53448);
            this.blinkProgress = Companion.calculateBlinkProgress(uuid, 4.0, 0.25, System.nanoTime());
        }

        @Override
        public void apply(@NotNull ModelInstance instance) {
            block2: {
                Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
                JointItem jointItem = this.center;
                if (jointItem != null) {
                    jointItem.update(instance, (Function1<? super NodeTransform.Decomposed, Unit>)((Function1)new Function1<NodeTransform.Decomposed, Unit>(this){
                        final /* synthetic */ LiveUpdated this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(NodeTransform.Decomposed $this$update) {
                            Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
                            $this$update.getRotation().rotationY(LiveUpdated.access$getBodyYaw$p(this.this$0));
                        }
                    }));
                }
                JointItem jointItem2 = this.head;
                if (jointItem2 != null) {
                    jointItem2.update(instance, (Function1<? super NodeTransform.Decomposed, Unit>)((Function1)new Function1<NodeTransform.Decomposed, Unit>(this){
                        final /* synthetic */ LiveUpdated this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(NodeTransform.Decomposed $this$update) {
                            Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
                            $this$update.getRotation().rotationYXZ(LiveUpdated.access$getHeadYaw$p(this.this$0), LiveUpdated.access$getHeadPitch$p(this.this$0), 0.0f);
                        }
                    }));
                }
                ExpressionItem expressionItem = this.blinkExpression;
                if (expressionItem == null) break block2;
                expressionItem.apply(instance, this.blinkProgress);
            }
        }

        public static final /* synthetic */ float access$getBodyYaw$p(LiveUpdated $this) {
            return $this.bodyYaw;
        }

        public static final /* synthetic */ float access$getHeadYaw$p(LiveUpdated $this) {
            return $this.headYaw;
        }

        public static final /* synthetic */ float access$getHeadPitch$p(LiveUpdated $this) {
            return $this.headPitch;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Ltop/fifthlight/armorstand/state/ModelController$Predefined;", "Ltop/fifthlight/armorstand/state/ModelController;", "animation", "Ltop/fifthlight/blazerod/animation/AnimationItem;", "<init>", "(Ltop/fifthlight/blazerod/animation/AnimationItem;)V", "timeline", "Ltop/fifthlight/blazerod/animation/Timeline;", "getTimeline", "()Ltop/fifthlight/blazerod/animation/Timeline;", "apply", "", "instance", "Ltop/fifthlight/blazerod/model/ModelInstance;", "top_fifthlight_armorstand"})
    public static final class Predefined
    extends ModelController {
        @NotNull
        private final AnimationItem animation;
        @NotNull
        private final Timeline timeline;

        /*
         * WARNING - void declaration
         */
        public Predefined(@NotNull AnimationItem animation) {
            void timeline;
            Timeline timeline2;
            Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
            super(null);
            this.animation = animation;
            double d = this.animation.getDuration();
            double d2 = ((Number)AnimationViewModel.Companion.getPlaySpeed().getValue()).doubleValue();
            Timeline timeline3 = timeline2 = new Timeline(d, true, d2);
            Predefined predefined = this;
            boolean i = false;
            timeline.play(System.nanoTime());
            predefined.timeline = timeline2;
        }

        @NotNull
        public final Timeline getTimeline() {
            return this.timeline;
        }

        @Override
        public void apply(@NotNull ModelInstance instance) {
            Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
            double time2 = this.timeline.getCurrentTime(System.nanoTime());
            this.animation.apply(instance, (float)time2);
        }
    }
}

