/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.armorstand.state;

import com.mojang.logging.LogUtils;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import top.fifthlight.armorstand.config.ConfigHolder;
import top.fifthlight.armorstand.config.GlobalConfig;
import top.fifthlight.armorstand.state.AnimationSet;
import top.fifthlight.armorstand.state.AnimationSetLoader;
import top.fifthlight.armorstand.state.ClientModelPathManager;
import top.fifthlight.armorstand.state.FullAnimationSet;
import top.fifthlight.armorstand.state.ModelController;
import top.fifthlight.armorstand.state.ModelInstanceManager;
import top.fifthlight.blazerod.animation.AnimationItem;
import top.fifthlight.blazerod.animation.AnimationLoader;
import top.fifthlight.blazerod.model.Metadata;
import top.fifthlight.blazerod.model.Model;
import top.fifthlight.blazerod.model.ModelFileLoader;
import top.fifthlight.blazerod.model.ModelFileLoaders;
import top.fifthlight.blazerod.model.ModelInstance;
import top.fifthlight.blazerod.model.ModelLoader;
import top.fifthlight.blazerod.model.RenderScene;
import top.fifthlight.blazerod.model.animation.Animation;
import top.fifthlight.blazerod.util.RefCount;

@kotlin.Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u000234B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0012J\u0010\u0010(\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u0012H\u0002J\u0010\u0010)\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u0012H\u0002J\u0010\u0010*\u001a\u0004\u0018\u00010\u001b2\u0006\u0010+\u001a\u00020,J)\u0010-\u001a\u0004\u0018\u00010\u001b2\u0006\u0010.\u001a\u00020\u000e2\b\u0010/\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010+\u001a\u00020,\u00a2\u0006\u0002\u00100J\u000e\u00101\u001a\u00020&2\u0006\u0010/\u001a\u00020\tJ\u0006\u00102\u001a\u00020&R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n \u0006*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001d\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001b0\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0019R\u0011\u0010\u001d\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0014R\u000e\u0010\u001f\u001a\u00020 X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00120\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u00065"}, d2={"Ltop/fifthlight/armorstand/state/ModelInstanceManager;", "", "<init>", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "INSTANCE_EXPIRE_NS", "", "client", "Lnet/minecraft/client/MinecraftClient;", "Lnet/minecraft/client/MinecraftClient;", "selfUuid", "Ljava/util/UUID;", "getSelfUuid", "()Ljava/util/UUID;", "modelDir", "Ljava/nio/file/Path;", "getModelDir", "()Ljava/nio/file/Path;", "modelCaches", "", "Ltop/fifthlight/armorstand/state/ModelInstanceManager$ModelCache;", "getModelCaches", "()Ljava/util/Map;", "modelInstanceItems", "Ltop/fifthlight/armorstand/state/ModelInstanceManager$ModelInstanceItem;", "getModelInstanceItems", "defaultAnimationDir", "getDefaultAnimationDir", "MAX_CACHE_FAVORITE_MODEL_ITEMS", "", "favoriteModelPaths", "Ljava/util/ArrayDeque;", "getFavoriteModelPaths", "()Ljava/util/ArrayDeque;", "addFavoriteModelPath", "", "path", "loadModel", "loadCache", "getSelfItem", "load", "", "get", "uuid", "time", "(Ljava/util/UUID;Ljava/lang/Long;Z)Ltop/fifthlight/armorstand/state/ModelInstanceManager$ModelInstanceItem;", "cleanup", "initialize", "ModelCache", "ModelInstanceItem", "top_fifthlight_armorstand"})
@SourceDebugExtension(value={"SMAP\nModelInstanceManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelInstanceManager.kt\ntop/fifthlight/armorstand/state/ModelInstanceManager\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,247:1\n95#2:248\n135#2,2:249\n137#2:258\n1557#3:251\n1628#3,3:252\n1288#4,3:255\n381#5,7:259\n1#6:266\n*S KotlinDebug\n*F\n+ 1 ModelInstanceManager.kt\ntop/fifthlight/armorstand/state/ModelInstanceManager\n*L\n72#1:248\n72#1:249,2\n72#1:258\n90#1:251\n90#1:252,3\n99#1:255,3\n115#1:259,7\n*E\n"})
public final class ModelInstanceManager {
    @NotNull
    public static final ModelInstanceManager INSTANCE;
    private static final Logger LOGGER;
    public static final long INSTANCE_EXPIRE_NS = 30000000000L;
    private static final class_310 client;
    @NotNull
    private static final Path modelDir;
    @NotNull
    private static final Map<Path, ModelCache> modelCaches;
    @NotNull
    private static final Map<UUID, ModelInstanceItem> modelInstanceItems;
    @NotNull
    private static final Path defaultAnimationDir;
    private static final int MAX_CACHE_FAVORITE_MODEL_ITEMS = 5;
    @NotNull
    private static final ArrayDeque<Path> favoriteModelPaths;

    private ModelInstanceManager() {
    }

    private final UUID getSelfUuid() {
        class_746 class_7462 = ModelInstanceManager.client.field_1724;
        return class_7462 != null ? class_7462.method_5667() : null;
    }

    @NotNull
    public final Path getModelDir() {
        return modelDir;
    }

    @NotNull
    public final Map<Path, ModelCache> getModelCaches() {
        return modelCaches;
    }

    @NotNull
    public final Map<UUID, ModelInstanceItem> getModelInstanceItems() {
        return modelInstanceItems;
    }

    @NotNull
    public final Path getDefaultAnimationDir() {
        return defaultAnimationDir;
    }

    @NotNull
    public final ArrayDeque<Path> getFavoriteModelPaths() {
        return favoriteModelPaths;
    }

    public final void addFavoriteModelPath(@NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        if (favoriteModelPaths.contains(path2)) {
            return;
        }
        favoriteModelPaths.addFirst(path2);
        while (favoriteModelPaths.size() > 5) {
            favoriteModelPaths.removeLast();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ModelCache loadModel(Path path2) {
        Object object;
        List animations2;
        RenderScene scene;
        ModelFileLoader.LoadResult result2;
        long mark$iv$iv;
        block14: {
            AnimationSet defaultAnimationSet;
            block13: {
                void $this$fold$iv;
                List list;
                boolean $i$f$mapTo;
                RenderScene ex2;
                ModelFileLoader.LoadResult loadResult;
                boolean $i$f$measureTimedValue = false;
                TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
                boolean $i$f$measureTimedValue2 = false;
                mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
                boolean k = false;
                Path modelPath2 = modelDir.resolve(path2).toAbsolutePath();
                try {
                    Intrinsics.checkNotNull((Object)modelPath2);
                    loadResult = ModelFileLoaders.probeAndLoad$default((ModelFileLoaders)ModelFileLoaders.INSTANCE, (Path)modelPath2, null, (int)2, null);
                }
                catch (Exception ex2) {
                    LOGGER.warn("Model load failed", (Throwable)ex2);
                    return ModelCache.Failed.INSTANCE;
                }
                ModelFileLoader.LoadResult loadResult2 = loadResult;
                if (loadResult2 == null) {
                    return ModelCache.Failed.INSTANCE;
                }
                result2 = loadResult2;
                Model model = result2.getModel();
                if (model == null) {
                    return ModelCache.Failed.INSTANCE;
                }
                Model model2 = model;
                LOGGER.info("Model metadata: " + result2.getMetadata());
                try {
                    ex2 = new ModelLoader().loadModel(model2);
                }
                catch (Exception ex3) {
                    LOGGER.warn("Model scene load failed", (Throwable)ex3);
                    return ModelCache.Failed.INSTANCE;
                }
                scene = ex2;
                List list2 = result2.getAnimations();
                if (list2 != null) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = list2;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Animation animation = (Animation)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean i = false;
                        collection.add(AnimationLoader.INSTANCE.load(scene, (Animation)it));
                    }
                    list = (List)destination$iv$iv;
                } else {
                    list = CollectionsKt.emptyList();
                }
                animations2 = list;
                defaultAnimationSet = AnimationSetLoader.INSTANCE.load(scene, defaultAnimationDir);
                object = modelPath2.getParent();
                if (object == null) break block13;
                Path parentPath = object;
                $i$f$mapTo = false;
                String[] stringArray = new String[]{PathsKt.getNameWithoutExtension((Path)modelPath2), ((Object)modelPath2.getFileName()).toString()};
                stringArray = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)CollectionsKt.listOf((Object[])stringArray)), (Function1)((Function1)new Function1<String, Path>(parentPath){
                    final /* synthetic */ Path $parentPath;
                    {
                        this.$parentPath = $parentPath;
                        super(1);
                    }

                    public final Path invoke(String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return this.$parentPath.resolve(it + ".animations");
                    }
                }));
                boolean $i$f$fold = false;
                AnimationSet accumulator$iv = defaultAnimationSet;
                for (Object element$iv : $this$fold$iv) {
                    void path3;
                    Path path4 = (Path)element$iv;
                    AnimationSet acc = accumulator$iv;
                    boolean j = false;
                    Intrinsics.checkNotNull((Object)path3);
                    accumulator$iv = acc.plus(AnimationSetLoader.INSTANCE.load(scene, (Path)path3));
                }
                AnimationSet animationSet = accumulator$iv;
                object = animationSet;
                if (animationSet != null) break block14;
            }
            object = defaultAnimationSet;
        }
        Object modelAnimation2 = object;
        Metadata metadata = result2.getMetadata();
        ModelCache.Loaded result$iv$iv = new ModelCache.Loaded(metadata, scene, animations2, (AnimationSet)modelAnimation2);
        TimedValue timedValue = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        ModelCache.Loaded result3 = (ModelCache.Loaded)timedValue.component1();
        long duration = timedValue.component2-UwyO8pc();
        LOGGER.info("Model " + path2 + " loaded, duration: " + Duration.toString-impl((long)duration));
        return result3;
    }

    private final ModelCache loadCache(Path path2) {
        ModelCache modelCache;
        Map<Path, ModelCache> $this$getOrPut$iv = modelCaches;
        boolean $i$f$getOrPut = false;
        ModelCache value$iv = $this$getOrPut$iv.get(path2);
        if (value$iv == null) {
            boolean i = false;
            ModelCache item = INSTANCE.loadModel(path2);
            ModelCache.Loaded loaded = item instanceof ModelCache.Loaded ? (ModelCache.Loaded)item : null;
            if (loaded != null) {
                loaded.increaseReferenceCount();
            }
            ModelCache answer$iv = item;
            $this$getOrPut$iv.put(path2, answer$iv);
            modelCache = answer$iv;
        } else {
            modelCache = value$iv;
        }
        return modelCache;
    }

    @Nullable
    public final ModelInstanceItem getSelfItem(boolean load) {
        ModelInstanceItem modelInstanceItem;
        UUID uUID = this.getSelfUuid();
        if (uUID != null) {
            UUID it = uUID;
            boolean i = false;
            modelInstanceItem = INSTANCE.get(it, null, load);
        } else {
            modelInstanceItem = null;
        }
        return modelInstanceItem;
    }

    @Nullable
    public final ModelInstanceItem get(@NotNull UUID uuid, @Nullable Long time2, boolean load) {
        ModelInstanceItem modelInstanceItem;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        boolean isSelf = Intrinsics.areEqual((Object)uuid, (Object)this.getSelfUuid());
        if (isSelf && !((GlobalConfig)ConfigHolder.INSTANCE.getConfig().getValue()).getShowOtherPlayerModel()) {
            return null;
        }
        Path path2 = ClientModelPathManager.INSTANCE.getPath(uuid);
        if (path2 == null) {
            return null;
        }
        Long lastAccessTime = isSelf ? Long.valueOf(-1L) : time2;
        ModelInstanceItem item = modelInstanceItems.get(uuid);
        if (item != null) {
            if (Intrinsics.areEqual((Object)item.getPath(), (Object)path2)) {
                ModelInstanceItem.Model model = item instanceof ModelInstanceItem.Model ? (ModelInstanceItem.Model)item : null;
                if (model != null) {
                    ModelInstanceItem.Model it = model;
                    boolean j = false;
                    Long l = lastAccessTime;
                    if (l != null) {
                        long time3 = ((Number)l).longValue();
                        boolean i = false;
                        it.setLastAccessTime(time3);
                    }
                }
                return item;
            }
            if (lastAccessTime != null) {
                ModelInstanceItem prevItem = modelInstanceItems.remove(uuid);
                ModelInstanceItem.Model model = prevItem instanceof ModelInstanceItem.Model ? (ModelInstanceItem.Model)prevItem : null;
                if (model != null) {
                    model.decreaseReferenceCount();
                }
            }
        }
        if (lastAccessTime == null) {
            return null;
        }
        if (!load) {
            return null;
        }
        ModelCache cache = this.loadCache(path2);
        if (Intrinsics.areEqual((Object)cache, (Object)ModelCache.Failed.INSTANCE)) {
            modelInstanceItem = new ModelInstanceItem.Failed(path2);
        } else if (cache instanceof ModelCache.Loaded) {
            RenderScene scene = ((ModelCache.Loaded)cache).getScene();
            Object object = ((ModelCache.Loaded)cache).getAnimations();
            Metadata time3 = ((ModelCache.Loaded)cache).getMetadata();
            ModelInstance modelInstance = new ModelInstance(scene);
            ModelInstanceManager $this$get_u24lambda_u249 = this;
            boolean k = false;
            FullAnimationSet animationSet = FullAnimationSet.Companion.from(((ModelCache.Loaded)cache).getAnimationSet());
            AnimationItem animation = (AnimationItem)CollectionsKt.firstOrNull(((ModelCache.Loaded)cache).getAnimations());
            ModelController modelController = animationSet != null ? (ModelController)new ModelController.LiveSwitched(scene, animationSet) : (animation != null ? (ModelController)new ModelController.Predefined(animation) : (ModelController)new ModelController.LiveUpdated(scene));
            Object it = object = new ModelInstanceItem.Model(path2, (List<AnimationItem>)object, lastAccessTime, time3, modelInstance, modelController);
            boolean l = false;
            ((ModelInstanceItem.Model)it).increaseReferenceCount();
            modelInstanceItem = (ModelInstanceItem)object;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        ModelInstanceItem newItem = modelInstanceItem;
        ModelInstanceItem prevItem = modelInstanceItems.remove(uuid);
        ModelInstanceItem.Model model = prevItem instanceof ModelInstanceItem.Model ? (ModelInstanceItem.Model)prevItem : null;
        if (model != null) {
            model.decreaseReferenceCount();
        }
        modelInstanceItems.put(uuid, newItem);
        LOGGER.info("Loaded model " + path2 + " for uuid " + uuid);
        return newItem;
    }

    public static /* synthetic */ ModelInstanceItem get$default(ModelInstanceManager modelInstanceManager, UUID uUID, Long long_, boolean bl, int i, Object object) {
        if ((i & 4) != 0) {
            bl = true;
        }
        return modelInstanceManager.get(uUID, long_, bl);
    }

    public final void cleanup(long time2) {
        Set usedPaths = new LinkedHashSet();
        Function1 function1 = (Function1)new Function1<Map.Entry<UUID, ModelInstanceItem>, Boolean>(time2, (Set<Path>)usedPaths){
            final /* synthetic */ long $time;
            final /* synthetic */ Set<Path> $usedPaths;
            {
                this.$time = $time;
                this.$usedPaths = $usedPaths;
                super(1);
            }

            public final Boolean invoke(Map.Entry<UUID, ModelInstanceItem> entry) {
                boolean bl;
                boolean pathInvalid;
                Intrinsics.checkNotNullParameter(entry, (String)"<destruct>");
                UUID uuid = entry.getKey();
                ModelInstanceItem item = entry.getValue();
                if (Intrinsics.areEqual((Object)uuid, (Object)ModelInstanceManager.access$getSelfUuid(ModelInstanceManager.INSTANCE))) {
                    if (Intrinsics.areEqual((Object)item.getPath(), (Object)ClientModelPathManager.INSTANCE.getSelfPath())) {
                        return false;
                    }
                    ModelInstanceItem.Model model = item instanceof ModelInstanceItem.Model ? (ModelInstanceItem.Model)item : null;
                    if (model != null) {
                        model.decreaseReferenceCount();
                    }
                    return true;
                }
                boolean bl2 = pathInvalid = !Intrinsics.areEqual((Object)item.getPath(), (Object)ClientModelPathManager.INSTANCE.getPath(uuid));
                if (pathInvalid) {
                    ModelInstanceItem.Model model = item instanceof ModelInstanceItem.Model ? (ModelInstanceItem.Model)item : null;
                    if (model != null) {
                        model.decreaseReferenceCount();
                    }
                    return true;
                }
                ModelInstanceItem modelInstanceItem = item;
                if (modelInstanceItem instanceof ModelInstanceItem.Failed) {
                    bl = false;
                } else if (modelInstanceItem instanceof ModelInstanceItem.Model) {
                    boolean expired;
                    long timeSinceLastUsed = this.$time - ((ModelInstanceItem.Model)item).getLastAccessTime();
                    boolean bl3 = expired = timeSinceLastUsed > 30000000000L;
                    if (expired) {
                        ((ModelInstanceItem.Model)item).decreaseReferenceCount();
                    } else {
                        this.$usedPaths.add(((ModelInstanceItem.Model)item).getPath());
                    }
                    bl = expired;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return bl;
            }
        };
        modelInstanceItems.entrySet().removeIf(new Predicate(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ boolean test(Object p0) {
                return (Boolean)this.function.invoke(p0);
            }
        });
        function1 = (Function1)new Function1<Map.Entry<Path, ModelCache>, Boolean>((Set<Path>)usedPaths){
            final /* synthetic */ Set<Path> $usedPaths;
            {
                this.$usedPaths = $usedPaths;
                super(1);
            }

            public final Boolean invoke(Map.Entry<Path, ModelCache> entry) {
                boolean remove;
                Intrinsics.checkNotNullParameter(entry, (String)"<destruct>");
                Path path2 = entry.getKey();
                ModelCache item = entry.getValue();
                if (Intrinsics.areEqual((Object)path2, (Object)ClientModelPathManager.INSTANCE.getSelfPath())) {
                    return false;
                }
                if (ModelInstanceManager.INSTANCE.getFavoriteModelPaths().contains(path2)) {
                    return false;
                }
                boolean bl = remove = !this.$usedPaths.contains(path2);
                if (remove && item instanceof ModelCache.Loaded) {
                    ((ModelCache.Loaded)item).getScene().decreaseReferenceCount();
                }
                return remove;
            }
        };
        modelCaches.entrySet().removeIf(new /* invalid duplicate definition of identical inner class */);
    }

    public final void initialize() {
        WorldRenderEvents.AFTER_ENTITIES.register((Object)initialize.1.INSTANCE);
    }

    public static final /* synthetic */ UUID access$getSelfUuid(ModelInstanceManager $this) {
        return $this.getSelfUuid();
    }

    static {
        Object object;
        block3: {
            block2: {
                INSTANCE = new ModelInstanceManager();
                LOGGER = LogUtils.getLogger();
                client = class_310.method_1551();
                object = System.getProperty("armorstand.modelDir");
                if (object == null) break block2;
                String it = object;
                boolean i = false;
                Path path2 = Path.of(it, new String[0]).toAbsolutePath();
                object = path2;
                if (path2 != null) break block3;
            }
            Path path3 = FabricLoader.getInstance().getGameDir().resolve("models");
            object = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        }
        modelDir = object;
        modelCaches = new LinkedHashMap();
        modelInstanceItems = new LinkedHashMap();
        Path path4 = modelDir.resolve("animations");
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
        defaultAnimationDir = path4;
        favoriteModelPaths = new ArrayDeque();
    }

    @kotlin.Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Ltop/fifthlight/armorstand/state/ModelInstanceManager$ModelCache;", "", "<init>", "()V", "Failed", "Loaded", "Ltop/fifthlight/armorstand/state/ModelInstanceManager$ModelCache$Failed;", "Ltop/fifthlight/armorstand/state/ModelInstanceManager$ModelCache$Loaded;", "top_fifthlight_armorstand"})
    public static abstract sealed class ModelCache {
        private ModelCache() {
        }

        public /* synthetic */ ModelCache(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @kotlin.Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Ltop/fifthlight/armorstand/state/ModelInstanceManager$ModelCache$Failed;", "Ltop/fifthlight/armorstand/state/ModelInstanceManager$ModelCache;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "top_fifthlight_armorstand"})
        public static final class Failed
        extends ModelCache {
            @NotNull
            public static final Failed INSTANCE = new Failed();

            private Failed() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "Failed";
            }

            public int hashCode() {
                return -963499151;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Failed)) {
                    return false;
                }
                Failed cfr_ignored_0 = (Failed)other;
                return true;
            }
        }

        @kotlin.Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B/\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u000bH\u00c6\u0003J9\u0010\u001a\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u0096\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020\u001cH\u0096\u0001J\t\u0010$\u001a\u00020%H\u00d6\u0001R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010&\u001a\u00020\u001eX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0012\u0010)\u001a\u00020\"X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006,"}, d2={"Ltop/fifthlight/armorstand/state/ModelInstanceManager$ModelCache$Loaded;", "Ltop/fifthlight/blazerod/util/RefCount;", "Ltop/fifthlight/armorstand/state/ModelInstanceManager$ModelCache;", "metadata", "Ltop/fifthlight/blazerod/model/Metadata;", "scene", "Ltop/fifthlight/blazerod/model/RenderScene;", "animations", "", "Ltop/fifthlight/blazerod/animation/AnimationItem;", "animationSet", "Ltop/fifthlight/armorstand/state/AnimationSet;", "<init>", "(Ltop/fifthlight/blazerod/model/Metadata;Ltop/fifthlight/blazerod/model/RenderScene;Ljava/util/List;Ltop/fifthlight/armorstand/state/AnimationSet;)V", "getMetadata", "()Ltop/fifthlight/blazerod/model/Metadata;", "getScene", "()Ltop/fifthlight/blazerod/model/RenderScene;", "getAnimations", "()Ljava/util/List;", "getAnimationSet", "()Ltop/fifthlight/armorstand/state/AnimationSet;", "component1", "component2", "component3", "component4", "copy", "decreaseReferenceCount", "", "equals", "", "other", "", "hashCode", "", "increaseReferenceCount", "toString", "", "closed", "getClosed", "()Z", "referenceCount", "getReferenceCount", "()I", "top_fifthlight_armorstand"})
        public static final class Loaded
        extends ModelCache
        implements RefCount {
            @Nullable
            private final Metadata metadata;
            @NotNull
            private final RenderScene scene;
            @NotNull
            private final List<AnimationItem> animations;
            @NotNull
            private final AnimationSet animationSet;

            public Loaded(@Nullable Metadata metadata, @NotNull RenderScene scene, @NotNull List<AnimationItem> animations2, @NotNull AnimationSet animationSet) {
                Intrinsics.checkNotNullParameter((Object)scene, (String)"scene");
                Intrinsics.checkNotNullParameter(animations2, (String)"animations");
                Intrinsics.checkNotNullParameter((Object)animationSet, (String)"animationSet");
                super(null);
                this.metadata = metadata;
                this.scene = scene;
                this.animations = animations2;
                this.animationSet = animationSet;
            }

            @Nullable
            public final Metadata getMetadata() {
                return this.metadata;
            }

            @NotNull
            public final RenderScene getScene() {
                return this.scene;
            }

            @NotNull
            public final List<AnimationItem> getAnimations() {
                return this.animations;
            }

            @NotNull
            public final AnimationSet getAnimationSet() {
                return this.animationSet;
            }

            @Nullable
            public final Metadata component1() {
                return this.metadata;
            }

            @NotNull
            public final RenderScene component2() {
                return this.scene;
            }

            @NotNull
            public final List<AnimationItem> component3() {
                return this.animations;
            }

            @NotNull
            public final AnimationSet component4() {
                return this.animationSet;
            }

            @NotNull
            public final Loaded copy(@Nullable Metadata metadata, @NotNull RenderScene scene, @NotNull List<AnimationItem> animations2, @NotNull AnimationSet animationSet) {
                Intrinsics.checkNotNullParameter((Object)scene, (String)"scene");
                Intrinsics.checkNotNullParameter(animations2, (String)"animations");
                Intrinsics.checkNotNullParameter((Object)animationSet, (String)"animationSet");
                return new Loaded(metadata, scene, animations2, animationSet);
            }

            public static /* synthetic */ Loaded copy$default(Loaded loaded, Metadata metadata, RenderScene renderScene, List list, AnimationSet animationSet, int i, Object object) {
                if ((i & 1) != 0) {
                    metadata = loaded.metadata;
                }
                if ((i & 2) != 0) {
                    renderScene = loaded.scene;
                }
                if ((i & 4) != 0) {
                    list = loaded.animations;
                }
                if ((i & 8) != 0) {
                    animationSet = loaded.animationSet;
                }
                return loaded.copy(metadata, renderScene, list, animationSet);
            }

            @NotNull
            public String toString() {
                return "Loaded(metadata=" + this.metadata + ", scene=" + this.scene + ", animations=" + this.animations + ", animationSet=" + this.animationSet + ")";
            }

            public int hashCode() {
                int result2 = this.metadata == null ? 0 : this.metadata.hashCode();
                result2 = result2 * 31 + this.scene.hashCode();
                result2 = result2 * 31 + ((Object)this.animations).hashCode();
                result2 = result2 * 31 + this.animationSet.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Loaded)) {
                    return false;
                }
                Loaded loaded = (Loaded)other;
                if (!Intrinsics.areEqual((Object)this.metadata, (Object)loaded.metadata)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.scene, (Object)loaded.scene)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.animations, loaded.animations)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.animationSet, (Object)loaded.animationSet);
            }

            public void increaseReferenceCount() {
                this.scene.increaseReferenceCount();
            }

            public void decreaseReferenceCount() {
                this.scene.decreaseReferenceCount();
            }

            public boolean getClosed() {
                return this.scene.getClosed();
            }

            public int getReferenceCount() {
                return this.scene.getReferenceCount();
            }
        }
    }

    @kotlin.Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0002\u0006\u0007R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0002\b\t\u00a8\u0006\n"}, d2={"Ltop/fifthlight/armorstand/state/ModelInstanceManager$ModelInstanceItem;", "", "path", "Ljava/nio/file/Path;", "getPath", "()Ljava/nio/file/Path;", "Failed", "Model", "Ltop/fifthlight/armorstand/state/ModelInstanceManager$ModelInstanceItem$Failed;", "Ltop/fifthlight/armorstand/state/ModelInstanceManager$ModelInstanceItem$Model;", "top_fifthlight_armorstand"})
    public static sealed interface ModelInstanceItem {
        @NotNull
        public Path getPath();

        @kotlin.Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Ltop/fifthlight/armorstand/state/ModelInstanceManager$ModelInstanceItem$Failed;", "Ltop/fifthlight/armorstand/state/ModelInstanceManager$ModelInstanceItem;", "path", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "getPath", "()Ljava/nio/file/Path;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "top_fifthlight_armorstand"})
        public static final class Failed
        implements ModelInstanceItem {
            @NotNull
            private final Path path;

            public Failed(@NotNull Path path2) {
                Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                this.path = path2;
            }

            @Override
            @NotNull
            public Path getPath() {
                return this.path;
            }

            @NotNull
            public final Path component1() {
                return this.path;
            }

            @NotNull
            public final Failed copy(@NotNull Path path2) {
                Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                return new Failed(path2);
            }

            public static /* synthetic */ Failed copy$default(Failed failed, Path path2, int i, Object object) {
                if ((i & 1) != 0) {
                    path2 = failed.path;
                }
                return failed.copy(path2);
            }

            @NotNull
            public String toString() {
                return "Failed(path=" + this.path + ")";
            }

            public int hashCode() {
                return ((Object)this.path).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Failed)) {
                    return false;
                }
                Failed failed = (Failed)other;
                return Intrinsics.areEqual((Object)this.path, (Object)failed.path);
            }
        }

        @kotlin.Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B?\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\t\u0010\"\u001a\u00020#H\u0096\u0001J\t\u0010$\u001a\u00020#H\u0096\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0012\u0010%\u001a\u00020&X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0012\u0010)\u001a\u00020*X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u00a8\u0006-"}, d2={"Ltop/fifthlight/armorstand/state/ModelInstanceManager$ModelInstanceItem$Model;", "Ltop/fifthlight/blazerod/util/RefCount;", "Ltop/fifthlight/armorstand/state/ModelInstanceManager$ModelInstanceItem;", "path", "Ljava/nio/file/Path;", "animations", "", "Ltop/fifthlight/blazerod/animation/AnimationItem;", "lastAccessTime", "", "metadata", "Ltop/fifthlight/blazerod/model/Metadata;", "instance", "Ltop/fifthlight/blazerod/model/ModelInstance;", "controller", "Ltop/fifthlight/armorstand/state/ModelController;", "<init>", "(Ljava/nio/file/Path;Ljava/util/List;JLtop/fifthlight/blazerod/model/Metadata;Ltop/fifthlight/blazerod/model/ModelInstance;Ltop/fifthlight/armorstand/state/ModelController;)V", "getPath", "()Ljava/nio/file/Path;", "getAnimations", "()Ljava/util/List;", "getLastAccessTime", "()J", "setLastAccessTime", "(J)V", "getMetadata", "()Ltop/fifthlight/blazerod/model/Metadata;", "getInstance", "()Ltop/fifthlight/blazerod/model/ModelInstance;", "getController", "()Ltop/fifthlight/armorstand/state/ModelController;", "setController", "(Ltop/fifthlight/armorstand/state/ModelController;)V", "decreaseReferenceCount", "", "increaseReferenceCount", "closed", "", "getClosed", "()Z", "referenceCount", "", "getReferenceCount", "()I", "top_fifthlight_armorstand"})
        public static final class Model
        implements RefCount,
        ModelInstanceItem {
            @NotNull
            private final Path path;
            @NotNull
            private final List<AnimationItem> animations;
            private long lastAccessTime;
            @Nullable
            private final Metadata metadata;
            @NotNull
            private final ModelInstance instance;
            @NotNull
            private ModelController controller;

            public Model(@NotNull Path path2, @NotNull List<AnimationItem> animations2, long lastAccessTime, @Nullable Metadata metadata, @NotNull ModelInstance instance, @NotNull ModelController controller) {
                Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                Intrinsics.checkNotNullParameter(animations2, (String)"animations");
                Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
                Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
                this.path = path2;
                this.animations = animations2;
                this.lastAccessTime = lastAccessTime;
                this.metadata = metadata;
                this.instance = instance;
                this.controller = controller;
            }

            @Override
            @NotNull
            public Path getPath() {
                return this.path;
            }

            @NotNull
            public final List<AnimationItem> getAnimations() {
                return this.animations;
            }

            public final long getLastAccessTime() {
                return this.lastAccessTime;
            }

            public final void setLastAccessTime(long l) {
                this.lastAccessTime = l;
            }

            @Nullable
            public final Metadata getMetadata() {
                return this.metadata;
            }

            @NotNull
            public final ModelInstance getInstance() {
                return this.instance;
            }

            @NotNull
            public final ModelController getController() {
                return this.controller;
            }

            public final void setController(@NotNull ModelController modelController) {
                Intrinsics.checkNotNullParameter((Object)modelController, (String)"<set-?>");
                this.controller = modelController;
            }

            public void increaseReferenceCount() {
                this.instance.increaseReferenceCount();
            }

            public void decreaseReferenceCount() {
                this.instance.decreaseReferenceCount();
            }

            public boolean getClosed() {
                return this.instance.getClosed();
            }

            public int getReferenceCount() {
                return this.instance.getReferenceCount();
            }
        }
    }
}

