/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.armorstand.animation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import top.fifthlight.armorstand.animation.AnimationChannelItem;
import top.fifthlight.armorstand.animation.AnimationItem;
import top.fifthlight.armorstand.model.RenderScene;
import top.fifthlight.renderer.model.HumanoidTag;
import top.fifthlight.renderer.model.Node;
import top.fifthlight.renderer.model.NodeId;
import top.fifthlight.renderer.model.animation.Animation;
import top.fifthlight.renderer.model.animation.AnimationChannel;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Ltop/fifthlight/armorstand/animation/AnimationLoader;", "", "<init>", "()V", "load", "Ltop/fifthlight/armorstand/animation/AnimationItem;", "scene", "Ltop/fifthlight/armorstand/model/RenderScene;", "animation", "Ltop/fifthlight/renderer/model/animation/Animation;", "top_fifthlight_armorstand"})
@SourceDebugExtension(value={"SMAP\nAnimationLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnimationLoader.kt\ntop/fifthlight/armorstand/animation/AnimationLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,47:1\n1617#2,9:48\n1869#2:57\n1870#2:59\n1626#2:60\n1#3:58\n1#3:61\n*S KotlinDebug\n*F\n+ 1 AnimationLoader.kt\ntop/fifthlight/armorstand/animation/AnimationLoader\n*L\n44#1:48,9\n44#1:57\n44#1:59\n44#1:60\n44#1:58\n*E\n"})
public final class AnimationLoader {
    @NotNull
    public static final AnimationLoader INSTANCE = new AnimationLoader();

    private AnimationLoader() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AnimationItem load(@NotNull RenderScene scene, @NotNull Animation animation) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)scene, (String)"scene");
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        Iterable iterable = animation.getChannels();
        String string = animation.getName();
        boolean $i$f$mapNotNull = false;
        void var5_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            AnimationChannelItem<?> it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean j$iv = false;
            AnimationChannel p0 = (AnimationChannel)element$iv$iv;
            boolean i$iv = false;
            if (AnimationLoader.load$mapAnimationChannel(scene, p0) == null) continue;
            i$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        String string2 = string;
        return new AnimationItem(string2, list2);
    }

    private static final Integer load$findTargetTransformIndex(RenderScene $scene, AnimationChannel<?> channel) {
        Node node = channel.getTargetNode();
        NodeId nodeId = node != null ? node.getId() : null;
        boolean j = false;
        Integer n = $scene.getNodeIdToTransformMap().getInt((Object)nodeId);
        int it = ((Number)n).intValue();
        boolean i2 = false;
        Integer n2 = it >= 0 ? n : null;
        Integer n3 = n2;
        if (n2 == null) {
            Integer n4;
            boolean k;
            int it2;
            String string = channel.getTargetNodeName();
            if (string != null) {
                String name = string;
                it = 0;
                Integer n5 = $scene.getNodeNameToTransformMap().getInt((Object)name);
                it2 = ((Number)n5).intValue();
                k = false;
                n4 = it2 >= 0 ? n5 : null;
            } else {
                n4 = n3 = null;
            }
            if (n4 == null) {
                HumanoidTag humanoidTag = channel.getTargetHumanoidTag();
                if (humanoidTag != null) {
                    HumanoidTag humanoid = humanoidTag;
                    it = 0;
                    Integer n6 = $scene.getHumanoidTagToTransformMap().getInt((Object)humanoid);
                    it2 = ((Number)n6).intValue();
                    k = false;
                    n3 = it2 >= 0 ? n6 : null;
                } else {
                    n3 = null;
                }
            }
        }
        return n3;
    }

    private static final AnimationChannelItem<?> load$mapAnimationChannel(RenderScene $scene, AnimationChannel<?> channel) {
        AnimationChannelItem animationChannelItem;
        Integer n = AnimationLoader.load$findTargetTransformIndex($scene, channel);
        if (n == null) {
            return null;
        }
        int index = n;
        AnimationChannel.Type<?> type2 = channel.getType();
        if (Intrinsics.areEqual(type2, (Object)AnimationChannel.Type.Translation.INSTANCE)) {
            Intrinsics.checkNotNull(channel, (String)"null cannot be cast to non-null type top.fifthlight.renderer.model.animation.AnimationChannel<org.joml.Vector3f>");
            animationChannelItem = new AnimationChannelItem.TranslationItem(index, channel);
        } else if (Intrinsics.areEqual(type2, (Object)AnimationChannel.Type.Scale.INSTANCE)) {
            Intrinsics.checkNotNull(channel, (String)"null cannot be cast to non-null type top.fifthlight.renderer.model.animation.AnimationChannel<org.joml.Vector3f>");
            animationChannelItem = new AnimationChannelItem.ScaleItem(index, channel);
        } else if (Intrinsics.areEqual(type2, (Object)AnimationChannel.Type.Rotation.INSTANCE)) {
            Intrinsics.checkNotNull(channel, (String)"null cannot be cast to non-null type top.fifthlight.renderer.model.animation.AnimationChannel<org.joml.Quaternionf>");
            animationChannelItem = new AnimationChannelItem.RotationItem(index, channel);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return animationChannelItem;
    }
}

