/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.armorstand.animation;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\nJ\u000e\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\nJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\nJ\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\nJ\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\nJ\u0016\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Ltop/fifthlight/armorstand/animation/Timeline;", "", "duration", "", "loop", "", "speed", "<init>", "(FZF)V", "startTime", "", "pausedTime", "isPaused", "isPlaying", "()Z", "isFinished", "currentNanos", "getCurrentTime", "play", "", "pause", "reset", "seek", "time", "top_fifthlight_armorstand"})
public final class Timeline {
    private final float duration;
    private final boolean loop;
    private final float speed;
    private long startTime;
    private long pausedTime;
    private boolean isPaused;

    public Timeline(float duration, boolean loop, float speed) {
        this.duration = duration;
        this.loop = loop;
        this.speed = speed;
        this.isPaused = true;
    }

    public /* synthetic */ Timeline(float f, boolean bl, float g, int i2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((i2 & 2) != 0) {
            bl = true;
        }
        if ((i2 & 4) != 0) {
            g = 1.0f;
        }
        this(f, bl, g);
    }

    public final boolean isPlaying() {
        return !this.isPaused;
    }

    public final boolean isFinished(long currentNanos) {
        return !this.loop && this.getCurrentTime(currentNanos) >= this.duration;
    }

    public final float getCurrentTime(long currentNanos) {
        if (this.isPaused) {
            return (float)this.pausedTime / 1.0E9f;
        }
        float elapsed = (float)(currentNanos - this.startTime) * this.speed;
        float totalTime = elapsed + (float)this.pausedTime;
        if (!this.loop) {
            return RangesKt.coerceAtMost((float)(totalTime / (float)1000000000L), (float)this.duration);
        }
        long loopDuration = (long)(this.duration * (float)1000000000L);
        if (loopDuration <= 0L) {
            return 0.0f;
        }
        float loopedTime = totalTime % (float)loopDuration;
        return (loopedTime < 0.0f ? loopedTime + (float)loopDuration : loopedTime) / (float)1000000000L;
    }

    public final void play(long currentNanos) {
        if (this.isPaused) {
            this.startTime = currentNanos - (long)((float)this.pausedTime / this.speed);
            this.isPaused = false;
        }
    }

    public final void pause(long currentNanos) {
        if (!this.isPaused) {
            this.pausedTime = (currentNanos - this.startTime) * (long)this.speed;
            this.isPaused = true;
        }
    }

    public final void reset(long currentNanos) {
        this.startTime = currentNanos;
        this.pausedTime = 0L;
    }

    public final void seek(long currentNanos, float time) {
        float targetTime = RangesKt.coerceIn((float)time, (float)0.0f, (float)this.duration);
        this.pausedTime = (long)(targetTime * (float)1000000000L);
        if (!this.isPaused) {
            this.startTime = currentNanos - (long)((float)this.pausedTime / this.speed);
        }
    }
}

