/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.armorstand.mixin.gl;

import com.mojang.blaze3d.opengl.GlStateManager;
import java.nio.ByteBuffer;
import java.util.Set;
import net.minecraft.class_10874;
import org.lwjgl.opengl.ARBClearBufferObject;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.lwjgl.opengl.GLCapabilities;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import top.fifthlight.armorstand.extension.CommandEncoderExt;
import top.fifthlight.armorstand.extension.internal.gl.BufferManagerExtInternal;
import top.fifthlight.armorstand.helper.gl.GlStateManagerHelper;
import top.fifthlight.armorstand.render.gl.ClearTypeParam;

@Mixin(value={class_10874.class})
public abstract class BufferManagerMixin
implements BufferManagerExtInternal {
    @Unique
    private static final boolean allowGlClearBufferObject = true;
    @Unique
    private static boolean glClearBufferObjectEnabled = false;

    @Inject(method={"method_68813(Lorg/lwjgl/opengl/GLCapabilities;Ljava/util/Set;)Lnet/minecraft/class_10874;"}, at={@At(value="HEAD")})
    private static void onCreate(GLCapabilities capabilities, Set<String> usedCapabilities, CallbackInfoReturnable<class_10874> cir) {
        if (capabilities.GL_ARB_clear_buffer_object) {
            usedCapabilities.add("GL_ARB_clear_buffer_object");
            glClearBufferObjectEnabled = true;
        }
    }

    @Override
    public boolean armorStand$isGlClearBufferObjectEnabled() {
        return glClearBufferObjectEnabled;
    }

    @Mixin(value={class_10874.class_10930.class})
    private static abstract class DefaultBufferManagerMixin
    implements BufferManagerExtInternal {
        private DefaultBufferManagerMixin() {
        }

        @Override
        public void armorStand$clearBufferData(int buffer, int offset, int size, CommandEncoderExt.ClearType clearType) {
            if (!this.armorStand$isGlClearBufferObjectEnabled()) {
                throw new IllegalStateException("Clear buffer when GL_ARB_clear_buffer_object is not supported");
            }
            ClearTypeParam param = ClearTypeParam.fromClearType(clearType);
            if (size % param.getAlign() != 0) {
                throw new IllegalArgumentException("Bad clear byte length " + size + " for clear type " + String.valueOf((Object)clearType));
            }
            GlStateManager._glBindBuffer((int)36663, (int)buffer);
            ARBClearBufferObject.glClearBufferSubData((int)36663, (int)param.getInternalFormat(), (long)offset, (long)size, (int)param.getFormat(), (int)param.getType(), (ByteBuffer)param.getData());
            GlStateManager._glBindBuffer((int)36663, (int)0);
        }

        @Override
        public void armorStand$copyBuffer(int target, int source, int targetOffset, int sourceOffset, int size) {
            GlStateManager._glBindBuffer((int)36662, (int)source);
            GlStateManager._glBindBuffer((int)36663, (int)target);
            GlStateManagerHelper._glCopyBufferSubData(36662, 36663, sourceOffset, targetOffset, size);
            GlStateManager._glBindBuffer((int)36662, (int)0);
            GlStateManager._glBindBuffer((int)36663, (int)0);
        }
    }

    @Mixin(value={class_10874.class_10929.class})
    private static abstract class ARBBufferManagerMixin
    implements BufferManagerExtInternal {
        private ARBBufferManagerMixin() {
        }

        @Override
        public void armorStand$clearBufferData(int buffer, int offset, int size, CommandEncoderExt.ClearType clearType) {
            if (!this.armorStand$isGlClearBufferObjectEnabled()) {
                throw new IllegalStateException("Clear buffer when GL_ARB_clear_buffer_object is not supported");
            }
            ClearTypeParam param = ClearTypeParam.fromClearType(clearType);
            if (size % param.getAlign() != 0) {
                throw new IllegalArgumentException("Bad clear byte length " + size + " for clear type " + String.valueOf((Object)clearType));
            }
            ARBDirectStateAccess.glClearNamedBufferSubData((int)buffer, (int)param.getInternalFormat(), (long)offset, (long)size, (int)param.getFormat(), (int)param.getType(), (ByteBuffer)param.getData());
        }

        @Override
        public void armorStand$copyBuffer(int target, int source, int targetOffset, int sourceOffset, int size) {
            ARBDirectStateAccess.glCopyNamedBufferSubData((int)source, (int)target, (long)sourceOffset, (long)targetOffset, (long)size);
        }
    }
}

