/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.armorstand.model;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import top.fifthlight.armorstand.model.RenderNode;
import top.fifthlight.armorstand.model.RenderPrimitive;
import top.fifthlight.armorstand.model.RenderScene;
import top.fifthlight.armorstand.model.RenderSkin;
import top.fifthlight.armorstand.util.AbstractRefCount;
import top.fifthlight.armorstand.util.SlottedGpuBuffer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\nB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0006R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ltop/fifthlight/armorstand/model/ModelBufferManager;", "", "<init>", "()V", "bufferEntries", "", "Ltop/fifthlight/armorstand/model/RenderScene;", "Ltop/fifthlight/armorstand/model/ModelBufferManager$BufferEntry;", "getEntry", "scene", "BufferEntry", "top_fifthlight_armorstand"})
@SourceDebugExtension(value={"SMAP\nModelBufferManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelBufferManager.kt\ntop/fifthlight/armorstand/model/ModelBufferManager\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,71:1\n384#2,7:72\n*S KotlinDebug\n*F\n+ 1 ModelBufferManager.kt\ntop/fifthlight/armorstand/model/ModelBufferManager\n*L\n13#1:72,7\n*E\n"})
public final class ModelBufferManager {
    @NotNull
    public static final ModelBufferManager INSTANCE = new ModelBufferManager();
    @NotNull
    private static final Map<RenderScene, BufferEntry> bufferEntries = new LinkedHashMap();

    private ModelBufferManager() {
    }

    @NotNull
    public final BufferEntry getEntry(@NotNull RenderScene scene) {
        BufferEntry bufferEntry;
        Intrinsics.checkNotNullParameter((Object)scene, (String)"scene");
        Map<RenderScene, BufferEntry> $this$getOrPut$iv = bufferEntries;
        boolean $i$f$getOrPut = false;
        BufferEntry value$iv = $this$getOrPut$iv.get(scene);
        if (value$iv == null) {
            boolean i2 = false;
            BufferEntry answer$iv = new BufferEntry(scene, 0, 2, null);
            $this$getOrPut$iv.put(scene, answer$iv);
            bufferEntry = answer$iv;
        } else {
            bufferEntry = value$iv;
        }
        return bufferEntry;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0019\u001a\u00020\u001aH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u0011\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u0019\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u0011\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0016\u0010\u0013R\u0019\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u0011\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0018\u0010\u0013\u00a8\u0006\u001c"}, d2={"Ltop/fifthlight/armorstand/model/ModelBufferManager$BufferEntry;", "Ltop/fifthlight/armorstand/util/AbstractRefCount;", "scene", "Ltop/fifthlight/armorstand/model/RenderScene;", "initialCapacity", "", "<init>", "(Ltop/fifthlight/armorstand/model/RenderScene;I)V", "typeId", "Lnet/minecraft/util/Identifier;", "getTypeId", "()Lnet/minecraft/util/Identifier;", "modelMatricesBuffers", "Ltop/fifthlight/armorstand/util/SlottedGpuBuffer;", "getModelMatricesBuffers", "()Ltop/fifthlight/armorstand/util/SlottedGpuBuffer;", "skinBuffers", "", "getSkinBuffers", "()[Ltop/fifthlight/armorstand/util/SlottedGpuBuffer;", "[Ltop/fifthlight/armorstand/util/SlottedGpuBuffer;", "morphWeightBuffers", "getMorphWeightBuffers", "morphIndicesBuffers", "getMorphIndicesBuffers", "onClosed", "", "Companion", "top_fifthlight_armorstand"})
    @SourceDebugExtension(value={"SMAP\nModelBufferManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelBufferManager.kt\ntop/fifthlight/armorstand/model/ModelBufferManager$BufferEntry\n+ 2 IteratorUtil.kt\ntop/fifthlight/armorstand/util/IteratorUtilKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n45#2,2:72\n45#2,2:74\n13472#3,2:76\n13472#3,2:78\n13472#3,2:80\n1#4:82\n*S KotlinDebug\n*F\n+ 1 ModelBufferManager.kt\ntop/fifthlight/armorstand/model/ModelBufferManager$BufferEntry\n*L\n31#1:72,2\n40#1:74,2\n65#1:76,2\n66#1:78,2\n67#1:80,2\n*E\n"})
    public static final class BufferEntry
    extends AbstractRefCount {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final RenderScene scene;
        @NotNull
        private final SlottedGpuBuffer modelMatricesBuffers;
        @NotNull
        private final SlottedGpuBuffer[] skinBuffers;
        @NotNull
        private final SlottedGpuBuffer[] morphWeightBuffers;
        @NotNull
        private final SlottedGpuBuffer[] morphIndicesBuffers;
        private static final class_2960 TYPE_ID = class_2960.method_60655((String)"armorstand", (String)"buffer_entry");
        private static final int BUFFER_USAGE_READ_WRITE = 27;

        /*
         * WARNING - void declaration
         */
        public BufferEntry(@NotNull RenderScene scene, int initialCapacity) {
            Integer skin;
            SlottedGpuBuffer slottedGpuBuffer;
            boolean i2;
            SlottedGpuBuffer[] slottedGpuBufferArray;
            int n;
            int n2;
            List $this$mapToArray$iv;
            Intrinsics.checkNotNullParameter((Object)scene, (String)"scene");
            this.scene = scene;
            this.modelMatricesBuffers = new SlottedGpuBuffer(initialCapacity, this.scene.getPrimitiveNodes().size() * 64, "Model matrices buffer", 283);
            List<RenderSkin> list2 = this.scene.getSkins();
            BufferEntry bufferEntry = this;
            boolean $i$f$mapToArray = false;
            Iterator iterator$iv = $this$mapToArray$iv.iterator();
            int n3 = 0;
            int n4 = $this$mapToArray$iv.size();
            SlottedGpuBuffer[] slottedGpuBufferArray2 = new SlottedGpuBuffer[n4];
            while (n3 < n4) {
                n2 = n3++;
                RenderSkin renderSkin = (RenderSkin)iterator$iv.next();
                n = n2;
                slottedGpuBufferArray = slottedGpuBufferArray2;
                i2 = false;
                slottedGpuBufferArray[n] = slottedGpuBuffer = new SlottedGpuBuffer(initialCapacity, ((RenderSkin)((Object)skin)).getJointSize() * 64, "Skin buffer", 283);
            }
            bufferEntry.skinBuffers = slottedGpuBufferArray2;
            $this$mapToArray$iv = (List)this.scene.getMorphedPrimitiveNodeIndices();
            bufferEntry = this;
            $i$f$mapToArray = false;
            iterator$iv = $this$mapToArray$iv.iterator();
            n3 = 0;
            n4 = $this$mapToArray$iv.size();
            slottedGpuBufferArray2 = new SlottedGpuBuffer[n4];
            while (n3 < n4) {
                RenderPrimitive.Targets targets;
                void morphedPrimitiveNodeIndex;
                n2 = n3++;
                skin = (Integer)iterator$iv.next();
                n = n2;
                slottedGpuBufferArray = slottedGpuBufferArray2;
                i2 = false;
                List<RenderNode> list3 = this.scene.getNodes();
                Intrinsics.checkNotNull((Object)morphedPrimitiveNodeIndex);
                RenderNode renderNode = list3.get(morphedPrimitiveNodeIndex.intValue());
                Intrinsics.checkNotNull((Object)renderNode, (String)"null cannot be cast to non-null type top.fifthlight.armorstand.model.RenderNode.Primitive");
                RenderNode.Primitive node = (RenderNode.Primitive)renderNode;
                RenderPrimitive primitive = node.getPrimitive();
                Intrinsics.checkNotNull((Object)primitive.getTargets());
                int totalTargets = targets.getPosition().getTargetsCount() + targets.getColor().getTargetsCount() + targets.getTexCoord().getTargetsCount();
                slottedGpuBufferArray[n] = slottedGpuBuffer = new SlottedGpuBuffer(initialCapacity, totalTargets * 4, "Morph target weight buffer", 283);
            }
            bufferEntry.morphWeightBuffers = slottedGpuBufferArray2;
            int n5 = 0;
            int n6 = this.scene.getMorphedPrimitiveNodeIndices().size();
            SlottedGpuBuffer[] slottedGpuBufferArray3 = new SlottedGpuBuffer[n6];
            bufferEntry = this;
            while (n5 < n6) {
                n3 = n5++;
                slottedGpuBufferArray3[n3] = new SlottedGpuBuffer(initialCapacity, 396, "Morph target indices buffer", 283);
            }
            bufferEntry.morphIndicesBuffers = slottedGpuBufferArray3;
        }

        public /* synthetic */ BufferEntry(RenderScene renderScene, int i2, int j, DefaultConstructorMarker defaultConstructorMarker) {
            if ((j & 2) != 0) {
                i2 = 1;
            }
            this(renderScene, i2);
        }

        @Override
        @NotNull
        public class_2960 getTypeId() {
            class_2960 class_29602 = TYPE_ID;
            Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"TYPE_ID");
            return class_29602;
        }

        @NotNull
        public final SlottedGpuBuffer getModelMatricesBuffers() {
            return this.modelMatricesBuffers;
        }

        @NotNull
        public final SlottedGpuBuffer[] getSkinBuffers() {
            return this.skinBuffers;
        }

        @NotNull
        public final SlottedGpuBuffer[] getMorphWeightBuffers() {
            return this.morphWeightBuffers;
        }

        @NotNull
        public final SlottedGpuBuffer[] getMorphIndicesBuffers() {
            return this.morphIndicesBuffers;
        }

        @Override
        protected void onClosed() {
            boolean i2;
            SlottedGpuBuffer it;
            SlottedGpuBuffer element$iv;
            int n;
            this.modelMatricesBuffers.close();
            SlottedGpuBuffer[] $this$forEach$iv = this.skinBuffers;
            boolean $i$f$forEach = false;
            int n2 = $this$forEach$iv.length;
            for (n = 0; n < n2; ++n) {
                it = element$iv = $this$forEach$iv[n];
                i2 = false;
                it.close();
            }
            $this$forEach$iv = this.morphWeightBuffers;
            $i$f$forEach = false;
            n2 = $this$forEach$iv.length;
            for (n = 0; n < n2; ++n) {
                it = element$iv = $this$forEach$iv[n];
                i2 = false;
                it.close();
            }
            $this$forEach$iv = this.morphIndicesBuffers;
            $i$f$forEach = false;
            n2 = $this$forEach$iv.length;
            for (n = 0; n < n2; ++n) {
                it = element$iv = $this$forEach$iv[n];
                i2 = false;
                it.close();
            }
            if (!bufferEntries.remove(this.scene, this)) {
                $i$f$forEach = false;
                String string = "Buffer entry not in manager!?";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ltop/fifthlight/armorstand/model/ModelBufferManager$BufferEntry$Companion;", "", "<init>", "()V", "TYPE_ID", "Lnet/minecraft/util/Identifier;", "kotlin.jvm.PlatformType", "Lnet/minecraft/util/Identifier;", "BUFFER_USAGE_READ_WRITE", "", "top_fifthlight_armorstand"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

