/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.armorstand.model;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import top.fifthlight.armorstand.model.ModelBufferManager;
import top.fifthlight.armorstand.model.MorphTargetGroup;
import top.fifthlight.armorstand.model.RenderNode;
import top.fifthlight.armorstand.model.RenderPrimitive;
import top.fifthlight.armorstand.model.RenderScene;
import top.fifthlight.armorstand.model.RenderSkin;
import top.fifthlight.armorstand.model.RenderTask;
import top.fifthlight.armorstand.model.data.ModelMatricesBuffer;
import top.fifthlight.armorstand.model.data.RenderSkinBuffer;
import top.fifthlight.armorstand.model.data.RenderTargetBuffer;
import top.fifthlight.armorstand.util.AbstractRefCount;
import top.fifthlight.renderer.model.NodeTransform;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 -2\u00020\u0001:\u0002-.B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J/\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00152\u0019\b\u0004\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00130\u001b\u00a2\u0006\u0002\b\u001dH\u0086\b\u00f8\u0001\u0000J\u001e\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"J\u0006\u0010%\u001a\u00020\u0013J\u0016\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0015J\u0016\u0010*\u001a\u00020+2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0015J\b\u0010,\u001a\u00020\u0013H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006/"}, d2={"Ltop/fifthlight/armorstand/model/ModelInstance;", "Ltop/fifthlight/armorstand/util/AbstractRefCount;", "scene", "Ltop/fifthlight/armorstand/model/RenderScene;", "bufferEntry", "Ltop/fifthlight/armorstand/model/ModelBufferManager$BufferEntry;", "<init>", "(Ltop/fifthlight/armorstand/model/RenderScene;Ltop/fifthlight/armorstand/model/ModelBufferManager$BufferEntry;)V", "getScene", "()Ltop/fifthlight/armorstand/model/RenderScene;", "typeId", "Lnet/minecraft/util/Identifier;", "getTypeId", "()Lnet/minecraft/util/Identifier;", "modelData", "Ltop/fifthlight/armorstand/model/ModelInstance$ModelData;", "getModelData", "()Ltop/fifthlight/armorstand/model/ModelInstance$ModelData;", "setTransformMatrix", "", "transformIndex", "", "matrix", "Lorg/joml/Matrix4f;", "setTransformDecomposed", "index", "updater", "Lkotlin/Function1;", "Ltop/fifthlight/renderer/model/NodeTransform$Decomposed;", "Lkotlin/ExtensionFunctionType;", "setGroupWeight", "morphedPrimitiveIndex", "targetGroupIndex", "weight", "", "updateMatrixStack", "Lorg/joml/Matrix4fStack;", "update", "render", "modelMatrix", "Lorg/joml/Matrix4fc;", "light", "schedule", "Ltop/fifthlight/armorstand/model/RenderTask$Instance;", "onClosed", "Companion", "ModelData", "top_fifthlight_armorstand"})
@SourceDebugExtension(value={"SMAP\nModelInstance.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelInstance.kt\ntop/fifthlight/armorstand/model/ModelInstance\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,168:1\n1#2:169\n*E\n"})
public final class ModelInstance
extends AbstractRefCount {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RenderScene scene;
    @NotNull
    private final ModelData modelData;
    @NotNull
    private final Matrix4fStack updateMatrixStack;
    private static final class_2960 TYPE_ID = class_2960.method_60655((String)"armorstand", (String)"model_instance");

    public ModelInstance(@NotNull RenderScene scene, @NotNull ModelBufferManager.BufferEntry bufferEntry) {
        Intrinsics.checkNotNullParameter((Object)scene, (String)"scene");
        Intrinsics.checkNotNullParameter((Object)bufferEntry, (String)"bufferEntry");
        this.scene = scene;
        this.modelData = new ModelData(this.scene, bufferEntry);
        this.scene.increaseReferenceCount();
        this.updateMatrixStack = new Matrix4fStack(64);
    }

    @NotNull
    public final RenderScene getScene() {
        return this.scene;
    }

    @Override
    @NotNull
    public class_2960 getTypeId() {
        class_2960 class_29602 = TYPE_ID;
        Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"TYPE_ID");
        return class_29602;
    }

    @NotNull
    public final ModelData getModelData() {
        return this.modelData;
    }

    public final void setTransformMatrix(int transformIndex, @NotNull Matrix4f matrix) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        NodeTransform transform = this.modelData.getTransforms()[transformIndex];
        if (transform instanceof NodeTransform.Matrix) {
            ((NodeTransform.Matrix)transform).getMatrix().set((Matrix4fc)matrix);
        } else {
            this.modelData.getTransforms()[transformIndex] = new NodeTransform.Matrix(matrix);
        }
        this.modelData.getTransformsDirty()[transformIndex] = true;
    }

    public final void setTransformDecomposed(int index, @NotNull Function1<? super NodeTransform.Decomposed, Unit> updater) {
        NodeTransform transform;
        Intrinsics.checkNotNullParameter(updater, (String)"updater");
        boolean $i$f$setTransformDecomposed = false;
        NodeTransform nodeTransform = transform = this.getModelData().getTransforms()[index];
        if (nodeTransform instanceof NodeTransform.Decomposed) {
            updater.invoke((Object)transform);
        } else if (nodeTransform instanceof NodeTransform.Matrix) {
            Quaternionf quaternionf;
            Vector3f vector3f;
            Vector3f vector3f2;
            Matrix4f prevMatrix = ((NodeTransform.Matrix)transform).getMatrix();
            Vector3f it = vector3f2 = new Vector3f();
            boolean i2 = false;
            prevMatrix.getTranslation(it);
            Vector3f vector3f3 = vector3f2;
            Vector3f it2 = vector3f = new Vector3f();
            boolean j = false;
            prevMatrix.getScale(it2);
            vector3f2 = vector3f;
            Quaternionf it3 = quaternionf = new Quaternionf();
            boolean k = false;
            prevMatrix.getNormalizedRotation(it3);
            vector3f = quaternionf;
            NodeTransform.Decomposed newTransform = new NodeTransform.Decomposed(vector3f3, (Quaternionf)vector3f, vector3f2);
            updater.invoke((Object)newTransform);
            this.getModelData().getTransforms()[index] = newTransform;
        } else if (nodeTransform == null) {
            NodeTransform.Decomposed newTransform = new NodeTransform.Decomposed(null, null, null, 7, null);
            updater.invoke((Object)newTransform);
            this.getModelData().getTransforms()[index] = newTransform;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.getModelData().getTransformsDirty()[index] = true;
    }

    public final void setGroupWeight(int morphedPrimitiveIndex, int targetGroupIndex, float weight) {
        block4: {
            boolean j;
            int it;
            int nodeIndex = this.scene.getMorphedPrimitiveNodeIndices().getInt(morphedPrimitiveIndex);
            RenderNode node = this.scene.getNodes().get(nodeIndex);
            if (!(node instanceof RenderNode.Primitive)) {
                boolean weightsIndex22 = false;
                String weightsIndex22 = "Node id " + morphedPrimitiveIndex + " is not primitive";
                throw new IllegalArgumentException(weightsIndex22.toString());
            }
            MorphTargetGroup group = ((RenderNode.Primitive)node).getPrimitive().getTargetGroups().get(targetGroupIndex);
            Integer n = ((RenderNode.Primitive)node).getMorphedPrimitiveIndex();
            if (n == null) {
                boolean i2 = false;
                String string = "Node " + nodeIndex + " don't have target? Check model loader";
                throw new IllegalArgumentException(string.toString());
            }
            int weightsIndex = ((Number)n).intValue();
            RenderTargetBuffer weights = this.modelData.getTargetBuffers()[weightsIndex];
            Integer n2 = group.getPosition();
            if (n2 != null) {
                it = ((Number)n2).intValue();
                j = false;
                weights.getPositionChannel().set(it, weight);
            }
            Integer n3 = group.getColor();
            if (n3 != null) {
                it = ((Number)n3).intValue();
                j = false;
                weights.getColorChannel().set(it, weight);
            }
            Integer n4 = group.getTexCoord();
            if (n4 == null) break block4;
            it = ((Number)n4).intValue();
            j = false;
            weights.getTexCoordChannel().set(it, weight);
        }
    }

    public final void update() {
        this.scene.update(this, this.updateMatrixStack);
    }

    public final void render(@NotNull Matrix4fc modelMatrix, int light) {
        Intrinsics.checkNotNullParameter((Object)modelMatrix, (String)"modelMatrix");
        this.scene.render(this, modelMatrix, light);
    }

    @NotNull
    public final RenderTask.Instance schedule(@NotNull Matrix4fc modelMatrix, int light) {
        Intrinsics.checkNotNullParameter((Object)modelMatrix, (String)"modelMatrix");
        return RenderTask.Instance.Companion.acquire(this, modelMatrix, light);
    }

    @Override
    protected void onClosed() {
        this.scene.decreaseReferenceCount();
        this.modelData.close();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Ltop/fifthlight/armorstand/model/ModelInstance$Companion;", "", "<init>", "()V", "TYPE_ID", "Lnet/minecraft/util/Identifier;", "kotlin.jvm.PlatformType", "Lnet/minecraft/util/Identifier;", "top_fifthlight_armorstand"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0019\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\n\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0019\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\n\u00a2\u0006\n\n\u0002\u0010\u001c\u001a\u0004\b\u001a\u0010\u001bR\u0019\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\n\u00a2\u0006\n\n\u0002\u0010!\u001a\u0004\b\u001f\u0010 \u00a8\u0006$"}, d2={"Ltop/fifthlight/armorstand/model/ModelInstance$ModelData;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "scene", "Ltop/fifthlight/armorstand/model/RenderScene;", "bufferEntry", "Ltop/fifthlight/armorstand/model/ModelBufferManager$BufferEntry;", "<init>", "(Ltop/fifthlight/armorstand/model/RenderScene;Ltop/fifthlight/armorstand/model/ModelBufferManager$BufferEntry;)V", "transforms", "", "Ltop/fifthlight/renderer/model/NodeTransform;", "getTransforms", "()[Ltop/fifthlight/renderer/model/NodeTransform;", "[Ltop/fifthlight/renderer/model/NodeTransform;", "transformsDirty", "", "getTransformsDirty", "()[Ljava/lang/Boolean;", "[Ljava/lang/Boolean;", "modelMatricesBuffer", "Ltop/fifthlight/armorstand/model/data/ModelMatricesBuffer;", "getModelMatricesBuffer", "()Ltop/fifthlight/armorstand/model/data/ModelMatricesBuffer;", "skinBuffers", "Ltop/fifthlight/armorstand/model/data/RenderSkinBuffer;", "getSkinBuffers", "()[Ltop/fifthlight/armorstand/model/data/RenderSkinBuffer;", "[Ltop/fifthlight/armorstand/model/data/RenderSkinBuffer;", "targetBuffers", "Ltop/fifthlight/armorstand/model/data/RenderTargetBuffer;", "getTargetBuffers", "()[Ltop/fifthlight/armorstand/model/data/RenderTargetBuffer;", "[Ltop/fifthlight/armorstand/model/data/RenderTargetBuffer;", "close", "", "top_fifthlight_armorstand"})
    @SourceDebugExtension(value={"SMAP\nModelInstance.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelInstance.kt\ntop/fifthlight/armorstand/model/ModelInstance$ModelData\n+ 2 IteratorUtil.kt\ntop/fifthlight/armorstand/util/IteratorUtilKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,168:1\n45#2,2:169\n50#2,2:171\n50#2,2:173\n13472#3,2:175\n13472#3,2:177\n*S KotlinDebug\n*F\n+ 1 ModelInstance.kt\ntop/fifthlight/armorstand/model/ModelInstance$ModelData\n*L\n46#1:169,2\n57#1:171,2\n63#1:173,2\n87#1:175,2\n88#1:177,2\n*E\n"})
    public static final class ModelData
    implements AutoCloseable {
        @NotNull
        private final ModelBufferManager.BufferEntry bufferEntry;
        @NotNull
        private final NodeTransform[] transforms;
        @NotNull
        private final Boolean[] transformsDirty;
        @NotNull
        private final ModelMatricesBuffer modelMatricesBuffer;
        @NotNull
        private final RenderSkinBuffer[] skinBuffers;
        @NotNull
        private final RenderTargetBuffer[] targetBuffers;

        /*
         * WARNING - void declaration
         */
        public ModelData(@NotNull RenderScene scene, @NotNull ModelBufferManager.BufferEntry bufferEntry) {
            Integer skin;
            List $this$mapToArrayIndexed$iv;
            void it;
            Object object;
            RenderSkin nodeIndex;
            int index;
            Object[] objectArray;
            int n;
            int n2;
            int n3;
            void $this$mapToArray$iv322;
            Intrinsics.checkNotNullParameter((Object)scene, (String)"scene");
            Intrinsics.checkNotNullParameter((Object)bufferEntry, (String)"bufferEntry");
            this.bufferEntry = bufferEntry;
            this.bufferEntry.increaseReferenceCount();
            List list2 = (List)scene.getTransformNodeIndices();
            ModelData modelData = this;
            int $i$f$mapToArray22 = 0;
            Boolean[] iterator$iv = $this$mapToArray$iv322.iterator();
            int n4 = $this$mapToArray$iv322.size();
            Object[] objectArray2 = new NodeTransform[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = n3;
                Integer n5 = (Integer)iterator$iv.next();
                n = n2;
                objectArray = objectArray2;
                index = 0;
                List<RenderNode> list3 = scene.getNodes();
                Intrinsics.checkNotNull((Object)nodeIndex);
                RenderNode renderNode = list3.get((Integer)((Object)nodeIndex));
                Intrinsics.checkNotNull((Object)renderNode, (String)"null cannot be cast to non-null type top.fifthlight.armorstand.model.RenderNode.Transform");
                RenderNode.Transform node = (RenderNode.Transform)renderNode;
                NodeTransform nodeTransform = node.getDefaultTransform();
                object = nodeTransform != null ? nodeTransform.clone() : null;
                objectArray[n] = object;
            }
            modelData.transforms = objectArray2;
            int $this$mapToArray$iv322 = 0;
            $i$f$mapToArray22 = scene.getTransformNodeIndices().size();
            iterator$iv = new Boolean[$i$f$mapToArray22];
            modelData = this;
            while ($this$mapToArray$iv322 < $i$f$mapToArray22) {
                n3 = $this$mapToArray$iv322++;
                iterator$iv[n3] = true;
            }
            modelData.transformsDirty = iterator$iv;
            Object $this$mapToArray$iv322 = new ModelMatricesBuffer(scene, this.bufferEntry.getModelMatricesBuffers().allocateSlot());
            ModelMatricesBuffer $i$f$mapToArray22 = $this$mapToArray$iv322;
            modelData = this;
            boolean i2 = false;
            it.clear();
            modelData.modelMatricesBuffer = $this$mapToArray$iv322;
            $this$mapToArray$iv322 = scene.getSkins();
            modelData = this;
            boolean $i$f$mapToArrayIndexed = false;
            Iterator iterator$iv2 = $this$mapToArrayIndexed$iv.iterator();
            n3 = 0;
            n4 = $this$mapToArrayIndexed$iv.size();
            objectArray2 = new RenderSkinBuffer[n4];
            while (n3 < n4) {
                RenderSkinBuffer renderSkinBuffer;
                n2 = n3++;
                nodeIndex = (RenderSkin)iterator$iv2.next();
                index = n2;
                n = n2;
                objectArray = objectArray2;
                boolean k = false;
                RenderSkinBuffer it2 = renderSkinBuffer = new RenderSkinBuffer((RenderSkin)((Object)skin), this.bufferEntry.getSkinBuffers()[index].allocateSlot());
                boolean j = false;
                it2.clear();
                objectArray[n] = object = renderSkinBuffer;
            }
            modelData.skinBuffers = objectArray2;
            $this$mapToArrayIndexed$iv = (List)scene.getMorphedPrimitiveNodeIndices();
            modelData = this;
            $i$f$mapToArrayIndexed = false;
            iterator$iv2 = $this$mapToArrayIndexed$iv.iterator();
            n4 = $this$mapToArrayIndexed$iv.size();
            objectArray2 = new RenderTargetBuffer[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                RenderPrimitive.Targets targets;
                n2 = n3;
                skin = (Integer)iterator$iv2.next();
                index = n2;
                n = n2;
                objectArray = objectArray2;
                boolean k = false;
                List<RenderNode> list4 = scene.getNodes();
                Intrinsics.checkNotNull((Object)nodeIndex);
                RenderNode renderNode = list4.get((Integer)((Object)nodeIndex));
                Intrinsics.checkNotNull((Object)renderNode, (String)"null cannot be cast to non-null type top.fifthlight.armorstand.model.RenderNode.Primitive");
                RenderNode.Primitive node = (RenderNode.Primitive)renderNode;
                RenderPrimitive primitive = node.getPrimitive();
                Intrinsics.checkNotNull((Object)primitive.getTargets());
                RenderTargetBuffer targetBuffers = new RenderTargetBuffer(targets, this.bufferEntry.getMorphWeightBuffers()[index].allocateSlot(), this.bufferEntry.getMorphIndicesBuffers()[index].allocateSlot());
                for (MorphTargetGroup targetGroup : primitive.getTargetGroups()) {
                    ModelData.targetBuffers$lambda$5$processGroup(targetGroup.getPosition(), targetBuffers.getPositionChannel(), targetGroup.getWeight());
                    ModelData.targetBuffers$lambda$5$processGroup(targetGroup.getColor(), targetBuffers.getColorChannel(), targetGroup.getWeight());
                    ModelData.targetBuffers$lambda$5$processGroup(targetGroup.getTexCoord(), targetBuffers.getTexCoordChannel(), targetGroup.getWeight());
                }
                objectArray[n] = object = targetBuffers;
            }
            modelData.targetBuffers = objectArray2;
        }

        @NotNull
        public final NodeTransform[] getTransforms() {
            return this.transforms;
        }

        @NotNull
        public final Boolean[] getTransformsDirty() {
            return this.transformsDirty;
        }

        @NotNull
        public final ModelMatricesBuffer getModelMatricesBuffer() {
            return this.modelMatricesBuffer;
        }

        @NotNull
        public final RenderSkinBuffer[] getSkinBuffers() {
            return this.skinBuffers;
        }

        @NotNull
        public final RenderTargetBuffer[] getTargetBuffers() {
            return this.targetBuffers;
        }

        @Override
        public void close() {
            boolean i2;
            RenderSkinBuffer it;
            AutoCloseable element$iv;
            int n;
            this.modelMatricesBuffer.close();
            AutoCloseable[] $this$forEach$iv = this.skinBuffers;
            boolean $i$f$forEach = false;
            int n2 = $this$forEach$iv.length;
            for (n = 0; n < n2; ++n) {
                it = element$iv = $this$forEach$iv[n];
                i2 = false;
                it.close();
            }
            $this$forEach$iv = this.targetBuffers;
            $i$f$forEach = false;
            n2 = $this$forEach$iv.length;
            for (n = 0; n < n2; ++n) {
                it = element$iv = $this$forEach$iv[n];
                i2 = false;
                ((RenderTargetBuffer)((Object)it)).close();
            }
            this.bufferEntry.decreaseReferenceCount();
        }

        private static final Unit targetBuffers$lambda$5$processGroup(Integer index, RenderTargetBuffer.WeightChannel channel, float weight) {
            Unit unit;
            Integer n = index;
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean i2 = false;
                channel.set(index, weight);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            return unit;
        }
    }
}

