/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.armorstand.model;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_10866;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fc;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import top.fifthlight.armorstand.extension.RenderPassExtKt;
import top.fifthlight.armorstand.model.ModelInstance;
import top.fifthlight.armorstand.model.MorphTargetGroup;
import top.fifthlight.armorstand.model.RenderMaterial;
import top.fifthlight.armorstand.model.RenderNode;
import top.fifthlight.armorstand.model.RenderPrimitive;
import top.fifthlight.armorstand.model.RenderTask;
import top.fifthlight.armorstand.model.data.RenderSkinBuffer;
import top.fifthlight.armorstand.model.data.RenderTargetBuffer;
import top.fifthlight.armorstand.model.uniform.InstanceDataUniformBuffer;
import top.fifthlight.armorstand.model.uniform.MorphDataUniformBuffer;
import top.fifthlight.armorstand.model.uniform.MorphModelIndicesUniformBuffer;
import top.fifthlight.armorstand.model.uniform.SkinModelIndicesUniformBuffer;
import top.fifthlight.armorstand.model.uniform.UniformBuffer;
import top.fifthlight.armorstand.render.IndexBuffer;
import top.fifthlight.armorstand.render.IndexBufferKt;
import top.fifthlight.armorstand.render.VertexBuffer;
import top.fifthlight.armorstand.util.AbstractRefCount;
import top.fifthlight.armorstand.util.SlottedGpuBuffer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 42\u00020\u0001:\u0003456B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0014\u0010\u001d\u001a\u00020\u001e*\u00020\u001f2\u0006\u0010\b\u001a\u00020\tH\u0002J:\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020&2\b\u0010*\u001a\u0004\u0018\u00010+2\b\u0010,\u001a\u0004\u0018\u00010-J\u001c\u0010.\u001a\u00020\u001e2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u000b2\u0006\u00101\u001a\u000202J\b\u00103\u001a\u00020\u001eH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0015\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Ltop/fifthlight/armorstand/model/RenderPrimitive;", "Ltop/fifthlight/armorstand/util/AbstractRefCount;", "vertexBuffer", "Ltop/fifthlight/armorstand/render/VertexBuffer;", "indexBuffer", "Ltop/fifthlight/armorstand/render/IndexBuffer;", "material", "Ltop/fifthlight/armorstand/model/RenderMaterial;", "targets", "Ltop/fifthlight/armorstand/model/RenderPrimitive$Targets;", "targetGroups", "", "Ltop/fifthlight/armorstand/model/MorphTargetGroup;", "<init>", "(Ltop/fifthlight/armorstand/render/VertexBuffer;Ltop/fifthlight/armorstand/render/IndexBuffer;Ltop/fifthlight/armorstand/model/RenderMaterial;Ltop/fifthlight/armorstand/model/RenderPrimitive$Targets;Ljava/util/List;)V", "getVertexBuffer", "()Ltop/fifthlight/armorstand/render/VertexBuffer;", "getIndexBuffer", "()Ltop/fifthlight/armorstand/render/IndexBuffer;", "getMaterial", "()Ltop/fifthlight/armorstand/model/RenderMaterial;", "getTargets", "()Ltop/fifthlight/armorstand/model/RenderPrimitive$Targets;", "getTargetGroups", "()Ljava/util/List;", "typeId", "Lnet/minecraft/util/Identifier;", "getTypeId", "()Lnet/minecraft/util/Identifier;", "bindMorphTargets", "", "Lcom/mojang/blaze3d/systems/RenderPass;", "lightVector", "Lorg/joml/Vector2i;", "render", "instance", "Ltop/fifthlight/armorstand/model/ModelInstance;", "primitiveIndex", "", "viewModelMatrix", "Lorg/joml/Matrix4fc;", "light", "skinBuffer", "Ltop/fifthlight/armorstand/model/data/RenderSkinBuffer;", "targetBuffer", "Ltop/fifthlight/armorstand/model/data/RenderTargetBuffer;", "renderInstanced", "tasks", "Ltop/fifthlight/armorstand/model/RenderTask$Instance;", "node", "Ltop/fifthlight/armorstand/model/RenderNode$Primitive;", "onClosed", "Companion", "Target", "Targets", "top_fifthlight_armorstand"})
@SourceDebugExtension(value={"SMAP\nRenderPrimitive.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderPrimitive.kt\ntop/fifthlight/armorstand/model/RenderPrimitive\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,397:1\n1#2:398\n*E\n"})
public final class RenderPrimitive
extends AbstractRefCount {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VertexBuffer vertexBuffer;
    @Nullable
    private final IndexBuffer indexBuffer;
    @NotNull
    private final RenderMaterial<?> material;
    @Nullable
    private final Targets targets;
    @NotNull
    private final List<MorphTargetGroup> targetGroups;
    @NotNull
    private final Vector2i lightVector;
    private static final class_2960 TYPE_ID = class_2960.method_60655((String)"armorstand", (String)"primitive");

    public RenderPrimitive(@NotNull VertexBuffer vertexBuffer, @Nullable IndexBuffer indexBuffer, @NotNull RenderMaterial<?> material, @Nullable Targets targets, @NotNull List<MorphTargetGroup> targetGroups) {
        Intrinsics.checkNotNullParameter((Object)vertexBuffer, (String)"vertexBuffer");
        Intrinsics.checkNotNullParameter(material, (String)"material");
        Intrinsics.checkNotNullParameter(targetGroups, (String)"targetGroups");
        this.vertexBuffer = vertexBuffer;
        this.indexBuffer = indexBuffer;
        this.material = material;
        this.targets = targets;
        this.targetGroups = targetGroups;
        this.vertexBuffer.increaseReferenceCount();
        IndexBuffer indexBuffer2 = this.indexBuffer;
        if (indexBuffer2 != null) {
            indexBuffer2.increaseReferenceCount();
        }
        this.material.increaseReferenceCount();
        if (this.targetGroups.isEmpty()) {
            if (!(this.targets == null)) {
                boolean i22 = false;
                String i22 = "Empty target groups with non-empty targets";
                throw new IllegalArgumentException(i22.toString());
            }
        } else if (!(this.targets != null)) {
            boolean i2 = false;
            String string = "Non-empty target groups with empty targets";
            throw new IllegalArgumentException(string.toString());
        }
        this.lightVector = new Vector2i();
    }

    @NotNull
    public final VertexBuffer getVertexBuffer() {
        return this.vertexBuffer;
    }

    @Nullable
    public final IndexBuffer getIndexBuffer() {
        return this.indexBuffer;
    }

    @NotNull
    public final RenderMaterial<?> getMaterial() {
        return this.material;
    }

    @Nullable
    public final Targets getTargets() {
        return this.targets;
    }

    @NotNull
    public final List<MorphTargetGroup> getTargetGroups() {
        return this.targetGroups;
    }

    @Override
    @NotNull
    public class_2960 getTypeId() {
        class_2960 class_29602 = TYPE_ID;
        Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"TYPE_ID");
        return class_29602;
    }

    private final void bindMorphTargets(RenderPass $this$bindMorphTargets, Targets targets) {
        $this$bindMorphTargets.setUniform("MorphPositionData", targets.getPosition().getData());
        $this$bindMorphTargets.setUniform("MorphColorData", targets.getColor().getData());
        $this$bindMorphTargets.setUniform("MorphTexCoordData", targets.getTexCoord().getData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void render(@NotNull ModelInstance instance, int primitiveIndex, @NotNull Matrix4fc viewModelMatrix, int light, @Nullable RenderSkinBuffer skinBuffer, @Nullable RenderTargetBuffer targetBuffer) {
        RenderPass renderPass;
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        Intrinsics.checkNotNullParameter((Object)viewModelMatrix, (String)"viewModelMatrix");
        GpuTextureView gpuTextureView = class_310.method_1551().method_1522().method_71639();
        Intrinsics.checkNotNull((Object)gpuTextureView);
        GpuTextureView mainColorTextureView = gpuTextureView;
        GpuTextureView mainDepthTextureView = class_310.method_1551().method_1522().method_71640();
        GpuDevice device = RenderSystem.getDevice();
        CommandEncoder commandEncoder = device.createCommandEncoder();
        RenderPass renderPass2 = null;
        UniformBuffer materialUniform = null;
        InstanceDataUniformBuffer instanceDataUniformBuffer = null;
        Ref.ObjectRef localMatricsBuffer = new Ref.ObjectRef();
        SkinModelIndicesUniformBuffer skinModelIndices = null;
        GpuBuffer skinJointBuffer = null;
        MorphDataUniformBuffer morphDataUniformBuffer = null;
        MorphModelIndicesUniformBuffer morphModelIndices = null;
        Ref.ObjectRef morphWeightsBuffer = new Ref.ObjectRef();
        Ref.ObjectRef morphTargetIndicesBuffer = new Ref.ObjectRef();
        try {
            boolean l;
            boolean i2;
            instanceDataUniformBuffer = InstanceDataUniformBuffer.Companion.acquire();
            instanceDataUniformBuffer.write((Function1)new Function1<InstanceDataUniformBuffer.InstanceDataLayout, Unit>(instance, primitiveIndex, viewModelMatrix, this, light, (Ref.ObjectRef<GpuBuffer>)localMatricsBuffer){
                final /* synthetic */ ModelInstance $instance;
                final /* synthetic */ int $primitiveIndex;
                final /* synthetic */ Matrix4fc $viewModelMatrix;
                final /* synthetic */ RenderPrimitive this$0;
                final /* synthetic */ int $light;
                final /* synthetic */ Ref.ObjectRef<GpuBuffer> $localMatricsBuffer;
                {
                    this.$instance = $instance;
                    this.$primitiveIndex = $primitiveIndex;
                    this.$viewModelMatrix = $viewModelMatrix;
                    this.this$0 = $receiver;
                    this.$light = $light;
                    this.$localMatricsBuffer = $localMatricsBuffer;
                    super(1);
                }

                public final void invoke(InstanceDataUniformBuffer.InstanceDataLayout $this$write) {
                    Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
                    $this$write.setPrimitiveSize(this.$instance.getScene().getPrimitiveNodes().size());
                    $this$write.setPrimitiveIndex(this.$primitiveIndex);
                    $this$write.getViewModelMatrices().set(0, this.$viewModelMatrix);
                    RenderPrimitive.access$getLightVector$p(this.this$0).set(this.$light & 0xFFFF, this.$light >> 16 & 0xFFFF);
                    $this$write.getLightMapUvs().set(0, (Vector2ic)RenderPrimitive.access$getLightVector$p(this.this$0));
                    SlottedGpuBuffer.Slot slot = this.$instance.getModelData().getModelMatricesBuffer().getSlot();
                    if (slot instanceof SlottedGpuBuffer.Slotted) {
                        $this$write.getLocalMatricesIndices().set(0, ((SlottedGpuBuffer.Slotted)slot).getIndex());
                        this.$localMatricsBuffer.element = ((SlottedGpuBuffer.Slotted)slot).getBuffer().getBuffer();
                    } else if (slot instanceof SlottedGpuBuffer.Unslotted) {
                        $this$write.getLocalMatricesIndices().set(0, 0);
                        this.$localMatricsBuffer.element = ((SlottedGpuBuffer.Unslotted)slot).getBuffer();
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            });
            RenderSkinBuffer renderSkinBuffer = skinBuffer;
            if (renderSkinBuffer != null) {
                RenderSkinBuffer skinBuffer2 = renderSkinBuffer;
                i2 = false;
                skinModelIndices = SkinModelIndicesUniformBuffer.Companion.acquire();
                SlottedGpuBuffer.Slot slot = skinBuffer2.getSlot();
                SlottedGpuBuffer.Slot slot2 = slot;
                if (slot2 instanceof SlottedGpuBuffer.Slotted) {
                    skinModelIndices.write((Function1)new Function1<SkinModelIndicesUniformBuffer.SkinModelIndicesLayout, Unit>(skinBuffer2, slot){
                        final /* synthetic */ RenderSkinBuffer $skinBuffer;
                        final /* synthetic */ SlottedGpuBuffer.Slot $slot;
                        {
                            this.$skinBuffer = $skinBuffer;
                            this.$slot = $slot;
                            super(1);
                        }

                        public final void invoke(SkinModelIndicesUniformBuffer.SkinModelIndicesLayout $this$write) {
                            Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
                            $this$write.setSkinJoints(this.$skinBuffer.getSkin().getJointSize());
                            $this$write.getSkinModelOffsets().set(0, ((SlottedGpuBuffer.Slotted)this.$slot).getIndex());
                        }
                    });
                    skinJointBuffer = ((SlottedGpuBuffer.Slotted)slot).getBuffer().getBuffer();
                } else if (slot2 instanceof SlottedGpuBuffer.Unslotted) {
                    skinModelIndices.write((Function1)new Function1<SkinModelIndicesUniformBuffer.SkinModelIndicesLayout, Unit>(skinBuffer2){
                        final /* synthetic */ RenderSkinBuffer $skinBuffer;
                        {
                            this.$skinBuffer = $skinBuffer;
                            super(1);
                        }

                        public final void invoke(SkinModelIndicesUniformBuffer.SkinModelIndicesLayout $this$write) {
                            Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
                            $this$write.setSkinJoints(this.$skinBuffer.getSkin().getJointSize());
                            $this$write.getSkinModelOffsets().set(0, 0);
                        }
                    });
                    skinJointBuffer = ((SlottedGpuBuffer.Unslotted)slot).getBuffer();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            RenderTargetBuffer renderTargetBuffer = targetBuffer;
            if (renderTargetBuffer != null) {
                RenderTargetBuffer targetBuffer2 = renderTargetBuffer;
                i2 = false;
                Targets targets = this.targets;
                if (targets != null) {
                    Targets targets2 = targets;
                    boolean j = false;
                    morphDataUniformBuffer = MorphDataUniformBuffer.Companion.acquire();
                    morphDataUniformBuffer.write((Function1)new Function1<MorphDataUniformBuffer.MorphDataLayout, Unit>(this, targets2){
                        final /* synthetic */ RenderPrimitive this$0;
                        final /* synthetic */ Targets $targets;
                        {
                            this.this$0 = $receiver;
                            this.$targets = $targets;
                            super(1);
                        }

                        public final void invoke(MorphDataUniformBuffer.MorphDataLayout $this$write) {
                            Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
                            $this$write.setTotalVertices(this.this$0.getVertexBuffer().getVerticesCount());
                            $this$write.setPosTargets(this.$targets.getPosition().getTargetsCount());
                            $this$write.setColorTargets(this.$targets.getColor().getTargetsCount());
                            $this$write.setTexCoordTargets(this.$targets.getTexCoord().getTargetsCount());
                            $this$write.setTotalTargets(this.$targets.getPosition().getTargetsCount() + this.$targets.getColor().getTargetsCount() + this.$targets.getTexCoord().getTargetsCount());
                        }
                    });
                }
                targetBuffer2.uploadIndices();
                morphModelIndices = MorphModelIndicesUniformBuffer.Companion.acquire();
                morphModelIndices.write((Function1)new Function1<MorphModelIndicesUniformBuffer.MorphModelIndicesLayout, Unit>(targetBuffer2, (Ref.ObjectRef<GpuBuffer>)morphWeightsBuffer, (Ref.ObjectRef<GpuBuffer>)morphTargetIndicesBuffer){
                    final /* synthetic */ RenderTargetBuffer $targetBuffer;
                    final /* synthetic */ Ref.ObjectRef<GpuBuffer> $morphWeightsBuffer;
                    final /* synthetic */ Ref.ObjectRef<GpuBuffer> $morphTargetIndicesBuffer;
                    {
                        this.$targetBuffer = $targetBuffer;
                        this.$morphWeightsBuffer = $morphWeightsBuffer;
                        this.$morphTargetIndicesBuffer = $morphTargetIndicesBuffer;
                        super(1);
                    }

                    public final void invoke(MorphModelIndicesUniformBuffer.MorphModelIndicesLayout $this$write) {
                        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
                        SlottedGpuBuffer.Slot slot = this.$targetBuffer.getWeightsSlot();
                        if (slot instanceof SlottedGpuBuffer.Slotted) {
                            $this$write.getMorphWeightIndices().set(0, ((SlottedGpuBuffer.Slotted)slot).getIndex());
                            this.$morphWeightsBuffer.element = ((SlottedGpuBuffer.Slotted)slot).getBuffer().getBuffer();
                        } else if (slot instanceof SlottedGpuBuffer.Unslotted) {
                            $this$write.getMorphWeightIndices().set(0, 0);
                            this.$morphWeightsBuffer.element = ((SlottedGpuBuffer.Unslotted)slot).getBuffer();
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        slot = this.$targetBuffer.getIndicesSlot();
                        if (slot instanceof SlottedGpuBuffer.Slotted) {
                            $this$write.getMorphIndexIndices().set(0, ((SlottedGpuBuffer.Slotted)slot).getIndex());
                            this.$morphTargetIndicesBuffer.element = ((SlottedGpuBuffer.Slotted)slot).getBuffer().getBuffer();
                        } else if (slot instanceof SlottedGpuBuffer.Unslotted) {
                            $this$write.getMorphIndexIndices().set(0, 0);
                            this.$morphTargetIndicesBuffer.element = ((SlottedGpuBuffer.Unslotted)slot).getBuffer();
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                });
            }
            Pair setupResult2 = RenderMaterial.setup$default(this.material, false, (Function0)new Function0<RenderPass>(commandEncoder, mainColorTextureView, mainDepthTextureView){
                final /* synthetic */ CommandEncoder $commandEncoder;
                final /* synthetic */ GpuTextureView $mainColorTextureView;
                final /* synthetic */ GpuTextureView $mainDepthTextureView;
                {
                    this.$commandEncoder = $commandEncoder;
                    this.$mainColorTextureView = $mainColorTextureView;
                    this.$mainDepthTextureView = $mainDepthTextureView;
                    super(0);
                }

                public final RenderPass invoke() {
                    RenderPass renderPass = this.$commandEncoder.createRenderPass((Supplier)render.setupResult.1.INSTANCE, this.$mainColorTextureView, OptionalInt.empty(), this.$mainDepthTextureView, OptionalDouble.empty());
                    Intrinsics.checkNotNullExpressionValue((Object)renderPass, (String)"createRenderPass(...)");
                    return renderPass;
                }
            }, 1, null);
            renderPass2 = (RenderPass)setupResult2.getFirst();
            materialUniform = (UniformBuffer)setupResult2.getSecond();
            RenderPass $this$render_u24lambda_u2415 = renderPass2;
            i2 = false;
            if (class_10866.field_57867 && !(this.material.getSkinned() == (skinBuffer != null))) {
                boolean k = false;
                String string = "Primitive's skin data " + (skinBuffer != null) + " and material skinned " + this.material.getSkinned() + " not matching";
                throw new IllegalArgumentException(string.toString());
            }
            $this$render_u24lambda_u2415.setUniform("InstanceData", instanceDataUniformBuffer.getSlice());
            $this$render_u24lambda_u2415.setUniform("LocalMatrices", (GpuBuffer)localMatricsBuffer.element);
            GpuBuffer gpuBuffer2 = skinJointBuffer;
            if (gpuBuffer2 != null) {
                GpuBuffer skinJointBuffer2 = gpuBuffer2;
                l = false;
                $this$render_u24lambda_u2415.setUniform("Joints", skinJointBuffer2);
            }
            SkinModelIndicesUniformBuffer skinModelIndicesUniformBuffer = skinModelIndices;
            if (skinModelIndicesUniformBuffer != null) {
                SkinModelIndicesUniformBuffer skinModelIndices2 = skinModelIndicesUniformBuffer;
                l = false;
                $this$render_u24lambda_u2415.setUniform("SkinModelIndices", skinModelIndices2.getSlice());
            }
            MorphModelIndicesUniformBuffer morphModelIndicesUniformBuffer = morphModelIndices;
            if (morphModelIndicesUniformBuffer != null) {
                MorphModelIndicesUniformBuffer morphModelIndices2 = morphModelIndicesUniformBuffer;
                l = false;
                $this$render_u24lambda_u2415.setUniform("MorphModelIndices", morphModelIndices2.getSlice());
            }
            MorphDataUniformBuffer morphDataUniformBuffer2 = morphDataUniformBuffer;
            if (morphDataUniformBuffer2 != null) {
                MorphDataUniformBuffer morphDataUniformBuffer3 = morphDataUniformBuffer2;
                l = false;
                $this$render_u24lambda_u2415.setUniform("MorphData", morphDataUniformBuffer3.getSlice());
            }
            GpuBuffer gpuBuffer3 = (GpuBuffer)morphWeightsBuffer.element;
            if (gpuBuffer3 != null) {
                GpuBuffer morphWeightsBuffer2 = gpuBuffer3;
                l = false;
                $this$render_u24lambda_u2415.setUniform("MorphWeights", morphWeightsBuffer2);
            }
            GpuBuffer gpuBuffer4 = (GpuBuffer)morphTargetIndicesBuffer.element;
            if (gpuBuffer4 != null) {
                GpuBuffer morphTargetIndicesBuffer2 = gpuBuffer4;
                l = false;
                $this$render_u24lambda_u2415.setUniform("MorphTargetIndices", morphTargetIndicesBuffer2);
            }
            RenderPassExtKt.setVertexBuffer($this$render_u24lambda_u2415, this.vertexBuffer);
            Targets targets = this.targets;
            if (targets != null) {
                Targets targets3 = targets;
                l = false;
                this.bindMorphTargets($this$render_u24lambda_u2415, targets3);
            }
            IndexBuffer indexBuffer = this.indexBuffer;
            if (indexBuffer != null) {
                IndexBuffer indices = indexBuffer;
                boolean m = false;
                IndexBufferKt.setIndexBuffer($this$render_u24lambda_u2415, indices);
                $this$render_u24lambda_u2415.drawIndexed(0, 0, indices.getLength(), 1);
            } else {
                RenderPass $this$render_u24lambda_u2415_u24lambda_u2414 = $this$render_u24lambda_u2415;
                boolean m = false;
                $this$render_u24lambda_u2415_u24lambda_u2414.draw(0, this.vertexBuffer.getVerticesCount());
            }
            renderPass = renderPass2;
        }
        catch (Throwable throwable) {
            RenderPass renderPass3 = renderPass2;
            if (renderPass3 != null) {
                renderPass3.close();
            }
            UniformBuffer uniformBuffer = materialUniform;
            if (uniformBuffer != null) {
                uniformBuffer.close();
            }
            InstanceDataUniformBuffer instanceDataUniformBuffer2 = instanceDataUniformBuffer;
            if (instanceDataUniformBuffer2 != null) {
                instanceDataUniformBuffer2.close();
            }
            SkinModelIndicesUniformBuffer skinModelIndicesUniformBuffer = skinModelIndices;
            if (skinModelIndicesUniformBuffer != null) {
                skinModelIndicesUniformBuffer.close();
            }
            MorphDataUniformBuffer morphDataUniformBuffer4 = morphDataUniformBuffer;
            if (morphDataUniformBuffer4 != null) {
                morphDataUniformBuffer4.close();
            }
            MorphModelIndicesUniformBuffer morphModelIndicesUniformBuffer = morphModelIndices;
            if (morphModelIndicesUniformBuffer != null) {
                morphModelIndicesUniformBuffer.close();
            }
            throw throwable;
        }
        if (renderPass != null) {
            renderPass.close();
        }
        UniformBuffer uniformBuffer = materialUniform;
        if (uniformBuffer != null) {
            uniformBuffer.close();
        }
        InstanceDataUniformBuffer instanceDataUniformBuffer3 = instanceDataUniformBuffer;
        if (instanceDataUniformBuffer3 != null) {
            instanceDataUniformBuffer3.close();
        }
        SkinModelIndicesUniformBuffer skinModelIndicesUniformBuffer = skinModelIndices;
        if (skinModelIndicesUniformBuffer != null) {
            skinModelIndicesUniformBuffer.close();
        }
        MorphDataUniformBuffer morphDataUniformBuffer5 = morphDataUniformBuffer;
        if (morphDataUniformBuffer5 != null) {
            morphDataUniformBuffer5.close();
        }
        MorphModelIndicesUniformBuffer morphModelIndicesUniformBuffer = morphModelIndices;
        if (morphModelIndicesUniformBuffer != null) {
            morphModelIndicesUniformBuffer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void renderInstanced(@NotNull List<RenderTask.Instance> tasks, @NotNull RenderNode.Primitive node) {
        RenderPass renderPass;
        Intrinsics.checkNotNullParameter(tasks, (String)"tasks");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!this.material.getSupportInstancing()) {
            boolean i22 = false;
            String i22 = "Primitives which cannot be instanced were scheduled";
            throw new IllegalArgumentException(i22.toString());
        }
        GpuTextureView gpuTextureView = class_310.method_1551().method_1522().method_71639();
        Intrinsics.checkNotNull((Object)gpuTextureView);
        GpuTextureView mainColorTextureView = gpuTextureView;
        GpuTextureView mainDepthTextureView = class_310.method_1551().method_1522().method_71640();
        GpuDevice device = RenderSystem.getDevice();
        CommandEncoder commandEncoder = device.createCommandEncoder();
        RenderPass renderPass2 = null;
        UniformBuffer materialUniform = null;
        InstanceDataUniformBuffer instanceDataUniformBuffer = null;
        Ref.ObjectRef localMatricsBuffer = new Ref.ObjectRef();
        SkinModelIndicesUniformBuffer skinModelIndices = null;
        GpuBuffer skinJointBuffer = null;
        MorphDataUniformBuffer morphDataUniformBuffer = null;
        MorphModelIndicesUniformBuffer morphModelIndices = null;
        Ref.ObjectRef morphWeightsBuffer = new Ref.ObjectRef();
        Ref.ObjectRef morphTargetIndicesBuffer = new Ref.ObjectRef();
        ModelInstance firstInstance = ((RenderTask.Instance)CollectionsKt.first(tasks)).getInstance();
        try {
            boolean k;
            Targets targets;
            boolean j;
            int skinIndex;
            instanceDataUniformBuffer = InstanceDataUniformBuffer.Companion.acquire();
            instanceDataUniformBuffer.write((Function1)new Function1<InstanceDataUniformBuffer.InstanceDataLayout, Unit>(firstInstance, node, tasks, this, (Ref.ObjectRef<GpuBuffer>)localMatricsBuffer){
                final /* synthetic */ ModelInstance $firstInstance;
                final /* synthetic */ RenderNode.Primitive $node;
                final /* synthetic */ List<RenderTask.Instance> $tasks;
                final /* synthetic */ RenderPrimitive this$0;
                final /* synthetic */ Ref.ObjectRef<GpuBuffer> $localMatricsBuffer;
                {
                    this.$firstInstance = $firstInstance;
                    this.$node = $node;
                    this.$tasks = $tasks;
                    this.this$0 = $receiver;
                    this.$localMatricsBuffer = $localMatricsBuffer;
                    super(1);
                }

                public final void invoke(InstanceDataUniformBuffer.InstanceDataLayout $this$write) {
                    Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
                    $this$write.setPrimitiveSize(this.$firstInstance.getScene().getPrimitiveNodes().size());
                    $this$write.setPrimitiveIndex(this.$node.getPrimitiveIndex());
                    Iterator<T> iterator = ((Iterable)this.$tasks).iterator();
                    int n = 0;
                    while (iterator.hasNext()) {
                        int index = n++;
                        RenderTask.Instance task = (RenderTask.Instance)iterator.next();
                        int light = task.getLight();
                        RenderPrimitive.access$getLightVector$p(this.this$0).set(light & 0xFFFF, light >> 16 & 0xFFFF);
                        $this$write.getLightMapUvs().set(index, (Vector2ic)RenderPrimitive.access$getLightVector$p(this.this$0));
                        $this$write.getViewModelMatrices().set(index, (Matrix4fc)task.getViewModelMatrix());
                        SlottedGpuBuffer.Slotted slot = RenderPrimitive.access$renderInstanced$asSlotted(task.getInstance().getModelData().getModelMatricesBuffer().getSlot());
                        $this$write.getLocalMatricesIndices().set(index, slot.getIndex());
                    }
                    this.$localMatricsBuffer.element = RenderPrimitive.access$renderInstanced$asSlotted(this.$firstInstance.getModelData().getModelMatricesBuffer().getSlot()).getBuffer().getBuffer();
                }
            });
            Integer n = node.getSkinIndex();
            if (n != null) {
                skinIndex = ((Number)n).intValue();
                j = false;
                skinModelIndices = SkinModelIndicesUniformBuffer.Companion.acquire();
                skinModelIndices.write((Function1)new Function1<SkinModelIndicesUniformBuffer.SkinModelIndicesLayout, Unit>(tasks, skinIndex){
                    final /* synthetic */ List<RenderTask.Instance> $tasks;
                    final /* synthetic */ int $skinIndex;
                    {
                        this.$tasks = $tasks;
                        this.$skinIndex = $skinIndex;
                        super(1);
                    }

                    public final void invoke(SkinModelIndicesUniformBuffer.SkinModelIndicesLayout $this$write) {
                        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
                        Iterator<T> iterator = ((Iterable)this.$tasks).iterator();
                        int n = 0;
                        while (iterator.hasNext()) {
                            int index = n++;
                            RenderTask.Instance task = (RenderTask.Instance)iterator.next();
                            RenderSkinBuffer skinBuffer = task.getInstance().getModelData().getSkinBuffers()[this.$skinIndex];
                            SlottedGpuBuffer.Slot slot = skinBuffer.getSlot();
                            $this$write.setSkinJoints(skinBuffer.getSkin().getJointSize());
                            $this$write.getSkinModelOffsets().set(index, RenderPrimitive.access$renderInstanced$asSlotted(slot).getIndex());
                        }
                    }
                });
                skinJointBuffer = RenderPrimitive.renderInstanced$asSlotted(firstInstance.getModelData().getSkinBuffers()[skinIndex].getSlot()).getBuffer().getBuffer();
            }
            Integer n2 = node.getMorphedPrimitiveIndex();
            if (n2 != null) {
                int weightsIndex = ((Number)n2).intValue();
                j = false;
                Targets targets2 = this.targets;
                if (targets2 != null) {
                    targets = targets2;
                    k = false;
                    morphDataUniformBuffer = MorphDataUniformBuffer.Companion.acquire();
                    morphDataUniformBuffer.write((Function1)new Function1<MorphDataUniformBuffer.MorphDataLayout, Unit>(this, targets){
                        final /* synthetic */ RenderPrimitive this$0;
                        final /* synthetic */ Targets $targets;
                        {
                            this.this$0 = $receiver;
                            this.$targets = $targets;
                            super(1);
                        }

                        public final void invoke(MorphDataUniformBuffer.MorphDataLayout $this$write) {
                            Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
                            $this$write.setTotalVertices(this.this$0.getVertexBuffer().getVerticesCount());
                            $this$write.setPosTargets(this.$targets.getPosition().getTargetsCount());
                            $this$write.setColorTargets(this.$targets.getColor().getTargetsCount());
                            $this$write.setTexCoordTargets(this.$targets.getTexCoord().getTargetsCount());
                            $this$write.setTotalTargets(this.$targets.getPosition().getTargetsCount() + this.$targets.getColor().getTargetsCount() + this.$targets.getTexCoord().getTargetsCount());
                        }
                    });
                }
                morphModelIndices = MorphModelIndicesUniformBuffer.Companion.acquire();
                morphModelIndices.write((Function1)new Function1<MorphModelIndicesUniformBuffer.MorphModelIndicesLayout, Unit>(tasks, weightsIndex, (Ref.ObjectRef<GpuBuffer>)morphWeightsBuffer, (Ref.ObjectRef<GpuBuffer>)morphTargetIndicesBuffer){
                    final /* synthetic */ List<RenderTask.Instance> $tasks;
                    final /* synthetic */ int $weightsIndex;
                    final /* synthetic */ Ref.ObjectRef<GpuBuffer> $morphWeightsBuffer;
                    final /* synthetic */ Ref.ObjectRef<GpuBuffer> $morphTargetIndicesBuffer;
                    {
                        this.$tasks = $tasks;
                        this.$weightsIndex = $weightsIndex;
                        this.$morphWeightsBuffer = $morphWeightsBuffer;
                        this.$morphTargetIndicesBuffer = $morphTargetIndicesBuffer;
                        super(1);
                    }

                    public final void invoke(MorphModelIndicesUniformBuffer.MorphModelIndicesLayout $this$write) {
                        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
                        Iterator<T> iterator = ((Iterable)this.$tasks).iterator();
                        int n = 0;
                        while (iterator.hasNext()) {
                            int index = n++;
                            RenderTask.Instance task = (RenderTask.Instance)iterator.next();
                            RenderTargetBuffer targetBuffer = task.getInstance().getModelData().getTargetBuffers()[this.$weightsIndex];
                            targetBuffer.uploadIndices();
                            SlottedGpuBuffer.Slotted weightsSlot = RenderPrimitive.access$renderInstanced$asSlotted(targetBuffer.getWeightsSlot());
                            SlottedGpuBuffer.Slotted indicesSlot = RenderPrimitive.access$renderInstanced$asSlotted(targetBuffer.getIndicesSlot());
                            $this$write.getMorphWeightIndices().set(index, weightsSlot.getIndex());
                            this.$morphWeightsBuffer.element = weightsSlot.getBuffer().getBuffer();
                            $this$write.getMorphIndexIndices().set(index, indicesSlot.getIndex());
                            this.$morphTargetIndicesBuffer.element = indicesSlot.getBuffer().getBuffer();
                        }
                    }
                });
            }
            Pair<RenderPass, UniformBuffer<?, ?>> setupResult2 = this.material.setup(true, (Function0<RenderPass>)((Function0)new Function0<RenderPass>(commandEncoder, mainColorTextureView, mainDepthTextureView){
                final /* synthetic */ CommandEncoder $commandEncoder;
                final /* synthetic */ GpuTextureView $mainColorTextureView;
                final /* synthetic */ GpuTextureView $mainDepthTextureView;
                {
                    this.$commandEncoder = $commandEncoder;
                    this.$mainColorTextureView = $mainColorTextureView;
                    this.$mainDepthTextureView = $mainDepthTextureView;
                    super(0);
                }

                public final RenderPass invoke() {
                    RenderPass renderPass = this.$commandEncoder.createRenderPass((Supplier)renderInstanced.setupResult.1.INSTANCE, this.$mainColorTextureView, OptionalInt.empty(), this.$mainDepthTextureView, OptionalDouble.empty());
                    Intrinsics.checkNotNullExpressionValue((Object)renderPass, (String)"createRenderPass(...)");
                    return renderPass;
                }
            }));
            renderPass2 = (RenderPass)setupResult2.getFirst();
            materialUniform = (UniformBuffer)setupResult2.getSecond();
            RenderPass $this$renderInstanced_u24lambda_u2430 = renderPass2;
            skinIndex = 0;
            if (class_10866.field_57867 && !(this.material.getSkinned() == (node.getSkinIndex() != null))) {
                j = false;
                String string = "Primitive's skin data and material skinned property not matching";
                throw new IllegalArgumentException(string.toString());
            }
            $this$renderInstanced_u24lambda_u2430.setUniform("InstanceData", instanceDataUniformBuffer.getSlice());
            $this$renderInstanced_u24lambda_u2430.setUniform("LocalMatrices", (GpuBuffer)localMatricsBuffer.element);
            GpuBuffer gpuBuffer2 = skinJointBuffer;
            if (gpuBuffer2 != null) {
                GpuBuffer skinJointBuffer2 = gpuBuffer2;
                k = false;
                $this$renderInstanced_u24lambda_u2430.setUniform("Joints", skinJointBuffer2);
            }
            SkinModelIndicesUniformBuffer skinModelIndicesUniformBuffer = skinModelIndices;
            if (skinModelIndicesUniformBuffer != null) {
                SkinModelIndicesUniformBuffer skinModelIndices2 = skinModelIndicesUniformBuffer;
                k = false;
                $this$renderInstanced_u24lambda_u2430.setUniform("SkinModelIndices", skinModelIndices2.getSlice());
            }
            MorphModelIndicesUniformBuffer morphModelIndicesUniformBuffer = morphModelIndices;
            if (morphModelIndicesUniformBuffer != null) {
                MorphModelIndicesUniformBuffer morphModelIndices2 = morphModelIndicesUniformBuffer;
                k = false;
                $this$renderInstanced_u24lambda_u2430.setUniform("MorphModelIndices", morphModelIndices2.getSlice());
            }
            MorphDataUniformBuffer morphDataUniformBuffer2 = morphDataUniformBuffer;
            if (morphDataUniformBuffer2 != null) {
                MorphDataUniformBuffer morphDataUniformBuffer3 = morphDataUniformBuffer2;
                k = false;
                $this$renderInstanced_u24lambda_u2430.setUniform("MorphData", morphDataUniformBuffer3.getSlice());
            }
            GpuBuffer gpuBuffer3 = (GpuBuffer)morphWeightsBuffer.element;
            if (gpuBuffer3 != null) {
                GpuBuffer morphWeightsBuffer2 = gpuBuffer3;
                k = false;
                $this$renderInstanced_u24lambda_u2430.setUniform("MorphWeights", morphWeightsBuffer2);
            }
            GpuBuffer gpuBuffer4 = (GpuBuffer)morphTargetIndicesBuffer.element;
            if (gpuBuffer4 != null) {
                GpuBuffer morphTargetIndicesBuffer2 = gpuBuffer4;
                k = false;
                $this$renderInstanced_u24lambda_u2430.setUniform("MorphTargetIndices", morphTargetIndicesBuffer2);
            }
            RenderPassExtKt.setVertexBuffer($this$renderInstanced_u24lambda_u2430, this.vertexBuffer);
            Targets targets3 = this.targets;
            if (targets3 != null) {
                targets = targets3;
                k = false;
                this.bindMorphTargets($this$renderInstanced_u24lambda_u2430, targets);
            }
            IndexBuffer indexBuffer = this.indexBuffer;
            if (indexBuffer != null) {
                IndexBuffer indices = indexBuffer;
                boolean l = false;
                IndexBufferKt.setIndexBuffer($this$renderInstanced_u24lambda_u2430, indices);
                $this$renderInstanced_u24lambda_u2430.drawIndexed(0, 0, indices.getLength(), tasks.size());
            } else {
                RenderPass $this$renderInstanced_u24lambda_u2430_u24lambda_u2429 = $this$renderInstanced_u24lambda_u2430;
                boolean l = false;
                RenderPassExtKt.draw($this$renderInstanced_u24lambda_u2430_u24lambda_u2429, 0, 0, this.vertexBuffer.getVerticesCount(), tasks.size());
            }
            renderPass = renderPass2;
        }
        catch (Throwable throwable) {
            RenderPass renderPass3 = renderPass2;
            if (renderPass3 != null) {
                renderPass3.close();
            }
            UniformBuffer uniformBuffer = materialUniform;
            if (uniformBuffer != null) {
                uniformBuffer.close();
            }
            InstanceDataUniformBuffer instanceDataUniformBuffer2 = instanceDataUniformBuffer;
            if (instanceDataUniformBuffer2 != null) {
                instanceDataUniformBuffer2.close();
            }
            SkinModelIndicesUniformBuffer skinModelIndicesUniformBuffer = skinModelIndices;
            if (skinModelIndicesUniformBuffer != null) {
                skinModelIndicesUniformBuffer.close();
            }
            MorphDataUniformBuffer morphDataUniformBuffer4 = morphDataUniformBuffer;
            if (morphDataUniformBuffer4 != null) {
                morphDataUniformBuffer4.close();
            }
            MorphModelIndicesUniformBuffer morphModelIndicesUniformBuffer = morphModelIndices;
            if (morphModelIndicesUniformBuffer != null) {
                morphModelIndicesUniformBuffer.close();
            }
            throw throwable;
        }
        if (renderPass != null) {
            renderPass.close();
        }
        UniformBuffer uniformBuffer = materialUniform;
        if (uniformBuffer != null) {
            uniformBuffer.close();
        }
        InstanceDataUniformBuffer instanceDataUniformBuffer3 = instanceDataUniformBuffer;
        if (instanceDataUniformBuffer3 != null) {
            instanceDataUniformBuffer3.close();
        }
        SkinModelIndicesUniformBuffer skinModelIndicesUniformBuffer = skinModelIndices;
        if (skinModelIndicesUniformBuffer != null) {
            skinModelIndicesUniformBuffer.close();
        }
        MorphDataUniformBuffer morphDataUniformBuffer5 = morphDataUniformBuffer;
        if (morphDataUniformBuffer5 != null) {
            morphDataUniformBuffer5.close();
        }
        MorphModelIndicesUniformBuffer morphModelIndicesUniformBuffer = morphModelIndices;
        if (morphModelIndicesUniformBuffer != null) {
            morphModelIndicesUniformBuffer.close();
        }
    }

    @Override
    protected void onClosed() {
        block1: {
            Targets targets;
            this.vertexBuffer.decreaseReferenceCount();
            IndexBuffer indexBuffer = this.indexBuffer;
            if (indexBuffer != null) {
                indexBuffer.decreaseReferenceCount();
            }
            this.material.decreaseReferenceCount();
            Targets targets2 = this.targets;
            if (targets2 == null) break block1;
            Targets $this$onClosed_u24lambda_u2431 = targets = targets2;
            boolean i2 = false;
            $this$onClosed_u24lambda_u2431.getPosition().close();
            $this$onClosed_u24lambda_u2431.getColor().close();
            $this$onClosed_u24lambda_u2431.getTexCoord().close();
        }
    }

    private static final SlottedGpuBuffer.Slotted renderInstanced$asSlotted(SlottedGpuBuffer.Slot $this$renderInstanced_u24asSlotted) {
        Intrinsics.checkNotNull((Object)$this$renderInstanced_u24asSlotted, (String)"null cannot be cast to non-null type top.fifthlight.armorstand.util.SlottedGpuBuffer.Slotted");
        return (SlottedGpuBuffer.Slotted)$this$renderInstanced_u24asSlotted;
    }

    public static final /* synthetic */ Vector2i access$getLightVector$p(RenderPrimitive $this) {
        return $this.lightVector;
    }

    public static final /* synthetic */ SlottedGpuBuffer.Slotted access$renderInstanced$asSlotted(SlottedGpuBuffer.Slot $receiver) {
        return RenderPrimitive.renderInstanced$asSlotted($receiver);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Ltop/fifthlight/armorstand/model/RenderPrimitive$Companion;", "", "<init>", "()V", "TYPE_ID", "Lnet/minecraft/util/Identifier;", "kotlin.jvm.PlatformType", "Lnet/minecraft/util/Identifier;", "top_fifthlight_armorstand"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u000eH\u0096\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Ltop/fifthlight/armorstand/model/RenderPrimitive$Target;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "data", "Lcom/mojang/blaze3d/buffers/GpuBuffer;", "targetsCount", "", "<init>", "(Lcom/mojang/blaze3d/buffers/GpuBuffer;I)V", "getData", "()Lcom/mojang/blaze3d/buffers/GpuBuffer;", "getTargetsCount", "()I", "close", "", "top_fifthlight_armorstand"})
    public static final class Target
    implements AutoCloseable {
        @NotNull
        private final GpuBuffer data;
        private final int targetsCount;

        public Target(@NotNull GpuBuffer data, int targetsCount) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.data = data;
            this.targetsCount = targetsCount;
            if (!((this.data.usage() & 0x100) != 0)) {
                boolean i2 = false;
                String string = "RenderPrimitive's target should have buffer with usage USAGE_UNIFORM_TEXEL_BUFFER";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final GpuBuffer getData() {
            return this.data;
        }

        public final int getTargetsCount() {
            return this.targetsCount;
        }

        @Override
        public void close() {
            this.data.close();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Ltop/fifthlight/armorstand/model/RenderPrimitive$Targets;", "", "position", "Ltop/fifthlight/armorstand/model/RenderPrimitive$Target;", "color", "texCoord", "<init>", "(Ltop/fifthlight/armorstand/model/RenderPrimitive$Target;Ltop/fifthlight/armorstand/model/RenderPrimitive$Target;Ltop/fifthlight/armorstand/model/RenderPrimitive$Target;)V", "getPosition", "()Ltop/fifthlight/armorstand/model/RenderPrimitive$Target;", "getColor", "getTexCoord", "top_fifthlight_armorstand"})
    public static final class Targets {
        @NotNull
        private final Target position;
        @NotNull
        private final Target color;
        @NotNull
        private final Target texCoord;

        public Targets(@NotNull Target position, @NotNull Target color, @NotNull Target texCoord) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            Intrinsics.checkNotNullParameter((Object)texCoord, (String)"texCoord");
            this.position = position;
            this.color = color;
            this.texCoord = texCoord;
        }

        @NotNull
        public final Target getPosition() {
            return this.position;
        }

        @NotNull
        public final Target getColor() {
            return this.color;
        }

        @NotNull
        public final Target getTexCoord() {
            return this.texCoord;
        }
    }
}

