/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.armorstand.model.data;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import top.fifthlight.armorstand.model.RenderPrimitive;
import top.fifthlight.armorstand.util.SlottedGpuBuffer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u001d2\u00060\u0001j\u0002`\u0002:\u0003\u001d\u001e\u001fB1\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bB!\b\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000eJ\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\u001bH\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\u0018\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015\u00a8\u0006 "}, d2={"Ltop/fifthlight/armorstand/model/data/RenderTargetBuffer;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "positionTargets", "", "colorTargets", "texCoordTargets", "weightsSlot", "Ltop/fifthlight/armorstand/util/SlottedGpuBuffer$Slot;", "indicesSlot", "<init>", "(IIILtop/fifthlight/armorstand/util/SlottedGpuBuffer$Slot;Ltop/fifthlight/armorstand/util/SlottedGpuBuffer$Slot;)V", "targets", "Ltop/fifthlight/armorstand/model/RenderPrimitive$Targets;", "(Ltop/fifthlight/armorstand/model/RenderPrimitive$Targets;Ltop/fifthlight/armorstand/util/SlottedGpuBuffer$Slot;Ltop/fifthlight/armorstand/util/SlottedGpuBuffer$Slot;)V", "getWeightsSlot", "()Ltop/fifthlight/armorstand/util/SlottedGpuBuffer$Slot;", "getIndicesSlot", "positionChannel", "Ltop/fifthlight/armorstand/model/data/RenderTargetBuffer$WeightChannel;", "getPositionChannel", "()Ltop/fifthlight/armorstand/model/data/RenderTargetBuffer$WeightChannel;", "colorChannel", "getColorChannel", "texCoordChannel", "getTexCoordChannel", "uploadIndices", "", "close", "Companion", "WeightChannel", "WeightChannelImpl", "top_fifthlight_armorstand"})
@SourceDebugExtension(value={"SMAP\nRenderTargetBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderTargetBuffer.kt\ntop/fifthlight/armorstand/model/data/RenderTargetBuffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n1#2:128\n*E\n"})
public final class RenderTargetBuffer
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SlottedGpuBuffer.Slot weightsSlot;
    @NotNull
    private final SlottedGpuBuffer.Slot indicesSlot;
    @NotNull
    private final WeightChannel positionChannel;
    @NotNull
    private final WeightChannel colorChannel;
    @NotNull
    private final WeightChannel texCoordChannel;
    public static final int INDICES_ENTRY_SIZE = 396;

    private RenderTargetBuffer(int positionTargets, int colorTargets, int texCoordTargets, SlottedGpuBuffer.Slot weightsSlot, SlottedGpuBuffer.Slot indicesSlot) {
        this.weightsSlot = weightsSlot;
        this.indicesSlot = indicesSlot;
        int totalTargets = positionTargets + colorTargets + texCoordTargets;
        if (!(this.weightsSlot.getSize() == 4 * totalTargets)) {
            boolean i22 = false;
            String i22 = "Weights slot size mismatch: want " + 4 * totalTargets + ", but got " + this.weightsSlot.getSize();
            throw new IllegalArgumentException(i22.toString());
        }
        if (!(this.indicesSlot.getSize() == 396)) {
            boolean i2 = false;
            String string = "Indices slot size not match: want 396, but got " + this.indicesSlot.getSize();
            throw new IllegalArgumentException(string.toString());
        }
        this.positionChannel = new WeightChannelImpl(0, 0, positionTargets);
        this.colorChannel = new WeightChannelImpl(1, positionTargets, colorTargets);
        this.texCoordChannel = new WeightChannelImpl(2, positionTargets + colorTargets, texCoordTargets);
    }

    @NotNull
    public final SlottedGpuBuffer.Slot getWeightsSlot() {
        return this.weightsSlot;
    }

    @NotNull
    public final SlottedGpuBuffer.Slot getIndicesSlot() {
        return this.indicesSlot;
    }

    public RenderTargetBuffer(@NotNull RenderPrimitive.Targets targets, @NotNull SlottedGpuBuffer.Slot weightsSlot, @NotNull SlottedGpuBuffer.Slot indicesSlot) {
        Intrinsics.checkNotNullParameter((Object)targets, (String)"targets");
        Intrinsics.checkNotNullParameter((Object)weightsSlot, (String)"weightsSlot");
        Intrinsics.checkNotNullParameter((Object)indicesSlot, (String)"indicesSlot");
        this(targets.getPosition().getTargetsCount(), targets.getColor().getTargetsCount(), targets.getTexCoord().getTargetsCount(), weightsSlot, indicesSlot);
    }

    @NotNull
    public final WeightChannel getPositionChannel() {
        return this.positionChannel;
    }

    @NotNull
    public final WeightChannel getColorChannel() {
        return this.colorChannel;
    }

    @NotNull
    public final WeightChannel getTexCoordChannel() {
        return this.texCoordChannel;
    }

    public final void uploadIndices() {
        this.positionChannel.uploadIndices();
        this.colorChannel.uploadIndices();
        this.texCoordChannel.uploadIndices();
    }

    @Override
    public void close() {
        this.weightsSlot.close();
        this.indicesSlot.close();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ltop/fifthlight/armorstand/model/data/RenderTargetBuffer$Companion;", "", "<init>", "()V", "INDICES_ENTRY_SIZE", "", "top_fifthlight_armorstand"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0019\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u00a6\u0002\u00a8\u0006\t"}, d2={"Ltop/fifthlight/armorstand/model/data/RenderTargetBuffer$WeightChannel;", "", "uploadIndices", "", "set", "index", "", "weight", "", "top_fifthlight_armorstand"})
    public static interface WeightChannel {
        public void uploadIndices();

        public void set(int var1, float var2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B)\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tB!\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\fJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0019\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0096\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ltop/fifthlight/armorstand/model/data/RenderTargetBuffer$WeightChannelImpl;", "Ltop/fifthlight/armorstand/model/data/RenderTargetBuffer$WeightChannel;", "channelByteOffset", "", "weightByteOffset", "enabledIndices", "Lit/unimi/dsi/fastutil/ints/IntSet;", "targetsSize", "<init>", "(Ltop/fifthlight/armorstand/model/data/RenderTargetBuffer;IILit/unimi/dsi/fastutil/ints/IntSet;I)V", "channelIndex", "weightOffset", "(Ltop/fifthlight/armorstand/model/data/RenderTargetBuffer;III)V", "indicesDirty", "", "uploadIndices", "", "set", "index", "weight", "", "top_fifthlight_armorstand"})
    @SourceDebugExtension(value={"SMAP\nRenderTargetBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderTargetBuffer.kt\ntop/fifthlight/armorstand/model/data/RenderTargetBuffer$WeightChannelImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n1#2:128\n*E\n"})
    private final class WeightChannelImpl
    implements WeightChannel {
        private final int channelByteOffset;
        private final int weightByteOffset;
        @NotNull
        private final IntSet enabledIndices;
        private final int targetsSize;
        private boolean indicesDirty;

        private WeightChannelImpl(int channelByteOffset, int weightByteOffset, IntSet enabledIndices, int targetsSize) {
            this.channelByteOffset = channelByteOffset;
            this.weightByteOffset = weightByteOffset;
            this.enabledIndices = enabledIndices;
            this.targetsSize = targetsSize;
        }

        public WeightChannelImpl(int channelIndex, int weightOffset, int targetsSize) {
            this(channelIndex * 4, weightOffset * 4, (IntSet)new IntOpenHashSet(targetsSize), targetsSize);
        }

        @Override
        public void uploadIndices() {
            if (!this.indicesDirty) {
                return;
            }
            this.indicesDirty = false;
            RenderTargetBuffer.this.getIndicesSlot().edit((Function1<? super ByteBuffer, Unit>)((Function1)new Function1<ByteBuffer, Unit>(this){
                final /* synthetic */ WeightChannelImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(ByteBuffer $this$edit) {
                    Intrinsics.checkNotNullParameter((Object)$this$edit, (String)"$this$edit");
                    int effectiveEnabledTargets = RangesKt.coerceAtMost((int)WeightChannelImpl.access$getEnabledIndices$p(this.this$0).size(), (int)32);
                    $this$edit.putInt(WeightChannelImpl.access$getChannelByteOffset$p(this.this$0), effectiveEnabledTargets);
                    IntIterator iterator = WeightChannelImpl.access$getEnabledIndices$p(this.this$0).intIterator();
                    for (int index = 0; iterator.hasNext() && index < effectiveEnabledTargets; ++index) {
                        $this$edit.putInt(12 + index * 12 + WeightChannelImpl.access$getChannelByteOffset$p(this.this$0), iterator.nextInt());
                    }
                }
            }));
        }

        @Override
        public void set(int index, float weight) {
            if (!(0 <= index ? index < this.targetsSize : false)) {
                boolean i2 = false;
                String string = "Invalid target index: " + index + ", should be in [0, " + this.targetsSize + ")";
                throw new IllegalStateException(string.toString());
            }
            RenderTargetBuffer.this.getWeightsSlot().edit((Function1<? super ByteBuffer, Unit>)((Function1)new Function1<ByteBuffer, Unit>(this, index, weight){
                final /* synthetic */ WeightChannelImpl this$0;
                final /* synthetic */ int $index;
                final /* synthetic */ float $weight;
                {
                    this.this$0 = $receiver;
                    this.$index = $index;
                    this.$weight = $weight;
                    super(1);
                }

                public final void invoke(ByteBuffer $this$edit) {
                    Intrinsics.checkNotNullParameter((Object)$this$edit, (String)"$this$edit");
                    $this$edit.putFloat(WeightChannelImpl.access$getWeightByteOffset$p(this.this$0) + this.$index * 4, this.$weight);
                }
            }));
            if (weight == 0.0f) {
                if (this.enabledIndices.remove(index)) {
                    this.indicesDirty = true;
                }
            } else if (this.enabledIndices.add(index)) {
                this.indicesDirty = true;
            }
        }

        public static final /* synthetic */ IntSet access$getEnabledIndices$p(WeightChannelImpl $this) {
            return $this.enabledIndices;
        }

        public static final /* synthetic */ int access$getChannelByteOffset$p(WeightChannelImpl $this) {
            return $this.channelByteOffset;
        }

        public static final /* synthetic */ int access$getWeightByteOffset$p(WeightChannelImpl $this) {
            return $this.weightByteOffset;
        }
    }
}

