/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.armorstand.model.uniform;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import top.fifthlight.armorstand.std140.Std140Layout;
import top.fifthlight.armorstand.util.Pool;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\u0014\b\u0000\u0010\u0001*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0000*\u000e\b\u0001\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00032\u00060\u0004j\u0002`\u0005B\u000f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\n\u001a\u00028\u0001\u00a2\u0006\u0004\b\b\u0010\u000bJ\u001f\u0010\u001c\u001a\u00020\u001d2\u0017\u0010\u001e\u001a\u0013\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u001d0\u001f\u00a2\u0006\u0002\b J\b\u0010!\u001a\u00020\u001dH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0012\u0010\n\u001a\u00028\u0001X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\""}, d2={"Ltop/fifthlight/armorstand/model/uniform/UniformBuffer;", "T", "L", "Ltop/fifthlight/armorstand/std140/Std140Layout;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "buffer", "Lcom/mojang/blaze3d/buffers/GpuBuffer;", "<init>", "(Lcom/mojang/blaze3d/buffers/GpuBuffer;)V", "layout", "(Ltop/fifthlight/armorstand/std140/Std140Layout;)V", "pool", "Ltop/fifthlight/armorstand/util/Pool;", "getPool", "()Ltop/fifthlight/armorstand/util/Pool;", "released", "", "getReleased", "()Z", "setReleased", "(Z)V", "slice", "Lcom/mojang/blaze3d/buffers/GpuBufferSlice;", "getSlice", "()Lcom/mojang/blaze3d/buffers/GpuBufferSlice;", "getLayout", "()Ltop/fifthlight/armorstand/std140/Std140Layout;", "write", "", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "close", "top_fifthlight_armorstand"})
@SourceDebugExtension(value={"SMAP\nUniformBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UniformBuffer.kt\ntop/fifthlight/armorstand/model/uniform/UniformBuffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,44:1\n1#2:45\n*E\n"})
public abstract class UniformBuffer<T extends UniformBuffer<T, L>, L extends Std140Layout<L>>
implements AutoCloseable {
    @NotNull
    private final GpuBuffer buffer;
    private boolean released;
    @NotNull
    private final GpuBufferSlice slice;

    public UniformBuffer(@NotNull GpuBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.buffer = buffer;
        GpuBufferSlice gpuBufferSlice = this.buffer.slice();
        Intrinsics.checkNotNullExpressionValue((Object)gpuBufferSlice, (String)"slice(...)");
        this.slice = gpuBufferSlice;
        if (!(((Std140Layout)this.getLayout()).getTotalSize() <= 65536)) {
            boolean i2 = false;
            String string = "Uniform size too big: " + ((Std140Layout)this.getLayout()).getTotalSize() + ", maximum is 65536";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public abstract Pool<T> getPool();

    protected final boolean getReleased() {
        return this.released;
    }

    protected final void setReleased(boolean bl) {
        this.released = bl;
    }

    public UniformBuffer(@NotNull L layout) {
        Intrinsics.checkNotNullParameter(layout, (String)"layout");
        GpuBuffer gpuBuffer2 = RenderSystem.getDevice().createBuffer((Supplier)1.INSTANCE, 130, ((Std140Layout)layout).getTotalSize());
        Intrinsics.checkNotNullExpressionValue((Object)gpuBuffer2, (String)"createBuffer(...)");
        this(gpuBuffer2);
    }

    @NotNull
    public final GpuBufferSlice getSlice() {
        return this.slice;
    }

    @NotNull
    public abstract L getLayout();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(@NotNull Function1<? super L, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (!(!this.released)) {
            boolean i22 = false;
            String i22 = "Attempt to write a closed uniform buffer";
            throw new IllegalArgumentException(i22.toString());
        }
        GpuDevice device = RenderSystem.getDevice();
        CommandEncoder commandEncoder = device.createCommandEncoder();
        AutoCloseable autoCloseable = (AutoCloseable)commandEncoder.mapBuffer(this.buffer, false, true);
        Throwable throwable = null;
        try {
            GpuBuffer.MappedView mappedView = (GpuBuffer.MappedView)autoCloseable;
            boolean j = false;
            ? super L v0 = this.getLayout();
            ByteBuffer byteBuffer = mappedView.data();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"data(...)");
            v0.withBuffer(byteBuffer, block);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    public void close() {
        if (this.released) {
            return;
        }
        this.released = true;
        Pool<UniformBuffer> pool = this.getPool();
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type T of top.fifthlight.armorstand.model.uniform.UniformBuffer");
        pool.release(this);
    }
}

