/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.armorstand.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_10055;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import top.fifthlight.armorstand.animation.AnimationItem;
import top.fifthlight.armorstand.animation.Timeline;
import top.fifthlight.armorstand.model.ModelInstance;
import top.fifthlight.armorstand.model.RenderExpression;
import top.fifthlight.armorstand.model.RenderNode;
import top.fifthlight.armorstand.model.RenderScene;
import top.fifthlight.armorstand.util.MathUtilKt;
import top.fifthlight.renderer.model.Expression;
import top.fifthlight.renderer.model.HumanoidTag;
import top.fifthlight.renderer.model.NodeTransform;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\r\u000e\u000fB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH&\u0082\u0001\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Ltop/fifthlight/armorstand/state/ModelController;", "", "<init>", "()V", "update", "", "uuid", "Ljava/util/UUID;", "vanillaState", "Lnet/minecraft/client/render/entity/state/PlayerEntityRenderState;", "apply", "instance", "Ltop/fifthlight/armorstand/model/ModelInstance;", "JointItem", "LiveUpdated", "Predefined", "Ltop/fifthlight/armorstand/state/ModelController$LiveUpdated;", "Ltop/fifthlight/armorstand/state/ModelController$Predefined;", "top_fifthlight_armorstand"})
public abstract sealed class ModelController {
    private ModelController() {
    }

    public void update(@NotNull UUID uuid, @NotNull class_10055 vanillaState) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)vanillaState, (String)"vanillaState");
    }

    public abstract void apply(@NotNull ModelInstance var1);

    public /* synthetic */ ModelController(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J/\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0019\b\u0004\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b0\u000f\u00a2\u0006\u0002\b\u0010H\u0086\b\u00f8\u0001\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0011"}, d2={"Ltop/fifthlight/armorstand/state/ModelController$JointItem;", "", "initialMatrix", "Lorg/joml/Matrix4fc;", "transformIndex", "", "<init>", "(Lorg/joml/Matrix4fc;I)V", "targetMatrix", "Lorg/joml/Matrix4f;", "update", "", "instance", "Ltop/fifthlight/armorstand/model/ModelInstance;", "func", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "top_fifthlight_armorstand"})
    private static final class JointItem {
        @NotNull
        private final Matrix4fc initialMatrix;
        private final int transformIndex;
        @NotNull
        private final Matrix4f targetMatrix;

        public JointItem(@NotNull Matrix4fc initialMatrix, int transformIndex) {
            Intrinsics.checkNotNullParameter((Object)initialMatrix, (String)"initialMatrix");
            this.initialMatrix = initialMatrix;
            this.transformIndex = transformIndex;
            this.targetMatrix = new Matrix4f();
        }

        public final void update(@NotNull ModelInstance instance, @NotNull Function1<? super Matrix4f, Unit> func) {
            Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
            Intrinsics.checkNotNullParameter(func, (String)"func");
            boolean $i$f$update = false;
            this.targetMatrix.set(this.initialMatrix);
            func.invoke((Object)this.targetMatrix);
            instance.setTransformMatrix(this.transformIndex, this.targetMatrix);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB'\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ltop/fifthlight/armorstand/state/ModelController$LiveUpdated;", "Ltop/fifthlight/armorstand/state/ModelController;", "center", "Ltop/fifthlight/armorstand/state/ModelController$JointItem;", "head", "blinkExpression", "Ltop/fifthlight/armorstand/model/RenderExpression;", "<init>", "(Ltop/fifthlight/armorstand/state/ModelController$JointItem;Ltop/fifthlight/armorstand/state/ModelController$JointItem;Ltop/fifthlight/armorstand/model/RenderExpression;)V", "scene", "Ltop/fifthlight/armorstand/model/RenderScene;", "(Ltop/fifthlight/armorstand/model/RenderScene;)V", "bodyYaw", "", "headYaw", "headPitch", "blinkProgress", "update", "", "uuid", "Ljava/util/UUID;", "vanillaState", "Lnet/minecraft/client/render/entity/state/PlayerEntityRenderState;", "apply", "instance", "Ltop/fifthlight/armorstand/model/ModelInstance;", "Companion", "top_fifthlight_armorstand"})
    @SourceDebugExtension(value={"SMAP\nModelController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelController.kt\ntop/fifthlight/armorstand/state/ModelController$LiveUpdated\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ModelController.kt\ntop/fifthlight/armorstand/state/ModelController$JointItem\n*L\n1#1,118:1\n295#2,2:119\n1869#2,2:129\n32#3,4:121\n32#3,4:125\n*S KotlinDebug\n*F\n+ 1 ModelController.kt\ntop/fifthlight/armorstand/state/ModelController$LiveUpdated\n*L\n51#1:119,2\n81#1:129,2\n74#1:121,4\n77#1:125,4\n*E\n"})
    public static final class LiveUpdated
    extends ModelController {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final JointItem center;
        @Nullable
        private final JointItem head;
        @Nullable
        private final RenderExpression blinkExpression;
        private float bodyYaw;
        private float headYaw;
        private float headPitch;
        private float blinkProgress;

        private LiveUpdated(JointItem center, JointItem head, RenderExpression blinkExpression) {
            super(null);
            this.center = center;
            this.head = head;
            this.blinkExpression = blinkExpression;
        }

        /*
         * WARNING - void declaration
         */
        public LiveUpdated(@NotNull RenderScene scene) {
            Object v0;
            LiveUpdated liveUpdated;
            JointItem jointItem;
            JointItem jointItem2;
            block1: {
                void $this$firstOrNull$iv;
                Intrinsics.checkNotNullParameter((Object)scene, (String)"scene");
                Iterable iterable = scene.getExpressions();
                jointItem2 = LiveUpdated.Companion.getBone(scene, HumanoidTag.HEAD);
                jointItem = LiveUpdated.Companion.getBone(scene, HumanoidTag.CENTER);
                liveUpdated = this;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    RenderExpression it = (RenderExpression)element$iv;
                    boolean i2 = false;
                    if (!(it.getTag() == Expression.Tag.Blink.BLINK)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            Object var11_11 = v0;
            liveUpdated(jointItem, jointItem2, var11_11);
        }

        @Override
        public void update(@NotNull UUID uuid, @NotNull class_10055 vanillaState) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Intrinsics.checkNotNullParameter((Object)vanillaState, (String)"vanillaState");
            this.bodyYaw = (float)Math.PI - MathUtilKt.toRadian(vanillaState.field_53446);
            this.headYaw = -MathUtilKt.toRadian(vanillaState.field_53447);
            this.headPitch = -MathUtilKt.toRadian(vanillaState.field_53448);
            this.blinkProgress = (float)Math.abs(System.currentTimeMillis() % (long)2000 - (long)1000) / 1000.0f;
        }

        @Override
        public void apply(@NotNull ModelInstance instance) {
            block4: {
                boolean i2;
                boolean $i$f$update;
                JointItem this_$iv;
                Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
                JointItem jointItem = this.center;
                if (jointItem != null) {
                    this_$iv = jointItem;
                    $i$f$update = false;
                    this_$iv.targetMatrix.set(this_$iv.initialMatrix);
                    Matrix4f $this$apply_u24lambda_u241 = this_$iv.targetMatrix;
                    i2 = false;
                    $this$apply_u24lambda_u241.rotateY(this.bodyYaw);
                    instance.setTransformMatrix(this_$iv.transformIndex, this_$iv.targetMatrix);
                }
                JointItem jointItem2 = this.head;
                if (jointItem2 != null) {
                    this_$iv = jointItem2;
                    $i$f$update = false;
                    this_$iv.targetMatrix.set(this_$iv.initialMatrix);
                    Matrix4f $this$apply_u24lambda_u242 = this_$iv.targetMatrix;
                    i2 = false;
                    $this$apply_u24lambda_u242.rotateYXZ(this.headYaw, this.headPitch, 0.0f);
                    instance.setTransformMatrix(this_$iv.transformIndex, this_$iv.targetMatrix);
                }
                RenderExpression renderExpression = this.blinkExpression;
                if (renderExpression == null) break block4;
                RenderExpression expression = renderExpression;
                boolean k = false;
                Iterable $this$forEach$iv = expression.getBindings();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    RenderExpression.Binding binding = (RenderExpression.Binding)element$iv;
                    boolean j = false;
                    if (binding instanceof RenderExpression.Binding.MorphTarget) {
                        instance.setGroupWeight(((RenderExpression.Binding.MorphTarget)binding).getMorphedPrimitiveIndex(), ((RenderExpression.Binding.MorphTarget)binding).getGroupIndex(), this.blinkProgress);
                        continue;
                    }
                    throw new NoWhenBranchMatchedException();
                }
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Ltop/fifthlight/armorstand/state/ModelController$LiveUpdated$Companion;", "", "<init>", "()V", "getBone", "Ltop/fifthlight/armorstand/state/ModelController$JointItem;", "Ltop/fifthlight/armorstand/model/RenderScene;", "tag", "Ltop/fifthlight/renderer/model/HumanoidTag;", "top_fifthlight_armorstand"})
        @SourceDebugExtension(value={"SMAP\nModelController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelController.kt\ntop/fifthlight/armorstand/state/ModelController$LiveUpdated$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n1#2:119\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            private final JointItem getBone(RenderScene $this$getBone, HumanoidTag tag) {
                JointItem jointItem;
                Integer n = $this$getBone.getHumanoidTagToTransformMap().getInt((Object)tag);
                int it = ((Number)n).intValue();
                boolean i2 = false;
                Integer n2 = it != -1 ? n : null;
                if (n2 != null) {
                    int transformIndex = ((Number)n2).intValue();
                    i2 = false;
                    int nodeIndex = $this$getBone.getTransformNodeIndices().getInt(transformIndex);
                    RenderNode renderNode = $this$getBone.getNodes().get(nodeIndex);
                    Intrinsics.checkNotNull((Object)renderNode, (String)"null cannot be cast to non-null type top.fifthlight.armorstand.model.RenderNode.Transform");
                    RenderNode.Transform transformNode = (RenderNode.Transform)renderNode;
                    NodeTransform nodeTransform = transformNode.getDefaultTransform();
                    if (nodeTransform == null || (nodeTransform = nodeTransform.getMatrix()) == null) {
                        nodeTransform = (Matrix4fc)new Matrix4f();
                    }
                    jointItem = new JointItem((Matrix4fc)nodeTransform, transformIndex);
                } else {
                    jointItem = null;
                }
                return jointItem;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ltop/fifthlight/armorstand/state/ModelController$Predefined;", "Ltop/fifthlight/armorstand/state/ModelController;", "animations", "", "Ltop/fifthlight/armorstand/animation/AnimationItem;", "<init>", "(Ljava/util/List;)V", "items", "Ltop/fifthlight/armorstand/state/ModelController$Predefined$Item;", "apply", "", "instance", "Ltop/fifthlight/armorstand/model/ModelInstance;", "Item", "top_fifthlight_armorstand"})
    @SourceDebugExtension(value={"SMAP\nModelController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelController.kt\ntop/fifthlight/armorstand/state/ModelController$Predefined\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n1563#2:119\n1634#2,3:120\n1869#2,2:123\n*S KotlinDebug\n*F\n+ 1 ModelController.kt\ntop/fifthlight/armorstand/state/ModelController$Predefined\n*L\n100#1:119\n100#1:120,3\n113#1:123,2\n*E\n"})
    public static final class Predefined
    extends ModelController {
        @NotNull
        private final List<Item> items;

        /*
         * WARNING - void declaration
         */
        public Predefined(@NotNull List<AnimationItem> animations) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(animations, (String)"animations");
            super(null);
            Iterable iterable = animations;
            Predefined predefined = this;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void timeline;
                void it;
                Timeline timeline2;
                AnimationItem animationItem = (AnimationItem)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean j = false;
                Timeline timeline3 = timeline2 = new Timeline(it.getDuration(), true, 0.0f, 4, null);
                void var13_14 = it;
                boolean i2 = false;
                timeline.play(System.nanoTime());
                Timeline timeline4 = timeline2;
                void var18_18 = var13_14;
                collection.add(new Item((AnimationItem)var18_18, timeline4));
            }
            predefined.items = (List)destination$iv$iv;
        }

        @Override
        public void apply(@NotNull ModelInstance instance) {
            Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
            Iterable $this$forEach$iv = this.items;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Item it = (Item)element$iv;
                boolean i2 = false;
                it.getAnimation().apply(instance, it.getTimeline().getCurrentTime(System.nanoTime()));
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Ltop/fifthlight/armorstand/state/ModelController$Predefined$Item;", "", "animation", "Ltop/fifthlight/armorstand/animation/AnimationItem;", "timeline", "Ltop/fifthlight/armorstand/animation/Timeline;", "<init>", "(Ltop/fifthlight/armorstand/animation/AnimationItem;Ltop/fifthlight/armorstand/animation/Timeline;)V", "getAnimation", "()Ltop/fifthlight/armorstand/animation/AnimationItem;", "getTimeline", "()Ltop/fifthlight/armorstand/animation/Timeline;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "top_fifthlight_armorstand"})
        private static final class Item {
            @NotNull
            private final AnimationItem animation;
            @NotNull
            private final Timeline timeline;

            public Item(@NotNull AnimationItem animation, @NotNull Timeline timeline) {
                Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                Intrinsics.checkNotNullParameter((Object)timeline, (String)"timeline");
                this.animation = animation;
                this.timeline = timeline;
            }

            @NotNull
            public final AnimationItem getAnimation() {
                return this.animation;
            }

            @NotNull
            public final Timeline getTimeline() {
                return this.timeline;
            }

            @NotNull
            public final AnimationItem component1() {
                return this.animation;
            }

            @NotNull
            public final Timeline component2() {
                return this.timeline;
            }

            @NotNull
            public final Item copy(@NotNull AnimationItem animation, @NotNull Timeline timeline) {
                Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                Intrinsics.checkNotNullParameter((Object)timeline, (String)"timeline");
                return new Item(animation, timeline);
            }

            public static /* synthetic */ Item copy$default(Item item, AnimationItem animationItem, Timeline timeline, int i2, Object object) {
                if ((i2 & 1) != 0) {
                    animationItem = item.animation;
                }
                if ((i2 & 2) != 0) {
                    timeline = item.timeline;
                }
                return item.copy(animationItem, timeline);
            }

            @NotNull
            public String toString() {
                return "Item(animation=" + this.animation + ", timeline=" + this.timeline + ")";
            }

            public int hashCode() {
                int result = this.animation.hashCode();
                result = result * 31 + this.timeline.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Item)) {
                    return false;
                }
                Item item = (Item)other;
                if (!Intrinsics.areEqual((Object)this.animation, (Object)item.animation)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.timeline, (Object)item.timeline);
            }
        }
    }
}

