/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.armorstand.util;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import top.fifthlight.armorstand.model.RenderNode;
import top.fifthlight.armorstand.render.IndexBuffer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006J,\u0010\u0007\u001a\u00020\b*\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\rJ\u0016\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u0011"}, d2={"Ltop/fifthlight/armorstand/util/ModelDumper;", "", "<init>", "()V", "getNodeDescription", "", "Ltop/fifthlight/armorstand/model/RenderNode;", "dumpTreeInternal", "", "logger", "Lorg/slf4j/Logger;", "prefix", "isLastChild", "", "isFirst", "dumpNode", "node", "top_fifthlight_armorstand"})
@SourceDebugExtension(value={"SMAP\nModelDumper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelDumper.kt\ntop/fifthlight/armorstand/util/ModelDumper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,35:1\n1878#2,3:36\n*S KotlinDebug\n*F\n+ 1 ModelDumper.kt\ntop/fifthlight/armorstand/util/ModelDumper\n*L\n26#1:36,3\n*E\n"})
public final class ModelDumper {
    @NotNull
    public static final ModelDumper INSTANCE = new ModelDumper();

    private ModelDumper() {
    }

    @NotNull
    public final String getNodeDescription(@NotNull RenderNode $this$getNodeDescription) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$getNodeDescription, (String)"<this>");
        RenderNode renderNode = $this$getNodeDescription;
        if (renderNode instanceof RenderNode.Group) {
            string = "Group (" + ((RenderNode.Group)$this$getNodeDescription).getChildren().size() + " children)";
        } else if (renderNode instanceof RenderNode.Transform) {
            string = "Transform[targetIndex=" + ((RenderNode.Transform)$this$getNodeDescription).getTransformIndex() + "]";
        } else if (renderNode instanceof RenderNode.Primitive) {
            IndexBuffer indexBuffer = ((RenderNode.Primitive)$this$getNodeDescription).getPrimitive().getIndexBuffer();
            string = "Primitive[material=" + ((RenderNode.Primitive)$this$getNodeDescription).getPrimitive().getMaterial() + ", skinIndex=" + ((RenderNode.Primitive)$this$getNodeDescription).getSkinIndex() + ", vertices=" + ((RenderNode.Primitive)$this$getNodeDescription).getPrimitive().getVertexBuffer().getVerticesCount() + ", indices=" + (indexBuffer != null ? Integer.valueOf(indexBuffer.getLength()) : null) + "]";
        } else if (renderNode instanceof RenderNode.Joint) {
            string = "Joint[skinIndex=" + ((RenderNode.Joint)$this$getNodeDescription).getSkinIndex() + ", jointIndex=" + ((RenderNode.Joint)$this$getNodeDescription).getJointIndex() + "]";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final void dumpTreeInternal(@NotNull RenderNode $this$dumpTreeInternal, @NotNull Logger logger, @NotNull String prefix, boolean isLastChild, boolean isFirst) {
        Intrinsics.checkNotNullParameter((Object)$this$dumpTreeInternal, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        String currentSymbol = isFirst ? "" : (isLastChild ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ");
        logger.info(prefix + currentSymbol + this.getNodeDescription($this$dumpTreeInternal));
        List children = CollectionsKt.toList((Iterable)$this$dumpTreeInternal);
        String newPrefix = prefix + (isFirst ? "" : (isLastChild ? "    " : "\u2502   "));
        Iterable $this$forEachIndexed$iv = children;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void child;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            RenderNode renderNode = (RenderNode)item$iv;
            int index = n;
            boolean i2 = false;
            boolean isLast = index == CollectionsKt.getLastIndex((List)children);
            ModelDumper.dumpTreeInternal$default(INSTANCE, (RenderNode)child, logger, newPrefix, isLast, false, 8, null);
        }
    }

    public static /* synthetic */ void dumpTreeInternal$default(ModelDumper modelDumper, RenderNode renderNode, Logger logger, String string, boolean bl, boolean bl2, int i2, Object object) {
        if ((i2 & 8) != 0) {
            bl2 = false;
        }
        modelDumper.dumpTreeInternal(renderNode, logger, string, bl, bl2);
    }

    public final void dumpNode(@NotNull RenderNode node, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.dumpTreeInternal(node, logger, "", true, true);
    }
}

