/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.armorstand.util;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntHeapPriorityQueue;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.BitSet;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_10866;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.fifthlight.armorstand.extension.CommandEncoderExtKt;
import top.fifthlight.armorstand.util.ObjectPool;
import top.fifthlight.armorstand.util.SlottedGpuBuffer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0003'()B+\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J)\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00032\u0017\u0010\u001d\u001a\u0013\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00190\u001e\u00a2\u0006\u0002\b H\u0002J\b\u0010!\u001a\u00020\u0003H\u0002J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0003H\u0002J\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020\u0013J\b\u0010&\u001a\u00020\u0019H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Ltop/fifthlight/armorstand/util/SlottedGpuBuffer;", "Ljava/lang/AutoCloseable;", "initialCapacity", "", "itemSize", "label", "", "usage", "<init>", "(IILjava/lang/String;I)V", "getItemSize", "()I", "capacity", "highestSlot", "allocatedSlotBitmap", "Ljava/util/BitSet;", "freeSlots", "Lit/unimi/dsi/fastutil/ints/IntHeapPriorityQueue;", "gpuBuffer", "Lcom/mojang/blaze3d/buffers/GpuBuffer;", "kotlin.jvm.PlatformType", "Lcom/mojang/blaze3d/buffers/GpuBuffer;", "mappedBuffer", "Lcom/mojang/blaze3d/buffers/GpuBuffer$MappedView;", "enlargeBuffer", "", "newCapacity", "editSlot", "index", "func", "Lkotlin/Function1;", "Ljava/nio/ByteBuffer;", "Lkotlin/ExtensionFunctionType;", "allocateSlotIndex", "freeSlotIndex", "allocateSlot", "Ltop/fifthlight/armorstand/util/SlottedGpuBuffer$Slot;", "getBuffer", "close", "Slot", "Slotted", "Unslotted", "top_fifthlight_armorstand"})
@SourceDebugExtension(value={"SMAP\nSlottedGpuBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlottedGpuBuffer.kt\ntop/fifthlight/armorstand/util/SlottedGpuBuffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,179:1\n1#2:180\n*E\n"})
public final class SlottedGpuBuffer
implements AutoCloseable {
    private final int itemSize;
    @Nullable
    private final String label;
    private final int usage;
    private int capacity;
    private int highestSlot;
    @NotNull
    private final BitSet allocatedSlotBitmap;
    @NotNull
    private final IntHeapPriorityQueue freeSlots;
    private GpuBuffer gpuBuffer;
    @Nullable
    private GpuBuffer.MappedView mappedBuffer;

    /*
     * WARNING - void declaration
     */
    public SlottedGpuBuffer(int initialCapacity, int itemSize, @Nullable String label, int usage) {
        Supplier supplier;
        this.itemSize = itemSize;
        this.label = label;
        this.usage = usage;
        if (!(initialCapacity > 0)) {
            boolean i22 = false;
            String i22 = "Capacity should be larger than 0";
            throw new IllegalArgumentException(i22.toString());
        }
        if (!((this.usage & 8) != 0)) {
            boolean i32 = false;
            String i32 = "Buffer should have USAGE_COPY_DST bit set";
            throw new IllegalArgumentException(i32.toString());
        }
        if (!((this.usage & 0x10) != 0)) {
            boolean i42 = false;
            String i42 = "Buffer should have USAGE_COPY_SRC bit set";
            throw new IllegalArgumentException(i42.toString());
        }
        if (!((this.usage & 1) != 0)) {
            boolean i52 = false;
            String i52 = "Buffer should have USAGE_MAP_READ bit set";
            throw new IllegalArgumentException(i52.toString());
        }
        if (!((this.usage & 2) != 0)) {
            boolean i2 = false;
            String string = "Buffer should have USAGE_MAP_WRITE bit set";
            throw new IllegalArgumentException(string.toString());
        }
        this.capacity = initialCapacity;
        this.allocatedSlotBitmap = new BitSet(initialCapacity);
        this.freeSlots = new IntHeapPriorityQueue(initialCapacity);
        SlottedGpuBuffer slottedGpuBuffer = this;
        GpuDevice gpuDevice = RenderSystem.getDevice();
        String string = this.label;
        if (string != null) {
            void it;
            String string2 = string;
            GpuDevice gpuDevice2 = gpuDevice;
            SlottedGpuBuffer slottedGpuBuffer2 = slottedGpuBuffer;
            boolean j = false;
            Function0 function0 = (Function0)new Function0<String>((String)it){
                final /* synthetic */ String $it;
                {
                    this.$it = $it;
                    super(0);
                }

                public final String invoke() {
                    return this.$it;
                }
            };
            slottedGpuBuffer = slottedGpuBuffer2;
            gpuDevice = gpuDevice2;
            Function0 function02 = function0;
            supplier = new Supplier(function02){
                private final /* synthetic */ Function0 function;
                {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    this.function = function;
                }

                public final /* synthetic */ Object get() {
                    return this.function.invoke();
                }
            };
        } else {
            supplier = null;
        }
        slottedGpuBuffer.gpuBuffer = gpuDevice.createBuffer(supplier, this.usage, initialCapacity * this.itemSize);
    }

    public /* synthetic */ SlottedGpuBuffer(int i2, int j, String string, int k, int l, DefaultConstructorMarker defaultConstructorMarker) {
        if ((l & 1) != 0) {
            i2 = 1;
        }
        this(i2, j, string, k);
    }

    public final int getItemSize() {
        return this.itemSize;
    }

    /*
     * WARNING - void declaration
     */
    private final void enlargeBuffer(int newCapacity) {
        Supplier supplier;
        GpuDevice device;
        if (newCapacity <= this.capacity) {
            throw new IllegalStateException("Unable to shrink buffer");
        }
        this.capacity = newCapacity;
        int newSize = newCapacity * this.itemSize;
        GpuBuffer.MappedView mappedView = this.mappedBuffer;
        if (mappedView != null) {
            mappedView.close();
        }
        this.mappedBuffer = null;
        GpuDevice gpuDevice = device = RenderSystem.getDevice();
        String string = this.label;
        if (string != null) {
            void it;
            String string2 = string;
            GpuDevice gpuDevice2 = gpuDevice;
            boolean i2 = false;
            gpuDevice = gpuDevice2;
            Function0 function0 = (Function0)new Function0<String>((String)it){
                final /* synthetic */ String $it;
                {
                    this.$it = $it;
                    super(0);
                }

                public final String invoke() {
                    return this.$it;
                }
            };
            supplier = new /* invalid duplicate definition of identical inner class */;
        } else {
            supplier = null;
        }
        GpuBuffer newBuffer2 = gpuDevice.createBuffer(supplier, this.usage, newSize);
        CommandEncoder commandEncoder = device.createCommandEncoder();
        Intrinsics.checkNotNull((Object)commandEncoder);
        GpuBufferSlice gpuBufferSlice = newBuffer2.slice(0, this.gpuBuffer.size);
        Intrinsics.checkNotNullExpressionValue((Object)gpuBufferSlice, (String)"slice(...)");
        GpuBufferSlice gpuBufferSlice2 = this.gpuBuffer.slice();
        Intrinsics.checkNotNullExpressionValue((Object)gpuBufferSlice2, (String)"slice(...)");
        CommandEncoderExtKt.copyBuffer(commandEncoder, gpuBufferSlice, gpuBufferSlice2);
        this.gpuBuffer.close();
        this.gpuBuffer = newBuffer2;
    }

    private final void editSlot(int index, Function1<? super ByteBuffer, Unit> func) {
        GpuBuffer.MappedView mappedView = this.mappedBuffer;
        if (mappedView == null) {
            GpuBuffer.MappedView mappedView2;
            SlottedGpuBuffer $this$editSlot_u24lambda_u248 = this;
            boolean j = false;
            GpuDevice device = RenderSystem.getDevice();
            CommandEncoder commandEncoder = device.createCommandEncoder();
            GpuBuffer.MappedView it = mappedView2 = commandEncoder.mapBuffer($this$editSlot_u24lambda_u248.gpuBuffer, false, true);
            boolean i2 = false;
            $this$editSlot_u24lambda_u248.mappedBuffer = it;
            mappedView = mappedView2;
        }
        GpuBuffer.MappedView mappedBuffer = mappedView;
        int startPos = index * this.itemSize;
        ByteBuffer buffer = mappedBuffer.data().slice(startPos, this.itemSize).order(ByteOrder.nativeOrder());
        Intrinsics.checkNotNull((Object)buffer);
        func.invoke((Object)buffer);
    }

    private final int allocateSlotIndex() {
        int n;
        int n2;
        if (this.freeSlots.isEmpty()) {
            n2 = this.highestSlot;
            this.highestSlot = n2 + 1;
            n = n2;
        } else {
            n = this.freeSlots.dequeueInt();
        }
        int index = n2 = n;
        boolean i2 = false;
        this.highestSlot = Math.max(this.highestSlot, index);
        this.allocatedSlotBitmap.set(index);
        if (index >= this.capacity) {
            this.enlargeBuffer(this.capacity * 2);
        }
        return n2;
    }

    private final void freeSlotIndex(int index) {
        Unit unit;
        if (!this.allocatedSlotBitmap.get(index)) {
            boolean i22 = false;
            String i22 = "Trying to free unallocated slot " + index;
            throw new IllegalArgumentException(i22.toString());
        }
        Unit it = unit = Unit.INSTANCE;
        boolean j = false;
        this.allocatedSlotBitmap.clear(index);
        this.freeSlots.enqueue(index);
    }

    @NotNull
    public final Slot allocateSlot() {
        Slotted slotted;
        int it = this.allocateSlotIndex();
        boolean j = false;
        Slotted $this$allocateSlot_u24lambda_u2413_u24lambda_u2412 = slotted = Slotted.Companion.getPOOL().acquire();
        boolean i2 = false;
        $this$allocateSlot_u24lambda_u2413_u24lambda_u2412.setBuffer(this);
        $this$allocateSlot_u24lambda_u2413_u24lambda_u2412.setIndex(it);
        return slotted;
    }

    @NotNull
    public final GpuBuffer getBuffer() {
        GpuBuffer.MappedView mappedView = this.mappedBuffer;
        if (mappedView != null) {
            mappedView.close();
        }
        this.mappedBuffer = null;
        GpuBuffer gpuBuffer2 = this.gpuBuffer;
        Intrinsics.checkNotNullExpressionValue((Object)gpuBuffer2, (String)"gpuBuffer");
        return gpuBuffer2;
    }

    @Override
    public void close() {
        if (class_10866.field_57867 && !this.allocatedSlotBitmap.isEmpty()) {
            boolean i2 = false;
            String string = "SlottedGpuBuffer closed with item not freed";
            throw new IllegalStateException(string.toString());
        }
        GpuBuffer.MappedView mappedView = this.mappedBuffer;
        if (mappedView != null) {
            mappedView.close();
        }
        this.mappedBuffer = null;
        this.gpuBuffer.close();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001J!\u0010\u0006\u001a\u00020\u00072\u0017\u0010\b\u001a\u0013\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0002\b\u000bH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0002\f\r\u00a8\u0006\u000e"}, d2={"Ltop/fifthlight/armorstand/util/SlottedGpuBuffer$Slot;", "Ljava/lang/AutoCloseable;", "size", "", "getSize", "()I", "edit", "", "block", "Lkotlin/Function1;", "Ljava/nio/ByteBuffer;", "Lkotlin/ExtensionFunctionType;", "Ltop/fifthlight/armorstand/util/SlottedGpuBuffer$Slotted;", "Ltop/fifthlight/armorstand/util/SlottedGpuBuffer$Unslotted;", "top_fifthlight_armorstand"})
    public static sealed interface Slot
    extends AutoCloseable
    permits Slotted, Unslotted {
        public int getSize();

        public void edit(@NotNull Function1<? super ByteBuffer, Unit> var1);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0013\b\u0002\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J!\u0010\u0015\u001a\u00020\u00162\u0017\u0010\u0017\u001a\u0013\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00160\u0018\u00a2\u0006\u0002\b\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0016H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0007\u00a8\u0006\u001d"}, d2={"Ltop/fifthlight/armorstand/util/SlottedGpuBuffer$Slotted;", "Ltop/fifthlight/armorstand/util/SlottedGpuBuffer$Slot;", "index", "", "<init>", "(I)V", "getIndex", "()I", "setIndex", "_buffer", "Ltop/fifthlight/armorstand/util/SlottedGpuBuffer;", "value", "buffer", "getBuffer", "()Ltop/fifthlight/armorstand/util/SlottedGpuBuffer;", "setBuffer", "(Ltop/fifthlight/armorstand/util/SlottedGpuBuffer;)V", "recycled", "", "size", "getSize", "edit", "", "block", "Lkotlin/Function1;", "Ljava/nio/ByteBuffer;", "Lkotlin/ExtensionFunctionType;", "close", "Companion", "top_fifthlight_armorstand"})
    public static final class Slotted
    implements Slot {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private int index;
        @Nullable
        private SlottedGpuBuffer _buffer;
        private boolean recycled;
        @NotNull
        private static final ObjectPool<Slotted> POOL;

        private Slotted(int index) {
            this.index = index;
        }

        /* synthetic */ Slotted(int i2, int j, DefaultConstructorMarker defaultConstructorMarker) {
            if ((j & 1) != 0) {
                i2 = -1;
            }
            this(i2);
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int i2) {
            this.index = i2;
        }

        @NotNull
        public final SlottedGpuBuffer getBuffer() {
            SlottedGpuBuffer slottedGpuBuffer = this._buffer;
            if (slottedGpuBuffer == null) {
                throw new IllegalStateException("Buffer is not initialized or recycled".toString());
            }
            return slottedGpuBuffer;
        }

        public final void setBuffer(@NotNull SlottedGpuBuffer value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this._buffer = value;
        }

        @Override
        public int getSize() {
            return this.getBuffer().getItemSize();
        }

        @Override
        public void edit(@NotNull Function1<? super ByteBuffer, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            this.getBuffer().editSlot(this.index, (Function1<? super ByteBuffer, Unit>)block);
        }

        @Override
        public void close() {
            if (this.recycled) {
                return;
            }
            this.recycled = true;
            this.getBuffer().freeSlotIndex(this.index);
            POOL.release(this);
        }

        public static final /* synthetic */ void access$setRecycled$p(Slotted $this, boolean bl) {
            $this.recycled = bl;
        }

        static {
            class_2960 class_29602 = class_2960.method_60655((String)"armorstand", (String)"gpu_buffer_slot");
            Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"of(...)");
            POOL = new ObjectPool(class_29602, Companion.POOL.2.INSTANCE, Companion.POOL.3.INSTANCE, null, 8, null);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ltop/fifthlight/armorstand/util/SlottedGpuBuffer$Slotted$Companion;", "", "<init>", "()V", "POOL", "Ltop/fifthlight/armorstand/util/ObjectPool;", "Ltop/fifthlight/armorstand/util/SlottedGpuBuffer$Slotted;", "getPOOL", "()Ltop/fifthlight/armorstand/util/ObjectPool;", "top_fifthlight_armorstand"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ObjectPool<Slotted> getPOOL() {
                return POOL;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J!\u0010\r\u001a\u00020\u000e2\u0017\u0010\u000f\u001a\u0013\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000e0\u0010\u00a2\u0006\u0002\b\u0012H\u0016J\u0006\u0010\u0013\u001a\u00020\nJ\b\u0010\u0014\u001a\u00020\u000eH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ltop/fifthlight/armorstand/util/SlottedGpuBuffer$Unslotted;", "Ltop/fifthlight/armorstand/util/SlottedGpuBuffer$Slot;", "size", "", "usage", "<init>", "(II)V", "getSize", "()I", "gpuBuffer", "Lcom/mojang/blaze3d/buffers/GpuBuffer;", "mappedBuffer", "Lcom/mojang/blaze3d/buffers/GpuBuffer$MappedView;", "edit", "", "block", "Lkotlin/Function1;", "Ljava/nio/ByteBuffer;", "Lkotlin/ExtensionFunctionType;", "getBuffer", "close", "top_fifthlight_armorstand"})
    @SourceDebugExtension(value={"SMAP\nSlottedGpuBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlottedGpuBuffer.kt\ntop/fifthlight/armorstand/util/SlottedGpuBuffer$Unslotted\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,179:1\n1#2:180\n*E\n"})
    public static final class Unslotted
    implements Slot {
        private final int size;
        @NotNull
        private final GpuBuffer gpuBuffer;
        @Nullable
        private GpuBuffer.MappedView mappedBuffer;

        public Unslotted(int size, int usage) {
            this.size = size;
            GpuBuffer gpuBuffer2 = RenderSystem.getDevice().createBuffer((Supplier)gpuBuffer.1.INSTANCE, usage, this.getSize());
            Intrinsics.checkNotNullExpressionValue((Object)gpuBuffer2, (String)"createBuffer(...)");
            this.gpuBuffer = gpuBuffer2;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public void edit(@NotNull Function1<? super ByteBuffer, Unit> block) {
            GpuBuffer.MappedView mappedView;
            Intrinsics.checkNotNullParameter(block, (String)"block");
            GpuDevice device = RenderSystem.getDevice();
            CommandEncoder commandEncoder = device.createCommandEncoder();
            GpuBuffer.MappedView it = mappedView = commandEncoder.mapBuffer(this.gpuBuffer, false, true);
            boolean i2 = false;
            this.mappedBuffer = it;
            GpuBuffer.MappedView mappedBuffer = mappedView;
            ByteBuffer buffer = mappedBuffer.data().order(ByteOrder.nativeOrder());
            buffer.clear();
            Intrinsics.checkNotNull((Object)buffer);
            block.invoke((Object)buffer);
        }

        @NotNull
        public final GpuBuffer getBuffer() {
            GpuBuffer gpuBuffer2;
            block0: {
                GpuBuffer it = gpuBuffer2 = this.gpuBuffer;
                boolean j = false;
                GpuBuffer.MappedView mappedView = this.mappedBuffer;
                if (mappedView == null) break block0;
                GpuBuffer.MappedView it2 = mappedView;
                boolean i2 = false;
                it2.close();
                this.mappedBuffer = null;
            }
            return gpuBuffer2;
        }

        @Override
        public void close() {
            GpuBuffer.MappedView mappedView = this.mappedBuffer;
            if (mappedView != null) {
                mappedView.close();
            }
            this.mappedBuffer = null;
            this.gpuBuffer.close();
        }
    }
}

