/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.armorstand.util;

import it.unimi.dsi.fastutil.ints.AbstractInt2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntHeapPriorityQueue;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.fifthlight.armorstand.util.InvalidReferenceCountException;
import top.fifthlight.armorstand.util.RefCount;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0002B\u0011\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0011\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0012\u001a\u00020\u0005H\u0096\u0002\u00a2\u0006\u0002\u0010\u0013J\u0013\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0016J\u0017\u0010\u0017\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0012\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u001f\u0010\u0014\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ\b\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020%H\u0016J\b\u0010'\u001a\u00020%H\u0016J\b\u0010(\u001a\u00020%H\u0002R\u001a\u0010\b\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\u0007R\"\u0010\f\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00018\u00000\rj\n\u0012\u0006\u0012\u0004\u0018\u00018\u0000`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\u001cX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\n\"\u0004\b#\u0010\u0007\u00a8\u0006)"}, d2={"Ltop/fifthlight/armorstand/util/SlottedMap;", "T", "Ltop/fifthlight/armorstand/util/RefCount;", "Lit/unimi/dsi/fastutil/ints/AbstractInt2ObjectMap;", "initialCapacity", "", "<init>", "(I)V", "size", "getSize", "()I", "setSize", "items", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "freeIndices", "Lit/unimi/dsi/fastutil/ints/IntHeapPriorityQueue;", "get", "key", "(I)Ltop/fifthlight/armorstand/util/RefCount;", "put", "value", "(Ltop/fifthlight/armorstand/util/RefCount;)I", "remove", "int2ObjectEntrySet", "", "(ILtop/fifthlight/armorstand/util/RefCount;)Ljava/lang/Void;", "closed", "", "getClosed", "()Z", "setClosed", "(Z)V", "referenceCount", "getReferenceCount", "setReferenceCount", "requireNotClosed", "", "increaseReferenceCount", "decreaseReferenceCount", "close", "top_fifthlight_armorstand"})
@SourceDebugExtension(value={"SMAP\nSlottedMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlottedMap.kt\ntop/fifthlight/armorstand/util/SlottedMap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n1#2:96\n1869#3,2:97\n*S KotlinDebug\n*F\n+ 1 SlottedMap.kt\ntop/fifthlight/armorstand/util/SlottedMap\n*L\n90#1:97,2\n*E\n"})
public final class SlottedMap<T extends RefCount>
extends AbstractInt2ObjectMap<T>
implements RefCount {
    private int size;
    @NotNull
    private final ArrayList<T> items;
    @NotNull
    private final IntHeapPriorityQueue freeIndices;
    private boolean closed;
    private int referenceCount;

    public SlottedMap(int initialCapacity) {
        this.items = new ArrayList(initialCapacity);
        this.freeIndices = new IntHeapPriorityQueue(initialCapacity);
    }

    public /* synthetic */ SlottedMap(int i2, int j, DefaultConstructorMarker defaultConstructorMarker) {
        if ((j & 1) != 0) {
            i2 = 1;
        }
        this(i2);
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int i2) {
        this.size = i2;
    }

    @Nullable
    public T get(int key) {
        this.requireNotClosed();
        if (!(0 <= key ? key < ((Collection)this.items).size() : false)) {
            return null;
        }
        return (T)((RefCount)this.items.get(key));
    }

    public final int put(@NotNull T value) {
        int index;
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.requireNotClosed();
        int n = index = this.freeIndices.isEmpty() ? this.items.size() : this.freeIndices.dequeueInt();
        if (index == this.items.size()) {
            value.increaseReferenceCount();
            this.items.add(value);
            int n2 = this.size();
            this.setSize(n2 + 1);
        } else {
            RefCount existing = (RefCount)this.items.get(index);
            if (existing == null) {
                value.increaseReferenceCount();
                this.items.set(index, value);
                int n3 = this.size();
                this.setSize(n3 + 1);
            } else {
                if (Intrinsics.areEqual((Object)existing, value)) {
                    return index;
                }
                value.increaseReferenceCount();
                existing.decreaseReferenceCount();
                this.items.set(index, value);
            }
        }
        return index;
    }

    @Nullable
    public T remove(int key) {
        RefCount refCount;
        this.requireNotClosed();
        if (!(0 <= key ? key < ((Collection)this.items).size() : false)) {
            return null;
        }
        RefCount refCount2 = (RefCount)this.items.get(key);
        if (refCount2 != null) {
            RefCount refCount3;
            RefCount value = refCount3 = refCount2;
            boolean i2 = false;
            value.decreaseReferenceCount();
            this.items.set(key, null);
            this.freeIndices.enqueue(key);
            int n = this.size();
            this.setSize(n + -1);
            refCount = refCount3;
        } else {
            refCount = null;
        }
        return (T)refCount;
    }

    @NotNull
    public Void int2ObjectEntrySet() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Void put(int key, @Nullable T value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getClosed() {
        return this.closed;
    }

    public void setClosed(boolean bl) {
        this.closed = bl;
    }

    @Override
    public int getReferenceCount() {
        return this.referenceCount;
    }

    public void setReferenceCount(int i2) {
        this.referenceCount = i2;
    }

    private final void requireNotClosed() {
        if (!(!this.getClosed())) {
            boolean i2 = false;
            String string = "Object " + this + " is already closed.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public void increaseReferenceCount() {
        this.requireNotClosed();
        if (this.getReferenceCount() < 0) {
            throw new InvalidReferenceCountException(this, this.getReferenceCount());
        }
        int n = this.getReferenceCount();
        this.setReferenceCount(n + 1);
    }

    @Override
    public void decreaseReferenceCount() {
        if (this.getReferenceCount() == 0) {
            this.close();
        } else {
            int n = this.getReferenceCount();
            this.setReferenceCount(n + -1);
        }
    }

    private final void close() {
        this.setClosed(true);
        Iterable $this$forEach$iv = this.items;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RefCount item = (RefCount)element$iv;
            boolean i2 = false;
            RefCount refCount = item;
            if (refCount == null) continue;
            refCount.decreaseReferenceCount();
        }
    }

    public SlottedMap() {
        this(0, 1, null);
    }
}

