/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.renderer.model;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.fifthlight.renderer.model.BufferView;
import top.fifthlight.renderer.model.util.ReadUtilKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0015\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u0086\b\u0018\u00002\u00020\u0001:\u0003;<=Bm\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0010\b\u0002\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e\u0012\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\"\u0010'\u001a\u00020(2\u0014\b\u0004\u0010)\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020(0*H\u0086\b\u00f8\u0001\u0000J\"\u0010,\u001a\u00020(2\u0014\b\u0004\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020(0*H\u0086\b\u00f8\u0001\u0000J\u000b\u0010-\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010.\u001a\u00020\u0005H\u00c6\u0003J\t\u0010/\u001a\u00020\u0007H\u00c6\u0003J\t\u00100\u001a\u00020\tH\u00c6\u0003J\t\u00101\u001a\u00020\u0005H\u00c6\u0003J\t\u00102\u001a\u00020\fH\u00c6\u0003J\u0011\u00103\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eH\u00c6\u0003J\u0011\u00104\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eH\u00c6\u0003J\u000b\u00105\u001a\u0004\u0018\u00010\u0012H\u00c6\u0003Jw\u00106\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\f2\u0010\b\u0002\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00c6\u0001J\u0013\u00107\u001a\u00020\t2\b\u00108\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00109\u001a\u00020\u0005H\u00d6\u0001J\t\u0010:\u001a\u00020\u0012H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0018R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0019\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0019\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010!R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0018\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006>"}, d2={"Ltop/fifthlight/renderer/model/Accessor;", "", "bufferView", "Ltop/fifthlight/renderer/model/BufferView;", "byteOffset", "", "componentType", "Ltop/fifthlight/renderer/model/Accessor$ComponentType;", "normalized", "", "count", "type", "Ltop/fifthlight/renderer/model/Accessor$AccessorType;", "max", "", "", "min", "name", "", "<init>", "(Ltop/fifthlight/renderer/model/BufferView;ILtop/fifthlight/renderer/model/Accessor$ComponentType;ZILtop/fifthlight/renderer/model/Accessor$AccessorType;Ljava/util/List;Ljava/util/List;Ljava/lang/String;)V", "getBufferView", "()Ltop/fifthlight/renderer/model/BufferView;", "getByteOffset", "()I", "getComponentType", "()Ltop/fifthlight/renderer/model/Accessor$ComponentType;", "getNormalized", "()Z", "getCount", "getType", "()Ltop/fifthlight/renderer/model/Accessor$AccessorType;", "getMax", "()Ljava/util/List;", "getMin", "getName", "()Ljava/lang/String;", "totalByteLength", "getTotalByteLength", "read", "", "func", "Lkotlin/Function1;", "Ljava/nio/ByteBuffer;", "readNormalized", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "toString", "ComponentType", "ComponentTypeItem", "AccessorType", "model_model-base-model-base"})
@SourceDebugExtension(value={"SMAP\nAccessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Accessor.kt\ntop/fifthlight/renderer/model/Accessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
public final class Accessor {
    @Nullable
    private final BufferView bufferView;
    private final int byteOffset;
    @NotNull
    private final ComponentType componentType;
    private final boolean normalized;
    private final int count;
    @NotNull
    private final AccessorType type;
    @Nullable
    private final List<Float> max;
    @Nullable
    private final List<Float> min;
    @Nullable
    private final String name;

    public Accessor(@Nullable BufferView bufferView, int byteOffset, @NotNull ComponentType componentType, boolean normalized, int count, @NotNull AccessorType type2, @Nullable List<Float> max, @Nullable List<Float> min, @Nullable String name) {
        Intrinsics.checkNotNullParameter((Object)((Object)componentType), (String)"componentType");
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        this.bufferView = bufferView;
        this.byteOffset = byteOffset;
        this.componentType = componentType;
        this.normalized = normalized;
        this.count = count;
        this.type = type2;
        this.max = max;
        this.min = min;
        this.name = name;
        if (!(this.count >= 1)) {
            boolean $i$a$-require-Accessor$32 = false;
            String $i$a$-require-Accessor$32 = "Bad count of accessor: " + this.count;
            throw new IllegalArgumentException($i$a$-require-Accessor$32.toString());
        }
        if (!(this.byteOffset >= 0)) {
            boolean bl = false;
            String string = "Invalid byte offset for accessor: " + this.byteOffset;
            throw new IllegalArgumentException(string.toString());
        }
        BufferView bufferView2 = this.bufferView;
        if (bufferView2 != null) {
            BufferView bufferView3 = bufferView2;
            boolean bl = false;
            if (bufferView3.getByteStride() > 0 && !(bufferView3.getByteStride() % this.componentType.getByteLength() == 0)) {
                boolean $i$a$-require-Accessor$3$32 = false;
                String $i$a$-require-Accessor$3$32 = "Invalid byte stride: " + bufferView3.getByteStride() + " (" + bufferView3.getByteStride() + " % " + this.componentType.getByteLength() + " != 0)";
                throw new IllegalArgumentException($i$a$-require-Accessor$3$32.toString());
            }
            if (!(this.getTotalByteLength() <= bufferView3.getByteLength() - this.byteOffset)) {
                boolean bl2 = false;
                String string = "Bad accessor size: " + this.getTotalByteLength() + ", bufferView: " + bufferView3.getByteLength() + ", accessor offset: " + this.byteOffset;
                throw new IllegalArgumentException(string.toString());
            }
        }
    }

    public /* synthetic */ Accessor(BufferView bufferView, int n, ComponentType componentType, boolean bl, int n2, AccessorType accessorType, List list2, List list3, String string, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            bl = false;
        }
        if ((n3 & 0x40) != 0) {
            list2 = null;
        }
        if ((n3 & 0x80) != 0) {
            list3 = null;
        }
        if ((n3 & 0x100) != 0) {
            string = null;
        }
        this(bufferView, n, componentType, bl, n2, accessorType, list2, list3, string);
    }

    @Nullable
    public final BufferView getBufferView() {
        return this.bufferView;
    }

    public final int getByteOffset() {
        return this.byteOffset;
    }

    @NotNull
    public final ComponentType getComponentType() {
        return this.componentType;
    }

    public final boolean getNormalized() {
        return this.normalized;
    }

    public final int getCount() {
        return this.count;
    }

    @NotNull
    public final AccessorType getType() {
        return this.type;
    }

    @Nullable
    public final List<Float> getMax() {
        return this.max;
    }

    @Nullable
    public final List<Float> getMin() {
        return this.min;
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final int getTotalByteLength() {
        int n;
        Object object = this.bufferView;
        if (object != null) {
            Integer n2 = ((BufferView)object).getByteStride();
            int it = ((Number)n2).intValue();
            boolean bl = false;
            object = it > 0 ? n2 : null;
            if (object != null) {
                int stride = ((Number)object).intValue();
                boolean bl2 = false;
                n = (this.count - 1) * stride + this.componentType.getByteLength() * this.type.getComponents();
                return n;
            }
        }
        Accessor $this$_get_totalByteLength__u24lambda_u242 = this;
        boolean bl = false;
        n = $this$_get_totalByteLength__u24lambda_u242.count * $this$_get_totalByteLength__u24lambda_u242.componentType.getByteLength() * $this$_get_totalByteLength__u24lambda_u242.type.getComponents();
        return n;
    }

    public final void read(@NotNull Function1<? super ByteBuffer, Unit> func) {
        Intrinsics.checkNotNullParameter(func, (String)"func");
        boolean $i$f$read = false;
        BufferView bufferView = this.getBufferView();
        int elementLength = this.getComponentType().getByteLength() * this.getType().getComponents();
        if (bufferView == null) {
            ByteBuffer buffer = ByteBuffer.allocate(elementLength);
            int n = this.getCount();
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)buffer);
                func.invoke((Object)buffer);
            }
            return;
        }
        ByteBuffer buffer = bufferView.getBuffer().getBuffer().slice(this.getByteOffset() + bufferView.getByteOffset(), this.getTotalByteLength());
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        Integer n = bufferView.getByteStride();
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n3 = it > 0 ? n : null;
        int stride = n3 != null ? n3 : elementLength;
        int n4 = this.getCount();
        int n5 = 0;
        while (n5 < n4) {
            int elementIndex = n5++;
            boolean bl2 = false;
            int newPosition = elementIndex * stride;
            buffer.position(newPosition);
            buffer.limit(newPosition + elementLength);
            Intrinsics.checkNotNull((Object)buffer);
            func.invoke((Object)buffer);
            buffer.limit(buffer.capacity());
        }
    }

    public final void readNormalized(@NotNull Function1<? super Float, Unit> func) {
        Intrinsics.checkNotNullParameter(func, (String)"func");
        boolean $i$f$readNormalized = false;
        if (!this.getNormalized()) {
            boolean $i$a$-require-Accessor$readNormalized$22 = false;
            String $i$a$-require-Accessor$readNormalized$22 = "Read normalized data from a not normalized accessor";
            throw new IllegalArgumentException($i$a$-require-Accessor$readNormalized$22.toString());
        }
        BufferView bufferView = this.getBufferView();
        int elementLength = this.getComponentType().getByteLength() * this.getType().getComponents();
        if (bufferView == null) {
            int n = this.getCount() * this.getType().getComponents();
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                func.invoke((Object)Float.valueOf(0.0f));
            }
            return;
        }
        ByteBuffer buffer = bufferView.getBuffer().getBuffer().slice(bufferView.getByteOffset() + this.getByteOffset(), this.getTotalByteLength());
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        Integer n = bufferView.getByteStride();
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n3 = it > 0 ? n : null;
        int stride = n3 != null ? n3 : elementLength;
        int n4 = this.getCount();
        for (int j = 0; j < n4; ++j) {
            int elementIndex = j;
            boolean bl2 = false;
            buffer.position(elementIndex * stride);
            int n5 = this.getType().getComponents();
            for (int k = 0; k < n5; ++k) {
                int it2 = k;
                boolean bl3 = false;
                float value = switch (WhenMappings.$EnumSwitchMapping$0[this.getComponentType().ordinal()]) {
                    case 1 -> {
                        Intrinsics.checkNotNull((Object)buffer);
                        yield ReadUtilKt.getSByteNormalized(buffer);
                    }
                    case 2 -> {
                        Intrinsics.checkNotNull((Object)buffer);
                        yield ReadUtilKt.getUByteNormalized(buffer);
                    }
                    case 3 -> {
                        Intrinsics.checkNotNull((Object)buffer);
                        yield ReadUtilKt.getSShortNormalized(buffer);
                    }
                    case 4 -> {
                        Intrinsics.checkNotNull((Object)buffer);
                        yield ReadUtilKt.getUShortNormalized(buffer);
                    }
                    case 5 -> {
                        Intrinsics.checkNotNull((Object)buffer);
                        yield ReadUtilKt.getUIntNormalized(buffer);
                    }
                    case 6 -> buffer.getFloat();
                    default -> throw new NoWhenBranchMatchedException();
                };
                func.invoke((Object)Float.valueOf(value));
            }
        }
    }

    @Nullable
    public final BufferView component1() {
        return this.bufferView;
    }

    public final int component2() {
        return this.byteOffset;
    }

    @NotNull
    public final ComponentType component3() {
        return this.componentType;
    }

    public final boolean component4() {
        return this.normalized;
    }

    public final int component5() {
        return this.count;
    }

    @NotNull
    public final AccessorType component6() {
        return this.type;
    }

    @Nullable
    public final List<Float> component7() {
        return this.max;
    }

    @Nullable
    public final List<Float> component8() {
        return this.min;
    }

    @Nullable
    public final String component9() {
        return this.name;
    }

    @NotNull
    public final Accessor copy(@Nullable BufferView bufferView, int byteOffset, @NotNull ComponentType componentType, boolean normalized, int count, @NotNull AccessorType type2, @Nullable List<Float> max, @Nullable List<Float> min, @Nullable String name) {
        Intrinsics.checkNotNullParameter((Object)((Object)componentType), (String)"componentType");
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        return new Accessor(bufferView, byteOffset, componentType, normalized, count, type2, max, min, name);
    }

    public static /* synthetic */ Accessor copy$default(Accessor accessor, BufferView bufferView, int n, ComponentType componentType, boolean bl, int n2, AccessorType accessorType, List list2, List list3, String string, int n3, Object object) {
        if ((n3 & 1) != 0) {
            bufferView = accessor.bufferView;
        }
        if ((n3 & 2) != 0) {
            n = accessor.byteOffset;
        }
        if ((n3 & 4) != 0) {
            componentType = accessor.componentType;
        }
        if ((n3 & 8) != 0) {
            bl = accessor.normalized;
        }
        if ((n3 & 0x10) != 0) {
            n2 = accessor.count;
        }
        if ((n3 & 0x20) != 0) {
            accessorType = accessor.type;
        }
        if ((n3 & 0x40) != 0) {
            list2 = accessor.max;
        }
        if ((n3 & 0x80) != 0) {
            list3 = accessor.min;
        }
        if ((n3 & 0x100) != 0) {
            string = accessor.name;
        }
        return accessor.copy(bufferView, n, componentType, bl, n2, accessorType, list2, list3, string);
    }

    @NotNull
    public String toString() {
        return "Accessor(bufferView=" + this.bufferView + ", byteOffset=" + this.byteOffset + ", componentType=" + this.componentType + ", normalized=" + this.normalized + ", count=" + this.count + ", type=" + this.type + ", max=" + this.max + ", min=" + this.min + ", name=" + this.name + ")";
    }

    public int hashCode() {
        int result = this.bufferView == null ? 0 : this.bufferView.hashCode();
        result = result * 31 + Integer.hashCode(this.byteOffset);
        result = result * 31 + this.componentType.hashCode();
        result = result * 31 + Boolean.hashCode(this.normalized);
        result = result * 31 + Integer.hashCode(this.count);
        result = result * 31 + this.type.hashCode();
        result = result * 31 + (this.max == null ? 0 : ((Object)this.max).hashCode());
        result = result * 31 + (this.min == null ? 0 : ((Object)this.min).hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Accessor)) {
            return false;
        }
        Accessor accessor = (Accessor)other;
        if (!Intrinsics.areEqual((Object)this.bufferView, (Object)accessor.bufferView)) {
            return false;
        }
        if (this.byteOffset != accessor.byteOffset) {
            return false;
        }
        if (this.componentType != accessor.componentType) {
            return false;
        }
        if (this.normalized != accessor.normalized) {
            return false;
        }
        if (this.count != accessor.count) {
            return false;
        }
        if (this.type != accessor.type) {
            return false;
        }
        if (!Intrinsics.areEqual(this.max, accessor.max)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.min, accessor.min)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.name, (Object)accessor.name);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\f\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Ltop/fifthlight/renderer/model/Accessor$AccessorType;", "", "components", "", "<init>", "(Ljava/lang/String;II)V", "getComponents", "()I", "SCALAR", "VEC2", "VEC3", "VEC4", "MAT2", "MAT3", "MAT4", "model_model-base-model-base"})
    public static final class AccessorType
    extends Enum<AccessorType> {
        private final int components;
        public static final /* enum */ AccessorType SCALAR = new AccessorType(1);
        public static final /* enum */ AccessorType VEC2 = new AccessorType(2);
        public static final /* enum */ AccessorType VEC3 = new AccessorType(3);
        public static final /* enum */ AccessorType VEC4 = new AccessorType(4);
        public static final /* enum */ AccessorType MAT2 = new AccessorType(4);
        public static final /* enum */ AccessorType MAT3 = new AccessorType(9);
        public static final /* enum */ AccessorType MAT4 = new AccessorType(16);
        private static final /* synthetic */ AccessorType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private AccessorType(int components) {
            this.components = components;
        }

        public final int getComponents() {
            return this.components;
        }

        public static AccessorType[] values() {
            return (AccessorType[])$VALUES.clone();
        }

        public static AccessorType valueOf(String value) {
            return Enum.valueOf(AccessorType.class, value);
        }

        @NotNull
        public static EnumEntries<AccessorType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = accessorTypeArray = new AccessorType[]{AccessorType.SCALAR, AccessorType.VEC2, AccessorType.VEC3, AccessorType.VEC4, AccessorType.MAT2, AccessorType.MAT3, AccessorType.MAT4};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Ltop/fifthlight/renderer/model/Accessor$ComponentType;", "", "byteLength", "", "<init>", "(Ljava/lang/String;II)V", "getByteLength", "()I", "BYTE", "UNSIGNED_BYTE", "SHORT", "UNSIGNED_SHORT", "UNSIGNED_INT", "FLOAT", "model_model-base-model-base"})
    public static final class ComponentType
    extends Enum<ComponentType> {
        private final int byteLength;
        public static final /* enum */ ComponentType BYTE = new ComponentType(1);
        public static final /* enum */ ComponentType UNSIGNED_BYTE = new ComponentType(1);
        public static final /* enum */ ComponentType SHORT = new ComponentType(2);
        public static final /* enum */ ComponentType UNSIGNED_SHORT = new ComponentType(2);
        public static final /* enum */ ComponentType UNSIGNED_INT = new ComponentType(4);
        public static final /* enum */ ComponentType FLOAT = new ComponentType(4);
        private static final /* synthetic */ ComponentType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ComponentType(int byteLength) {
            this.byteLength = byteLength;
        }

        public final int getByteLength() {
            return this.byteLength;
        }

        public static ComponentType[] values() {
            return (ComponentType[])$VALUES.clone();
        }

        public static ComponentType valueOf(String value) {
            return Enum.valueOf(ComponentType.class, value);
        }

        @NotNull
        public static EnumEntries<ComponentType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = componentTypeArray = new ComponentType[]{ComponentType.BYTE, ComponentType.UNSIGNED_BYTE, ComponentType.SHORT, ComponentType.UNSIGNED_SHORT, ComponentType.UNSIGNED_INT, ComponentType.FLOAT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Ltop/fifthlight/renderer/model/Accessor$ComponentTypeItem;", "", "type", "Ltop/fifthlight/renderer/model/Accessor$ComponentType;", "normalized", "", "<init>", "(Ltop/fifthlight/renderer/model/Accessor$ComponentType;Z)V", "getType", "()Ltop/fifthlight/renderer/model/Accessor$ComponentType;", "getNormalized", "()Z", "toString", "", "component1", "component2", "copy", "equals", "other", "hashCode", "", "model_model-base-model-base"})
    public static final class ComponentTypeItem {
        @NotNull
        private final ComponentType type;
        private final boolean normalized;

        public ComponentTypeItem(@NotNull ComponentType type2, boolean normalized) {
            Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
            this.type = type2;
            this.normalized = normalized;
        }

        public /* synthetic */ ComponentTypeItem(ComponentType componentType, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            this(componentType, bl);
        }

        @NotNull
        public final ComponentType getType() {
            return this.type;
        }

        public final boolean getNormalized() {
            return this.normalized;
        }

        @NotNull
        public String toString() {
            return this.type + " (normalized: " + this.normalized + ")";
        }

        @NotNull
        public final ComponentType component1() {
            return this.type;
        }

        public final boolean component2() {
            return this.normalized;
        }

        @NotNull
        public final ComponentTypeItem copy(@NotNull ComponentType type2, boolean normalized) {
            Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
            return new ComponentTypeItem(type2, normalized);
        }

        public static /* synthetic */ ComponentTypeItem copy$default(ComponentTypeItem componentTypeItem, ComponentType componentType, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                componentType = componentTypeItem.type;
            }
            if ((n & 2) != 0) {
                bl = componentTypeItem.normalized;
            }
            return componentTypeItem.copy(componentType, bl);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = result * 31 + Boolean.hashCode(this.normalized);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ComponentTypeItem)) {
                return false;
            }
            ComponentTypeItem componentTypeItem = (ComponentTypeItem)other;
            if (this.type != componentTypeItem.type) {
                return false;
            }
            return this.normalized == componentTypeItem.normalized;
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=176)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ComponentType.values().length];
            try {
                nArray[ComponentType.BYTE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComponentType.UNSIGNED_BYTE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComponentType.SHORT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComponentType.UNSIGNED_SHORT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComponentType.UNSIGNED_INT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComponentType.FLOAT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

