/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.renderer.model.animation;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import top.fifthlight.renderer.model.Accessor;
import top.fifthlight.renderer.model.BufferView;
import top.fifthlight.renderer.model.animation.AnimationKeyFrameData;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010 \n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002BO\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00126\u0010\u0007\u001a2\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\b\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001e\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u00062\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R>\u0010\u0007\u001a2\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0019\u001a\n \u001a*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001b\u00a8\u0006 "}, d2={"Ltop/fifthlight/renderer/model/animation/AccessorAnimationKeyFrameData;", "T", "Ltop/fifthlight/renderer/model/animation/AnimationKeyFrameData;", "accessor", "Ltop/fifthlight/renderer/model/Accessor;", "elements", "", "elementGetter", "Lkotlin/Function2;", "Ljava/nio/ByteBuffer;", "Lkotlin/ParameterName;", "name", "buffer", "result", "", "<init>", "(Ltop/fifthlight/renderer/model/Accessor;ILkotlin/jvm/functions/Function2;)V", "getElements", "()I", "frames", "getFrames", "isZeroFilled", "", "itemLength", "elementLength", "slice", "kotlin.jvm.PlatformType", "Ljava/nio/ByteBuffer;", "get", "index", "data", "", "model_model-base-model-base"})
@SourceDebugExtension(value={"SMAP\nAnimationKeyFrameData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnimationKeyFrameData.kt\ntop/fifthlight/renderer/model/animation/AccessorAnimationKeyFrameData\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
public final class AccessorAnimationKeyFrameData<T>
implements AnimationKeyFrameData<T> {
    @NotNull
    private final Accessor accessor;
    private final int elements;
    @NotNull
    private final Function2<ByteBuffer, T, Unit> elementGetter;
    private final int frames;
    private final boolean isZeroFilled;
    private final int itemLength;
    private final int elementLength;
    private final ByteBuffer slice;

    /*
     * WARNING - void declaration
     */
    public AccessorAnimationKeyFrameData(@NotNull Accessor accessor, int elements, @NotNull Function2<? super ByteBuffer, ? super T, Unit> elementGetter) {
        Object object;
        block7: {
            void $this$slice_u24lambda_u244;
            AccessorAnimationKeyFrameData accessorAnimationKeyFrameData;
            AccessorAnimationKeyFrameData accessorAnimationKeyFrameData2;
            block6: {
                void bufferView;
                Intrinsics.checkNotNullParameter((Object)accessor, (String)"accessor");
                Intrinsics.checkNotNullParameter(elementGetter, (String)"elementGetter");
                this.accessor = accessor;
                this.elements = elements;
                this.elementGetter = elementGetter;
                if (!(this.accessor.getCount() % this.getElements() == 0)) {
                    boolean bl = false;
                    String string = "Invalid data size " + this.accessor.getCount() + " for elements " + this.getElements();
                    throw new IllegalArgumentException(string.toString());
                }
                BufferView bufferView2 = this.accessor.getBufferView();
                if (bufferView2 != null) {
                    BufferView it = bufferView2;
                    boolean bl = false;
                    if (!(it.getByteStride() == 0)) {
                        boolean $i$a$-require-AccessorAnimationKeyFrameData$2$22 = false;
                        String $i$a$-require-AccessorAnimationKeyFrameData$2$22 = "Byte stride is not zero";
                        throw new IllegalArgumentException($i$a$-require-AccessorAnimationKeyFrameData$2$22.toString());
                    }
                }
                this.frames = this.accessor.getCount() / this.getElements();
                this.isZeroFilled = this.accessor.getBufferView() == null;
                this.itemLength = this.accessor.getComponentType().getByteLength() * this.accessor.getType().getComponents();
                this.elementLength = this.itemLength * this.getElements();
                accessorAnimationKeyFrameData2 = this;
                object = this.accessor.getBufferView();
                if (object == null) break block6;
                BufferView bl = object;
                accessorAnimationKeyFrameData = accessorAnimationKeyFrameData2;
                boolean bl2 = false;
                ByteBuffer byteBuffer = bufferView.getBuffer().getBuffer().slice(this.accessor.getByteOffset() + bufferView.getByteOffset(), this.accessor.getTotalByteLength()).order(ByteOrder.LITTLE_ENDIAN);
                accessorAnimationKeyFrameData2 = accessorAnimationKeyFrameData;
                object = byteBuffer;
                if (byteBuffer != null) break block7;
            }
            AccessorAnimationKeyFrameData bufferView = this;
            accessorAnimationKeyFrameData = accessorAnimationKeyFrameData2;
            boolean bl = false;
            object = ByteBuffer.allocate($this$slice_u24lambda_u244.itemLength).order(ByteOrder.LITTLE_ENDIAN);
            accessorAnimationKeyFrameData2 = accessorAnimationKeyFrameData;
        }
        accessorAnimationKeyFrameData2.slice = object;
    }

    @Override
    public int getElements() {
        return this.elements;
    }

    @Override
    public int getFrames() {
        return this.frames;
    }

    @Override
    public void get(int index, @NotNull List<? extends T> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        int position = index * this.elementLength;
        int n = this.getElements();
        for (int i2 = 0; i2 < n; ++i2) {
            if (this.isZeroFilled) {
                this.slice.clear();
                ByteBuffer byteBuffer = this.slice;
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"slice");
                this.elementGetter.invoke((Object)byteBuffer, data.get(i2));
                continue;
            }
            this.slice.clear();
            this.slice.position(position);
            this.slice.limit(position + this.itemLength);
            ByteBuffer byteBuffer = this.slice;
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"slice");
            this.elementGetter.invoke((Object)byteBuffer, data.get(i2));
            position += this.itemLength;
        }
    }
}

