/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.renderer.model.animation;

import it.unimi.dsi.fastutil.floats.AbstractFloatList;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.fifthlight.renderer.model.Accessor;
import top.fifthlight.renderer.model.BufferView;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Ltop/fifthlight/renderer/model/animation/FloatAccessorList;", "Lit/unimi/dsi/fastutil/floats/AbstractFloatList;", "accessor", "Ltop/fifthlight/renderer/model/Accessor;", "<init>", "(Ltop/fifthlight/renderer/model/Accessor;)V", "slice", "Ljava/nio/ByteBuffer;", "size", "", "getSize", "()I", "getFloat", "", "index", "model_model-base-model-base"})
@SourceDebugExtension(value={"SMAP\nAnimationKeyFrameIndexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnimationKeyFrameIndexer.kt\ntop/fifthlight/renderer/model/animation/FloatAccessorList\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,153:1\n1#2:154\n*E\n"})
final class FloatAccessorList
extends AbstractFloatList {
    @NotNull
    private final Accessor accessor;
    @Nullable
    private final ByteBuffer slice;

    /*
     * WARNING - void declaration
     */
    public FloatAccessorList(@NotNull Accessor accessor) {
        ByteBuffer byteBuffer;
        Intrinsics.checkNotNullParameter((Object)accessor, (String)"accessor");
        this.accessor = accessor;
        if (!(this.accessor.getType() == Accessor.AccessorType.SCALAR)) {
            boolean $i$a$-require-FloatAccessorList$32 = false;
            String $i$a$-require-FloatAccessorList$32 = "Invalid accessor type: should be SCALAR, but got " + this.accessor.getType();
            throw new IllegalArgumentException($i$a$-require-FloatAccessorList$32.toString());
        }
        if (!(this.accessor.getComponentType() == Accessor.ComponentType.FLOAT)) {
            boolean bl = false;
            String string = "Invalid component type: should be FLOAT, but got " + this.accessor.getComponentType();
            throw new IllegalArgumentException(string.toString());
        }
        FloatAccessorList floatAccessorList = this;
        BufferView bufferView = this.accessor.getBufferView();
        if (bufferView != null) {
            void bufferView2;
            BufferView bufferView3 = bufferView;
            FloatAccessorList floatAccessorList2 = floatAccessorList;
            boolean bl = false;
            byteBuffer = bufferView2.getBuffer().getBuffer().slice(this.accessor.getByteOffset() + bufferView2.getByteOffset(), this.accessor.getTotalByteLength()).order(ByteOrder.LITTLE_ENDIAN);
            floatAccessorList = floatAccessorList2;
        } else {
            byteBuffer = null;
        }
        floatAccessorList.slice = byteBuffer;
    }

    public int getSize() {
        return this.accessor.getCount();
    }

    public float getFloat(int index) {
        ByteBuffer byteBuffer = this.slice;
        return byteBuffer != null ? byteBuffer.getFloat(index * 4) : 0.0f;
    }
}

