/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.renderer.model.animation;

import it.unimi.dsi.fastutil.floats.FloatList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import top.fifthlight.renderer.model.animation.AnimationKeyFrameData;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002Bl\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012K\u0010\b\u001aG\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\t\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00062\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000RS\u0010\b\u001aG\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006\u001a"}, d2={"Ltop/fifthlight/renderer/model/animation/FloatListAnimationKeyFrameData;", "T", "Ltop/fifthlight/renderer/model/animation/AnimationKeyFrameData;", "values", "Lit/unimi/dsi/fastutil/floats/FloatList;", "elements", "", "componentCount", "elementGetter", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "list", "offset", "result", "", "<init>", "(Lit/unimi/dsi/fastutil/floats/FloatList;IILkotlin/jvm/functions/Function3;)V", "getElements", "()I", "frames", "getFrames", "get", "index", "data", "", "model_model-base-model-base"})
public final class FloatListAnimationKeyFrameData<T>
implements AnimationKeyFrameData<T> {
    @NotNull
    private final FloatList values;
    private final int elements;
    private final int componentCount;
    @NotNull
    private final Function3<FloatList, Integer, T, Unit> elementGetter;
    private final int frames;

    public FloatListAnimationKeyFrameData(@NotNull FloatList values, int elements, int componentCount, @NotNull Function3<? super FloatList, ? super Integer, ? super T, Unit> elementGetter) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Intrinsics.checkNotNullParameter(elementGetter, (String)"elementGetter");
        this.values = values;
        this.elements = elements;
        this.componentCount = componentCount;
        this.elementGetter = elementGetter;
        if (!(this.values.size() % (this.getElements() * this.componentCount) == 0)) {
            boolean bl = false;
            String string = "Invalid data size " + this.values.size() + " for elements " + this.getElements() + " (requires multiple of " + this.getElements() * this.componentCount + ")";
            throw new IllegalArgumentException(string.toString());
        }
        this.frames = this.values.size() / (this.getElements() * this.componentCount);
    }

    @Override
    public int getElements() {
        return this.elements;
    }

    @Override
    public int getFrames() {
        return this.frames;
    }

    @Override
    public void get(int index, @NotNull List<? extends T> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        int baseOffset = index * this.getElements() * this.componentCount;
        int n = this.getElements();
        for (int i2 = 0; i2 < n; ++i2) {
            int offset = baseOffset + i2 * this.componentCount;
            this.elementGetter.invoke((Object)this.values, (Object)offset, data.get(i2));
        }
    }
}

