/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.renderer.model.animation;

import it.unimi.dsi.fastutil.floats.FloatList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import top.fifthlight.renderer.model.animation.AnimationKeyFrameIndexer;
import top.fifthlight.renderer.model.animation.AnimationKeyFrameIndexerKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Ltop/fifthlight/renderer/model/animation/ListAnimationKeyFrameIndexer;", "Ltop/fifthlight/renderer/model/animation/AnimationKeyFrameIndexer;", "times", "Lit/unimi/dsi/fastutil/floats/FloatList;", "<init>", "(Lit/unimi/dsi/fastutil/floats/FloatList;)V", "startTime", "", "getStartTime", "()F", "lastTime", "getLastTime", "indices", "", "getIndices", "()I", "findKeyFrames", "", "time", "result", "Ltop/fifthlight/renderer/model/animation/AnimationKeyFrameIndexer$FindResult;", "model_model-base-model-base"})
public final class ListAnimationKeyFrameIndexer
implements AnimationKeyFrameIndexer {
    @NotNull
    private final FloatList times;
    private final float startTime;
    private final float lastTime;
    private final int indices;

    public ListAnimationKeyFrameIndexer(@NotNull FloatList times) {
        float f;
        Intrinsics.checkNotNullParameter((Object)times, (String)"times");
        this.times = times;
        if (this.times.isEmpty()) {
            v0 = 0.0f;
        } else {
            Object object = CollectionsKt.first((List)((List)this.times));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
            v0 = this.startTime = ((Number)object).floatValue();
        }
        if (this.times.isEmpty()) {
            f = 0.0f;
        } else {
            Object object = CollectionsKt.last((List)((List)this.times));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"last(...)");
            f = ((Number)object).floatValue();
        }
        this.lastTime = f;
        this.indices = this.times.size();
    }

    @Override
    public float getStartTime() {
        return this.startTime;
    }

    @Override
    public float getLastTime() {
        return this.lastTime;
    }

    @Override
    public int getIndices() {
        return this.indices;
    }

    @Override
    public void findKeyFrames(float time, @NotNull AnimationKeyFrameIndexer.FindResult result) {
        int n;
        int searchResult;
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (this.times.isEmpty()) {
            result.clear();
            return;
        }
        if (this.times.size() < 2 || time <= this.times.getFloat(0)) {
            result.setStartFrame(0);
            result.setEndFrame(0);
            result.setStartTime(this.times.getFloat(0));
            result.setEndTime(this.times.getFloat(0));
            return;
        }
        if (time >= AnimationKeyFrameIndexerKt.access$getLastFloat(this.times)) {
            result.setStartFrame(CollectionsKt.getLastIndex((List)((List)this.times)));
            result.setEndFrame(CollectionsKt.getLastIndex((List)((List)this.times)));
            result.setStartTime(AnimationKeyFrameIndexerKt.access$getLastFloat(this.times));
            result.setEndTime(AnimationKeyFrameIndexerKt.access$getLastFloat(this.times));
            return;
        }
        int maxFrames = 30;
        float maxTime = 1.0f;
        int searchStartIndex = RangesKt.coerceIn((int)result.getStartFrame(), (int)0, (int)(CollectionsKt.getLastIndex((List)((List)this.times)) - 1));
        int searchEndIndex = RangesKt.coerceIn((int)(result.getStartFrame() + maxFrames), (int)0, (int)(CollectionsKt.getLastIndex((List)((List)this.times)) - 1));
        for (int currentIndex = RangesKt.coerceIn((int)result.getStartFrame(), (int)0, (int)(CollectionsKt.getLastIndex((List)((List)this.times)) - 1)); currentIndex < CollectionsKt.getLastIndex((List)((List)this.times)) && currentIndex < searchEndIndex && this.times.getFloat(currentIndex) - this.times.getFloat(searchStartIndex) <= maxTime; ++currentIndex) {
            if (time >= this.times.getFloat(currentIndex) && time < this.times.getFloat(currentIndex + 1)) {
                result.setStartFrame(currentIndex);
                result.setEndFrame(currentIndex + 1);
                result.setStartTime(this.times.getFloat(currentIndex));
                result.setEndTime(this.times.getFloat(currentIndex + 1));
                return;
            }
            if (this.times.getFloat(currentIndex) > time) break;
        }
        if ((searchResult = AnimationKeyFrameIndexerKt.binarySearch$default(this.times, time, 0, 0, 6, null)) >= 0) {
            n = searchResult;
        } else {
            int insertionPoint = -searchResult - 1;
            n = RangesKt.coerceAtLeast((int)(insertionPoint - 1), (int)0);
        }
        int foundIndex = RangesKt.coerceIn((int)n, (ClosedRange)((ClosedRange)RangesKt.until((int)0, (int)CollectionsKt.getLastIndex((List)((List)this.times)))));
        result.setStartFrame(foundIndex);
        result.setEndFrame(foundIndex + 1);
        result.setStartTime(this.times.getFloat(foundIndex));
        result.setEndTime(this.times.getFloat(foundIndex + 1));
    }
}

