/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.renderer.model.animation;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.fifthlight.renderer.model.HumanoidTag;
import top.fifthlight.renderer.model.Node;
import top.fifthlight.renderer.model.animation.AnimationChannel;
import top.fifthlight.renderer.model.animation.AnimationInterpolation;
import top.fifthlight.renderer.model.animation.AnimationInterpolator;
import top.fifthlight.renderer.model.animation.AnimationKeyFrameData;
import top.fifthlight.renderer.model.animation.AnimationKeyFrameIndexer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003Bm\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001d\u00103\u001a\u0002042\u0006\u00105\u001a\u00020+2\u0006\u00106\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00107J\u000f\u00108\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0003J\u000b\u00109\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010:\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010;\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\t\u0010<\u001a\u00020\rH\u00c6\u0003J\u000f\u0010=\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u00c6\u0003J\u000f\u0010>\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011H\u00c6\u0003J\t\u0010?\u001a\u00020\u0013H\u00c6\u0003J\u000f\u0010@\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015H\u00c6\u0003J\u0087\u0001\u0010A\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f2\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00132\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015H\u00c6\u0001J\u0013\u0010B\u001a\u00020C2\b\u0010D\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010E\u001a\u00020FH\u00d6\u0001J\t\u0010G\u001a\u00020\tH\u00d6\u0001R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020+8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00100\u001a\b\u0012\u0004\u0012\u00028\u000001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00102\u001a\b\u0012\u0004\u0012\u00028\u000001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Ltop/fifthlight/renderer/model/animation/SimpleAnimationChannel;", "T", "", "Ltop/fifthlight/renderer/model/animation/AnimationChannel;", "type", "Ltop/fifthlight/renderer/model/animation/AnimationChannel$Type;", "targetNode", "Ltop/fifthlight/renderer/model/Node;", "targetNodeName", "", "targetHumanoidTag", "Ltop/fifthlight/renderer/model/HumanoidTag;", "indexer", "Ltop/fifthlight/renderer/model/animation/AnimationKeyFrameIndexer;", "interpolator", "Ltop/fifthlight/renderer/model/animation/AnimationInterpolator;", "keyframeData", "Ltop/fifthlight/renderer/model/animation/AnimationKeyFrameData;", "interpolation", "Ltop/fifthlight/renderer/model/animation/AnimationInterpolation;", "defaultValue", "Lkotlin/Function0;", "<init>", "(Ltop/fifthlight/renderer/model/animation/AnimationChannel$Type;Ltop/fifthlight/renderer/model/Node;Ljava/lang/String;Ltop/fifthlight/renderer/model/HumanoidTag;Ltop/fifthlight/renderer/model/animation/AnimationKeyFrameIndexer;Ltop/fifthlight/renderer/model/animation/AnimationInterpolator;Ltop/fifthlight/renderer/model/animation/AnimationKeyFrameData;Ltop/fifthlight/renderer/model/animation/AnimationInterpolation;Lkotlin/jvm/functions/Function0;)V", "getType", "()Ltop/fifthlight/renderer/model/animation/AnimationChannel$Type;", "getTargetNode", "()Ltop/fifthlight/renderer/model/Node;", "getTargetNodeName", "()Ljava/lang/String;", "getTargetHumanoidTag", "()Ltop/fifthlight/renderer/model/HumanoidTag;", "getIndexer", "()Ltop/fifthlight/renderer/model/animation/AnimationKeyFrameIndexer;", "getInterpolator", "()Ltop/fifthlight/renderer/model/animation/AnimationInterpolator;", "getKeyframeData", "()Ltop/fifthlight/renderer/model/animation/AnimationKeyFrameData;", "getInterpolation", "()Ltop/fifthlight/renderer/model/animation/AnimationInterpolation;", "getDefaultValue", "()Lkotlin/jvm/functions/Function0;", "duration", "", "getDuration", "()F", "indexResult", "Ltop/fifthlight/renderer/model/animation/AnimationKeyFrameIndexer$FindResult;", "startValues", "", "endValues", "getKeyFrameData", "", "time", "result", "(FLjava/lang/Object;)V", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "", "toString", "model_model-base-model-base"})
@SourceDebugExtension(value={"SMAP\nAnimationChannel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnimationChannel.kt\ntop/fifthlight/renderer/model/animation/SimpleAnimationChannel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,99:1\n1#2:100\n*E\n"})
public final class SimpleAnimationChannel<T>
implements AnimationChannel<T> {
    @NotNull
    private final AnimationChannel.Type<T> type;
    @Nullable
    private final Node targetNode;
    @Nullable
    private final String targetNodeName;
    @Nullable
    private final HumanoidTag targetHumanoidTag;
    @NotNull
    private final AnimationKeyFrameIndexer indexer;
    @NotNull
    private final AnimationInterpolator<T> interpolator;
    @NotNull
    private final AnimationKeyFrameData<T> keyframeData;
    @NotNull
    private final AnimationInterpolation interpolation;
    @NotNull
    private final Function0<T> defaultValue;
    @NotNull
    private final AnimationKeyFrameIndexer.FindResult indexResult;
    @NotNull
    private final List<T> startValues;
    @NotNull
    private final List<T> endValues;

    public SimpleAnimationChannel(@NotNull AnimationChannel.Type<T> type2, @Nullable Node targetNode, @Nullable String targetNodeName, @Nullable HumanoidTag targetHumanoidTag, @NotNull AnimationKeyFrameIndexer indexer, @NotNull AnimationInterpolator<T> interpolator, @NotNull AnimationKeyFrameData<T> keyframeData, @NotNull AnimationInterpolation interpolation, @NotNull Function0<? extends T> defaultValue) {
        ArrayList<Object> arrayList;
        int n;
        Intrinsics.checkNotNullParameter(type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)indexer, (String)"indexer");
        Intrinsics.checkNotNullParameter(interpolator, (String)"interpolator");
        Intrinsics.checkNotNullParameter(keyframeData, (String)"keyframeData");
        Intrinsics.checkNotNullParameter((Object)((Object)interpolation), (String)"interpolation");
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        this.type = type2;
        this.targetNode = targetNode;
        this.targetNodeName = targetNodeName;
        this.targetHumanoidTag = targetHumanoidTag;
        this.indexer = indexer;
        this.interpolator = interpolator;
        this.keyframeData = keyframeData;
        this.interpolation = interpolation;
        this.defaultValue = defaultValue;
        if (!(this.interpolation.getElements() == this.keyframeData.getElements())) {
            boolean bl = false;
            String string = "Bad elements of keyframe data: " + this.keyframeData.getElements();
            throw new IllegalArgumentException(string.toString());
        }
        this.indexResult = new AnimationKeyFrameIndexer.FindResult(0, 0, 0.0f, 0.0f, 15, null);
        int n2 = this.interpolation.getElements();
        SimpleAnimationChannel simpleAnimationChannel = this;
        ArrayList<Object> arrayList2 = new ArrayList<Object>(n2);
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n = n3++;
            arrayList = arrayList2;
            boolean bl = false;
            arrayList.add(this.defaultValue.invoke());
        }
        simpleAnimationChannel.startValues = arrayList2;
        n2 = this.interpolation.getElements();
        simpleAnimationChannel = this;
        arrayList2 = new ArrayList(n2);
        n3 = 0;
        while (n3 < n2) {
            int it = n = n3++;
            arrayList = arrayList2;
            boolean bl = false;
            arrayList.add(this.defaultValue.invoke());
        }
        simpleAnimationChannel.endValues = arrayList2;
    }

    @Override
    @NotNull
    public AnimationChannel.Type<T> getType() {
        return this.type;
    }

    @Override
    @Nullable
    public Node getTargetNode() {
        return this.targetNode;
    }

    @Override
    @Nullable
    public String getTargetNodeName() {
        return this.targetNodeName;
    }

    @Override
    @Nullable
    public HumanoidTag getTargetHumanoidTag() {
        return this.targetHumanoidTag;
    }

    @NotNull
    public final AnimationKeyFrameIndexer getIndexer() {
        return this.indexer;
    }

    @NotNull
    public final AnimationInterpolator<T> getInterpolator() {
        return this.interpolator;
    }

    @NotNull
    public final AnimationKeyFrameData<T> getKeyframeData() {
        return this.keyframeData;
    }

    @NotNull
    public final AnimationInterpolation getInterpolation() {
        return this.interpolation;
    }

    @NotNull
    public final Function0<T> getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public float getDuration() {
        return this.indexer.getLastTime();
    }

    @Override
    public void getKeyFrameData(float time, @NotNull T result) {
        Intrinsics.checkNotNullParameter(result, (String)"result");
        this.indexer.findKeyFrames(time, this.indexResult);
        if (this.indexResult.getStartFrame() == this.indexResult.getEndFrame() || this.indexResult.getStartTime() > time || this.indexResult.getEndTime() < time) {
            this.keyframeData.get(this.indexResult.getStartFrame(), this.startValues);
            this.interpolator.set(this.startValues, result);
            return;
        }
        float delta = (time - this.indexResult.getStartTime()) / (this.indexResult.getEndTime() - this.indexResult.getStartTime());
        this.keyframeData.get(this.indexResult.getStartFrame(), this.startValues);
        this.keyframeData.get(this.indexResult.getEndFrame(), this.endValues);
        this.interpolator.interpolate(delta, this.interpolation, this.startValues, this.endValues, result);
    }

    @NotNull
    public final AnimationChannel.Type<T> component1() {
        return this.type;
    }

    @Nullable
    public final Node component2() {
        return this.targetNode;
    }

    @Nullable
    public final String component3() {
        return this.targetNodeName;
    }

    @Nullable
    public final HumanoidTag component4() {
        return this.targetHumanoidTag;
    }

    @NotNull
    public final AnimationKeyFrameIndexer component5() {
        return this.indexer;
    }

    @NotNull
    public final AnimationInterpolator<T> component6() {
        return this.interpolator;
    }

    @NotNull
    public final AnimationKeyFrameData<T> component7() {
        return this.keyframeData;
    }

    @NotNull
    public final AnimationInterpolation component8() {
        return this.interpolation;
    }

    @NotNull
    public final Function0<T> component9() {
        return this.defaultValue;
    }

    @NotNull
    public final SimpleAnimationChannel<T> copy(@NotNull AnimationChannel.Type<T> type2, @Nullable Node targetNode, @Nullable String targetNodeName, @Nullable HumanoidTag targetHumanoidTag, @NotNull AnimationKeyFrameIndexer indexer, @NotNull AnimationInterpolator<T> interpolator, @NotNull AnimationKeyFrameData<T> keyframeData, @NotNull AnimationInterpolation interpolation, @NotNull Function0<? extends T> defaultValue) {
        Intrinsics.checkNotNullParameter(type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)indexer, (String)"indexer");
        Intrinsics.checkNotNullParameter(interpolator, (String)"interpolator");
        Intrinsics.checkNotNullParameter(keyframeData, (String)"keyframeData");
        Intrinsics.checkNotNullParameter((Object)((Object)interpolation), (String)"interpolation");
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        return new SimpleAnimationChannel<T>(type2, targetNode, targetNodeName, targetHumanoidTag, indexer, interpolator, keyframeData, interpolation, defaultValue);
    }

    public static /* synthetic */ SimpleAnimationChannel copy$default(SimpleAnimationChannel simpleAnimationChannel, AnimationChannel.Type type2, Node node, String string, HumanoidTag humanoidTag, AnimationKeyFrameIndexer animationKeyFrameIndexer, AnimationInterpolator animationInterpolator, AnimationKeyFrameData animationKeyFrameData, AnimationInterpolation animationInterpolation, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            type2 = simpleAnimationChannel.type;
        }
        if ((n & 2) != 0) {
            node = simpleAnimationChannel.targetNode;
        }
        if ((n & 4) != 0) {
            string = simpleAnimationChannel.targetNodeName;
        }
        if ((n & 8) != 0) {
            humanoidTag = simpleAnimationChannel.targetHumanoidTag;
        }
        if ((n & 0x10) != 0) {
            animationKeyFrameIndexer = simpleAnimationChannel.indexer;
        }
        if ((n & 0x20) != 0) {
            animationInterpolator = simpleAnimationChannel.interpolator;
        }
        if ((n & 0x40) != 0) {
            animationKeyFrameData = simpleAnimationChannel.keyframeData;
        }
        if ((n & 0x80) != 0) {
            animationInterpolation = simpleAnimationChannel.interpolation;
        }
        if ((n & 0x100) != 0) {
            function0 = simpleAnimationChannel.defaultValue;
        }
        return simpleAnimationChannel.copy(type2, node, string, humanoidTag, animationKeyFrameIndexer, animationInterpolator, animationKeyFrameData, animationInterpolation, function0);
    }

    @NotNull
    public String toString() {
        return "SimpleAnimationChannel(type=" + this.type + ", targetNode=" + this.targetNode + ", targetNodeName=" + this.targetNodeName + ", targetHumanoidTag=" + this.targetHumanoidTag + ", indexer=" + this.indexer + ", interpolator=" + this.interpolator + ", keyframeData=" + this.keyframeData + ", interpolation=" + this.interpolation + ", defaultValue=" + this.defaultValue + ")";
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = result * 31 + (this.targetNode == null ? 0 : this.targetNode.hashCode());
        result = result * 31 + (this.targetNodeName == null ? 0 : this.targetNodeName.hashCode());
        result = result * 31 + (this.targetHumanoidTag == null ? 0 : this.targetHumanoidTag.hashCode());
        result = result * 31 + this.indexer.hashCode();
        result = result * 31 + this.interpolator.hashCode();
        result = result * 31 + this.keyframeData.hashCode();
        result = result * 31 + this.interpolation.hashCode();
        result = result * 31 + this.defaultValue.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SimpleAnimationChannel)) {
            return false;
        }
        SimpleAnimationChannel simpleAnimationChannel = (SimpleAnimationChannel)other;
        if (!Intrinsics.areEqual(this.type, simpleAnimationChannel.type)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.targetNode, (Object)simpleAnimationChannel.targetNode)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.targetNodeName, (Object)simpleAnimationChannel.targetNodeName)) {
            return false;
        }
        if (this.targetHumanoidTag != simpleAnimationChannel.targetHumanoidTag) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.indexer, (Object)simpleAnimationChannel.indexer)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.interpolator, simpleAnimationChannel.interpolator)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.keyframeData, simpleAnimationChannel.keyframeData)) {
            return false;
        }
        if (this.interpolation != simpleAnimationChannel.interpolation) {
            return false;
        }
        return Intrinsics.areEqual(this.defaultValue, simpleAnimationChannel.defaultValue);
    }
}

