/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.renderer.model.animation;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import top.fifthlight.renderer.model.animation.AnimationInterpolation;
import top.fifthlight.renderer.model.animation.AnimationInterpolator;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J<\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\u0011"}, d2={"Ltop/fifthlight/renderer/model/animation/Vector3AnimationInterpolator;", "Ltop/fifthlight/renderer/model/animation/AnimationInterpolator;", "Lorg/joml/Vector3f;", "<init>", "()V", "set", "", "value", "", "result", "interpolate", "delta", "", "type", "Ltop/fifthlight/renderer/model/animation/AnimationInterpolation;", "startValue", "endValue", "model_model-base-model-base"})
public final class Vector3AnimationInterpolator
implements AnimationInterpolator<Vector3f> {
    @NotNull
    public static final Vector3AnimationInterpolator INSTANCE = new Vector3AnimationInterpolator();

    private Vector3AnimationInterpolator() {
    }

    @Override
    public void set(@NotNull List<? extends Vector3f> value, @NotNull Vector3f result) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        result.set((Vector3fc)value.get(0));
    }

    @Override
    public void interpolate(float delta, @NotNull AnimationInterpolation type2, @NotNull List<? extends Vector3f> startValue, @NotNull List<? extends Vector3f> endValue, @NotNull Vector3f result) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        Intrinsics.checkNotNullParameter(startValue, (String)"startValue");
        Intrinsics.checkNotNullParameter(endValue, (String)"endValue");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            case 1: {
                Vector3f vector3f = result.set((Vector3fc)startValue.get(0)).lerp((Vector3fc)endValue.get(0), delta);
                break;
            }
            case 2: {
                Vector3f vector3f = result.set((Vector3fc)startValue.get(0));
                break;
            }
            case 3: {
                float t = delta;
                float t2 = t * t;
                float t3 = t2 * t;
                float h1 = 2.0f * t3 - 3.0f * t2 + 1.0f;
                float h2 = t3 - 2.0f * t2 + t;
                float h3 = -2.0f * t3 + 3.0f * t2;
                float h4 = t3 - t2;
                Vector3f vector3f = result.set((Vector3fc)startValue.get(1).mul(h1).add((Vector3fc)startValue.get(2).mul(h2)).add((Vector3fc)endValue.get(1).mul(h3)).add((Vector3fc)endValue.get(0).mul(h4)));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnimationInterpolation.values().length];
            try {
                nArray[AnimationInterpolation.LINEAR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnimationInterpolation.STEP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnimationInterpolation.CUBIC_SPLINE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

