/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.renderer.model.gltf;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.fifthlight.renderer.model.ModelFileLoader;
import top.fifthlight.renderer.model.gltf.GltfBinaryLoader;
import top.fifthlight.renderer.model.gltf.GltfLoadException;
import top.fifthlight.renderer.model.gltf.GltfLoader;
import top.fifthlight.renderer.model.util.ReadUtilKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Ltop/fifthlight/renderer/model/gltf/GltfBinaryLoader;", "Ltop/fifthlight/renderer/model/ModelFileLoader;", "<init>", "()V", "extensions", "", "", "getExtensions", "()Ljava/util/List;", "abilities", "Ltop/fifthlight/renderer/model/ModelFileLoader$Ability;", "getAbilities", "GLTF_BINARY_MAGIC", "", "probeLength", "getProbeLength", "()I", "probe", "", "buffer", "Ljava/nio/ByteBuffer;", "load", "Ltop/fifthlight/renderer/model/ModelFileLoader$Result;", "path", "Ljava/nio/file/Path;", "basePath", "ChunkType", "model_model-gltf-model-gltf"})
@SourceDebugExtension(value={"SMAP\nGltfBinaryLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GltfBinaryLoader.kt\ntop/fifthlight/renderer/model/gltf/GltfBinaryLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,125:1\n295#2,2:126\n*S KotlinDebug\n*F\n+ 1 GltfBinaryLoader.kt\ntop/fifthlight/renderer/model/gltf/GltfBinaryLoader\n*L\n85#1:126,2\n*E\n"})
public final class GltfBinaryLoader
implements ModelFileLoader {
    @NotNull
    public static final GltfBinaryLoader INSTANCE = new GltfBinaryLoader();
    @NotNull
    private static final List<String> extensions;
    @NotNull
    private static final List<ModelFileLoader.Ability> abilities;
    private static final int GLTF_BINARY_MAGIC = 1179937895;
    private static final int probeLength;

    private GltfBinaryLoader() {
    }

    @Override
    @NotNull
    public List<String> getExtensions() {
        return extensions;
    }

    @Override
    @NotNull
    public List<ModelFileLoader.Ability> getAbilities() {
        return abilities;
    }

    @Override
    public int getProbeLength() {
        return probeLength;
    }

    @Override
    public boolean probe(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (buffer.remaining() < 4) {
            return false;
        }
        ByteBuffer slice = buffer.slice().order(ByteOrder.LITTLE_ENDIAN);
        return slice.getInt() == 1179937895;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ModelFileLoader.Result load(@NotNull Path path, @NotNull Path basePath) {
        ModelFileLoader.Result result;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Object object = new OpenOption[]{StandardOpenOption.READ};
        object = FileChannel.open(path, object);
        Throwable throwable = null;
        try {
            FileChannel channel = (FileChannel)object;
            boolean bl = false;
            ByteBuffer readBuffer = ByteBuffer.allocate(16);
            readBuffer.order(ByteOrder.LITTLE_ENDIAN);
            GltfBinaryLoader.load$lambda$1$readBytes(readBuffer, channel, 4, (Function1<? super Integer, String>)((Function1)load.1.1.INSTANCE));
            int magic = readBuffer.getInt();
            if (magic != 1179937895) {
                String string = Integer.toString(magic, CharsKt.checkRadix((int)16));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                throw new GltfLoadException("Bad magic: want 0x46546c67, but got 0x" + StringsKt.padStart((String)string, (int)8, (char)'0'));
            }
            GltfBinaryLoader.load$lambda$1$readBytes(readBuffer, channel, 8, (Function1<? super Integer, String>)((Function1)load.1.2.INSTANCE));
            int version = readBuffer.getInt();
            if (version != 2) {
                throw new GltfLoadException("Bad GLTF version: want 2, but get " + version);
            }
            int totalLength = UInt.constructor-impl((int)readBuffer.getInt());
            Ref.IntRef readLength = new Ref.IntRef();
            readLength.element = 0;
            ByteBuffer byteBuffer = GltfBinaryLoader.load$lambda$1$readChunk(readLength, totalLength, readBuffer, channel, ChunkType.JSON, 0x400000);
            if (byteBuffer == null) {
                throw new GltfLoadException("Missing JSON chunk in binary GLTF");
            }
            ByteBuffer jsonChunk = byteBuffer;
            ByteBuffer binaryChunk = GltfBinaryLoader.load$lambda$1$readChunk(readLength, totalLength, readBuffer, channel, ChunkType.BINARY, 0x10000000);
            Path path2 = path.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getParent(...)");
            GltfLoader context = new GltfLoader(binaryChunk, path, path2);
            String string = StandardCharsets.UTF_8.decode(jsonChunk).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            result = context.load(string);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return result;
    }

    private static final void load$lambda$1$readBytes(ByteBuffer readBuffer, FileChannel $channel, int len, Function1<? super Integer, String> fail) {
        readBuffer.clear();
        readBuffer.limit(len);
        Intrinsics.checkNotNull((Object)$channel);
        ReadableByteChannel readableByteChannel = $channel;
        Intrinsics.checkNotNull((Object)readBuffer);
        ReadUtilKt.readAll(readableByteChannel, readBuffer);
        if (readBuffer.limit() < len) {
            throw new GltfLoadException((String)fail.invoke((Object)readBuffer.limit()));
        }
        readBuffer.flip();
    }

    private static final ByteBuffer load$lambda$1$readChunk(Ref.IntRef readLength, int totalLength, ByteBuffer readBuffer, FileChannel $channel, ChunkType wantedType, int sizeLimit) {
        ChunkType chunkType;
        ChunkType chunkType2;
        Object v2;
        int length;
        block14: {
            if (Integer.compareUnsigned(UInt.constructor-impl((int)(readLength.element + 8)), totalLength) > 0) {
                throw new GltfLoadException("No available space for chunk header: current read " + UInt.toString-impl((int)readLength.element) + ", total length " + UInt.toString-impl((int)totalLength));
            }
            readBuffer.clear();
            readBuffer.limit(8);
            Intrinsics.checkNotNull((Object)$channel);
            ReadableByteChannel readableByteChannel = $channel;
            Intrinsics.checkNotNull((Object)readBuffer);
            ReadUtilKt.readAll(readableByteChannel, readBuffer);
            switch (readBuffer.limit()) {
                case 0: {
                    return null;
                }
                case 8: {
                    break;
                }
                default: {
                    throw new GltfLoadException("Bad chunk header: want 8 bytes, but only read " + readBuffer.limit() + " bytes");
                }
            }
            readBuffer.flip();
            readLength.element = UInt.constructor-impl((int)(readLength.element + 8));
            length = UInt.constructor-impl((int)readBuffer.getInt());
            int type2 = UInt.constructor-impl((int)readBuffer.getInt());
            if (Integer.compareUnsigned(UInt.constructor-impl((int)(readLength.element + length)), totalLength) > 0) {
                throw new GltfLoadException("Bad chunk length: total length is " + UInt.toString-impl((int)totalLength) + ", current location is at " + UInt.toString-impl((int)readLength.element) + ", but want to read " + UInt.toString-impl((int)length));
            }
            readLength.element = UInt.constructor-impl((int)(readLength.element + length));
            Iterable $this$firstOrNull$iv = (Iterable)ChunkType.getEntries();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ChunkType it = (ChunkType)((Object)element$iv);
                boolean bl = false;
                UInt uInt = it.getId-0hXNFcg();
                if (!(uInt == null ? false : uInt.unbox-impl() == type2)) continue;
                v2 = element$iv;
                break block14;
            }
            v2 = null;
        }
        if ((chunkType2 = (ChunkType)v2) == null) {
            chunkType2 = ChunkType.UNKNOWN;
        }
        if ((chunkType = chunkType2) != wantedType) {
            throw new GltfLoadException("Bad chunk type: " + chunkType + ", want " + wantedType);
        }
        try {
            long length2 = (long)length & 0xFFFFFFFFL;
            MappedByteBuffer mappedBuffer = $channel.map(FileChannel.MapMode.READ_ONLY, $channel.position(), length2);
            $channel.position($channel.position() + length2);
            return mappedBuffer;
        }
        catch (IOException length2) {
        }
        catch (UnsupportedOperationException length2) {
            // empty catch block
        }
        if (Integer.compareUnsigned(length, UInt.constructor-impl((int)sizeLimit)) > 0) {
            throw new GltfLoadException("Chunk is too large: maximum is " + sizeLimit + ", but got " + UInt.toString-impl((int)length));
        }
        ByteBuffer binaryBuffer = ByteBuffer.allocateDirect(length);
        binaryBuffer.limit(length);
        ReadableByteChannel readableByteChannel = $channel;
        Intrinsics.checkNotNull((Object)binaryBuffer);
        ReadUtilKt.readAll(readableByteChannel, binaryBuffer);
        binaryBuffer.flip();
        if (binaryBuffer.limit() < length) {
            throw new GltfLoadException("Chunk's size not correct: want to read " + UInt.toString-impl((int)length) + ", but only got " + binaryBuffer.limit());
        }
        return binaryBuffer;
    }

    static {
        Object[] objectArray = new String[]{"glb", "vrm"};
        extensions = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new ModelFileLoader.Ability[]{ModelFileLoader.Ability.MODEL, ModelFileLoader.Ability.ANIMATION};
        abilities = CollectionsKt.listOf((Object[])objectArray);
        probeLength = 4;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0013\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Ltop/fifthlight/renderer/model/gltf/GltfBinaryLoader$ChunkType;", "", "id", "Lkotlin/UInt;", "<init>", "(Ljava/lang/String;ILkotlin/UInt;)V", "getId-0hXNFcg", "()Lkotlin/UInt;", "JSON", "BINARY", "UNKNOWN", "model_model-gltf-model-gltf"})
    private static final class ChunkType
    extends Enum<ChunkType> {
        @Nullable
        private final UInt id;
        public static final /* enum */ ChunkType JSON = new ChunkType(UInt.box-impl((int)1313821514));
        public static final /* enum */ ChunkType BINARY = new ChunkType(UInt.box-impl((int)5130562));
        public static final /* enum */ ChunkType UNKNOWN = new ChunkType(null);
        private static final /* synthetic */ ChunkType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ChunkType(UInt id) {
            this.id = id;
        }

        @Nullable
        public final UInt getId-0hXNFcg() {
            return this.id;
        }

        public static ChunkType[] values() {
            return (ChunkType[])$VALUES.clone();
        }

        public static ChunkType valueOf(String value) {
            return Enum.valueOf(ChunkType.class, value);
        }

        @NotNull
        public static EnumEntries<ChunkType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = chunkTypeArray = new ChunkType[]{ChunkType.JSON, ChunkType.BINARY, ChunkType.UNKNOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

