/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.renderer.model.gltf;

import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import top.fifthlight.renderer.model.Accessor;
import top.fifthlight.renderer.model.Buffer;
import top.fifthlight.renderer.model.BufferView;
import top.fifthlight.renderer.model.Expression;
import top.fifthlight.renderer.model.HumanoidTag;
import top.fifthlight.renderer.model.Material;
import top.fifthlight.renderer.model.Mesh;
import top.fifthlight.renderer.model.MeshId;
import top.fifthlight.renderer.model.Metadata;
import top.fifthlight.renderer.model.Model;
import top.fifthlight.renderer.model.ModelFileLoader;
import top.fifthlight.renderer.model.Node;
import top.fifthlight.renderer.model.NodeId;
import top.fifthlight.renderer.model.NodeTransform;
import top.fifthlight.renderer.model.Primitive;
import top.fifthlight.renderer.model.Scene;
import top.fifthlight.renderer.model.Skin;
import top.fifthlight.renderer.model.Texture;
import top.fifthlight.renderer.model.animation.AccessorAnimationKeyFrameData;
import top.fifthlight.renderer.model.animation.AccessorAnimationKeyFrameIndexer;
import top.fifthlight.renderer.model.animation.Animation;
import top.fifthlight.renderer.model.animation.AnimationChannel;
import top.fifthlight.renderer.model.animation.AnimationChannelKt;
import top.fifthlight.renderer.model.animation.AnimationKeyFrameIndexer;
import top.fifthlight.renderer.model.animation.SimpleAnimationChannel;
import top.fifthlight.renderer.model.gltf.GltfLoadException;
import top.fifthlight.renderer.model.gltf.GltfLoader;
import top.fifthlight.renderer.model.gltf.format.Gltf;
import top.fifthlight.renderer.model.gltf.format.GltfAccessor;
import top.fifthlight.renderer.model.gltf.format.GltfAnimation;
import top.fifthlight.renderer.model.gltf.format.GltfAnimationChannel;
import top.fifthlight.renderer.model.gltf.format.GltfAnimationSampler;
import top.fifthlight.renderer.model.gltf.format.GltfAnimationTarget;
import top.fifthlight.renderer.model.gltf.format.GltfAttributeKey;
import top.fifthlight.renderer.model.gltf.format.GltfBuffer;
import top.fifthlight.renderer.model.gltf.format.GltfBufferView;
import top.fifthlight.renderer.model.gltf.format.GltfExtension;
import top.fifthlight.renderer.model.gltf.format.GltfImage;
import top.fifthlight.renderer.model.gltf.format.GltfMaterial;
import top.fifthlight.renderer.model.gltf.format.GltfMesh;
import top.fifthlight.renderer.model.gltf.format.GltfNode;
import top.fifthlight.renderer.model.gltf.format.GltfPrimitive;
import top.fifthlight.renderer.model.gltf.format.GltfScene;
import top.fifthlight.renderer.model.gltf.format.GltfSkin;
import top.fifthlight.renderer.model.gltf.format.GltfTexture;
import top.fifthlight.renderer.model.gltf.format.GltfTextureInfo;
import top.fifthlight.renderer.model.gltf.format.GltfTextureSampler;
import top.fifthlight.renderer.model.gltf.format.extension.VrmV0Extension;
import top.fifthlight.renderer.model.gltf.format.extension.VrmV1Extension;

@kotlin.Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 B2\u00020\u0001:\u0001BB!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u0013H\u0002J\b\u00100\u001a\u000201H\u0002J\b\u00102\u001a\u000201H\u0002J\b\u00103\u001a\u000201H\u0002J\b\u00104\u001a\u000201H\u0002J\b\u00105\u001a\u000201H\u0002J\b\u00106\u001a\u000201H\u0002J\b\u00107\u001a\u000201H\u0002J\b\u00108\u001a\u000201H\u0002J\u0010\u00109\u001a\u00020'2\u0006\u0010:\u001a\u00020&H\u0002J\b\u0010;\u001a\u000201H\u0002J\b\u0010<\u001a\u000201H\u0002J\b\u0010=\u001a\u000201H\u0002J\u000e\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00030\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u0015X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Ltop/fifthlight/renderer/model/gltf/GltfLoader;", "", "buffer", "Ljava/nio/ByteBuffer;", "filePath", "Ljava/nio/file/Path;", "basePath", "<init>", "(Ljava/nio/ByteBuffer;Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "uuid", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "Ljava/util/UUID;", "loaded", "", "gltf", "Ltop/fifthlight/renderer/model/gltf/format/Gltf;", "externalBuffers", "", "Ljava/net/URI;", "buffers", "", "Ltop/fifthlight/renderer/model/Buffer;", "bufferViews", "Ltop/fifthlight/renderer/model/BufferView;", "accessors", "Ltop/fifthlight/renderer/model/Accessor;", "samplers", "Ltop/fifthlight/renderer/model/Texture$Sampler;", "textures", "Ltop/fifthlight/renderer/model/Texture;", "materials", "Ltop/fifthlight/renderer/model/Material;", "meshes", "Ltop/fifthlight/renderer/model/Mesh;", "skins", "Ltop/fifthlight/renderer/model/Skin;", "nodes", "", "Ltop/fifthlight/renderer/model/Node;", "scenes", "Ltop/fifthlight/renderer/model/Scene;", "animations", "Ltop/fifthlight/renderer/model/animation/Animation;", "expressions", "Ltop/fifthlight/renderer/model/Expression;", "loadExternalUri", "uri", "loadBuffers", "", "loadBufferViews", "loadAccessors", "loadSamplers", "loadTextures", "loadMaterials", "loadMeshes", "loadSkins", "loadNode", "index", "loadScenes", "loadAnimations", "loadExpressions", "load", "Ltop/fifthlight/renderer/model/ModelFileLoader$Result;", "json", "", "Companion", "model_model-gltf-model-gltf"})
@SourceDebugExtension(value={"SMAP\nGltfLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GltfLoader.kt\ntop/fifthlight/renderer/model/gltf/GltfLoader\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 Accessor.kt\ntop/fifthlight/renderer/model/Accessor\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,586:1\n381#2,7:587\n381#2,3:672\n384#2,4:679\n1567#3:594\n1598#3,4:595\n1557#3:599\n1628#3,3:600\n1557#3:603\n1628#3,3:604\n1557#3:607\n1628#3,3:608\n1557#3:611\n1628#3,2:612\n295#3,2:614\n1630#3:616\n1557#3:617\n1628#3,3:618\n1567#3:621\n1598#3,3:622\n1557#3:625\n1628#3,3:626\n1601#3:629\n1557#3:640\n1628#3,2:641\n1557#3:662\n1628#3,3:663\n1557#3:667\n1628#3,3:668\n1630#3:671\n1557#3:675\n1628#3,3:676\n1557#3:683\n1628#3,2:684\n1557#3:686\n1628#3,3:687\n1630#3:690\n1557#3:691\n1628#3,2:692\n1611#3,9:694\n1863#3:703\n1864#3:705\n1620#3:706\n1630#3:707\n1611#3,9:708\n1863#3:717\n1557#3:719\n1628#3,3:720\n1864#3:724\n1620#3:725\n1557#3:727\n1628#3,3:728\n1557#3:732\n1628#3,3:733\n662#4:630\n743#4,4:631\n662#4:635\n743#4,4:636\n37#5,5:643\n42#5,13:649\n1#6:648\n1#6:666\n1#6:704\n1#6:718\n1#6:723\n1#6:731\n222#7:726\n*S KotlinDebug\n*F\n+ 1 GltfLoader.kt\ntop/fifthlight/renderer/model/gltf/GltfLoader\n*L\n56#1:587,7\n321#1:672,3\n321#1:679,4\n61#1:594\n61#1:595,4\n81#1:599\n81#1:600,3\n93#1:603\n93#1:604,3\n112#1:607\n112#1:608,3\n124#1:611\n124#1:612,2\n148#1:614,2\n124#1:616\n162#1:617\n162#1:618,3\n260#1:621\n260#1:622,3\n263#1:625\n263#1:626,3\n260#1:629\n288#1:640\n288#1:641,2\n313#1:662\n313#1:663,3\n316#1:667\n316#1:668,3\n288#1:671\n340#1:675\n340#1:676,3\n348#1:683\n348#1:684,2\n350#1:686\n350#1:687,3\n348#1:690\n356#1:691\n356#1:692,2\n359#1:694,9\n359#1:703\n359#1:705\n359#1:706\n356#1:707\n472#1:708,9\n472#1:717\n495#1:719\n495#1:720,3\n472#1:724\n472#1:725\n218#1:727\n218#1:728,3\n256#1:732\n256#1:733,3\n276#1:630\n276#1:631,4\n284#1:635\n284#1:636,4\n306#1:643,5\n306#1:649,13\n306#1:648\n359#1:704\n472#1:723\n554#1:726\n*E\n"})
public final class GltfLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final ByteBuffer buffer;
    @NotNull
    private final Path filePath;
    @NotNull
    private final Path basePath;
    private final UUID uuid;
    private boolean loaded;
    private Gltf gltf;
    @NotNull
    private final Map<URI, ByteBuffer> externalBuffers;
    private List<Buffer> buffers;
    private List<BufferView> bufferViews;
    private List<Accessor> accessors;
    private List<Texture.Sampler> samplers;
    private List<Texture> textures;
    private List<? extends Material> materials;
    private List<Mesh> meshes;
    private List<Skin> skins;
    @NotNull
    private final Map<Integer, Node> nodes;
    private List<Scene> scenes;
    private List<Animation> animations;
    private List<Expression> expressions;
    @NotNull
    private static final Texture.Sampler defaultSampler = new Texture.Sampler(Texture.Sampler.MagFilter.LINEAR, Texture.Sampler.MinFilter.LINEAR, Texture.Sampler.WrapMode.REPEAT, Texture.Sampler.WrapMode.REPEAT);
    @NotNull
    private static final Json format = JsonKt.Json$default(null, (Function1)Companion.format.1.INSTANCE, (int)1, null);

    public GltfLoader(@Nullable ByteBuffer buffer, @NotNull Path filePath, @NotNull Path basePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        this.buffer = buffer;
        this.filePath = filePath;
        this.basePath = basePath;
        this.uuid = UUID.randomUUID();
        this.externalBuffers = new LinkedHashMap();
        this.nodes = new LinkedHashMap();
    }

    private final ByteBuffer loadExternalUri(URI uri) {
        Map<URI, ByteBuffer> $this$getOrPut$iv = this.externalBuffers;
        boolean $i$f$getOrPut = false;
        ByteBuffer value$iv = $this$getOrPut$iv.get(uri);
        if (value$iv == null) {
            boolean bl = false;
            String string = "URI resources is not supported for now";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
        return value$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void loadBuffers() {
        List list2;
        GltfLoader gltfLoader = this;
        Gltf gltf = this.gltf;
        if (gltf == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gltf");
            gltf = null;
        }
        List<GltfBuffer> list3 = gltf.getBuffers();
        if (list3 != null) {
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            Iterable iterable = list3;
            GltfLoader gltfLoader2 = gltfLoader;
            boolean $i$f$mapIndexed = false;
            void var3_4 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                Buffer buffer;
                void buffer2;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                GltfBuffer gltfBuffer = (GltfBuffer)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (buffer2.getUri() == null) {
                    void index;
                    ByteBuffer contextBuffer = this.buffer;
                    if (index != false || contextBuffer == null) {
                        throw new GltfLoadException("Buffer at " + (int)index + " missing URI");
                    }
                    buffer = new Buffer("GLB built-in buffer", contextBuffer);
                } else {
                    String string = buffer2.getUri();
                    URI uRI = URI.create(buffer2.getUri());
                    Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
                    buffer = new Buffer(string, this.loadExternalUri(uRI));
                }
                collection.add(buffer);
            }
            list2 = (List)destination$iv$iv;
            gltfLoader = gltfLoader2;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        gltfLoader.buffers = list2;
    }

    /*
     * WARNING - void declaration
     */
    private final void loadBufferViews() {
        List list2;
        GltfLoader gltfLoader = this;
        Gltf gltf = this.gltf;
        if (gltf == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gltf");
            gltf = null;
        }
        List<GltfBufferView> list3 = gltf.getBufferViews();
        if (list3 != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list3;
            GltfLoader gltfLoader2 = gltfLoader;
            boolean $i$f$map = false;
            void var3_4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                GltfBufferView gltfBufferView = (GltfBufferView)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                List<Buffer> list4 = this.buffers;
                if (list4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"buffers");
                    list4 = null;
                }
                Buffer buffer = (Buffer)CollectionsKt.getOrNull(list4, (int)it.getBuffer());
                if (buffer == null) {
                    throw new GltfLoadException("Invalid buffer view: buffer " + it.getBuffer() + " not found");
                }
                Integer n = it.getByteOffset();
                Integer n2 = it.getByteStride();
                collection.add(new BufferView(buffer, it.getByteLength(), n != null ? n : 0, n2 != null ? n2 : 0));
            }
            list2 = (List)destination$iv$iv;
            gltfLoader = gltfLoader2;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        gltfLoader.bufferViews = list2;
    }

    /*
     * WARNING - void declaration
     */
    private final void loadAccessors() {
        List list2;
        GltfLoader gltfLoader = this;
        Gltf gltf = this.gltf;
        if (gltf == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gltf");
            gltf = null;
        }
        List<GltfAccessor> list3 = gltf.getAccessors();
        if (list3 != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list3;
            GltfLoader gltfLoader2 = gltfLoader;
            boolean $i$f$map = false;
            void var3_4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                BufferView bufferView;
                void it;
                GltfAccessor gltfAccessor = (GltfAccessor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Integer n = it.getBufferView();
                if (n != null) {
                    int index = ((Number)n).intValue();
                    boolean bl2 = false;
                    List<BufferView> list4 = this.bufferViews;
                    if (list4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"bufferViews");
                        list4 = null;
                    }
                    if ((bufferView = (BufferView)CollectionsKt.getOrNull(list4, (int)index)) == null) {
                        throw new GltfLoadException("Invalid accessor: buffer view " + it.getBufferView() + " not found");
                    }
                } else {
                    bufferView = null;
                }
                String string = it.getName();
                List<Float> list5 = it.getMin();
                List<Float> list6 = it.getMax();
                Accessor.AccessorType accessorType = it.getType();
                int n2 = it.getCount();
                boolean bl3 = it.getNormalized();
                Accessor.ComponentType componentType = it.getComponentType();
                int n3 = it.getByteOffset();
                BufferView bufferView2 = bufferView;
                collection.add(new Accessor(bufferView2, n3, componentType, bl3, n2, accessorType, list6, list5, string));
            }
            list2 = (List)destination$iv$iv;
            gltfLoader = gltfLoader2;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        gltfLoader.accessors = list2;
    }

    /*
     * WARNING - void declaration
     */
    private final void loadSamplers() {
        List list2;
        GltfLoader gltfLoader = this;
        Gltf gltf = this.gltf;
        if (gltf == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gltf");
            gltf = null;
        }
        List<GltfTextureSampler> list3 = gltf.getSamplers();
        if (list3 != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list3;
            GltfLoader gltfLoader2 = gltfLoader;
            boolean $i$f$map = false;
            void var3_4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                GltfTextureSampler gltfTextureSampler = (GltfTextureSampler)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Texture.Sampler(it.getMagFilter(), it.getMinFilter(), it.getWrapS(), it.getWrapT()));
            }
            list2 = (List)destination$iv$iv;
            gltfLoader = gltfLoader2;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        gltfLoader.samplers = list2;
    }

    /*
     * WARNING - void declaration
     */
    private final void loadTextures() {
        List list2;
        block32: {
            block27: {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                List list3;
                Gltf gltf = this.gltf;
                if (gltf == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"gltf");
                    gltf = null;
                }
                if ((list3 = gltf.getImages()) == null) {
                    list3 = CollectionsKt.emptyList();
                }
                List images = list3;
                GltfLoader gltfLoader = this;
                Gltf gltf2 = this.gltf;
                if (gltf2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"gltf");
                    gltf2 = null;
                }
                List<GltfTexture> list4 = gltf2.getTextures();
                if (list4 == null) break block27;
                Iterable iterable = list4;
                GltfLoader gltfLoader2 = gltfLoader;
                boolean $i$f$map = false;
                void var4_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Texture.TextureType textureType;
                    Object object;
                    Object object2;
                    String string;
                    Object bufferView;
                    GltfImage image;
                    Collection collection;
                    block31: {
                        Object object3;
                        block30: {
                            Object object4;
                            void texture;
                            block29: {
                                Object object5;
                                block28: {
                                    GltfImage gltfImage;
                                    GltfTexture gltfTexture = (GltfTexture)item$iv$iv;
                                    collection = destination$iv$iv;
                                    boolean bl = false;
                                    Integer n = texture.getSource();
                                    if (n != null) {
                                        int index = ((Number)n).intValue();
                                        boolean bl2 = false;
                                        gltfImage = (GltfImage)CollectionsKt.getOrNull((List)images, (int)index);
                                        if (gltfImage == null) {
                                            throw new GltfLoadException("Bad texture: image " + index + " not found");
                                        }
                                    } else {
                                        gltfImage = null;
                                    }
                                    if ((object4 = (image = gltfImage)) == null || (object4 = ((GltfImage)object4).getBufferView()) == null) break block28;
                                    int index = ((Number)object4).intValue();
                                    boolean bl3 = false;
                                    List<BufferView> list5 = this.bufferViews;
                                    if (list5 == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"bufferViews");
                                        list5 = null;
                                    }
                                    BufferView bufferView2 = (BufferView)CollectionsKt.getOrNull(list5, (int)index);
                                    if (bufferView2 == null) {
                                        throw new GltfLoadException("");
                                    }
                                    object4 = bufferView2;
                                    if (bufferView2 != null) break block29;
                                }
                                if ((object5 = image) != null && (object5 = ((GltfImage)object5).getUri()) != null) {
                                    Object uri = object5;
                                    boolean bl = false;
                                    URI uRI = URI.create((String)uri);
                                    Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
                                    ByteBuffer buffer = this.loadExternalUri(uRI);
                                    object4 = new BufferView(new Buffer(null, buffer, 1, null), buffer.remaining(), 0, 0);
                                } else {
                                    object4 = null;
                                }
                            }
                            bufferView = object4;
                            string = texture.getName();
                            object3 = texture.getSampler();
                            if (object3 == null) break block30;
                            int index = ((Number)object3).intValue();
                            boolean bl = false;
                            List<Texture.Sampler> list6 = this.samplers;
                            if (list6 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"samplers");
                                list6 = null;
                            }
                            Texture.Sampler sampler = (Texture.Sampler)CollectionsKt.getOrNull(list6, (int)index);
                            if (sampler == null) {
                                throw new GltfLoadException("Bad texture: sampler " + index + " not found");
                            }
                            object3 = sampler;
                            if (sampler != null) break block31;
                        }
                        object3 = object2 = defaultSampler;
                    }
                    if ((object = image) != null && (object = ((GltfImage)object).getMimeType()) != null) {
                        Object v16;
                        block26: {
                            Object mime = object;
                            boolean bl = false;
                            Iterable $this$firstOrNull$iv = (Iterable)Texture.TextureType.getEntries();
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                Texture.TextureType it = (Texture.TextureType)((Object)element$iv);
                                boolean bl4 = false;
                                if (!Intrinsics.areEqual((Object)mime, (Object)it.getMimeType())) continue;
                                v16 = element$iv;
                                break block26;
                            }
                            v16 = null;
                        }
                        textureType = v16;
                    } else {
                        textureType = null;
                    }
                    Texture.TextureType textureType2 = textureType;
                    collection.add(new Texture(string, (BufferView)bufferView, textureType2, (Texture.Sampler)object2));
                }
                list2 = (List)destination$iv$iv;
                gltfLoader = gltfLoader2;
                break block32;
            }
            list2 = CollectionsKt.emptyList();
        }
        gltfLoader.textures = list2;
    }

    /*
     * WARNING - void declaration
     */
    private final void loadMaterials() {
        List list2;
        GltfLoader gltfLoader = this;
        Gltf gltf = this.gltf;
        if (gltf == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gltf");
            gltf = null;
        }
        List<GltfMaterial> list3 = gltf.getMaterials();
        if (list3 != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list3;
            GltfLoader gltfLoader2 = gltfLoader;
            boolean $i$f$map = false;
            void var3_4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                GltfMaterial gltfMaterial = (GltfMaterial)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                GltfMaterial.Extension.Unlit unlit = it.getExtensions().getUnlit();
                collection.add(unlit != null ? (Material)new Material.Unlit(it.getName(), it.getPbrMetallicRoughness().getBaseColorFactor(), GltfLoader.loadMaterials$loadTextureInfo(this, it.getPbrMetallicRoughness().getBaseColorTexture()), it.getAlphaMode(), it.getAlphaCutoff(), it.getDoubleSided()) : (Material)new Material.Pbr(it.getName(), it.getPbrMetallicRoughness().getBaseColorFactor(), GltfLoader.loadMaterials$loadTextureInfo(this, it.getPbrMetallicRoughness().getBaseColorTexture()), it.getPbrMetallicRoughness().getMetallicFactor(), 0.0f, GltfLoader.loadMaterials$loadTextureInfo(this, it.getPbrMetallicRoughness().getMetallicRoughnessTexture()), null, null, null, null, it.getAlphaMode(), it.getAlphaCutoff(), it.getDoubleSided(), 976, null));
            }
            list2 = (List)destination$iv$iv;
            gltfLoader = gltfLoader2;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        gltfLoader.materials = list2;
    }

    /*
     * WARNING - void declaration
     */
    private final void loadMeshes() {
        List list2;
        GltfLoader gltfLoader = this;
        Gltf gltf = this.gltf;
        if (gltf == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gltf");
            gltf = null;
        }
        List<GltfMesh> list3 = gltf.getMeshes();
        if (list3 != null) {
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            Iterable iterable = list3;
            GltfLoader gltfLoader2 = gltfLoader;
            boolean $i$f$mapIndexed = false;
            void var3_4 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void index;
                void mesh;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                GltfMesh gltfMesh = (GltfMesh)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                UUID uUID = this.uuid;
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"uuid");
                Iterable iterable2 = mesh.getPrimitives();
                MeshId meshId = new MeshId(uUID, (int)index);
                boolean $i$f$map = false;
                void var16_17 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                    void primitive;
                    GltfPrimitive gltfPrimitive = (GltfPrimitive)item$iv$iv2;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    collection2.add(GltfLoader.loadMeshes$loadPrimitive(this, (GltfPrimitive)primitive));
                }
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n3 = 4;
                List<Float> list4 = mesh.getWeights();
                Mesh.FirstPersonFlag firstPersonFlag = null;
                List list5 = (List)destination$iv$iv2;
                MeshId meshId2 = meshId;
                collection.add(new Mesh(meshId2, list5, firstPersonFlag, list4, n3, defaultConstructorMarker));
            }
            list2 = (List)destination$iv$iv;
            gltfLoader = gltfLoader2;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        gltfLoader.meshes = list2;
    }

    /*
     * Unable to fully structure code
     */
    private final void loadSkins() {
        block27: {
            block26: {
                $this$loadSkins_u24lambda_u2424 = this;
                $i$a$-run-GltfLoader$loadSkins$boneMapping$1 = false;
                v0 = $this$loadSkins_u24lambda_u2424.gltf;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"gltf");
                    v0 = null;
                }
                v1 = (v2 = v0.getExtensions()) != null && (v2 = v2.getVrmV0()) != null && (v2 = v2.getHumanoid()) != null ? v2.getHumanBones() : (vrmV0 = null);
                if (vrmV0 != null) {
                    var5_6 = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)vrmV0), (Function1)loadSkins.boneMapping.1.1.INSTANCE);
                    $i$f$associate = false;
                    var7_10 = $this$associate$iv;
                    destination$iv$iv = new LinkedHashMap<K, V>();
                    $i$f$associateTo = false;
                    for (Object element$iv$iv : $this$associateTo$iv$iv) {
                        var12_21 = destination$iv$iv;
                        it = (Pair)element$iv$iv;
                        $i$a$-associate-GltfLoader$loadSkins$boneMapping$1$2 = false;
                        var12_21.put(it.getFirst(), it.getSecond());
                    }
                    v3 = destination$iv$iv;
                } else {
                    v4 = $this$loadSkins_u24lambda_u2424.gltf;
                    if (v4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"gltf");
                        v4 = null;
                    }
                    v5 = (v6 = v4.getExtensions()) != null && (v6 = v6.getVrmV1()) != null && (v6 = v6.getHumanoid()) != null ? v6.getHumanBones() : (vrmV1 = null);
                    if (vrmV1 != null) {
                        $i$f$associate = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)vrmV1.entrySet()), (Function1)loadSkins.boneMapping.1.3.INSTANCE);
                        $i$f$associate = false;
                        destination$iv$iv = $this$associate$iv;
                        destination$iv$iv = new LinkedHashMap<K, V>();
                        $i$f$associateTo = false;
                        for (E element$iv$iv : $this$associateTo$iv$iv) {
                            it = destination$iv$iv;
                            $i$a$-associate-GltfLoader$loadSkins$boneMapping$1$2 = (Pair)element$iv$iv;
                            $i$a$-associate-GltfLoader$loadSkins$boneMapping$1$4 = false;
                            tag = (HumanoidTag)$i$a$-associate-GltfLoader$loadSkins$boneMapping$1$2.component1();
                            index = ((Number)$i$a$-associate-GltfLoader$loadSkins$boneMapping$1$2.component2()).intValue();
                            $i$a$-associate-GltfLoader$loadSkins$boneMapping$1$2 = new Pair((Object)index, (Object)tag);
                            it.put($i$a$-associate-GltfLoader$loadSkins$boneMapping$1$2.getFirst(), $i$a$-associate-GltfLoader$loadSkins$boneMapping$1$2.getSecond());
                        }
                        v3 = destination$iv$iv;
                    } else {
                        v3 = null;
                    }
                }
                boneMapping = v3;
                v7 = this;
                v8 = this.gltf;
                if (v8 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"gltf");
                    v8 = null;
                }
                v9 = v8.getSkins();
                if (v9 == null) break block26;
                $i$a$-run-GltfLoader$loadSkins$boneMapping$1 = v9;
                var34_43 = v7;
                $i$f$map = false;
                vrmV1 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    $i$f$associateTo = (GltfSkin)item$iv$iv;
                    var35_65 = destination$iv$iv;
                    $i$a$-map-GltfLoader$loadSkins$1 = false;
                    if (skin.getJoints().isEmpty()) {
                        throw new GltfLoadException("Bad skin: no joints");
                    }
                    $this$loadSkins_u24lambda_u2432_u24lambda_u2428 = this;
                    $i$a$-run-GltfLoader$loadSkins$1$inverseBindMatrices$1 = false;
                    v10 = skin.getInverseBindMatrices();
                    if (v10 == null) ** GOTO lbl-1000
                    it = ((Number)v10).intValue();
                    $i$a$-let-GltfLoader$loadSkins$1$inverseBindMatrices$1$accessor$1 = false;
                    v11 = $this$loadSkins_u24lambda_u2432_u24lambda_u2428.accessors;
                    if (v11 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"accessors");
                        v11 = null;
                    }
                    v12 = (Accessor)CollectionsKt.getOrNull(v11, (int)it);
                    if (v12 == null) {
                        throw new GltfLoadException("Bad skin: no accessor at index " + it);
                    }
                    v10 = v12;
                    if (v12 == null) lbl-1000:
                    // 2 sources

                    {
                        v13 = null;
                    } else {
                        accessor = v10;
                        if (accessor.getComponentType() != Accessor.ComponentType.FLOAT) {
                            throw new GltfLoadException("Bad component type in skin's inverseBindMatrices: " + accessor.getComponentType() + ", should be FLOAT");
                        }
                        if (accessor.getType() != Accessor.AccessorType.MAT4) {
                            throw new GltfLoadException("Bad type in skin's inverseBindMatrices: " + accessor.getType() + ", should be MAT4");
                        }
                        if (accessor.getCount() != skin.getJoints().size()) {
                            throw new GltfLoadException("Bad size of inverseBindMatrices: get " + accessor.getCount() + ", should be " + skin.getJoints().size());
                        }
                        index = CollectionsKt.createListBuilder((int)accessor.getCount());
                        $this$loadSkins_u24lambda_u2432_u24lambda_u2428_u24lambda_u2427 = index;
                        $i$a$-buildList-GltfLoader$loadSkins$1$inverseBindMatrices$1$1 = false;
                        this_$iv = accessor;
                        $i$f$read = false;
                        bufferView$iv = this_$iv.getBufferView();
                        elementLength$iv = this_$iv.getComponentType().getByteLength() * this_$iv.getType().getComponents();
                        if (bufferView$iv == null) {
                            buffer$iv = ByteBuffer.allocate(elementLength$iv);
                            var23_53 = this_$iv.getCount();
                            var24_54 = 0;
                            while (var24_54 < var23_53) {
                                it$iv = var24_54++;
                                $i$a$-repeat-Accessor$read$1$iv = false;
                                Intrinsics.checkNotNull((Object)buffer$iv);
                                buffer = buffer$iv;
                                $i$a$-read-GltfLoader$loadSkins$1$inverseBindMatrices$1$1$1 = false;
                                v14 = new Matrix4f().set(buffer);
                                Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"set(...)");
                                $this$loadSkins_u24lambda_u2432_u24lambda_u2428_u24lambda_u2427.add(v14);
                            }
                        } else {
                            buffer$iv = bufferView$iv.getBuffer().getBuffer().slice(this_$iv.getByteOffset() + bufferView$iv.getByteOffset(), this_$iv.getTotalByteLength());
                            buffer$iv.order(ByteOrder.LITTLE_ENDIAN);
                            var25_56 = bufferView$iv.getByteStride();
                            it$iv = ((Number)var25_56).intValue();
                            $i$a$-takeIf-Accessor$read$stride$1$iv = false;
                            v15 = it$iv > 0 != false ? var25_56 : null;
                            stride$iv = v15 != null ? v15 : elementLength$iv;
                            var24_54 = this_$iv.getCount();
                            var25_55 = 0;
                            while (var25_55 < var24_54) {
                                elementIndex$iv = var25_55++;
                                $i$a$-repeat-Accessor$read$2$iv = false;
                                newPosition$iv = elementIndex$iv * stride$iv;
                                buffer$iv.position(newPosition$iv);
                                buffer$iv.limit(newPosition$iv + elementLength$iv);
                                Intrinsics.checkNotNull((Object)buffer$iv);
                                buffer = buffer$iv;
                                $i$a$-read-GltfLoader$loadSkins$1$inverseBindMatrices$1$1$1 = false;
                                v16 = new Matrix4f().set(buffer);
                                Intrinsics.checkNotNullExpressionValue((Object)v16, (String)"set(...)");
                                $this$loadSkins_u24lambda_u2432_u24lambda_u2428_u24lambda_u2427.add(v16);
                                buffer$iv.limit(buffer$iv.capacity());
                            }
                        }
                        v13 = CollectionsKt.build((List)index);
                    }
                    inverseBindMatrices = v13;
                    var32_63 = skin.getName();
                    $this$map$iv = skin.getJoints();
                    $i$f$map = false;
                    this_$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        bufferView$iv = ((Number)item$iv$iv).intValue();
                        var33_64 = destination$iv$iv;
                        $i$a$-map-GltfLoader$loadSkins$1$1 = false;
                        v17 = this.uuid;
                        Intrinsics.checkNotNullExpressionValue((Object)v17, (String)"uuid");
                        var33_64.add(new NodeId(v17, (int)it));
                    }
                    var12_21 = (List)destination$iv$iv;
                    v18 = skin.getSkeleton();
                    if (v18 != null) {
                        it = ((Number)v18).intValue();
                        $i$a$-let-GltfLoader$loadSkins$1$2 = false;
                        v19 = this.uuid;
                        Intrinsics.checkNotNullExpressionValue((Object)v19, (String)"uuid");
                        v20 = new NodeId(v19, it);
                    } else {
                        v20 = null;
                    }
                    var13_22 = v20;
                    $this$map$iv = skin.getJoints();
                    $i$f$map = false;
                    $i$a$-let-GltfLoader$loadSkins$1$2 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        buffer$iv = ((Number)item$iv$iv).intValue();
                        var33_64 = destination$iv$iv;
                        $i$a$-map-GltfLoader$loadSkins$1$3 = false;
                        v21 = boneMapping;
                        var33_64.add(v21 != null ? (HumanoidTag)v21.get((int)it) : null);
                    }
                    var14_28 = (List)destination$iv$iv;
                    var35_65.add(new Skin(var32_63, (List<NodeId>)var12_21, inverseBindMatrices, var13_22, var14_28));
                }
                v22 = (List)destination$iv$iv;
                v7 = var34_43;
                break block27;
            }
            v22 = CollectionsKt.emptyList();
        }
        v7.skins = v22;
    }

    /*
     * WARNING - void declaration
     */
    private final Node loadNode(int index) {
        Object object;
        void $this$getOrPut$iv;
        Map<Integer, Node> map2 = this.nodes;
        Integer key$iv = index;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            Skin skin;
            Mesh mesh;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            NodeTransform nodeTransform;
            Object object2;
            boolean bl = false;
            Gltf gltf = this.gltf;
            if (gltf == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"gltf");
                gltf = null;
            }
            if ((object2 = gltf.getNodes()) == null || (object2 = (GltfNode)CollectionsKt.getOrNull(object2, (int)index)) == null) {
                throw new GltfLoadException("No node at index " + index);
            }
            Object node = object2;
            if (((GltfNode)node).getMatrix() != null) {
                nodeTransform = new NodeTransform.Matrix(((GltfNode)node).getMatrix());
            } else if (((GltfNode)node).getTranslation() != null || ((GltfNode)node).getRotation() != null || ((GltfNode)node).getScale() != null) {
                Vector3f vector3f;
                Quaternionf quaternionf;
                Vector3f vector3f2 = ((GltfNode)node).getTranslation();
                if (vector3f2 == null) {
                    vector3f2 = new Vector3f();
                }
                if ((quaternionf = ((GltfNode)node).getRotation()) == null) {
                    quaternionf = new Quaternionf();
                }
                if ((vector3f = ((GltfNode)node).getScale()) == null) {
                    vector3f = new Vector3f(1.0f);
                }
                nodeTransform = new NodeTransform.Decomposed(vector3f2, quaternionf, vector3f);
            } else {
                nodeTransform = null;
            }
            NodeTransform transform = nodeTransform;
            String string = ((GltfNode)node).getName();
            UUID uUID = this.uuid;
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"uuid");
            NodeId nodeId = new NodeId(uUID, index);
            List list2 = ((GltfNode)node).getChildren();
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            Iterable iterable = list2;
            boolean $i$f$map = false;
            void var13_14 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                int n = ((Number)item$iv$iv).intValue();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(this.loadNode((int)p0));
            }
            List list3 = (List)destination$iv$iv;
            Integer n = ((GltfNode)node).getMesh();
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl3 = false;
                List<Mesh> list4 = this.meshes;
                if (list4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"meshes");
                    list4 = null;
                }
                if ((mesh = (Mesh)CollectionsKt.getOrNull(list4, (int)it)) == null) {
                    throw new GltfLoadException("Bad node: unknown mesh " + it);
                }
            } else {
                mesh = null;
            }
            iterable = mesh;
            Integer n2 = ((GltfNode)node).getSkin();
            if (n2 != null) {
                int it = ((Number)n2).intValue();
                boolean bl4 = false;
                List<Skin> list5 = this.skins;
                if (list5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"skins");
                    list5 = null;
                }
                if ((skin = (Skin)CollectionsKt.getOrNull(list5, (int)it)) == null) {
                    throw new GltfLoadException("Bad node: unknown skin " + it);
                }
            } else {
                skin = null;
            }
            Skin skin2 = skin;
            Node answer$iv = new Node(string, nodeId, list3, transform, (Mesh)((Object)iterable), skin2);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Node)object;
    }

    /*
     * WARNING - void declaration
     */
    private final void loadScenes() {
        List list2;
        GltfLoader gltfLoader = this;
        Gltf gltf = this.gltf;
        if (gltf == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gltf");
            gltf = null;
        }
        List<GltfScene> list3 = gltf.getScenes();
        if (list3 != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list3;
            GltfLoader gltfLoader2 = gltfLoader;
            boolean $i$f$map = false;
            void var3_4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                List list4;
                void it;
                GltfScene gltfScene = (GltfScene)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                List<Integer> list5 = it.getNodes();
                if (list5 != null) {
                    void $this$mapTo$iv$iv2;
                    Iterable $this$map$iv2 = list5;
                    boolean $i$f$map2 = false;
                    Iterable iterable2 = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                        void p0;
                        int n = ((Number)item$iv$iv2).intValue();
                        Collection collection2 = destination$iv$iv2;
                        boolean bl2 = false;
                        collection2.add(this.loadNode((int)p0));
                    }
                    list4 = (List)destination$iv$iv2;
                } else {
                    list4 = CollectionsKt.emptyList();
                }
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n = 2;
                NodeTransform nodeTransform = null;
                List list6 = list4;
                collection.add(new Scene(list6, nodeTransform, n, defaultConstructorMarker));
            }
            list2 = (List)destination$iv$iv;
            gltfLoader = gltfLoader2;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        gltfLoader.scenes = list2;
    }

    /*
     * WARNING - void declaration
     */
    private final void loadAnimations() {
        List list2;
        GltfLoader gltfLoader = this;
        Gltf gltf = this.gltf;
        if (gltf == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gltf");
            gltf = null;
        }
        List<GltfAnimation> list3 = gltf.getAnimations();
        if (list3 != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list3;
            GltfLoader gltfLoader2 = gltfLoader;
            boolean $i$f$map = false;
            void var3_4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                void animation;
                GltfAnimation gltfAnimation = (GltfAnimation)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Iterable iterable2 = animation.getChannels();
                String string = animation.getName();
                boolean $i$f$mapNotNull = false;
                void var13_14 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    SimpleAnimationChannel<Vector3f> simpleAnimationChannel;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl2 = false;
                    GltfAnimationChannel channel = (GltfAnimationChannel)element$iv$iv;
                    boolean bl3 = false;
                    Integer n = channel.getTarget().getNode();
                    if (n == null) {
                        simpleAnimationChannel = null;
                    } else {
                        Accessor outputAccessor;
                        GltfAnimationSampler sampler;
                        HumanoidTag targetHumanoidTag;
                        Node targetNode;
                        int targetNodeId = n;
                        if (this.nodes.get(targetNodeId) == null) {
                            throw new GltfLoadException("Bad animation channel: target node " + targetNodeId + " not found");
                        }
                        String targetNodeName = targetNode.getName();
                        if (targetNode.getName() != null) {
                            String it;
                            boolean bl4 = false;
                            v5 = HumanoidTag.Companion.fromVrmName(it);
                        } else {
                            v5 = targetHumanoidTag = null;
                        }
                        if ((GltfAnimationSampler)CollectionsKt.getOrNull(animation.getSamplers(), (int)channel.getSampler()) == null) {
                            throw new GltfLoadException("Bad animation channel: unknown sampler " + channel.getSampler());
                        }
                        List<Accessor> list4 = this.accessors;
                        if (list4 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"accessors");
                            list4 = null;
                        }
                        if ((Accessor)CollectionsKt.getOrNull(list4, (int)sampler.getInput()) == null) {
                            throw new GltfLoadException("Bad animation sampler: unknown input accessor " + sampler.getInput());
                        }
                        List<Accessor> list5 = this.accessors;
                        if (list5 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"accessors");
                            list5 = null;
                        }
                        if ((Accessor)CollectionsKt.getOrNull(list5, (int)sampler.getOutput()) == null) {
                            throw new GltfLoadException("Bad animation sampler: unknown output accessor " + sampler.getOutput());
                        }
                        channel.getTarget().getPath().check(outputAccessor);
                        switch (WhenMappings.$EnumSwitchMapping$1[channel.getTarget().getPath().ordinal()]) {
                            case 1: {
                                Accessor inputAccessor;
                                simpleAnimationChannel = AnimationChannelKt.Vector3fSimpleAnimationChannel(AnimationChannel.Type.Translation.INSTANCE, targetNode, targetNodeName, targetHumanoidTag, new AccessorAnimationKeyFrameIndexer(inputAccessor), new AccessorAnimationKeyFrameData(outputAccessor, sampler.getInterpolation().getElements(), loadAnimations.1.1.1.INSTANCE), sampler.getInterpolation());
                                break;
                            }
                            case 2: {
                                Accessor inputAccessor;
                                simpleAnimationChannel = AnimationChannelKt.Vector3fSimpleAnimationChannel(AnimationChannel.Type.Scale.INSTANCE, targetNode, targetNodeName, targetHumanoidTag, new AccessorAnimationKeyFrameIndexer(inputAccessor), new AccessorAnimationKeyFrameData(outputAccessor, sampler.getInterpolation().getElements(), loadAnimations.1.1.2.INSTANCE), sampler.getInterpolation());
                                break;
                            }
                            case 3: {
                                Accessor inputAccessor;
                                AnimationChannel.Type type2 = AnimationChannel.Type.Rotation.INSTANCE;
                                AnimationKeyFrameIndexer animationKeyFrameIndexer = new AccessorAnimationKeyFrameIndexer(inputAccessor);
                                int n2 = sampler.getInterpolation().getElements();
                                simpleAnimationChannel = AnimationChannelKt.QuaternionfSimpleAnimationChannel(type2, targetNode, targetNodeName, targetHumanoidTag, animationKeyFrameIndexer, new AccessorAnimationKeyFrameData(outputAccessor, n2, switch (WhenMappings.$EnumSwitchMapping$0[outputAccessor.getComponentType().ordinal()]) {
                                    case 1 -> loadAnimations.1.1.3.INSTANCE;
                                    case 2 -> loadAnimations.1.1.4.INSTANCE;
                                    case 3 -> loadAnimations.1.1.5.INSTANCE;
                                    case 4 -> loadAnimations.1.1.6.INSTANCE;
                                    case 5 -> loadAnimations.1.1.7.INSTANCE;
                                    default -> throw new AssertionError();
                                }), sampler.getInterpolation());
                                break;
                            }
                            default: {
                                simpleAnimationChannel = null;
                                break;
                            }
                        }
                    }
                    if (simpleAnimationChannel == null) continue;
                    SimpleAnimationChannel<Vector3f> it$iv$iv = simpleAnimationChannel;
                    boolean bl5 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                List list6 = (List)destination$iv$iv2;
                String string2 = string;
                collection.add(new Animation(string2, list6));
            }
            list2 = (List)destination$iv$iv;
            gltfLoader = gltfLoader2;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        gltfLoader.animations = list2;
    }

    /*
     * Unable to fully structure code
     */
    private final void loadExpressions() {
        block70: {
            v0 = this.gltf;
            if (v0 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"gltf");
                v0 = null;
            }
            v1 = (v2 = v0.getExtensions()) != null && (v2 = v2.getVrmV0()) != null && (v2 = v2.getBlendShapeMaster()) != null ? v2.getBlendShapeGroups() : (vrmV0 = null);
            if (vrmV0 == null) break block70;
            var2_2 = vrmV0;
            var37_4 = this;
            $i$f$mapNotNull = false;
            var4_6 = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            var9_11 = $this$forEach$iv$iv$iv.iterator();
            while (var9_11.hasNext()) {
                block72: {
                    element$iv$iv = element$iv$iv$iv = var9_11.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    expression = (VrmV0Extension.BlendShapeMaster.Group)element$iv$iv;
                    $i$a$-mapNotNull-GltfLoader$loadExpressions$1 = false;
                    v3 = expression.getName();
                    if (expression.getPresetName() != null) {
                        if (((CharSequence)var15_17).length() > 0) {
                            var16_18 = var15_17.charAt(0);
                            var17_21 = new StringBuilder();
                            var18_22 = v3;
                            $i$a$-replaceFirstCharWithCharSequence-GltfLoader$loadExpressions$1$1 = 0;
                            v4 = String.valueOf((char)p0);
                            Intrinsics.checkNotNull((Object)v4, (String)"null cannot be cast to non-null type java.lang.String");
                            Intrinsics.checkNotNullExpressionValue((Object)v4.toUpperCase(Locale.ROOT), (String)"toUpperCase(...)");
                            v3 = var18_22;
                            v5 = var17_21.append((Object)var20_25);
                            p0 = var15_17;
                            $i$a$-replaceFirstCharWithCharSequence-GltfLoader$loadExpressions$1$1 = 1;
                            v6 = p0.substring($i$a$-replaceFirstCharWithCharSequence-GltfLoader$loadExpressions$1$1);
                            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"substring(...)");
                            v7 = v5.append(v6).toString();
                        } else {
                            v7 = var15_17;
                        }
                    } else {
                        v7 = var21_27 = null;
                    }
                    if (var21_27 == null) ** GOTO lbl-1000
                    tmp = -1;
                    switch (var21_27.hashCode()) {
                        case -785992281: {
                            if (var21_27.equals("Neutral")) {
                                tmp = 1;
                            }
                            break;
                        }
                        case 65: {
                            if (var21_27.equals("A")) {
                                tmp = 2;
                            }
                            break;
                        }
                        case 69: {
                            if (var21_27.equals("E")) {
                                tmp = 3;
                            }
                            break;
                        }
                        case 63408513: {
                            if (var21_27.equals("Angry")) {
                                tmp = 4;
                            }
                            break;
                        }
                        case 64274236: {
                            if (var21_27.equals("Blink")) {
                                tmp = 5;
                            }
                            break;
                        }
                        case 1638001673: {
                            if (var21_27.equals("Blink_L")) {
                                tmp = 6;
                            }
                            break;
                        }
                        case 73: {
                            if (var21_27.equals("I")) {
                                tmp = 7;
                            }
                            break;
                        }
                        case 1638001679: {
                            if (var21_27.equals("Blink_R")) {
                                tmp = 8;
                            }
                            break;
                        }
                        case 79: {
                            if (var21_27.equals("O")) {
                                tmp = 9;
                            }
                            break;
                        }
                        case -1173195107: {
                            if (var21_27.equals("LookRight")) {
                                tmp = 10;
                            }
                            break;
                        }
                        case 85: {
                            if (var21_27.equals("U")) {
                                tmp = 11;
                            }
                            break;
                        }
                        case 74676: {
                            if (var21_27.equals("Joy")) {
                                tmp = 12;
                            }
                            break;
                        }
                        case -1812727644: {
                            if (var21_27.equals("Sorrow")) {
                                tmp = 13;
                            }
                            break;
                        }
                        case -1977690266: {
                            if (var21_27.equals("LookLeft")) {
                                tmp = 14;
                            }
                            break;
                        }
                        case -2013228614: {
                            if (var21_27.equals("LookUp")) {
                                tmp = 15;
                            }
                            break;
                        }
                        case -1977918463: {
                            if (var21_27.equals("LookDown")) {
                                tmp = 16;
                            }
                            break;
                        }
                        case 71007: {
                            if (var21_27.equals("Fun")) {
                                tmp = 17;
                            }
                            break;
                        }
                    }
                    switch (tmp) {
                        case 1: {
                            v8 = Expression.Tag.Neutral.INSTANCE;
                            break;
                        }
                        case 2: {
                            v8 = Expression.Tag.Lip.AA;
                            break;
                        }
                        case 3: {
                            v8 = Expression.Tag.Lip.EE;
                            break;
                        }
                        case 7: {
                            v8 = Expression.Tag.Lip.IH;
                            break;
                        }
                        case 9: {
                            v8 = Expression.Tag.Lip.OH;
                            break;
                        }
                        case 11: {
                            v8 = Expression.Tag.Lip.OU;
                            break;
                        }
                        case 5: {
                            v8 = Expression.Tag.Blink.BLINK;
                            break;
                        }
                        case 6: {
                            v8 = Expression.Tag.Blink.BLINK_LEFT;
                            break;
                        }
                        case 8: {
                            v8 = Expression.Tag.Blink.BLINK_RIGHT;
                            break;
                        }
                        case 17: {
                            v8 = Expression.Tag.Emotion.RELAXED;
                            break;
                        }
                        case 4: {
                            v8 = Expression.Tag.Emotion.ANGRY;
                            break;
                        }
                        case 12: {
                            v8 = Expression.Tag.Emotion.HAPPY;
                            break;
                        }
                        case 13: {
                            v8 = Expression.Tag.Emotion.SAD;
                            break;
                        }
                        case 15: {
                            v8 = Expression.Tag.Gaze.LOOK_UP;
                            break;
                        }
                        case 16: {
                            v8 = Expression.Tag.Gaze.LOOK_DOWN;
                            break;
                        }
                        case 14: {
                            v8 = Expression.Tag.Gaze.LOOK_LEFT;
                            break;
                        }
                        case 10: {
                            v8 = Expression.Tag.Gaze.LOOK_RIGHT;
                            break;
                        }
                        default: lbl-1000:
                        // 2 sources

                        {
                            v9 = var22_28 = null;
                            break block72;
                        }
                    }
                    v10 = false;
                    v11 = expression.getBinds();
                    if (v11 != null) {
                        var15_17 = v11;
                        var20_26 = v10;
                        var17_21 = v8;
                        var18_22 = v3;
                        $i$f$map = false;
                        $i$a$-replaceFirstCharWithCharSequence-GltfLoader$loadExpressions$1$1 = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            var27_33 = (VrmV0Extension.BlendShapeMaster.Group.Bind)item$iv$iv;
                            var28_34 = destination$iv$iv;
                            $i$a$-map-GltfLoader$loadExpressions$1$2 = false;
                            v12 = this.uuid;
                            Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"uuid");
                            v13 = new MeshId(v12, bind.getMesh());
                            v14 = bind.getIndex();
                            v15 = bind.getWeight();
                            if (v15 != null) {
                                var30_36 = ((Number)v15).floatValue();
                                var31_37 = v14;
                                var32_38 = v13;
                                $i$a$-let-GltfLoader$loadExpressions$1$2$1 = false;
                                var34_40 = it / 100.0f;
                                v13 = var32_38;
                                v14 = var31_37;
                                v16 = var34_40;
                            } else {
                                v16 = 1.0f;
                            }
                            var38_43 = v16;
                            var39_44 = v14;
                            var40_45 = v13;
                            var28_34.add(new Expression.Binding.MeshMorphTarget(var40_45, var39_44, var38_43));
                        }
                        var28_34 = (List)destination$iv$iv;
                        v3 = var18_22;
                        v8 = var17_21;
                        v10 = var20_26;
                        v17 = var28_34;
                    } else {
                        v17 = CollectionsKt.emptyList();
                    }
                    var41_46 = null;
                    var42_47 = 4;
                    var43_48 = v17;
                    var44_49 = v10;
                    var45_50 = v8;
                    var46_51 = v3;
                    v9 = new Expression(var46_51, var45_50, var44_49, var43_48, var42_47, var41_46);
                }
                if (v9 == null) continue;
                it$iv$iv = v9;
                $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                destination$iv$iv.add(it$iv$iv);
            }
            var37_4.expressions = (List)destination$iv$iv;
            return;
        }
        v18 = this.gltf;
        if (v18 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gltf");
            v18 = null;
        }
        v19 = (v20 = v18.getExtensions()) != null && (v20 = v20.getVrmV1()) != null ? v20.getExpressions() : (vrmV1 = null);
        if (vrmV1 != null) {
            v21 = vrmV1.getPreset();
            if (v21 == null || (v21 = v21.entrySet()) == null || (v21 = CollectionsKt.asSequence((Iterable)((Iterable)v21))) == null) {
                v21 = SequencesKt.sequenceOf((Object[])new Map.Entry[0]);
            }
            if ((v22 = vrmV1.getCustom()) == null || (v22 = v22.entrySet()) == null || (v22 = CollectionsKt.asSequence((Iterable)((Iterable)v22))) == null) {
                v22 = SequencesKt.sequenceOf((Object[])new Map.Entry[0]);
            }
            this.expressions = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.plus((Sequence)v21, (Sequence)v22), (Function1)((Function1)new Function1<Map.Entry<? extends String, ? extends VrmV1Extension.Expression>, Expression>(this){
                final /* synthetic */ GltfLoader this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final Expression invoke(Map.Entry<String, VrmV1Extension.Expression> entry) {
                    List list2;
                    Expression.Tag tag;
                    String string;
                    Object object;
                    Intrinsics.checkNotNullParameter(entry, (String)"<destruct>");
                    String key = entry.getKey();
                    VrmV1Extension.Expression value = entry.getValue();
                    Boolean bl = value.isBinary();
                    boolean bl2 = bl != null ? bl : false;
                    String string2 = key;
                    if (((CharSequence)string2).length() > 0) {
                        void p0;
                        char c = string2.charAt(0);
                        object = new StringBuilder();
                        int n = 0;
                        String string3 = String.valueOf((char)p0);
                        Intrinsics.checkNotNull((Object)string3, (String)"null cannot be cast to non-null type java.lang.String");
                        String string4 = string3.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                        StringBuilder stringBuilder = ((StringBuilder)object).append((Object)string4);
                        String string5 = string2;
                        n = 1;
                        String string6 = string5.substring(n);
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                        string = stringBuilder.append(string6).toString();
                    } else {
                        string = string2;
                    }
                    switch (string) {
                        case "neutral": {
                            tag = Expression.Tag.Neutral.INSTANCE;
                            break;
                        }
                        case "aa": {
                            tag = Expression.Tag.Lip.AA;
                            break;
                        }
                        case "ee": {
                            tag = Expression.Tag.Lip.EE;
                            break;
                        }
                        case "ih": {
                            tag = Expression.Tag.Lip.IH;
                            break;
                        }
                        case "oh": {
                            tag = Expression.Tag.Lip.OH;
                            break;
                        }
                        case "ou": {
                            tag = Expression.Tag.Lip.OU;
                            break;
                        }
                        case "blink": {
                            tag = Expression.Tag.Blink.BLINK;
                            break;
                        }
                        case "blinkLeft": {
                            tag = Expression.Tag.Blink.BLINK_LEFT;
                            break;
                        }
                        case "blinkRight": {
                            tag = Expression.Tag.Blink.BLINK_RIGHT;
                            break;
                        }
                        case "relaxed": {
                            tag = Expression.Tag.Emotion.RELAXED;
                            break;
                        }
                        case "angry": {
                            tag = Expression.Tag.Emotion.ANGRY;
                            break;
                        }
                        case "happy": {
                            tag = Expression.Tag.Emotion.HAPPY;
                            break;
                        }
                        case "sad": {
                            tag = Expression.Tag.Emotion.SAD;
                            break;
                        }
                        case "surprised": {
                            tag = Expression.Tag.Emotion.SURPRISED;
                            break;
                        }
                        case "lookUp": {
                            tag = Expression.Tag.Gaze.LOOK_UP;
                            break;
                        }
                        case "lookDown": {
                            tag = Expression.Tag.Gaze.LOOK_DOWN;
                            break;
                        }
                        case "lookLeft": {
                            tag = Expression.Tag.Gaze.LOOK_LEFT;
                            break;
                        }
                        case "lookRight": {
                            tag = Expression.Tag.Gaze.LOOK_RIGHT;
                            break;
                        }
                        default: {
                            return null;
                        }
                    }
                    Expression.Tag tag2 = tag;
                    List<VrmV1Extension.Expression.MorphTargetBind> list3 = value.getMorphTargetBinds();
                    if (list3 != null) {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Iterable n = list3;
                        GltfLoader gltfLoader = this.this$0;
                        boolean $i$f$map = false;
                        void var12_15 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            float f;
                            void bind;
                            VrmV1Extension.Expression.MorphTargetBind morphTargetBind = (VrmV1Extension.Expression.MorphTargetBind)item$iv$iv;
                            object = destination$iv$iv;
                            boolean bl3 = false;
                            UUID uUID = GltfLoader.access$getUuid$p(gltfLoader);
                            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"access$getUuid$p(...)");
                            NodeId nodeId = new NodeId(uUID, bind.getNode());
                            int n2 = bind.getIndex();
                            Float f2 = bind.getWeight();
                            if (f2 != null) {
                                void it;
                                float f3 = ((Number)f2).floatValue();
                                int n3 = n2;
                                NodeId nodeId2 = nodeId;
                                boolean bl4 = false;
                                void var23_26 = it / 100.0f;
                                nodeId = nodeId2;
                                n2 = n3;
                                f = var23_26;
                            } else {
                                f = 1.0f;
                            }
                            float f4 = f;
                            int n4 = n2;
                            NodeId nodeId3 = nodeId;
                            object.add(new Expression.Binding.NodeMorphTarget(nodeId3, n4, f4));
                        }
                        list2 = (List)destination$iv$iv;
                    } else {
                        list2 = CollectionsKt.emptyList();
                    }
                    Object object2 = list2;
                    return new Expression(key, tag2, bl2, (List<? extends Expression.Binding>)object2);
                }
            })));
            return;
        }
        this.expressions = CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ModelFileLoader.Result load(@NotNull String json) {
        List<Expression> list2;
        List<Skin> list3;
        Scene scene;
        Gltf gltf;
        List<Scene> list4;
        Object metadata2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        if (this.loaded) {
            throw new GltfLoadException("Already loaded. Please don't load again.");
        }
        this.loaded = true;
        Json this_$iv = format;
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        this.gltf = (Gltf)this_$iv.decodeFromString((DeserializationStrategy)Gltf.Companion.serializer(), json);
        this.loadBuffers();
        this.loadBufferViews();
        this.loadAccessors();
        this.loadSamplers();
        this.loadTextures();
        this.loadMaterials();
        this.loadMeshes();
        this.loadSkins();
        this.loadScenes();
        this.loadAnimations();
        this.loadExpressions();
        Gltf gltf2 = this.gltf;
        if (gltf2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gltf");
            gltf2 = null;
        }
        if ((object = gltf2.getExtensions()) == null || (object = ((GltfExtension)object).getVrmV0()) == null || (object = ((VrmV0Extension)object).getMeta()) == null || (object = ((VrmV0Extension.Meta)object).toMetadata((Function1<? super Integer, Texture>)((Function1)new Function1<Integer, Texture>(this){
            final /* synthetic */ GltfLoader this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Texture invoke(int it) {
                List list2 = GltfLoader.access$getTextures$p(this.this$0);
                if (list2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"textures");
                    list2 = null;
                }
                return (Texture)CollectionsKt.getOrNull((List)list2, (int)it);
            }
        }))) == null) {
            Object object2;
            Gltf gltf3 = this.gltf;
            if (gltf3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"gltf");
                gltf3 = null;
            }
            object = metadata2 = (object2 = gltf3.getExtensions()) != null && (object2 = ((GltfExtension)object2).getVrmV1()) != null && (object2 = ((VrmV1Extension)object2).getMeta()) != null ? ((VrmV1Extension.Meta)object2).toMetadata((Function1<? super Integer, Texture>)((Function1)new Function1<Integer, Texture>(this){
                final /* synthetic */ GltfLoader this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final Texture invoke(int it) {
                    List list2 = GltfLoader.access$getTextures$p(this.this$0);
                    if (list2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"textures");
                        list2 = null;
                    }
                    return (Texture)CollectionsKt.getOrNull((List)list2, (int)it);
                }
            })) : null;
        }
        if ((list4 = this.scenes) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scenes");
            list4 = null;
        }
        if ((gltf = this.gltf) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gltf");
            gltf = null;
        }
        Integer n = gltf.getScene();
        if (n != null) {
            void it;
            int n2 = ((Number)n).intValue();
            List<Scene> list5 = list4;
            boolean bl = false;
            List<Scene> list6 = this.scenes;
            if (list6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"scenes");
                list6 = null;
            }
            Scene scene2 = (Scene)CollectionsKt.getOrNull(list6, (int)it);
            if (scene2 == null) {
                Gltf gltf4 = this.gltf;
                if (gltf4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"gltf");
                    gltf4 = null;
                }
                throw new GltfLoadException("Bad model: unknown scene index " + gltf4.getScene());
            }
            scene = scene2;
            list4 = list5;
        } else {
            scene = null;
        }
        if ((list3 = this.skins) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"skins");
            list3 = null;
        }
        if ((list2 = this.expressions) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"expressions");
            list2 = null;
        }
        List<Expression> list7 = list2;
        List<Skin> list8 = list3;
        Scene scene3 = scene;
        List<Scene> list9 = list4;
        Model model = new Model(list9, scene3, list8, list7);
        List<Animation> list10 = this.animations;
        if (list10 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"animations");
            list10 = null;
        }
        return new ModelFileLoader.Result((Metadata)metadata2, model, list10);
    }

    private static final Material.TextureInfo loadMaterials$loadTextureInfo(GltfLoader this$0, GltfTextureInfo info) {
        Material.TextureInfo textureInfo;
        GltfTextureInfo gltfTextureInfo = info;
        if (gltfTextureInfo != null) {
            GltfTextureInfo it = gltfTextureInfo;
            boolean bl = false;
            List<Texture> list2 = this$0.textures;
            if (list2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"textures");
                list2 = null;
            }
            Texture texture = (Texture)CollectionsKt.getOrNull(list2, (int)info.getIndex());
            if (texture == null) {
                throw new GltfLoadException("Bad texture info: texture " + info.getIndex() + " not found");
            }
            textureInfo = new Material.TextureInfo(texture, info.getTexCoord());
        } else {
            textureInfo = null;
        }
        return textureInfo;
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> List<T> loadMeshes$loadAttributes$loadAttributeMap(Map<Integer, ? extends T> map2) {
        List list2;
        if (map2.isEmpty()) {
            list2 = CollectionsKt.emptyList();
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)new IntRange(0, ((Number)((Object)CollectionsKt.maxOrThrow((Iterable)map2.keySet()))).intValue());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                T t = map2.get((int)it);
                if (t == null) {
                    throw new GltfLoadException("Bad attribute map: missing index " + (int)it);
                }
                collection.add(t);
            }
            list2 = (List)destination$iv$iv;
        }
        return list2;
    }

    private static final Primitive.Attributes loadMeshes$loadAttributes(GltfLoader this$0, Map<GltfAttributeKey, Integer> attributes, boolean morph) {
        Accessor position = null;
        Accessor normal = null;
        Accessor tangent = null;
        Map texcoords = new LinkedHashMap();
        Map colors = new LinkedHashMap();
        Map joints = new LinkedHashMap();
        Map weights = new LinkedHashMap();
        for (Map.Entry<GltfAttributeKey, Integer> entry : attributes.entrySet()) {
            Accessor accessor;
            GltfAttributeKey key = entry.getKey();
            int value = ((Number)entry.getValue()).intValue();
            List<Accessor> list2 = this$0.accessors;
            if (list2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"accessors");
                list2 = null;
            }
            if ((Accessor)CollectionsKt.getOrNull(list2, (int)value) == null) {
                throw new GltfLoadException("Bad attributes: unknown accessor index: " + value);
            }
            GltfAttributeKey gltfAttributeKey = key;
            if (Intrinsics.areEqual((Object)gltfAttributeKey, (Object)GltfAttributeKey.Normal.INSTANCE)) {
                normal = accessor;
                continue;
            }
            if (Intrinsics.areEqual((Object)gltfAttributeKey, (Object)GltfAttributeKey.Position.INSTANCE)) {
                position = accessor;
                continue;
            }
            if (Intrinsics.areEqual((Object)gltfAttributeKey, (Object)GltfAttributeKey.Tangent.INSTANCE)) {
                tangent = accessor;
                continue;
            }
            if (gltfAttributeKey instanceof GltfAttributeKey.Color) {
                colors.put(((GltfAttributeKey.Color)key).getIndex(), accessor);
                continue;
            }
            if (gltfAttributeKey instanceof GltfAttributeKey.TexCoord) {
                texcoords.put(((GltfAttributeKey.TexCoord)key).getIndex(), accessor);
                continue;
            }
            if (gltfAttributeKey instanceof GltfAttributeKey.Joints) {
                joints.put(((GltfAttributeKey.Joints)key).getIndex(), accessor);
                continue;
            }
            if (!(gltfAttributeKey instanceof GltfAttributeKey.Weights)) continue;
            weights.put(((GltfAttributeKey.Weights)key).getIndex(), accessor);
        }
        if (morph) {
            return new Primitive.Attributes.MorphTarget(position, normal, tangent, GltfLoader.loadMeshes$loadAttributes$loadAttributeMap(texcoords), GltfLoader.loadMeshes$loadAttributes$loadAttributeMap(colors), GltfLoader.loadMeshes$loadAttributes$loadAttributeMap(joints), GltfLoader.loadMeshes$loadAttributes$loadAttributeMap(weights));
        }
        if (!(position != null)) {
            boolean bl = false;
            String string = "No position attribute in primitive";
            throw new IllegalStateException(string.toString());
        }
        return new Primitive.Attributes.Primitive(position, normal, tangent, GltfLoader.loadMeshes$loadAttributes$loadAttributeMap(texcoords), GltfLoader.loadMeshes$loadAttributes$loadAttributeMap(colors), GltfLoader.loadMeshes$loadAttributes$loadAttributeMap(joints), GltfLoader.loadMeshes$loadAttributes$loadAttributeMap(weights));
    }

    /*
     * WARNING - void declaration
     */
    private static final Primitive loadMeshes$loadPrimitive(GltfLoader this$0, GltfPrimitive primitive) {
        List list2;
        Accessor accessor;
        Accessor accessor2;
        Object object;
        Primitive.Attributes.Primitive primitive2;
        Primitive.Mode mode;
        Object object2;
        Primitive.Mode mode2;
        block13: {
            block12: {
                void it;
                mode2 = primitive.getMode();
                object2 = primitive.getMaterial();
                if (object2 == null) break block12;
                int n = ((Number)object2).intValue();
                mode = mode2;
                boolean bl = false;
                List<? extends Material> list3 = this$0.materials;
                if (list3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"materials");
                    list3 = null;
                }
                Material material = (Material)CollectionsKt.getOrNull(list3, (int)it);
                if (material == null) {
                    throw new GltfLoadException("Bad primitive: unknown material " + (int)it);
                }
                mode2 = mode;
                object2 = material;
                if (material != null) break block13;
            }
            object2 = Material.Default.INSTANCE;
        }
        Primitive.Attributes attributes = GltfLoader.loadMeshes$loadAttributes(this$0, primitive.getAttributes(), false);
        Intrinsics.checkNotNull((Object)attributes, (String)"null cannot be cast to non-null type top.fifthlight.renderer.model.Primitive.Attributes.Primitive");
        Primitive.Attributes.Primitive primitive3 = (Primitive.Attributes.Primitive)attributes;
        Integer n = primitive.getIndices();
        if (n != null) {
            void indices;
            int n2 = ((Number)n).intValue();
            primitive2 = primitive3;
            object = object2;
            mode = mode2;
            boolean bl = false;
            List<Accessor> list4 = this$0.accessors;
            if (list4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"accessors");
                list4 = null;
            }
            Accessor accessor3 = (Accessor)CollectionsKt.getOrNull(list4, (int)indices);
            if (accessor3 == null) {
                throw new GltfLoadException("Bad primitive: unknown accessor index: " + (int)indices);
            }
            accessor2 = accessor3;
            mode2 = mode;
            object2 = object;
            primitive3 = primitive2;
            accessor = accessor2;
        } else {
            accessor = null;
        }
        List<Map<GltfAttributeKey, Integer>> list5 = primitive.getTargets();
        if (list5 != null) {
            Collection<Primitive.Attributes.MorphTarget> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable indices = list5;
            accessor2 = accessor;
            primitive2 = primitive3;
            object = object2;
            mode = mode2;
            boolean $i$f$map = false;
            void bl = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Map map2 = (Map)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                Primitive.Attributes attributes2 = GltfLoader.loadMeshes$loadAttributes(this$0, (Map<GltfAttributeKey, Integer>)it, true);
                Intrinsics.checkNotNull((Object)attributes2, (String)"null cannot be cast to non-null type top.fifthlight.renderer.model.Primitive.Attributes.MorphTarget");
                collection.add((Primitive.Attributes.MorphTarget)attributes2);
            }
            collection = (List)destination$iv$iv;
            mode2 = mode;
            object2 = object;
            primitive3 = primitive2;
            accessor = accessor2;
            list2 = collection;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        List list6 = list2;
        Accessor accessor4 = accessor;
        Primitive.Attributes.Primitive primitive4 = primitive3;
        Object object3 = object2;
        Primitive.Mode mode3 = mode2;
        return new Primitive(mode3, (Material)object3, primitive4, accessor4, list6);
    }

    public static final /* synthetic */ UUID access$getUuid$p(GltfLoader $this) {
        return $this.uuid;
    }

    public static final /* synthetic */ List access$getTextures$p(GltfLoader $this) {
        return $this.textures;
    }

    @kotlin.Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ltop/fifthlight/renderer/model/gltf/GltfLoader$Companion;", "", "<init>", "()V", "defaultSampler", "Ltop/fifthlight/renderer/model/Texture$Sampler;", "format", "Lkotlinx/serialization/json/Json;", "model_model-gltf-model-gltf"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @kotlin.Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Accessor.ComponentType.values().length];
            try {
                nArray[Accessor.ComponentType.BYTE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Accessor.ComponentType.UNSIGNED_BYTE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Accessor.ComponentType.SHORT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Accessor.ComponentType.UNSIGNED_SHORT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Accessor.ComponentType.FLOAT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[GltfAnimationTarget.Path.values().length];
            try {
                nArray[GltfAnimationTarget.Path.TRANSLATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GltfAnimationTarget.Path.SCALE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GltfAnimationTarget.Path.ROTATION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

