/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.renderer.model.pmd;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.UByte;
import kotlin.UShort;
import kotlin.Unit;
import kotlin.UnsignedKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import top.fifthlight.renderer.model.Accessor;
import top.fifthlight.renderer.model.Buffer;
import top.fifthlight.renderer.model.BufferView;
import top.fifthlight.renderer.model.HumanoidTag;
import top.fifthlight.renderer.model.Material;
import top.fifthlight.renderer.model.Mesh;
import top.fifthlight.renderer.model.MeshId;
import top.fifthlight.renderer.model.Metadata;
import top.fifthlight.renderer.model.Model;
import top.fifthlight.renderer.model.ModelFileLoader;
import top.fifthlight.renderer.model.Node;
import top.fifthlight.renderer.model.NodeId;
import top.fifthlight.renderer.model.NodeTransform;
import top.fifthlight.renderer.model.Primitive;
import top.fifthlight.renderer.model.RgbColor;
import top.fifthlight.renderer.model.RgbaColor;
import top.fifthlight.renderer.model.Scene;
import top.fifthlight.renderer.model.Skin;
import top.fifthlight.renderer.model.Texture;
import top.fifthlight.renderer.model.pmd.PmdLoadException;
import top.fifthlight.renderer.model.pmd.format.PmdBone;
import top.fifthlight.renderer.model.pmd.format.PmdHeader;
import top.fifthlight.renderer.model.pmd.format.PmdMaterial;
import top.fifthlight.renderer.model.util.ReadUtilKt;

@kotlin.Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001%B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u0018\u0010\u001a\u001a\n \u0018*\u0004\u0018\u00010\u001b0\u001bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Ltop/fifthlight/renderer/model/pmd/PmdLoader;", "Ltop/fifthlight/renderer/model/ModelFileLoader;", "<init>", "()V", "extensions", "", "", "getExtensions", "()Ljava/util/List;", "abilities", "Ltop/fifthlight/renderer/model/ModelFileLoader$Ability;", "getAbilities", "PMD_SIGNATURE", "", "probeLength", "", "getProbeLength", "()I", "probe", "", "buffer", "Ljava/nio/ByteBuffer;", "SHIFT_JIS", "Ljava/nio/charset/Charset;", "kotlin.jvm.PlatformType", "Ljava/nio/charset/Charset;", "decoder", "Ljava/nio/charset/CharsetDecoder;", "Ljava/nio/charset/CharsetDecoder;", "BASE_VERTEX_ATTRIBUTE_SIZE", "SKIN_VERTEX_ATTRIBUTE_SIZE", "VERTEX_ATTRIBUTE_SIZE", "load", "Ltop/fifthlight/renderer/model/ModelFileLoader$Result;", "path", "Ljava/nio/file/Path;", "basePath", "Context", "model_model-pmd-model-pmd"})
public final class PmdLoader
implements ModelFileLoader {
    @NotNull
    public static final PmdLoader INSTANCE = new PmdLoader();
    @NotNull
    private static final List<String> extensions = CollectionsKt.listOf((Object)"pmd");
    @NotNull
    private static final List<ModelFileLoader.Ability> abilities = CollectionsKt.listOf((Object)((Object)ModelFileLoader.Ability.MODEL));
    @NotNull
    private static final byte[] PMD_SIGNATURE;
    private static final int probeLength;
    private static final Charset SHIFT_JIS;
    private static final CharsetDecoder decoder;
    private static final int BASE_VERTEX_ATTRIBUTE_SIZE = 32;
    private static final int SKIN_VERTEX_ATTRIBUTE_SIZE = 32;
    private static final int VERTEX_ATTRIBUTE_SIZE = 64;

    private PmdLoader() {
    }

    @Override
    @NotNull
    public List<String> getExtensions() {
        return extensions;
    }

    @Override
    @NotNull
    public List<ModelFileLoader.Ability> getAbilities() {
        return abilities;
    }

    @Override
    public int getProbeLength() {
        return probeLength;
    }

    @Override
    public boolean probe(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (buffer.remaining() < PMD_SIGNATURE.length) {
            return false;
        }
        byte[] signatureBytes = new byte[PMD_SIGNATURE.length];
        buffer.get(signatureBytes, 0, PMD_SIGNATURE.length);
        return Arrays.equals(signatureBytes, PMD_SIGNATURE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ModelFileLoader.Result load(@NotNull Path path, @NotNull Path basePath) {
        ModelFileLoader.Result result;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Object object = new OpenOption[]{StandardOpenOption.READ};
        object = FileChannel.open(path, object);
        Throwable throwable = null;
        try {
            ByteBuffer byteBuffer;
            Object $this$load_u24lambda_u242_u24lambda_u240;
            FileChannel channel = (FileChannel)object;
            boolean bl = false;
            long fileSize = channel.size();
            Object object2 = INSTANCE;
            try {
                $this$load_u24lambda_u242_u24lambda_u240 = object2;
                boolean bl2 = false;
                $this$load_u24lambda_u242_u24lambda_u240 = Result.constructor-impl((Object)channel.map(FileChannel.MapMode.READ_ONLY, 0L, fileSize));
            }
            catch (Throwable bl2) {
                $this$load_u24lambda_u242_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object2 = $this$load_u24lambda_u242_u24lambda_u240;
            MappedByteBuffer mappedByteBuffer = (MappedByteBuffer)(Result.isFailure-impl((Object)object2) ? null : object2);
            if (mappedByteBuffer != null) {
                byteBuffer = mappedByteBuffer;
            } else {
                PmdLoader $this$load_u24lambda_u242_u24lambda_u241 = INSTANCE;
                boolean bl3 = false;
                if (fileSize > 0x2000000L) {
                    throw new PmdLoadException("PMD model size too large: maximum allowed is 32M, current is " + fileSize);
                }
                int fileSize2 = (int)fileSize;
                ByteBuffer buffer = ByteBuffer.allocate(fileSize2);
                Intrinsics.checkNotNull((Object)channel);
                ReadableByteChannel readableByteChannel = channel;
                Intrinsics.checkNotNull((Object)buffer);
                ReadUtilKt.readAll(readableByteChannel, buffer);
                buffer.flip();
                if (channel.position() != (long)fileSize2) {
                    throw new PmdLoadException("Not read to file's end, maybe a bug?");
                }
                byteBuffer = buffer;
            }
            ByteBuffer buffer = byteBuffer;
            Context context = new Context(basePath);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            Intrinsics.checkNotNull((Object)buffer);
            result = context.load(buffer);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return result;
    }

    static {
        byte[] byArray = new byte[]{80, 109, 100, 0, 0, (byte)128, 63};
        PMD_SIGNATURE = byArray;
        probeLength = PMD_SIGNATURE.length;
        SHIFT_JIS = Charset.forName("Shift-JIS");
        decoder = SHIFT_JIS.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
    }

    @kotlin.Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u000bH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\tH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\tH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\tH\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\tH\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020\tH\u0002J\u0010\u0010%\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\tH\u0002J\u0010\u0010&\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\tH\u0002J\u001e\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00180(2\u0006\u0010)\u001a\u00020\u0018H\u0002J\u0010\u0010*\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\tH\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0018H\u0002J\f\u0010.\u001a\u00020 *\u00020 H\u0002J\u0010\u0010/\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\tH\u0002J\u000e\u00100\u001a\u0002012\u0006\u0010\u0019\u001a\u00020\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R \u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Ltop/fifthlight/renderer/model/pmd/PmdLoader$Context;", "", "basePath", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "getBasePath", "()Ljava/nio/file/Path;", "vertexBuffer", "Ljava/nio/ByteBuffer;", "vertices", "", "indexBuffer", "indices", "materials", "", "Ltop/fifthlight/renderer/model/pmd/format/PmdMaterial;", "bones", "Ltop/fifthlight/renderer/model/pmd/format/PmdBone;", "childBoneMap", "", "", "rootBones", "loadString", "", "buffer", "maxLength", "loadRgbColor", "Ltop/fifthlight/renderer/model/RgbColor;", "loadRgbaColor", "Ltop/fifthlight/renderer/model/RgbaColor;", "loadVector3f", "Lorg/joml/Vector3f;", "loadSignature", "", "loadHeader", "Ltop/fifthlight/renderer/model/pmd/format/PmdHeader;", "loadVertices", "loadIndices", "parseTextureInfo", "Lkotlin/Pair;", "info", "loadMaterials", "loadTexture", "Ltop/fifthlight/renderer/model/Texture;", "name", "invertX", "loadBones", "load", "Ltop/fifthlight/renderer/model/ModelFileLoader$Result;", "model_model-pmd-model-pmd"})
    @SourceDebugExtension(value={"SMAP\nPmdLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PmdLoader.kt\ntop/fifthlight/renderer/model/pmd/PmdLoader$Context\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,479:1\n346#2,8:480\n1557#2:491\n1628#2,3:492\n1557#2:495\n1628#2,2:496\n1630#2:505\n1863#2,2:506\n1557#2:508\n1628#2,3:509\n1557#2:512\n1628#2,3:513\n1557#2:516\n1628#2,3:517\n1557#2:520\n1628#2,3:521\n1557#2:524\n1628#2,3:525\n12577#3,2:488\n1#4:490\n381#5,7:498\n*S KotlinDebug\n*F\n+ 1 PmdLoader.kt\ntop/fifthlight/renderer/model/pmd/PmdLoader$Context\n*L\n69#1:480,8\n200#1:491\n200#1:492,3\n275#1:495\n275#1:496,2\n275#1:505\n317#1:506,2\n323#1:508\n323#1:509,3\n324#1:512\n324#1:513,3\n325#1:516\n325#1:517,3\n350#1:520\n350#1:521,3\n303#1:524\n303#1:525,3\n108#1:488,2\n278#1:498,7\n*E\n"})
    private static final class Context {
        @NotNull
        private final Path basePath;
        private ByteBuffer vertexBuffer;
        private int vertices;
        private ByteBuffer indexBuffer;
        private int indices;
        private List<PmdMaterial> materials;
        private List<PmdBone> bones;
        @NotNull
        private final Map<Integer, List<Integer>> childBoneMap;
        @NotNull
        private final List<Integer> rootBones;

        public Context(@NotNull Path basePath) {
            Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
            this.basePath = basePath;
            this.vertices = -1;
            this.indices = -1;
            this.childBoneMap = new LinkedHashMap();
            this.rootBones = new ArrayList();
        }

        @NotNull
        public final Path getBasePath() {
            return this.basePath;
        }

        private final String loadString(ByteBuffer buffer, int maxLength) {
            int n;
            ByteBuffer bytes;
            block3: {
                bytes = ByteBuffer.allocate(maxLength);
                bytes.put(buffer.slice(buffer.position(), maxLength));
                buffer.position(buffer.position() + maxLength);
                Iterable $this$indexOfFirst$iv = (Iterable)RangesKt.until((int)0, (int)maxLength);
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    int item$iv = ((IntIterator)iterator).nextInt();
                    if (index$iv < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    int it = item$iv;
                    boolean bl = false;
                    if (bytes.get(it) == 0) {
                        n = index$iv;
                        break block3;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int nullIndex = n;
            ByteBuffer stringBytes = bytes.slice(0, nullIndex).order(ByteOrder.LITTLE_ENDIAN);
            String string = decoder.decode(stringBytes).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final RgbColor loadRgbColor(ByteBuffer buffer) {
            if (buffer.remaining() < 12) {
                throw new PmdLoadException("Bad file: want to read Vec3 (12 bytes), but only have " + buffer.remaining() + " bytes available");
            }
            return new RgbColor(buffer.getFloat(), buffer.getFloat(), buffer.getFloat());
        }

        private final RgbaColor loadRgbaColor(ByteBuffer buffer) {
            if (buffer.remaining() < 16) {
                throw new PmdLoadException("Bad file: want to read Vec4 (16 bytes), but only have " + buffer.remaining() + " bytes available");
            }
            return new RgbaColor(buffer.getFloat(), buffer.getFloat(), buffer.getFloat(), buffer.getFloat());
        }

        private final Vector3f loadVector3f(ByteBuffer buffer) {
            if (buffer.remaining() < 12) {
                throw new PmdLoadException("Bad file: want to read Vec3 (12 bytes), but only have " + buffer.remaining() + " bytes available");
            }
            return new Vector3f(buffer.getFloat(), buffer.getFloat(), buffer.getFloat());
        }

        private final void loadSignature(ByteBuffer buffer) {
            boolean bl;
            block3: {
                if (buffer.remaining() < PMD_SIGNATURE.length) {
                    throw new PmdLoadException("Bad file: signature is " + PMD_SIGNATURE.length + " bytes, but only " + buffer.remaining() + " bytes in buffer");
                }
                byte[] $this$any$iv = PMD_SIGNATURE;
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int j = 0; j < n; ++j) {
                    byte element$iv;
                    byte it = element$iv = $this$any$iv[j];
                    boolean bl2 = false;
                    if (!(buffer.get() != it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            if (bl) {
                throw new PmdLoadException("Bad PMX signature");
            }
        }

        private final PmdHeader loadHeader(ByteBuffer buffer) {
            this.loadSignature(buffer);
            return new PmdHeader(this.loadString(buffer, 20), this.loadString(buffer, 256));
        }

        private final void loadVertices(ByteBuffer buffer) {
            int vertexCount = buffer.getInt();
            if (vertexCount <= 0) {
                throw new PmdLoadException("Bad vertices: count " + vertexCount + " should be greater than zero");
            }
            ByteBuffer outputBuffer = ByteBuffer.allocateDirect(64 * vertexCount).order(ByteOrder.nativeOrder());
            int outputPosition = 0;
            Ref.IntRef inputPosition = new Ref.IntRef();
            inputPosition.element = buffer.position();
            int copyBaseVertexSize = 28;
            for (int i2 = 0; i2 < vertexCount; ++i2) {
                outputBuffer.putFloat(outputPosition, -Context.loadVertices$readFloat(buffer, inputPosition));
                outputBuffer.put(outputPosition += 4, buffer, inputPosition.element, copyBaseVertexSize);
                inputPosition.element += copyBaseVertexSize;
                outputBuffer.putInt(outputPosition += copyBaseVertexSize, UShort.constructor-impl((short)buffer.getShort(inputPosition.element)) & 0xFFFF);
                outputBuffer.putInt(outputPosition + 4, UShort.constructor-impl((short)buffer.getShort(inputPosition.element + 2)) & 0xFFFF);
                float weight = (float)UnsignedKt.uintToDouble((int)(UShort.constructor-impl((short)buffer.get()) & 0xFFFF)) / 100.0f;
                outputBuffer.putFloat(outputPosition + 16, weight);
                outputBuffer.putFloat(outputPosition + 20, 1.0f - weight);
                outputPosition += 32;
                inputPosition.element += 6;
            }
            if (!(outputPosition == outputBuffer.capacity())) {
                boolean bl = false;
                String string = "Bug: Not filled the entire output buffer";
                throw new IllegalArgumentException(string.toString());
            }
            this.vertexBuffer = outputBuffer;
            this.vertices = vertexCount;
            buffer.position(inputPosition.element);
        }

        private final void loadIndices(ByteBuffer buffer) {
            int indexCount = buffer.getInt();
            if (indexCount <= 0) {
                throw new PmdLoadException("Bad indeices: count " + indexCount + " should be greater than zero");
            }
            if (indexCount % 3 != 0) {
                throw new PmdLoadException("Bad index count: " + indexCount + " % 3 != 0");
            }
            int triangleCount = indexCount / 3;
            int indexBufferSize = 2 * indexCount;
            if (buffer.remaining() < indexBufferSize) {
                throw new PmdLoadException("Bad index data: should have " + indexBufferSize + " bytes, but only " + buffer.remaining() + " bytes available");
            }
            ByteBuffer outputBuffer = ByteBuffer.allocateDirect(indexBufferSize).order(ByteOrder.nativeOrder());
            for (int i2 = 0; i2 < triangleCount; ++i2) {
                outputBuffer.putShort(buffer.getShort());
                short a = buffer.getShort();
                short b = buffer.getShort();
                outputBuffer.putShort(b);
                outputBuffer.putShort(a);
            }
            this.indexBuffer = outputBuffer;
            this.indices = indexCount;
        }

        private final Pair<String, String> parseTextureInfo(String info) {
            char[] cArray = new char[]{'*'};
            List it = StringsKt.split$default((CharSequence)info, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean bl = false;
            return switch (it.size()) {
                case 1 -> new Pair(it.get(0), null);
                case 2 -> new Pair(it.get(0), it.get(1));
                default -> throw new PmdLoadException("Bad texture info: " + info);
            };
        }

        /*
         * WARNING - void declaration
         */
        private final void loadMaterials(ByteBuffer buffer) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            int materialCount = buffer.getInt();
            Iterable iterable = (Iterable)RangesKt.until((int)0, (int)materialCount);
            Context context = this;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                String string;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                RgbaColor diffuseColor = this.loadRgbaColor(buffer);
                float specularStrength = buffer.getFloat();
                RgbColor specularColor = this.loadRgbColor(buffer);
                RgbColor ambientColor = this.loadRgbColor(buffer);
                byte toonIndex = buffer.get();
                boolean edgeFlag = buffer.get() != 0;
                int verticesCount = buffer.getInt();
                Pair<String, String> pair = this.parseTextureInfo(this.loadString(buffer, 20));
                String texture = (String)pair.component1();
                String sphere = (String)pair.component2();
                String string2 = string = texture;
                int n2 = verticesCount;
                boolean bl2 = edgeFlag;
                byte by = toonIndex;
                RgbColor rgbColor = ambientColor;
                RgbColor rgbColor2 = specularColor;
                float f = specularStrength;
                RgbaColor rgbaColor = diffuseColor;
                boolean bl3 = false;
                String string3 = sphere;
                boolean bl4 = ((CharSequence)it).length() > 0;
                String string4 = bl4 ? string : null;
                int n3 = n2;
                boolean bl5 = bl2;
                byte by2 = by;
                RgbColor rgbColor3 = rgbColor;
                RgbColor rgbColor4 = rgbColor2;
                float f2 = f;
                RgbaColor rgbaColor2 = rgbaColor;
                collection.add(new PmdMaterial(rgbaColor2, f2, rgbColor4, rgbColor3, by2, bl5, n3, string4, string3));
            }
            context.materials = (List)destination$iv$iv;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Texture loadTexture(String name) {
            ByteBuffer byteBuffer;
            Path path = this.basePath.resolve(name);
            Object object = new OpenOption[]{StandardOpenOption.READ};
            object = FileChannel.open(path, object);
            Throwable throwable = null;
            try {
                ByteBuffer byteBuffer2;
                Object $this$loadTexture_u24lambda_u249_u24lambda_u247;
                FileChannel channel = (FileChannel)object;
                boolean bl = false;
                long size = channel.size();
                Object object2 = this;
                try {
                    $this$loadTexture_u24lambda_u249_u24lambda_u247 = object2;
                    boolean bl2 = false;
                    $this$loadTexture_u24lambda_u249_u24lambda_u247 = Result.constructor-impl((Object)channel.map(FileChannel.MapMode.READ_ONLY, 0L, size));
                }
                catch (Throwable bl2) {
                    $this$loadTexture_u24lambda_u249_u24lambda_u247 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
                }
                object2 = $this$loadTexture_u24lambda_u249_u24lambda_u247;
                MappedByteBuffer mappedByteBuffer = (MappedByteBuffer)(Result.isFailure-impl((Object)object2) ? null : object2);
                if (mappedByteBuffer != null) {
                    byteBuffer2 = mappedByteBuffer;
                } else {
                    Context $this$loadTexture_u24lambda_u249_u24lambda_u248 = this;
                    boolean bl3 = false;
                    if (size > 0x10000000L) {
                        throw new PmdLoadException("Texture too large! Maximum supported is 256M.");
                    }
                    int size2 = (int)size;
                    ByteBuffer buffer = ByteBuffer.allocateDirect(size2);
                    Intrinsics.checkNotNull((Object)channel);
                    ReadableByteChannel readableByteChannel = channel;
                    Intrinsics.checkNotNull((Object)buffer);
                    ReadUtilKt.readAll(readableByteChannel, buffer);
                    buffer.flip();
                    if (buffer.remaining() != size2) {
                        throw new PmdLoadException("Not read to texture's end, maybe a bug?");
                    }
                    byteBuffer2 = buffer;
                }
                byteBuffer = byteBuffer2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            ByteBuffer buffer = byteBuffer;
            String string = "Texture " + name;
            Intrinsics.checkNotNull((Object)buffer);
            return new Texture(name, new BufferView(new Buffer(string, buffer), buffer.remaining(), 0, 0), null, new Texture.Sampler(null, null, null, null, 15, null), 4, null);
        }

        private final Vector3f invertX(Vector3f $this$invertX) {
            Vector3f vector3f;
            Vector3f it = vector3f = $this$invertX;
            boolean bl = false;
            $this$invertX.x = -$this$invertX.x;
            return vector3f;
        }

        /*
         * WARNING - void declaration
         */
        private final void loadBones(ByteBuffer buffer) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            short boneCount = buffer.getShort();
            if (boneCount < 0) {
                throw new PmdLoadException("Bad PMD model: bones count less than zero");
            }
            Iterable iterable = (Iterable)RangesKt.until((int)0, (short)boneCount);
            Context context = this;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                PmdBone pmdBone;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                PmdBone bone = pmdBone = Context.loadBones$loadBone(this, buffer);
                boolean bl2 = false;
                Integer n2 = bone.getParentBoneIndex();
                if (n2 != null) {
                    Object object;
                    void $this$getOrPut$iv;
                    int parentBoneIndex = ((Number)n2).intValue();
                    boolean bl3 = false;
                    Map<Integer, List<Integer>> map2 = this.childBoneMap;
                    Integer key$iv = parentBoneIndex;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl4 = false;
                        List answer$iv = new ArrayList();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    ((List)object).add((int)index);
                } else {
                    Context $this$loadBones_u24lambda_u2418_u24lambda_u2417_u24lambda_u2416 = this;
                    boolean bl5 = false;
                    $this$loadBones_u24lambda_u2418_u24lambda_u2417_u24lambda_u2416.rootBones.add((int)index);
                }
                collection.add(pmdBone);
            }
            context.bones = (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ModelFileLoader.Result load(@NotNull ByteBuffer buffer) {
            void $this$mapTo$iv$iv;
            Collection<HumanoidTag> collection;
            Collection<Matrix4f> collection2;
            Collection collection3;
            Iterable $this$mapTo$iv$iv2;
            Iterable $this$map$iv;
            Object element$iv2;
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            PmdHeader header = this.loadHeader(buffer);
            this.loadVertices(buffer);
            this.loadIndices(buffer);
            this.loadMaterials(buffer);
            this.loadBones(buffer);
            UUID modelId = UUID.randomUUID();
            List rootNodes = new ArrayList();
            Ref.IntRef nextNodeId = new Ref.IntRef();
            Map jointIds = new LinkedHashMap();
            Iterable $this$forEach$iv = this.rootBones;
            boolean $i$f$forEach22 = false;
            for (Object element$iv2 : $this$forEach$iv) {
                int index = ((Number)element$iv2).intValue();
                boolean bl = false;
                rootNodes.add(Context.load$addBone$default(this, nextNodeId, modelId, jointIds, index, null, 32, null));
            }
            List<PmdBone> list2 = this.bones;
            if (list2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bones");
                list2 = null;
            }
            Iterable $i$f$forEach22 = (Iterable)RangesKt.until((int)0, (int)list2.size());
            String string = "PMX skin";
            boolean $i$f$map = false;
            element$iv2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv2.iterator();
            while (iterator.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                collection3 = destination$iv$iv;
                boolean bl = false;
                Object v = jointIds.get((int)it);
                Intrinsics.checkNotNull(v);
                collection3.add((NodeId)v);
            }
            List<PmdBone> list3 = this.bones;
            if (list3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bones");
                list3 = null;
            }
            $this$map$iv = list3;
            collection3 = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                PmdBone it = (PmdBone)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(new Matrix4f().translation((Vector3fc)it.getPosition()).invertAffine());
            }
            collection2 = (List)destination$iv$iv;
            List<PmdBone> list4 = this.bones;
            if (list4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bones");
                list4 = null;
            }
            $this$map$iv = list4;
            NodeId nodeId = null;
            $i$f$map = false;
            $this$mapTo$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                PmdBone it = (PmdBone)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(HumanoidTag.Companion.fromPmxJapanese(it.getName()));
            }
            collection = (List)destination$iv$iv;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 8;
            Collection<HumanoidTag> collection4 = collection;
            NodeId nodeId2 = nodeId;
            Collection<Matrix4f> collection5 = collection2;
            Collection collection6 = collection3;
            String string2 = string;
            Skin skin = new Skin(string2, (List)collection6, (List)collection5, nodeId2, (List)collection4, n, defaultConstructorMarker);
            ByteBuffer byteBuffer = this.vertexBuffer;
            if (byteBuffer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"vertexBuffer");
                byteBuffer = null;
            }
            Buffer vertexBuffer = new Buffer("Vertex Buffer", byteBuffer);
            BufferView vertexBufferView = new BufferView(vertexBuffer, this.vertices * 64, 0, 64);
            ByteBuffer byteBuffer2 = this.indexBuffer;
            if (byteBuffer2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"indexBuffer");
                byteBuffer2 = null;
            }
            Buffer indexBuffer = new Buffer("Index Buffer", byteBuffer2);
            BufferView indexBufferView = new BufferView(indexBuffer, this.indices * 2, 0, 0);
            int indexOffset = 0;
            List<PmdMaterial> list5 = this.materials;
            if (list5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"materials");
                list5 = null;
            }
            Iterable $this$map$iv2 = list5;
            boolean $i$f$map2 = false;
            Iterable it = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Material.TextureInfo textureInfo;
                void pmdMaterial;
                PmdMaterial pmdMaterial2 = (PmdMaterial)item$iv$iv;
                Collection collection7 = destination$iv$iv2;
                boolean bl = false;
                int n2 = nextNodeId.element;
                nextNodeId.element = n2 + 1;
                int nodeId3 = n2;
                String string3 = null;
                RgbaColor rgbaColor = pmdMaterial.getDiffuseColor();
                if (pmdMaterial.getTextureFilename() != null) {
                    void it2;
                    RgbaColor rgbaColor2 = rgbaColor;
                    String string4 = string3;
                    boolean bl2 = false;
                    Material.TextureInfo textureInfo2 = new Material.TextureInfo(this.loadTexture((String)it2), 0, 2, null);
                    string3 = string4;
                    rgbaColor = rgbaColor2;
                    textureInfo = textureInfo2;
                } else {
                    textureInfo = null;
                }
                DefaultConstructorMarker defaultConstructorMarker2 = null;
                int n3 = 24;
                boolean bl3 = true;
                float f = 0.0f;
                Material.AlphaMode alphaMode = null;
                Material.TextureInfo textureInfo3 = textureInfo;
                RgbaColor rgbaColor3 = rgbaColor;
                String string5 = string3;
                Material.Unlit material = new Material.Unlit(string5, rgbaColor3, textureInfo3, alphaMode, f, bl3, n3, defaultConstructorMarker2);
                Intrinsics.checkNotNull((Object)modelId);
                Object object = new NodeId(modelId, nodeId3);
                Mesh mesh = new Mesh(new MeshId(modelId, nodeId3), CollectionsKt.listOf((Object)new Primitive(Primitive.Mode.TRIANGLES, material, new Primitive.Attributes.Primitive(new Accessor(vertexBufferView, 0, Accessor.ComponentType.FLOAT, false, this.vertices, Accessor.AccessorType.VEC3, null, null, null, 448, null), new Accessor(vertexBufferView, 12, Accessor.ComponentType.FLOAT, false, this.vertices, Accessor.AccessorType.VEC3, null, null, null, 448, null), null, CollectionsKt.listOf((Object)new Accessor(vertexBufferView, 24, Accessor.ComponentType.FLOAT, false, this.vertices, Accessor.AccessorType.VEC2, null, null, null, 448, null)), null, CollectionsKt.listOf((Object)new Accessor(vertexBufferView, 32, Accessor.ComponentType.UNSIGNED_INT, false, this.vertices, Accessor.AccessorType.VEC4, null, null, null, 448, null)), CollectionsKt.listOf((Object)new Accessor(vertexBufferView, 48, Accessor.ComponentType.FLOAT, false, this.vertices, Accessor.AccessorType.VEC4, null, null, null, 448, null)), 20, null), new Accessor(indexBufferView, indexOffset * 2, Accessor.ComponentType.UNSIGNED_SHORT, false, pmdMaterial.getVerticesCount(), Accessor.AccessorType.SCALAR, null, null, null, 448, null), CollectionsKt.emptyList())), null, null, 4, null);
                Object it3 = object = new Node(null, (NodeId)object, null, null, mesh, skin, 13, null);
                boolean bl4 = false;
                rootNodes.add(it3);
                indexOffset += pmdMaterial.getVerticesCount();
                collection7.add(object);
            }
            List cfr_ignored_0 = (List)destination$iv$iv2;
            Scene scene = new Scene(rootNodes, new NodeTransform.Decomposed(null, null, new Vector3f(0.1f), 3, null));
            List list6 = CollectionsKt.listOf((Object)scene);
            List list7 = CollectionsKt.listOf((Object)skin);
            return new ModelFileLoader.Result(new Metadata(header.getName(), null, header.getComment(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0xFFFFFA, null), new Model(list6, scene, list7, null, 8, null), CollectionsKt.emptyList());
        }

        private static final float loadVertices$readFloat(ByteBuffer $buffer, Ref.IntRef inputPosition) {
            float f;
            float it = f = $buffer.getFloat(inputPosition.element);
            boolean bl = false;
            inputPosition.element += 4;
            return f;
        }

        private static final PmdBone loadBones$loadBone(Context this$0, ByteBuffer buffer) {
            boolean bl;
            int it;
            Integer n = buffer.getShort();
            int n2 = ((Number)n).intValue();
            String string = this$0.loadString(buffer, 20);
            boolean bl2 = false;
            boolean bl3 = it != -1;
            Integer n3 = bl3 ? n : null;
            n = buffer.getShort();
            it = ((Number)n).intValue();
            Integer n4 = n3;
            boolean bl4 = false;
            boolean bl5 = bl = it != -1;
            Integer n5 = bl ? n : null;
            n = buffer.getShort();
            it = ((Number)n).intValue();
            int n6 = UByte.constructor-impl((byte)buffer.get()) & 0xFF;
            Integer n7 = n5;
            boolean bl6 = false;
            boolean bl7 = it != -1;
            Vector3f vector3f = this$0.invertX(this$0.loadVector3f(buffer));
            Integer n8 = bl7 ? n : null;
            int n9 = n6;
            Integer n10 = n7;
            Integer n11 = n4;
            String string2 = string;
            return new PmdBone(string2, n11, n10, n9, n8, vector3f);
        }

        /*
         * WARNING - void declaration
         */
        private static final Node load$addBone(Context this$0, Ref.IntRef nextNodeId, UUID modelId, Map<Integer, NodeId> jointIds, int index, Vector3f parentPosition) {
            List list2;
            Iterable $this$map$iv;
            List<PmdBone> list3 = this$0.bones;
            if (list3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bones");
                list3 = null;
            }
            PmdBone bone = list3.get(index);
            int n = nextNodeId.element;
            nextNodeId.element = n + 1;
            int nodeIndex = n;
            Intrinsics.checkNotNull((Object)modelId);
            NodeId nodeId = new NodeId(modelId, nodeIndex);
            Integer n2 = index;
            jointIds.put(n2, nodeId);
            List<Integer> list4 = this$0.childBoneMap.get(index);
            if (list4 != null) {
                void $this$mapTo$iv$iv;
                $this$map$iv = list4;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    int n3 = ((Number)item$iv$iv).intValue();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(Context.load$addBone(this$0, nextNodeId, modelId, jointIds, (int)it, bone.getPosition()));
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = CollectionsKt.emptyList();
            }
            List children = list2;
            Vector3f vector3f = new Vector3f().set((Vector3fc)bone.getPosition());
            $this$map$iv = vector3f;
            List list5 = children;
            NodeId nodeId2 = nodeId;
            String string = bone.getName();
            boolean bl = false;
            if (parentPosition != null) {
                void it;
                it.sub((Vector3fc)parentPosition);
            }
            Unit unit = Unit.INSTANCE;
            Vector3f vector3f2 = vector3f;
            Intrinsics.checkNotNullExpressionValue((Object)vector3f2, (String)"also(...)");
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n4 = 6;
            Vector3f vector3f3 = null;
            Quaternionf quaternionf = null;
            Vector3f vector3f4 = vector3f2;
            DefaultConstructorMarker defaultConstructorMarker2 = null;
            int n5 = 48;
            Skin skin = null;
            Mesh mesh = null;
            NodeTransform nodeTransform = new NodeTransform.Decomposed(vector3f4, quaternionf, vector3f3, n4, defaultConstructorMarker);
            List list6 = list5;
            NodeId nodeId3 = nodeId2;
            String string2 = string;
            return new Node(string2, nodeId3, list6, nodeTransform, mesh, skin, n5, defaultConstructorMarker2);
        }

        static /* synthetic */ Node load$addBone$default(Context context, Ref.IntRef intRef, UUID uUID, Map map2, int n, Vector3f vector3f, int n2, Object object) {
            if ((n2 & 0x20) != 0) {
                vector3f = null;
            }
            return Context.load$addBone(context, intRef, uUID, map2, n, vector3f);
        }
    }
}

