/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.renderer.model.pmx;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.UByte;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import top.fifthlight.renderer.model.Accessor;
import top.fifthlight.renderer.model.Buffer;
import top.fifthlight.renderer.model.BufferView;
import top.fifthlight.renderer.model.HumanoidTag;
import top.fifthlight.renderer.model.Material;
import top.fifthlight.renderer.model.Mesh;
import top.fifthlight.renderer.model.MeshId;
import top.fifthlight.renderer.model.Metadata;
import top.fifthlight.renderer.model.Model;
import top.fifthlight.renderer.model.ModelFileLoader;
import top.fifthlight.renderer.model.Node;
import top.fifthlight.renderer.model.NodeId;
import top.fifthlight.renderer.model.NodeTransform;
import top.fifthlight.renderer.model.Primitive;
import top.fifthlight.renderer.model.RgbColor;
import top.fifthlight.renderer.model.RgbaColor;
import top.fifthlight.renderer.model.Scene;
import top.fifthlight.renderer.model.Skin;
import top.fifthlight.renderer.model.Texture;
import top.fifthlight.renderer.model.pmx.PmxLoadException;
import top.fifthlight.renderer.model.pmx.format.PmxBone;
import top.fifthlight.renderer.model.pmx.format.PmxGlobals;
import top.fifthlight.renderer.model.pmx.format.PmxHeader;
import top.fifthlight.renderer.model.pmx.format.PmxMaterial;
import top.fifthlight.renderer.model.pmx.format.PmxMorph;
import top.fifthlight.renderer.model.util.ReadUtilKt;

@kotlin.Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ltop/fifthlight/renderer/model/pmx/PmxLoader;", "Ltop/fifthlight/renderer/model/ModelFileLoader;", "<init>", "()V", "extensions", "", "", "getExtensions", "()Ljava/util/List;", "abilities", "Ltop/fifthlight/renderer/model/ModelFileLoader$Ability;", "getAbilities", "PMX_SIGNATURE", "", "probeLength", "", "getProbeLength", "()I", "probe", "", "buffer", "Ljava/nio/ByteBuffer;", "VALID_INDEX_SIZES", "BASE_VERTEX_ATTRIBUTE_SIZE", "SKIN_VERTEX_ATTRIBUTE_SIZE", "VERTEX_ATTRIBUTE_SIZE", "load", "Ltop/fifthlight/renderer/model/ModelFileLoader$Result;", "path", "Ljava/nio/file/Path;", "basePath", "Context", "model_model-pmx-model-pmx"})
public final class PmxLoader
implements ModelFileLoader {
    @NotNull
    public static final PmxLoader INSTANCE = new PmxLoader();
    @NotNull
    private static final List<String> extensions = CollectionsKt.listOf((Object)"pmx");
    @NotNull
    private static final List<ModelFileLoader.Ability> abilities = CollectionsKt.listOf((Object)((Object)ModelFileLoader.Ability.MODEL));
    @NotNull
    private static final byte[] PMX_SIGNATURE;
    private static final int probeLength;
    @NotNull
    private static final List<Integer> VALID_INDEX_SIZES;
    private static final int BASE_VERTEX_ATTRIBUTE_SIZE = 32;
    private static final int SKIN_VERTEX_ATTRIBUTE_SIZE = 32;
    private static final int VERTEX_ATTRIBUTE_SIZE = 64;

    private PmxLoader() {
    }

    @Override
    @NotNull
    public List<String> getExtensions() {
        return extensions;
    }

    @Override
    @NotNull
    public List<ModelFileLoader.Ability> getAbilities() {
        return abilities;
    }

    @Override
    public int getProbeLength() {
        return probeLength;
    }

    @Override
    public boolean probe(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (buffer.remaining() < PMX_SIGNATURE.length) {
            return false;
        }
        byte[] signatureBytes = new byte[PMX_SIGNATURE.length];
        buffer.get(signatureBytes, 0, PMX_SIGNATURE.length);
        return Arrays.equals(signatureBytes, PMX_SIGNATURE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ModelFileLoader.Result load(@NotNull Path path, @NotNull Path basePath) {
        ModelFileLoader.Result result;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Object object = new OpenOption[]{StandardOpenOption.READ};
        object = FileChannel.open(path, object);
        Throwable throwable = null;
        try {
            ByteBuffer byteBuffer;
            Object $this$load_u24lambda_u242_u24lambda_u240;
            FileChannel channel = (FileChannel)object;
            boolean bl = false;
            long fileSize = channel.size();
            Object object2 = INSTANCE;
            try {
                $this$load_u24lambda_u242_u24lambda_u240 = object2;
                boolean bl2 = false;
                $this$load_u24lambda_u242_u24lambda_u240 = Result.constructor-impl((Object)channel.map(FileChannel.MapMode.READ_ONLY, 0L, fileSize));
            }
            catch (Throwable bl2) {
                $this$load_u24lambda_u242_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object2 = $this$load_u24lambda_u242_u24lambda_u240;
            MappedByteBuffer mappedByteBuffer = (MappedByteBuffer)(Result.isFailure-impl((Object)object2) ? null : object2);
            if (mappedByteBuffer != null) {
                byteBuffer = mappedByteBuffer;
            } else {
                PmxLoader $this$load_u24lambda_u242_u24lambda_u241 = INSTANCE;
                boolean bl3 = false;
                if (fileSize > 0x2000000L) {
                    throw new PmxLoadException("PMX model size too large: maximum allowed is 32M, current is " + fileSize);
                }
                int fileSize2 = (int)fileSize;
                ByteBuffer buffer = ByteBuffer.allocate(fileSize2);
                Intrinsics.checkNotNull((Object)channel);
                ReadableByteChannel readableByteChannel = channel;
                Intrinsics.checkNotNull((Object)buffer);
                ReadUtilKt.readAll(readableByteChannel, buffer);
                buffer.flip();
                if (channel.position() != (long)fileSize2) {
                    throw new PmxLoadException("Not read to file's end, maybe a bug?");
                }
                byteBuffer = buffer;
            }
            ByteBuffer buffer = byteBuffer;
            Context context = new Context(basePath);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            Intrinsics.checkNotNull((Object)buffer);
            result = context.load(buffer);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return result;
    }

    static {
        Object[] objectArray = new byte[]{80, 77, 88, 32};
        PMX_SIGNATURE = objectArray;
        probeLength = PMX_SIGNATURE.length;
        objectArray = new Integer[3];
        objectArray[0] = (byte)1;
        objectArray[1] = (byte)2;
        objectArray[2] = (byte)4;
        VALID_INDEX_SIZES = CollectionsKt.listOf((Object[])objectArray);
    }

    @kotlin.Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020*2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010-\u001a\u00020.2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010/\u001a\u00020\u00072\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u00100\u001a\u0002012\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u00102\u001a\u0002032\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u00104\u001a\u00020.2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u00105\u001a\u00020.2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u00106\u001a\u00020.2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u00107\u001a\u00020.2\u0006\u0010'\u001a\u00020(H\u0002J\f\u00108\u001a\u00020,*\u00020,H\u0002J\u0010\u00109\u001a\u00020.2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010:\u001a\u00020.2\u0006\u0010'\u001a\u00020(H\u0002J\u000e\u0010;\u001a\u00020<2\u0006\u0010'\u001a\u00020(R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R#\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R \u0010!\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00120#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Ltop/fifthlight/renderer/model/pmx/PmxLoader$Context;", "", "basePath", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "globals", "Ltop/fifthlight/renderer/model/pmx/format/PmxGlobals;", "decoder", "Ljava/nio/charset/CharsetDecoder;", "kotlin.jvm.PlatformType", "getDecoder", "()Ljava/nio/charset/CharsetDecoder;", "decoder$delegate", "Lkotlin/Lazy;", "vertexAttributes", "Ltop/fifthlight/renderer/model/Primitive$Attributes$Primitive;", "vertices", "", "indexBufferView", "Ltop/fifthlight/renderer/model/BufferView;", "indexBufferType", "Ltop/fifthlight/renderer/model/Accessor$ComponentType;", "indices", "textures", "", "Ltop/fifthlight/renderer/model/Texture;", "materials", "Ltop/fifthlight/renderer/model/pmx/format/PmxMaterial;", "bones", "Ltop/fifthlight/renderer/model/pmx/format/PmxBone;", "morphTargets", "Ltop/fifthlight/renderer/model/Primitive$Attributes;", "childBoneMap", "", "", "rootBones", "loadRgbColor", "Ltop/fifthlight/renderer/model/RgbColor;", "buffer", "Ljava/nio/ByteBuffer;", "loadRgbaColor", "Ltop/fifthlight/renderer/model/RgbaColor;", "loadVector3f", "Lorg/joml/Vector3f;", "loadSignature", "", "loadGlobal", "loadString", "", "loadHeader", "Ltop/fifthlight/renderer/model/pmx/format/PmxHeader;", "loadVertices", "loadSurfaces", "loadTextures", "loadMaterials", "invertX", "loadBones", "loadMorphTargets", "load", "Ltop/fifthlight/renderer/model/ModelFileLoader$Result;", "model_model-pmx-model-pmx"})
    @SourceDebugExtension(value={"SMAP\nPmxLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PmxLoader.kt\ntop/fifthlight/renderer/model/pmx/PmxLoader$Context\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,886:1\n12577#2,2:887\n1#3:889\n1557#4:890\n1628#4,2:891\n1630#4:897\n1557#4:898\n1628#4,3:899\n1557#4:902\n1628#4,2:903\n1630#4:912\n1557#4:913\n1628#4,2:914\n295#4,2:916\n295#4,2:918\n1630#4:920\n1863#4,2:921\n1557#4:923\n1628#4,3:924\n1557#4:927\n1628#4,3:928\n1557#4:931\n1628#4,3:932\n1863#4,2:935\n1557#4:937\n1628#4,3:938\n1557#4:941\n1628#4,3:942\n37#5:893\n36#5,3:894\n381#6,7:905\n*S KotlinDebug\n*F\n+ 1 PmxLoader.kt\ntop/fifthlight/renderer/model/pmx/PmxLoader$Context\n*L\n124#1:887,2\n482#1:890\n482#1:891,2\n482#1:897\n551#1:898\n551#1:899,3\n701#1:902\n701#1:903,2\n701#1:912\n717#1:913\n717#1:914,2\n721#1:916,2\n724#1:918,2\n717#1:920\n781#1:921,2\n787#1:923\n787#1:924,3\n788#1:927\n788#1:928,3\n789#1:931\n789#1:932,3\n797#1:935,2\n660#1:937\n660#1:938,3\n765#1:941\n765#1:942,3\n489#1:893\n489#1:894,3\n704#1:905,7\n*E\n"})
    private static final class Context {
        @NotNull
        private final Path basePath;
        private PmxGlobals globals;
        @NotNull
        private final Lazy decoder$delegate;
        private Primitive.Attributes.Primitive vertexAttributes;
        private int vertices;
        private BufferView indexBufferView;
        private Accessor.ComponentType indexBufferType;
        private int indices;
        private List<Texture> textures;
        private List<PmxMaterial> materials;
        private List<PmxBone> bones;
        private List<? extends Primitive.Attributes> morphTargets;
        @NotNull
        private final Map<Integer, List<Integer>> childBoneMap;
        @NotNull
        private final List<Integer> rootBones;

        public Context(@NotNull Path basePath) {
            Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
            this.basePath = basePath;
            this.decoder$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CharsetDecoder>(this){
                final /* synthetic */ Context this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final CharsetDecoder invoke() {
                    PmxGlobals pmxGlobals = Context.access$getGlobals$p(this.this$0);
                    if (pmxGlobals == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"globals");
                        pmxGlobals = null;
                    }
                    return pmxGlobals.getTextEncoding().getCharset().newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                }
            }));
            this.vertices = -1;
            this.indices = -1;
            this.childBoneMap = new LinkedHashMap();
            this.rootBones = new ArrayList();
        }

        private final CharsetDecoder getDecoder() {
            Lazy lazy = this.decoder$delegate;
            return (CharsetDecoder)lazy.getValue();
        }

        private final RgbColor loadRgbColor(ByteBuffer buffer) {
            if (buffer.remaining() < 12) {
                throw new PmxLoadException("Bad file: want to read Vec3 (12 bytes), but only have " + buffer.remaining() + " bytes available");
            }
            return new RgbColor(buffer.getFloat(), buffer.getFloat(), buffer.getFloat());
        }

        private final RgbaColor loadRgbaColor(ByteBuffer buffer) {
            if (buffer.remaining() < 16) {
                throw new PmxLoadException("Bad file: want to read Vec4 (16 bytes), but only have " + buffer.remaining() + " bytes available");
            }
            return new RgbaColor(buffer.getFloat(), buffer.getFloat(), buffer.getFloat(), buffer.getFloat());
        }

        private final Vector3f loadVector3f(ByteBuffer buffer) {
            if (buffer.remaining() < 12) {
                throw new PmxLoadException("Bad file: want to read Vec3 (12 bytes), but only have " + buffer.remaining() + " bytes available");
            }
            return new Vector3f(buffer.getFloat(), buffer.getFloat(), buffer.getFloat());
        }

        private final void loadSignature(ByteBuffer buffer) {
            boolean bl;
            block3: {
                if (buffer.remaining() < PMX_SIGNATURE.length) {
                    throw new PmxLoadException("Bad file: signature is " + PMX_SIGNATURE.length + " bytes, but only " + buffer.remaining() + " bytes in buffer");
                }
                byte[] $this$any$iv = PMX_SIGNATURE;
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int j = 0; j < n; ++j) {
                    byte element$iv;
                    byte it = element$iv = $this$any$iv[j];
                    boolean bl2 = false;
                    if (!(buffer.get() != it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            if (bl) {
                throw new PmxLoadException("Bad PMX signature");
            }
        }

        private final PmxGlobals loadGlobal(ByteBuffer buffer) {
            int it;
            int n;
            int encoding = UByte.constructor-impl((byte)buffer.get()) & 0xFF;
            PmxGlobals.TextEncoding textEncoding = switch (encoding) {
                case 0 -> PmxGlobals.TextEncoding.UTF16LE;
                case 1 -> PmxGlobals.TextEncoding.UTF8;
                default -> throw new PmxLoadException("Bad text encoding: " + encoding);
            };
            int n2 = n = UByte.constructor-impl((byte)buffer.get()) & 0xFF;
            PmxGlobals.TextEncoding textEncoding2 = textEncoding;
            boolean bl = false;
            if (!(0 <= it ? it < 5 : false)) {
                throw new PmxLoadException("Bad additional vec4 count: " + it + ", should be in [0, 4]");
            }
            int n3 = n;
            it = n = UByte.constructor-impl((byte)buffer.get()) & 0xFF;
            int n4 = n3;
            boolean bl2 = false;
            if (!VALID_INDEX_SIZES.contains(it)) {
                throw new PmxLoadException("Bad vertex index size: " + it + ", should be " + CollectionsKt.joinToString$default((Iterable)VALID_INDEX_SIZES, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
            }
            Unit unit = Unit.INSTANCE;
            int n5 = n;
            it = n = UByte.constructor-impl((byte)buffer.get()) & 0xFF;
            int n6 = n5;
            boolean bl3 = false;
            if (!VALID_INDEX_SIZES.contains(it)) {
                throw new PmxLoadException("Bad texture index size: " + it + ", should be " + CollectionsKt.joinToString$default((Iterable)VALID_INDEX_SIZES, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
            }
            Unit unit2 = Unit.INSTANCE;
            int n7 = n;
            it = n = UByte.constructor-impl((byte)buffer.get()) & 0xFF;
            int n8 = n7;
            boolean bl4 = false;
            if (!VALID_INDEX_SIZES.contains(it)) {
                throw new PmxLoadException("Bad material index size: " + it + ", should be " + CollectionsKt.joinToString$default((Iterable)VALID_INDEX_SIZES, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
            }
            Unit unit3 = Unit.INSTANCE;
            int n9 = n;
            it = n = UByte.constructor-impl((byte)buffer.get()) & 0xFF;
            int n10 = n9;
            boolean bl5 = false;
            if (!VALID_INDEX_SIZES.contains(it)) {
                throw new PmxLoadException("Bad bone index size: " + it + ", should be " + CollectionsKt.joinToString$default((Iterable)VALID_INDEX_SIZES, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
            }
            Unit unit4 = Unit.INSTANCE;
            int n11 = n;
            it = n = UByte.constructor-impl((byte)buffer.get()) & 0xFF;
            int n12 = n11;
            boolean bl6 = false;
            if (!VALID_INDEX_SIZES.contains(it)) {
                throw new PmxLoadException("Bad morph index size: " + it + ", should be " + CollectionsKt.joinToString$default((Iterable)VALID_INDEX_SIZES, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
            }
            Unit unit5 = Unit.INSTANCE;
            int n13 = n;
            it = n = UByte.constructor-impl((byte)buffer.get()) & 0xFF;
            int n14 = n13;
            boolean bl7 = false;
            if (!VALID_INDEX_SIZES.contains(it)) {
                throw new PmxLoadException("Bad rigid body index size: " + it + ", should be " + CollectionsKt.joinToString$default((Iterable)VALID_INDEX_SIZES, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
            }
            Unit unit6 = Unit.INSTANCE;
            int n15 = n;
            int n16 = n14;
            int n17 = n12;
            int n18 = n10;
            int n19 = n8;
            int n20 = n6;
            int n21 = n4;
            PmxGlobals.TextEncoding textEncoding3 = textEncoding2;
            return new PmxGlobals(textEncoding3, n21, n20, n19, n18, n17, n16, n15);
        }

        private final String loadString(ByteBuffer buffer) {
            String string;
            if (buffer.remaining() < 4) {
                throw new PmxLoadException("No space for string index: want at least 4, but got " + buffer.remaining());
            }
            int length = buffer.getInt();
            if (length < 0) {
                throw new PmxLoadException("Bad string size, should be at least 0: " + length);
            }
            if (buffer.remaining() < length) {
                throw new PmxLoadException("No enough data for string: want " + length + " bytes, but only have " + buffer.remaining() + " bytes");
            }
            ByteBuffer stringBuffer = buffer.slice(buffer.position(), length).order(ByteOrder.LITTLE_ENDIAN);
            String string2 = this.getDecoder().decode(stringBuffer).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String it = string = string2;
            boolean bl = false;
            buffer.position(buffer.position() + length);
            return string;
        }

        private final PmxHeader loadHeader(ByteBuffer buffer) {
            this.loadSignature(buffer);
            if (buffer.remaining() < 5) {
                throw new PmxLoadException("Bad PMX signature");
            }
            float version = buffer.getFloat();
            if (version < 2.0f) {
                throw new PmxLoadException("Bad PMX version: at least 2.0, but get " + version);
            }
            int globalsCount = UByte.constructor-impl((byte)buffer.get()) & 0xFF;
            if (globalsCount < 8) {
                throw new PmxLoadException("Bad global count: " + globalsCount + ", at least 8");
            }
            ByteBuffer byteBuffer = buffer.slice(buffer.position(), globalsCount).order(ByteOrder.LITTLE_ENDIAN);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"order(...)");
            this.globals = this.loadGlobal(byteBuffer);
            buffer.position(buffer.position() + globalsCount);
            PmxGlobals pmxGlobals = this.globals;
            if (pmxGlobals == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"globals");
                pmxGlobals = null;
            }
            return new PmxHeader(version, pmxGlobals, this.loadString(buffer), this.loadString(buffer), this.loadString(buffer), this.loadString(buffer));
        }

        private final void loadVertices(ByteBuffer buffer) {
            int vertexCount = buffer.getInt();
            if (vertexCount <= 0) {
                throw new PmxLoadException("Bad vertex count: " + vertexCount + ", should be greater than 0");
            }
            PmxGlobals pmxGlobals = this.globals;
            if (pmxGlobals == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"globals");
                pmxGlobals = null;
            }
            int additionalVec4Size = pmxGlobals.getAdditionalVec4Count() * 4 * 4;
            PmxGlobals pmxGlobals2 = this.globals;
            if (pmxGlobals2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"globals");
                pmxGlobals2 = null;
            }
            int boneIndexSize = pmxGlobals2.getBoneIndexSize();
            ByteBuffer outputBuffer = ByteBuffer.allocateDirect(64 * vertexCount).order(ByteOrder.nativeOrder());
            int outputPosition = 0;
            Ref.IntRef inputPosition = new Ref.IntRef();
            inputPosition.element = buffer.position();
            int copyBaseVertexSize = 28;
            for (int i2 = 0; i2 < vertexCount; ++i2) {
                outputBuffer.putFloat(outputPosition, -Context.loadVertices$readFloat(buffer, inputPosition));
                outputBuffer.put(outputPosition += 4, buffer, inputPosition.element, copyBaseVertexSize);
                outputPosition += copyBaseVertexSize;
                inputPosition.element += copyBaseVertexSize;
                inputPosition.element += additionalVec4Size;
                int weightDeformType = UByte.constructor-impl((byte)buffer.get(inputPosition.element)) & 0xFF;
                ++inputPosition.element;
                Vector3f vec = new Vector3f();
                switch (weightDeformType) {
                    case 0: {
                        int index1 = Context.loadVertices$readBoneIndex(boneIndexSize, buffer, inputPosition);
                        outputBuffer.putInt(outputPosition, index1);
                        if (index1 == -1) break;
                        outputBuffer.putFloat(outputPosition + 16, 1.0f);
                        break;
                    }
                    case 1: {
                        int index1 = Context.loadVertices$readBoneIndex(boneIndexSize, buffer, inputPosition);
                        int index2 = Context.loadVertices$readBoneIndex(boneIndexSize, buffer, inputPosition);
                        float weight1 = Context.loadVertices$readWeight(buffer, inputPosition);
                        outputBuffer.putInt(outputPosition, index1);
                        outputBuffer.putInt(outputPosition + 4, index2);
                        if (index1 != -1) {
                            outputBuffer.putFloat(outputPosition + 16, weight1);
                        }
                        if (index2 == -1) break;
                        outputBuffer.putFloat(outputPosition + 20, 1.0f - weight1);
                        break;
                    }
                    case 2: 
                    case 4: {
                        int index1 = Context.loadVertices$readBoneIndex(boneIndexSize, buffer, inputPosition);
                        int index2 = Context.loadVertices$readBoneIndex(boneIndexSize, buffer, inputPosition);
                        int index3 = Context.loadVertices$readBoneIndex(boneIndexSize, buffer, inputPosition);
                        int index4 = Context.loadVertices$readBoneIndex(boneIndexSize, buffer, inputPosition);
                        float weight1 = Context.loadVertices$readWeight(buffer, inputPosition);
                        float weight2 = Context.loadVertices$readWeight(buffer, inputPosition);
                        float weight3 = Context.loadVertices$readWeight(buffer, inputPosition);
                        float weight4 = Context.loadVertices$readWeight(buffer, inputPosition);
                        outputBuffer.putInt(outputPosition, index1);
                        outputBuffer.putInt(outputPosition + 4, index2);
                        outputBuffer.putInt(outputPosition + 8, index3);
                        outputBuffer.putInt(outputPosition + 12, index4);
                        if (index1 != -1) {
                            outputBuffer.putFloat(outputPosition + 16, weight1);
                        }
                        if (index2 != -1) {
                            outputBuffer.putFloat(outputPosition + 20, weight2);
                        }
                        if (index3 != -1) {
                            outputBuffer.putFloat(outputPosition + 24, weight3);
                        }
                        if (index4 == -1) break;
                        outputBuffer.putFloat(outputPosition + 28, weight4);
                        break;
                    }
                    case 3: {
                        int index1 = Context.loadVertices$readBoneIndex(boneIndexSize, buffer, inputPosition);
                        int index2 = Context.loadVertices$readBoneIndex(boneIndexSize, buffer, inputPosition);
                        float weight1 = Context.loadVertices$readWeight(buffer, inputPosition);
                        outputBuffer.putInt(outputPosition, index1);
                        outputBuffer.putInt(outputPosition + 4, index2);
                        if (index1 != -1) {
                            outputBuffer.putFloat(outputPosition + 16, weight1);
                        }
                        if (index2 != -1) {
                            outputBuffer.putFloat(outputPosition + 20, 1.0f - weight1);
                        }
                        Vector3f c = Context.loadVertices$readVector3f(buffer, inputPosition, vec);
                        Vector3f r0 = Context.loadVertices$readVector3f(buffer, inputPosition, vec);
                        Vector3f vector3f = Context.loadVertices$readVector3f(buffer, inputPosition, vec);
                    }
                }
                outputPosition += 32;
                inputPosition.element += 4;
            }
            if (!(outputPosition == outputBuffer.capacity())) {
                boolean $i$a$-require-PmxLoader$Context$loadVertices$22 = false;
                String $i$a$-require-PmxLoader$Context$loadVertices$22 = "Bug: Not filled the entire output buffer";
                throw new IllegalArgumentException($i$a$-require-PmxLoader$Context$loadVertices$22.toString());
            }
            Intrinsics.checkNotNull((Object)outputBuffer);
            Buffer vertexBuffer = new Buffer("Vertex Buffer", outputBuffer);
            BufferView vertexBufferView = new BufferView(vertexBuffer, outputBuffer.remaining(), 0, 64);
            this.vertices = vertexCount;
            this.vertexAttributes = new Primitive.Attributes.Primitive(new Accessor(vertexBufferView, 0, Accessor.ComponentType.FLOAT, false, vertexCount, Accessor.AccessorType.VEC3, null, null, null, 448, null), new Accessor(vertexBufferView, 12, Accessor.ComponentType.FLOAT, false, vertexCount, Accessor.AccessorType.VEC3, null, null, null, 448, null), null, CollectionsKt.listOf((Object)new Accessor(vertexBufferView, 24, Accessor.ComponentType.FLOAT, false, vertexCount, Accessor.AccessorType.VEC2, null, null, null, 448, null)), null, CollectionsKt.listOf((Object)new Accessor(vertexBufferView, 32, Accessor.ComponentType.UNSIGNED_INT, false, vertexCount, Accessor.AccessorType.VEC4, null, null, null, 448, null)), CollectionsKt.listOf((Object)new Accessor(vertexBufferView, 48, Accessor.ComponentType.FLOAT, false, vertexCount, Accessor.AccessorType.VEC4, null, null, null, 448, null)), 20, null);
            buffer.position(inputPosition.element);
        }

        private final void loadSurfaces(ByteBuffer buffer) {
            BufferView bufferView;
            int surfaceCount = buffer.getInt();
            if (surfaceCount % 3 != 0) {
                throw new PmxLoadException("Bad surface count: " + surfaceCount + " % 3 != 0");
            }
            int triangleCount = surfaceCount / 3;
            PmxGlobals pmxGlobals = this.globals;
            if (pmxGlobals == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"globals");
                pmxGlobals = null;
            }
            int vertexIndexSize = pmxGlobals.getVertexIndexSize();
            int indexBufferSize = vertexIndexSize * surfaceCount;
            if (buffer.remaining() < indexBufferSize) {
                throw new PmxLoadException("Bad surface data: should have " + indexBufferSize + " bytes, but only " + buffer.remaining() + " bytes available");
            }
            ByteBuffer outputBuffer = ByteBuffer.allocateDirect(indexBufferSize).order(ByteOrder.nativeOrder());
            switch (vertexIndexSize) {
                case 1: {
                    int i2;
                    this.indexBufferType = Accessor.ComponentType.UNSIGNED_BYTE;
                    for (i2 = 0; i2 < triangleCount; ++i2) {
                        outputBuffer.put(buffer.get());
                        byte a = buffer.get();
                        byte b = buffer.get();
                        outputBuffer.put(b);
                        outputBuffer.put(a);
                    }
                    break;
                }
                case 2: {
                    int i2;
                    this.indexBufferType = Accessor.ComponentType.UNSIGNED_SHORT;
                    for (i2 = 0; i2 < triangleCount; ++i2) {
                        outputBuffer.putShort(buffer.getShort());
                        short a = buffer.getShort();
                        short b = buffer.getShort();
                        outputBuffer.putShort(b);
                        outputBuffer.putShort(a);
                    }
                    break;
                }
                case 4: {
                    int i2;
                    this.indexBufferType = Accessor.ComponentType.UNSIGNED_INT;
                    for (i2 = 0; i2 < triangleCount; ++i2) {
                        outputBuffer.putInt(buffer.getInt());
                        int a = buffer.getInt();
                        int b = buffer.getInt();
                        outputBuffer.putInt(b);
                        outputBuffer.putInt(a);
                    }
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            outputBuffer.flip();
            Intrinsics.checkNotNull((Object)outputBuffer);
            Buffer indexBuffer = new Buffer("Index Buffer", outputBuffer);
            this.indexBufferView = bufferView = new BufferView(indexBuffer, outputBuffer.remaining(), 0, 0);
            this.indices = surfaceCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void loadTextures(ByteBuffer buffer) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            int textureCount = buffer.getInt();
            if (textureCount < 0) {
                throw new PmxLoadException("Bad texture count: " + textureCount + ", should be at least zero");
            }
            Iterable iterable = (Iterable)RangesKt.until((int)0, (int)textureCount);
            Context context = this;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                ByteBuffer byteBuffer;
                Path path;
                char[] cArray;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String pathString = this.loadString(buffer);
                List pathParts = StringsKt.split$default((CharSequence)pathString, (char[])(cArray = new char[]{'/', '\\'}), (boolean)false, (int)0, (int)6, null);
                if (pathParts.size() == 1) {
                    path = this.basePath.getFileSystem().getPath((String)pathParts.get(0), new String[0]);
                } else {
                    Collection $this$toTypedArray$iv = pathParts.subList(1, pathParts.size());
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray = thisCollection$iv.toArray(new String[0]);
                    path = this.basePath.getFileSystem().getPath((String)pathParts.get(0), Arrays.copyOf(stringArray, stringArray.length));
                }
                Path relativePath = path;
                Path path2 = this.basePath.resolve(relativePath);
                Object object = new OpenOption[]{StandardOpenOption.READ};
                object = FileChannel.open(path2, object);
                Throwable throwable = null;
                try {
                    ByteBuffer byteBuffer2;
                    Object $this$loadTextures_u24lambda_u2416_u24lambda_u2415_u24lambda_u2413;
                    FileChannel channel = (FileChannel)object;
                    boolean bl2 = false;
                    long size = channel.size();
                    Object object2 = this;
                    try {
                        $this$loadTextures_u24lambda_u2416_u24lambda_u2415_u24lambda_u2413 = object2;
                        boolean bl3 = false;
                        $this$loadTextures_u24lambda_u2416_u24lambda_u2415_u24lambda_u2413 = Result.constructor-impl((Object)channel.map(FileChannel.MapMode.READ_ONLY, 0L, size));
                    }
                    catch (Throwable bl3) {
                        $this$loadTextures_u24lambda_u2416_u24lambda_u2415_u24lambda_u2413 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl3));
                    }
                    object2 = $this$loadTextures_u24lambda_u2416_u24lambda_u2415_u24lambda_u2413;
                    MappedByteBuffer mappedByteBuffer = (MappedByteBuffer)(Result.isFailure-impl((Object)object2) ? null : object2);
                    if (mappedByteBuffer != null) {
                        byteBuffer2 = mappedByteBuffer;
                    } else {
                        Context $this$loadTextures_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414 = this;
                        boolean bl4 = false;
                        if (size > 0x10000000L) {
                            throw new PmxLoadException("Texture too large! Maximum supported is 256M.");
                        }
                        int size2 = (int)size;
                        ByteBuffer buffer2 = ByteBuffer.allocateDirect(size2);
                        Intrinsics.checkNotNull((Object)channel);
                        ReadableByteChannel readableByteChannel = channel;
                        Intrinsics.checkNotNull((Object)buffer2);
                        ReadUtilKt.readAll(readableByteChannel, buffer2);
                        buffer2.flip();
                        if (buffer2.remaining() != size2) {
                            throw new PmxLoadException("Not read to texture's end, maybe a bug?");
                        }
                        byteBuffer2 = buffer2;
                    }
                    byteBuffer = byteBuffer2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                ByteBuffer buffer3 = byteBuffer;
                String string = "Texture " + pathString;
                Intrinsics.checkNotNull((Object)buffer3);
                collection.add(new Texture(pathString, new BufferView(new Buffer(string, buffer3), buffer3.remaining(), 0, 0), null, new Texture.Sampler(null, null, null, null, 15, null), 4, null));
            }
            context.textures = (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final void loadMaterials(ByteBuffer buffer) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            int materialCount = buffer.getInt();
            Iterable iterable = (Iterable)RangesKt.until((int)0, (int)materialCount);
            Context context = this;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                int n;
                int item$iv$iv;
                int n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = this.loadString(buffer);
                String string2 = this.loadString(buffer);
                RgbaColor rgbaColor = this.loadRgbaColor(buffer);
                RgbColor rgbColor = this.loadRgbColor(buffer);
                float f = buffer.getFloat();
                RgbColor rgbColor2 = this.loadRgbColor(buffer);
                PmxMaterial.DrawingFlags drawingFlags = Context.loadMaterials$loadDrawingFlags(buffer);
                RgbaColor rgbaColor2 = this.loadRgbaColor(buffer);
                float f2 = buffer.getFloat();
                int n3 = Context.loadMaterials$loadTextureIndex(this, buffer);
                int n4 = Context.loadMaterials$loadTextureIndex(this, buffer);
                byte mode = buffer.get();
                PmxMaterial.EnvironmentBlendMode environmentBlendMode = switch (mode) {
                    case 0 -> PmxMaterial.EnvironmentBlendMode.DISABLED;
                    case 1 -> PmxMaterial.EnvironmentBlendMode.MULTIPLY;
                    case 2 -> PmxMaterial.EnvironmentBlendMode.ADDICTIVE;
                    case 3 -> PmxMaterial.EnvironmentBlendMode.ADDITIONAL_VEC4;
                    default -> throw new PmxLoadException("Unsupported environment blend mode: " + mode);
                };
                byte type2 = buffer.get();
                PmxMaterial.ToonReference toonReference = switch (type2) {
                    case 0 -> new PmxMaterial.ToonReference.Texture(Context.loadMaterials$loadTextureIndex(this, buffer));
                    case 1 -> new PmxMaterial.ToonReference.Internal(UByte.constructor-impl((byte)buffer.get()), null);
                    default -> throw new PmxLoadException("Unsupported toon reference: " + type2);
                };
                int n5 = n = buffer.getInt();
                String string3 = this.loadString(buffer);
                PmxMaterial.ToonReference toonReference2 = toonReference;
                PmxMaterial.EnvironmentBlendMode environmentBlendMode2 = environmentBlendMode;
                int n6 = n4;
                int n7 = n3;
                float f3 = f2;
                RgbaColor rgbaColor3 = rgbaColor2;
                PmxMaterial.DrawingFlags drawingFlags2 = drawingFlags;
                RgbColor rgbColor3 = rgbColor2;
                float f4 = f;
                RgbColor rgbColor4 = rgbColor;
                RgbaColor rgbaColor4 = rgbaColor;
                String string4 = string2;
                String string5 = string;
                boolean bl2 = false;
                if (it < 0) {
                    throw new PmxLoadException("Material with " + (int)it + " vertices. Should be greater than zero.");
                }
                if (it % 3 != false) {
                    throw new PmxLoadException("Material with " + (int)it + " % 3 != 0 vertices.");
                }
                Unit unit = Unit.INSTANCE;
                int n8 = n;
                String string6 = string3;
                PmxMaterial.ToonReference toonReference3 = toonReference2;
                PmxMaterial.EnvironmentBlendMode environmentBlendMode3 = environmentBlendMode2;
                int n9 = n6;
                int n10 = n7;
                float f5 = f3;
                RgbaColor rgbaColor5 = rgbaColor3;
                PmxMaterial.DrawingFlags drawingFlags3 = drawingFlags2;
                RgbColor rgbColor5 = rgbColor3;
                float f6 = f4;
                RgbColor rgbColor6 = rgbColor4;
                RgbaColor rgbaColor6 = rgbaColor4;
                String string7 = string4;
                String string8 = string5;
                collection.add(new PmxMaterial(string8, string7, rgbaColor6, rgbColor6, f6, rgbColor5, drawingFlags3, rgbaColor5, f5, n10, n9, environmentBlendMode3, toonReference3, string6, n8));
            }
            context.materials = (List)destination$iv$iv;
        }

        private final Vector3f invertX(Vector3f $this$invertX) {
            Vector3f vector3f;
            Vector3f it = vector3f = $this$invertX;
            boolean bl = false;
            $this$invertX.x = -$this$invertX.x;
            return vector3f;
        }

        /*
         * WARNING - void declaration
         */
        private final void loadBones(ByteBuffer buffer) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            int boneCount = buffer.getInt();
            if (boneCount < 0) {
                throw new PmxLoadException("Bad PMX model: bones count less than zero");
            }
            Iterable iterable = (Iterable)RangesKt.until((int)0, (int)boneCount);
            Context context = this;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                PmxBone pmxBone;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                PmxBone bone = pmxBone = Context.loadBones$loadBone(this, buffer);
                boolean bl2 = false;
                Integer n2 = bone.getParentBoneIndex();
                if (n2 != null) {
                    Object object;
                    void $this$getOrPut$iv;
                    int parentBoneIndex = ((Number)n2).intValue();
                    boolean bl3 = false;
                    Map<Integer, List<Integer>> map2 = this.childBoneMap;
                    Integer key$iv = parentBoneIndex;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl4 = false;
                        List answer$iv = new ArrayList();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    ((List)object).add((int)index);
                } else {
                    Context $this$loadBones_u24lambda_u2427_u24lambda_u2426_u24lambda_u2425 = this;
                    boolean bl5 = false;
                    $this$loadBones_u24lambda_u2427_u24lambda_u2426_u24lambda_u2425.rootBones.add((int)index);
                }
                collection.add(pmxBone);
            }
            context.bones = (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final void loadMorphTargets(ByteBuffer buffer) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            int morphTargetCount = buffer.getInt();
            if (morphTargetCount < 0) {
                throw new PmxLoadException("Bad PMX model: morph targets count less than zero");
            }
            Iterable iterable = (Iterable)RangesKt.until((int)0, (int)morphTargetCount);
            Context context = this;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            if (iterator.hasNext()) {
                Object v2;
                block21: {
                    Object v0;
                    block20: {
                        int item$iv$iv;
                        int index = item$iv$iv = ((IntIterator)iterator).nextInt();
                        boolean bl = false;
                        String nameLocal = this.loadString(buffer);
                        String nameUniversal = this.loadString(buffer);
                        byte type2 = buffer.get();
                        boolean bl2 = false;
                        Iterable $this$firstOrNull$iv = (Iterable)PmxMorph.PanelType.getEntries();
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            PmxMorph.PanelType it = (PmxMorph.PanelType)((Object)element$iv);
                            boolean bl3 = false;
                            if (!(it.getValue() == type2)) continue;
                            v0 = element$iv;
                            break block20;
                        }
                        v0 = null;
                    }
                    PmxMorph.PanelType panelType = v0;
                    if (panelType == null) {
                        throw new PmxLoadException("Unknown panel type");
                    }
                    PmxMorph.PanelType panelType2 = panelType;
                    byte type3 = buffer.get();
                    boolean bl = false;
                    Iterable $this$firstOrNull$iv = (Iterable)PmxMorph.Type.getEntries();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        PmxMorph.Type it = (PmxMorph.Type)((Object)element$iv);
                        boolean bl4 = false;
                        if (!(it.getValue() == type3)) continue;
                        v2 = element$iv;
                        break block21;
                    }
                    v2 = null;
                }
                PmxMorph.Type type4 = v2;
                if (type4 == null) {
                    throw new PmxLoadException("Unknown panel type");
                }
                PmxMorph.Type morphType = type4;
                int offsetSize = buffer.getInt();
                if (offsetSize < 1) {
                    throw new PmxLoadException("Bad morph offset size: " + offsetSize);
                }
                switch (WhenMappings.$EnumSwitchMapping$0[morphType.ordinal()]) {
                    case 1: {
                        throw new NotImplementedError(null, 1, null);
                    }
                    case 2: {
                        throw new NotImplementedError(null, 1, null);
                    }
                    case 3: {
                        throw new NotImplementedError(null, 1, null);
                    }
                    case 4: {
                        throw new NotImplementedError(null, 1, null);
                    }
                    case 5: {
                        throw new NotImplementedError(null, 1, null);
                    }
                    case 6: {
                        throw new NotImplementedError(null, 1, null);
                    }
                    case 7: {
                        throw new NotImplementedError(null, 1, null);
                    }
                    case 8: {
                        throw new NotImplementedError(null, 1, null);
                    }
                    case 9: {
                        throw new NotImplementedError(null, 1, null);
                    }
                    case 10: {
                        throw new NotImplementedError(null, 1, null);
                    }
                    case 11: {
                        throw new NotImplementedError(null, 1, null);
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            context.morphTargets = (List)destination$iv$iv;
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final ModelFileLoader.Result load(@NotNull ByteBuffer buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            header = this.loadHeader(buffer);
            this.loadVertices(buffer);
            this.loadSurfaces(buffer);
            this.loadTextures(buffer);
            this.loadMaterials(buffer);
            this.loadBones(buffer);
            modelId = UUID.randomUUID();
            rootNodes = new ArrayList<E>();
            nextNodeId = new Ref.IntRef();
            jointIds = new LinkedHashMap<K, V>();
            $this$forEach$iv = this.rootBones;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                index = ((Number)element$iv).intValue();
                $i$a$-forEach-PmxLoader$Context$load$1 = false;
                rootNodes.add(Context.load$addBone$default(this, nextNodeId, modelId, jointIds, index, null, 32, null));
            }
            v0 = this.bones;
            if (v0 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bones");
                v0 = null;
            }
            $i$f$forEach = (Iterable)RangesKt.until((int)0, (int)v0.size());
            var25_21 = "PMX skin";
            $i$f$map = false;
            element$iv = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            var13_22 = $this$mapTo$iv$iv.iterator();
            while (var13_22.hasNext()) {
                var15_27 = item$iv$iv = ((IntIterator)var13_22).nextInt();
                var26_33 = destination$iv$iv;
                $i$a$-map-PmxLoader$Context$load$skin$1 = false;
                v1 = jointIds.get((int)it);
                Intrinsics.checkNotNull(v1);
                var26_33.add((NodeId)v1);
            }
            v2 = this.bones;
            if (v2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bones");
                v2 = null;
            }
            $this$map$iv = v2;
            var26_33 = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                it = (PmxBone)item$iv$iv;
                var27_34 = destination$iv$iv;
                $i$a$-map-PmxLoader$Context$load$skin$2 = false;
                var27_34.add(new Matrix4f().translation((Vector3fc)it.getPosition()).invertAffine());
            }
            var27_34 = (List)destination$iv$iv;
            v3 = this.bones;
            if (v3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bones");
                v3 = null;
            }
            $this$map$iv = v3;
            var28_35 = null;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                it = (PmxBone)item$iv$iv;
                var29_36 = destination$iv$iv;
                $i$a$-map-PmxLoader$Context$load$skin$3 = false;
                v4 = HumanoidTag.Companion.fromPmxJapanese(it.getNameLocal());
                if (v4 == null) {
                    v4 = HumanoidTag.Companion.fromPmxEnglish(it.getNameUniversal());
                }
                var29_36.add(v4);
            }
            var29_36 = (List)destination$iv$iv;
            var30_37 = null;
            var31_38 = 8;
            var32_39 = var29_36;
            var33_40 = var28_35;
            var34_41 = var27_34;
            var35_42 = var26_33;
            var36_43 = var25_21;
            skin = new Skin(var36_43, (List)var35_42, (List)var34_41, var33_40, (List)var32_39, var31_38, var30_37);
            indexOffset = 0;
            v5 = this.materials;
            if (v5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"materials");
                v5 = null;
            }
            $this$forEach$iv = v5;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                pmxMaterial = (PmxMaterial)element$iv;
                $i$a$-forEach-PmxLoader$Context$load$2 = false;
                it = nextNodeId.element;
                nextNodeId.element = it + 1;
                nodeId = it;
                var17_44 = pmxMaterial.getTextureIndex();
                var18_45 = ((Number)var17_44).intValue();
                var19_47 = pmxMaterial.getDiffuseColor();
                var20_48 = pmxMaterial.getNameLocal();
                $i$a$-takeIf-PmxLoader$Context$load$2$material$1 = 0;
                var22_51 = it >= 0;
                v6 = var20_48;
                v7 = var19_47;
                v8 = var23_53 = var22_51 != false ? var17_44 : null;
                if (var23_53 == null) ** GOTO lbl-1000
                $i$a$-takeIf-PmxLoader$Context$load$2$material$1 = ((Number)var23_53).intValue();
                var19_47 = v7;
                var20_48 = v6;
                $i$a$-let-PmxLoader$Context$load$2$material$2 = false;
                v9 = this.textures;
                if (v9 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"textures");
                    v9 = null;
                }
                if ((Texture)CollectionsKt.getOrNull(v9, (int)it) == null) {
                    throw new PmxLoadException("Bad texture index: " + (int)it);
                }
                v6 = var20_48;
                v7 = var19_47;
                var17_44 = var22_52;
                if (var17_44 != null) {
                    it = var17_44;
                    var19_47 = v7;
                    var20_48 = v6;
                    $i$a$-let-PmxLoader$Context$load$2$material$3 = false;
                    var22_52 = new Material.TextureInfo((Texture)it, 0, 2, null);
                    v6 = var20_48;
                    v7 = var19_47;
                    v10 = var22_52;
                } else lbl-1000:
                // 2 sources

                {
                    v10 = null;
                }
                var37_55 = null;
                var38_56 = 24;
                var39_57 = pmxMaterial.getDrawingFlags().getNoCull();
                var40_58 = 0.0f;
                var41_59 = null;
                var42_60 = v10;
                var43_61 = v7;
                var44_62 = v6;
                material = new Material.Unlit(var44_62, var43_61, (Material.TextureInfo)var42_60, var41_59, var40_58, var39_57, var38_56, var37_55);
                var23_53 = "Node for material " + pmxMaterial.getNameLocal();
                Intrinsics.checkNotNull((Object)modelId);
                var17_44 = new NodeId(modelId, nodeId);
                v11 = new MeshId(modelId, nodeId);
                v12 = material;
                v13 = this.vertexAttributes;
                if (v13 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"vertexAttributes");
                    v13 = null;
                }
                if ((v14 = this.indexBufferView) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"indexBufferView");
                    v14 = null;
                }
                if ((v15 = this.indexBufferType) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"indexBufferType");
                    v15 = null;
                }
                v16 = indexOffset * v15.getByteLength();
                v17 = this.indexBufferType;
                if (v17 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"indexBufferType");
                    v17 = null;
                }
                it = new Mesh(v11, CollectionsKt.listOf((Object)new Primitive(Primitive.Mode.TRIANGLES, v12, v13, new Accessor(v14, v16, v17, false, pmxMaterial.getSurfaceCount(), Accessor.AccessorType.SCALAR, null, null, null, 448, null), CollectionsKt.emptyList())), null, null, 4, null);
                it = var23_53 = new Node((String)var23_53, (NodeId)var17_44, null, null, it, skin, 12, null);
                $i$a$-also-PmxLoader$Context$load$2$1 = false;
                rootNodes.add(it);
                indexOffset += pmxMaterial.getSurfaceCount();
            }
            scene = new Scene(rootNodes, new NodeTransform.Decomposed(null, null, new Vector3f(0.1f), 3, null));
            var10_16 = CollectionsKt.listOf((Object)scene);
            var11_18 = CollectionsKt.listOf((Object)skin);
            return new ModelFileLoader.Result(new Metadata(header.getModelNameLocal(), header.getModelNameUniversal(), header.getCommentLocal(), header.getCommentUniversal(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0xFFFFF0, null), new Model(var10_16, scene, var11_18, null, 8, null), CollectionsKt.emptyList());
        }

        private static final float loadVertices$readFloat(ByteBuffer $buffer, Ref.IntRef inputPosition) {
            float f;
            float it = f = $buffer.getFloat(inputPosition.element);
            boolean bl = false;
            inputPosition.element += 4;
            return f;
        }

        private static final int loadVertices$readBoneIndex(int boneIndexSize, ByteBuffer $buffer, Ref.IntRef inputPosition) {
            short index = switch (boneIndexSize) {
                case 1 -> $buffer.get(inputPosition.element);
                case 2 -> $buffer.getShort(inputPosition.element);
                case 4 -> (short)$buffer.getInt(inputPosition.element);
                default -> throw new AssertionError();
            };
            inputPosition.element += boneIndexSize;
            return index;
        }

        private static final float loadVertices$readWeight(ByteBuffer $buffer, Ref.IntRef inputPosition) {
            float f;
            float it = f = $buffer.getFloat(inputPosition.element);
            boolean bl = false;
            inputPosition.element += 4;
            return f;
        }

        private static final Vector3f loadVertices$readVector3f(ByteBuffer $buffer, Ref.IntRef inputPosition, Vector3f dst) {
            Vector3f vector3f;
            Vector3f it = vector3f = dst;
            boolean bl = false;
            dst.set($buffer.getFloat(inputPosition.element), $buffer.getFloat(inputPosition.element + 4), $buffer.getFloat(inputPosition.element + 8));
            inputPosition.element += 12;
            return vector3f;
        }

        private static final boolean loadMaterials$loadDrawingFlags$loadBitfield(int n, int index) {
            return (n & 1 << index) != 0;
        }

        private static final PmxMaterial.DrawingFlags loadMaterials$loadDrawingFlags(ByteBuffer buffer) {
            int n = UByte.constructor-impl((byte)buffer.get()) & 0xFF;
            return new PmxMaterial.DrawingFlags(Context.loadMaterials$loadDrawingFlags$loadBitfield(n, 0), Context.loadMaterials$loadDrawingFlags$loadBitfield(n, 1), Context.loadMaterials$loadDrawingFlags$loadBitfield(n, 2), Context.loadMaterials$loadDrawingFlags$loadBitfield(n, 3), Context.loadMaterials$loadDrawingFlags$loadBitfield(n, 4), Context.loadMaterials$loadDrawingFlags$loadBitfield(n, 5), Context.loadMaterials$loadDrawingFlags$loadBitfield(n, 6), Context.loadMaterials$loadDrawingFlags$loadBitfield(n, 7));
        }

        private static final int loadMaterials$loadTextureIndex(Context this$0, ByteBuffer buffer) {
            PmxGlobals pmxGlobals = this$0.globals;
            if (pmxGlobals == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"globals");
                pmxGlobals = null;
            }
            return switch (pmxGlobals.getTextureIndexSize()) {
                case 1 -> buffer.get();
                case 2 -> buffer.getShort();
                case 4 -> (short)buffer.getInt();
                default -> throw new AssertionError();
            };
        }

        private static final int loadBones$loadBoneIndex(Context this$0, ByteBuffer buffer) {
            PmxGlobals pmxGlobals = this$0.globals;
            if (pmxGlobals == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"globals");
                pmxGlobals = null;
            }
            return switch (pmxGlobals.getBoneIndexSize()) {
                case 1 -> buffer.get();
                case 2 -> buffer.getShort();
                case 4 -> (short)buffer.getInt();
                default -> throw new AssertionError();
            };
        }

        private static final boolean loadBones$loadBoneFlags$loadBitfield$20(int flags, int index) {
            return (flags & 1 << index) != 0;
        }

        private static final PmxBone.Flags loadBones$loadBoneFlags(ByteBuffer buffer) {
            short flags = buffer.getShort();
            return new PmxBone.Flags(Context.loadBones$loadBoneFlags$loadBitfield$20(flags, 0), Context.loadBones$loadBoneFlags$loadBitfield$20(flags, 1), Context.loadBones$loadBoneFlags$loadBitfield$20(flags, 2), Context.loadBones$loadBoneFlags$loadBitfield$20(flags, 3), Context.loadBones$loadBoneFlags$loadBitfield$20(flags, 4), Context.loadBones$loadBoneFlags$loadBitfield$20(flags, 5), Context.loadBones$loadBoneFlags$loadBitfield$20(flags, 8), Context.loadBones$loadBoneFlags$loadBitfield$20(flags, 9), Context.loadBones$loadBoneFlags$loadBitfield$20(flags, 10), Context.loadBones$loadBoneFlags$loadBitfield$20(flags, 11), Context.loadBones$loadBoneFlags$loadBitfield$20(flags, 12), Context.loadBones$loadBoneFlags$loadBitfield$20(flags, 13));
        }

        /*
         * WARNING - void declaration
         */
        private static final PmxBone loadBones$loadBone(Context this$0, ByteBuffer buffer) {
            void it;
            PmxBone.IkData ikData;
            int loopCount;
            Integer externalParentIndex;
            String nameLocal = this$0.loadString(buffer);
            String nameUniversal = this$0.loadString(buffer);
            Vector3f position = this$0.invertX(this$0.loadVector3f(buffer));
            int parentBoneIndex = Context.loadBones$loadBoneIndex(this$0, buffer);
            int layer = buffer.getInt();
            PmxBone.Flags flags = Context.loadBones$loadBoneFlags(buffer);
            PmxBone.TailPosition tailPosition = flags.getIndexedTailPosition() ? (PmxBone.TailPosition)new PmxBone.TailPosition.Indexed(Context.loadBones$loadBoneIndex(this$0, buffer)) : (PmxBone.TailPosition)new PmxBone.TailPosition.Scalar(this$0.invertX(this$0.loadVector3f(buffer)));
            Pair inheritParent = flags.getInheritRotation() || flags.getInheritTranslation() ? new Pair((Object)Context.loadBones$loadBoneIndex(this$0, buffer), (Object)Float.valueOf(buffer.getFloat())) : null;
            Vector3f axisDirection = flags.getFixedAxis() ? this$0.invertX(this$0.loadVector3f(buffer)) : null;
            PmxBone.LocalCoordinate localCoordinate = flags.getLocalCoordinate() ? new PmxBone.LocalCoordinate(this$0.invertX(this$0.loadVector3f(buffer)), this$0.invertX(this$0.loadVector3f(buffer))) : null;
            Integer n = externalParentIndex = flags.getExternalParentDeform() ? Integer.valueOf(Context.loadBones$loadBoneIndex(this$0, buffer)) : null;
            if (flags.getIk()) {
                void $this$mapTo$iv$iv;
                int targetIndex = Context.loadBones$loadBoneIndex(this$0, buffer);
                loopCount = buffer.getInt();
                float limitRadian = buffer.getFloat();
                int linkCount = buffer.getInt();
                Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)linkCount);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    int item$iv$iv;
                    int n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    int index = Context.loadBones$loadBoneIndex(this$0, buffer);
                    PmxBone.IkLink.Limits limits = buffer.get() != 0 ? new PmxBone.IkLink.Limits(this$0.invertX(this$0.loadVector3f(buffer)), this$0.invertX(this$0.loadVector3f(buffer))) : null;
                    collection.add(new PmxBone.IkLink(index, limits));
                }
                List links = (List)destination$iv$iv;
                ikData = new PmxBone.IkData(targetIndex, loopCount, limitRadian, links);
            } else {
                ikData = null;
            }
            PmxBone.IkData ikData2 = ikData;
            Integer n3 = parentBoneIndex;
            loopCount = ((Number)n3).intValue();
            Vector3f vector3f = position;
            String string = nameUniversal;
            String string2 = nameLocal;
            boolean bl = false;
            boolean bl2 = it >= 0;
            Pair pair = inheritParent;
            Pair pair2 = inheritParent;
            PmxBone.IkData ikData3 = ikData2;
            Integer n4 = externalParentIndex;
            PmxBone.LocalCoordinate localCoordinate2 = localCoordinate;
            Vector3f vector3f2 = axisDirection;
            Float f = pair2 != null ? (Float)pair2.getSecond() : null;
            Integer n5 = pair != null ? (Integer)pair.getFirst() : null;
            PmxBone.TailPosition tailPosition2 = tailPosition;
            PmxBone.Flags flags2 = flags;
            int n6 = layer;
            Integer n7 = bl2 ? n3 : null;
            Vector3f vector3f3 = vector3f;
            String string3 = string;
            String string4 = string2;
            return new PmxBone(string4, string3, vector3f3, n7, n6, flags2, tailPosition2, n5, f, vector3f2, localCoordinate2, n4, ikData3);
        }

        /*
         * WARNING - void declaration
         */
        private static final Node load$addBone(Context this$0, Ref.IntRef nextNodeId, UUID modelId, Map<Integer, NodeId> jointIds, int index, Vector3f parentPosition) {
            List list2;
            Iterable $this$map$iv;
            List<PmxBone> list3 = this$0.bones;
            if (list3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bones");
                list3 = null;
            }
            PmxBone bone = list3.get(index);
            int n = nextNodeId.element;
            nextNodeId.element = n + 1;
            int nodeIndex = n;
            Intrinsics.checkNotNull((Object)modelId);
            NodeId nodeId = new NodeId(modelId, nodeIndex);
            Integer n2 = index;
            jointIds.put(n2, nodeId);
            List<Integer> list4 = this$0.childBoneMap.get(index);
            if (list4 != null) {
                void $this$mapTo$iv$iv;
                $this$map$iv = list4;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    int n3 = ((Number)item$iv$iv).intValue();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(Context.load$addBone(this$0, nextNodeId, modelId, jointIds, (int)it, bone.getPosition()));
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = CollectionsKt.emptyList();
            }
            List children = list2;
            Vector3f vector3f = new Vector3f().set((Vector3fc)bone.getPosition());
            $this$map$iv = vector3f;
            List list5 = children;
            NodeId nodeId2 = nodeId;
            String string = bone.getNameLocal();
            boolean bl = false;
            if (parentPosition != null) {
                void it;
                it.sub((Vector3fc)parentPosition);
            }
            Unit unit = Unit.INSTANCE;
            Vector3f vector3f2 = vector3f;
            Intrinsics.checkNotNullExpressionValue((Object)vector3f2, (String)"also(...)");
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n4 = 6;
            Vector3f vector3f3 = null;
            Quaternionf quaternionf = null;
            Vector3f vector3f4 = vector3f2;
            DefaultConstructorMarker defaultConstructorMarker2 = null;
            int n5 = 48;
            Skin skin = null;
            Mesh mesh = null;
            NodeTransform nodeTransform = new NodeTransform.Decomposed(vector3f4, quaternionf, vector3f3, n4, defaultConstructorMarker);
            List list6 = list5;
            NodeId nodeId3 = nodeId2;
            String string2 = string;
            return new Node(string2, nodeId3, list6, nodeTransform, mesh, skin, n5, defaultConstructorMarker2);
        }

        static /* synthetic */ Node load$addBone$default(Context context, Ref.IntRef intRef, UUID uUID, Map map2, int n, Vector3f vector3f, int n2, Object object) {
            if ((n2 & 0x20) != 0) {
                vector3f = null;
            }
            return Context.load$addBone(context, intRef, uUID, map2, n, vector3f);
        }

        public static final /* synthetic */ PmxGlobals access$getGlobals$p(Context $this) {
            return $this.globals;
        }

        @kotlin.Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[PmxMorph.Type.values().length];
                try {
                    nArray[PmxMorph.Type.GROUP.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PmxMorph.Type.VERTEX.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PmxMorph.Type.BONE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PmxMorph.Type.UV.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PmxMorph.Type.UV_EXT1.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PmxMorph.Type.UV_EXT2.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PmxMorph.Type.UV_EXT3.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PmxMorph.Type.UV_EXT4.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PmxMorph.Type.MATERIAL.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PmxMorph.Type.FLIP.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PmxMorph.Type.IMPULSE.ordinal()] = 11;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

