/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.renderer.model.util;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a(\u0010\u0005\u001a\u00020\u0006*\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00012\u000e\b\u0004\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u0086\b\u00f8\u0001\u0000\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\u0004\u001a\n\u0010\f\u001a\u00020\u000b*\u00020\u0004\u001a\n\u0010\r\u001a\u00020\u000b*\u00020\u0004\u001a\n\u0010\u000e\u001a\u00020\u000b*\u00020\u0004\u001a\n\u0010\u000f\u001a\u00020\u000b*\u00020\u0004\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0010"}, d2={"readAll", "", "Ljava/nio/channels/ReadableByteChannel;", "buffer", "Ljava/nio/ByteBuffer;", "withRelativeLimit", "", "relativeLimit", "func", "Lkotlin/Function0;", "getUByteNormalized", "", "getSByteNormalized", "getUShortNormalized", "getSShortNormalized", "getUIntNormalized", "model_model-base-model-base"})
public final class ReadUtilKt {
    public static final int readAll(@NotNull ReadableByteChannel $this$readAll, @NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)$this$readAll, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int length = 0;
        block4: while (buffer.hasRemaining()) {
            int len = $this$readAll.read(buffer);
            switch (len) {
                case -1: {
                    break block4;
                }
                case 0: {
                    throw new IllegalStateException("Buffer is not blocking");
                }
                default: {
                    length += len;
                    continue block4;
                }
            }
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void withRelativeLimit(@NotNull ByteBuffer $this$withRelativeLimit, int relativeLimit, @NotNull Function0<Unit> func) {
        Intrinsics.checkNotNullParameter((Object)$this$withRelativeLimit, (String)"<this>");
        Intrinsics.checkNotNullParameter(func, (String)"func");
        boolean $i$f$withRelativeLimit = false;
        int oldLimit = $this$withRelativeLimit.limit();
        int newLimit = $this$withRelativeLimit.position() + relativeLimit;
        if (newLimit > oldLimit) {
            throw new BufferOverflowException();
        }
        $this$withRelativeLimit.limit(newLimit);
        try {
            func.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            $this$withRelativeLimit.limit(oldLimit);
            InlineMarker.finallyEnd((int)1);
        }
    }

    public static final float getUByteNormalized(@NotNull ByteBuffer $this$getUByteNormalized) {
        Intrinsics.checkNotNullParameter((Object)$this$getUByteNormalized, (String)"<this>");
        return (float)$this$getUByteNormalized.get() / 255.0f;
    }

    public static final float getSByteNormalized(@NotNull ByteBuffer $this$getSByteNormalized) {
        Intrinsics.checkNotNullParameter((Object)$this$getSByteNormalized, (String)"<this>");
        return RangesKt.coerceAtLeast((float)((float)$this$getSByteNormalized.get() / 127.0f), (float)-1.0f);
    }

    public static final float getUShortNormalized(@NotNull ByteBuffer $this$getUShortNormalized) {
        Intrinsics.checkNotNullParameter((Object)$this$getUShortNormalized, (String)"<this>");
        return (float)$this$getUShortNormalized.getShort() / 65535.0f;
    }

    public static final float getSShortNormalized(@NotNull ByteBuffer $this$getSShortNormalized) {
        Intrinsics.checkNotNullParameter((Object)$this$getSShortNormalized, (String)"<this>");
        return RangesKt.coerceAtLeast((float)((float)$this$getSShortNormalized.getShort() / 32767.0f), (float)-1.0f);
    }

    public static final float getUIntNormalized(@NotNull ByteBuffer $this$getUIntNormalized) {
        Intrinsics.checkNotNullParameter((Object)$this$getUIntNormalized, (String)"<this>");
        return RangesKt.coerceAtLeast((float)((float)$this$getUIntNormalized.getInt() / 4.2949673E9f), (float)-1.0f);
    }
}

