/*
 * Decompiled with CFR 0.152.
 */
package top.fifthlight.renderer.model.vmd;

import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatList;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import top.fifthlight.renderer.model.HumanoidTag;
import top.fifthlight.renderer.model.ModelFileLoader;
import top.fifthlight.renderer.model.animation.Animation;
import top.fifthlight.renderer.model.animation.AnimationChannel;
import top.fifthlight.renderer.model.animation.AnimationChannelKt;
import top.fifthlight.renderer.model.animation.AnimationInterpolation;
import top.fifthlight.renderer.model.animation.AnimationKeyFrameData;
import top.fifthlight.renderer.model.animation.AnimationKeyFrameDataKt;
import top.fifthlight.renderer.model.animation.ListAnimationKeyFrameIndexer;
import top.fifthlight.renderer.model.animation.SimpleAnimationChannel;
import top.fifthlight.renderer.model.util.ReadUtilKt;
import top.fifthlight.renderer.model.vmd.VmdLoadException;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001+B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u000eH\u0002J\u0010\u0010!\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001a\u0010$\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030%0\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\fR\u0018\u0010\u0018\u001a\n \u001a*\u0004\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u0018\u0010\u001c\u001a\n \u001a*\u0004\u0018\u00010\u001d0\u001dX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001eR\u000e\u0010\"\u001a\u00020#X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Ltop/fifthlight/renderer/model/vmd/VmdLoader;", "Ltop/fifthlight/renderer/model/ModelFileLoader;", "<init>", "()V", "OLD_VMD_SIGNATURE", "", "NEW_VMD_SIGNATURE", "VMD_SIGNATURES", "", "extensions", "", "getExtensions", "()Ljava/util/List;", "probeLength", "", "getProbeLength", "()I", "abilities", "Ltop/fifthlight/renderer/model/ModelFileLoader$Ability;", "getAbilities", "probe", "", "buffer", "Ljava/nio/ByteBuffer;", "SHIFT_JIS", "Ljava/nio/charset/Charset;", "kotlin.jvm.PlatformType", "Ljava/nio/charset/Charset;", "decoder", "Ljava/nio/charset/CharsetDecoder;", "Ljava/nio/charset/CharsetDecoder;", "loadString", "maxLength", "loadHeader", "FRAME_TIME_SEC", "", "loadBone", "Ltop/fifthlight/renderer/model/animation/AnimationChannel;", "load", "Ltop/fifthlight/renderer/model/ModelFileLoader$Result;", "path", "Ljava/nio/file/Path;", "basePath", "BoneChannel", "model_model-vmd-model-vmd"})
@SourceDebugExtension(value={"SMAP\nVmdLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VmdLoader.kt\ntop/fifthlight/renderer/model/vmd/VmdLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,170:1\n1755#2,3:171\n346#2,8:174\n1734#2,3:195\n381#3,7:182\n77#4:189\n97#4,5:190\n1#5:198\n*S KotlinDebug\n*F\n+ 1 VmdLoader.kt\ntop/fifthlight/renderer/model/vmd/VmdLoader\n*L\n28#1:171,3\n46#1:174,8\n58#1:195,3\n89#1:182,7\n105#1:189\n105#1:190,5\n*E\n"})
public final class VmdLoader
implements ModelFileLoader {
    @NotNull
    public static final VmdLoader INSTANCE = new VmdLoader();
    @NotNull
    private static final byte[] OLD_VMD_SIGNATURE;
    @NotNull
    private static final byte[] NEW_VMD_SIGNATURE;
    @NotNull
    private static final List<byte[]> VMD_SIGNATURES;
    @NotNull
    private static final List<String> extensions;
    private static final int probeLength;
    @NotNull
    private static final List<ModelFileLoader.Ability> abilities;
    private static final Charset SHIFT_JIS;
    private static final CharsetDecoder decoder;
    private static final float FRAME_TIME_SEC = 0.041666668f;

    private VmdLoader() {
    }

    @Override
    @NotNull
    public List<String> getExtensions() {
        return extensions;
    }

    @Override
    public int getProbeLength() {
        return probeLength;
    }

    @Override
    @NotNull
    public List<ModelFileLoader.Ability> getAbilities() {
        return abilities;
    }

    @Override
    public boolean probe(@NotNull ByteBuffer buffer) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Iterable $this$any$iv = VMD_SIGNATURES;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    byte[] signature = (byte[])element$iv;
                    boolean bl2 = false;
                    int lastPosition = buffer.position();
                    if (buffer.remaining() < signature.length) {
                        return false;
                    }
                    byte[] signatureBytes = new byte[signature.length];
                    buffer.get(signatureBytes, 0, signature.length);
                    buffer.position(lastPosition);
                    if (!Arrays.equals(signatureBytes, signature)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final String loadString(ByteBuffer buffer, int maxLength) {
        int n;
        ByteBuffer bytes;
        block3: {
            bytes = ByteBuffer.allocate(maxLength);
            bytes.put(buffer.slice(buffer.position(), maxLength));
            buffer.position(buffer.position() + maxLength);
            Iterable $this$indexOfFirst$iv = (Iterable)RangesKt.until((int)0, (int)maxLength);
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                int item$iv = ((IntIterator)iterator).nextInt();
                if (index$iv < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int it = item$iv;
                boolean bl = false;
                if (bytes.get(it) == 0) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = -1;
        }
        int nullIndex = n;
        ByteBuffer stringBytes = bytes.slice(0, nullIndex).order(ByteOrder.LITTLE_ENDIAN);
        String string = decoder.decode(stringBytes).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String loadHeader(ByteBuffer buffer) {
        boolean bl;
        byte[] signature = new byte[30];
        buffer.get(signature);
        if (VmdLoader.loadHeader$compareSignature(signature, OLD_VMD_SIGNATURE)) {
            bl = false;
        } else if (VmdLoader.loadHeader$compareSignature(signature, NEW_VMD_SIGNATURE)) {
            bl = true;
        } else {
            throw new VmdLoadException("Bad VMD file signature");
        }
        boolean isNewFormat = bl;
        return isNewFormat ? this.loadString(buffer, 20) : this.loadString(buffer, 10);
    }

    /*
     * WARNING - void declaration
     */
    private final List<AnimationChannel<?>> loadBone(ByteBuffer buffer) {
        void $this$flatMapTo$iv$iv;
        Map channels = new LinkedHashMap();
        int boneKeyframeCount = buffer.getInt();
        for (int j = 0; j < boneKeyframeCount; ++j) {
            int it;
            Object object;
            int it2 = j;
            boolean bl = false;
            String boneName = INSTANCE.loadString(buffer, 15);
            Map $this$getOrPut$iv = channels;
            boolean $i$f$getOrPut = false;
            Object value$iv22 = $this$getOrPut$iv.get(boneName);
            if (value$iv22 == null) {
                boolean bl2 = false;
                BoneChannel answer$iv = new BoneChannel();
                $this$getOrPut$iv.put(boneName, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv22;
            }
            BoneChannel channel = (BoneChannel)object;
            int frameNumber = buffer.getInt();
            float frameTime = (float)frameNumber * 0.041666668f;
            channel.getIndexList().add(frameTime);
            int value$iv22 = 3;
            int answer$iv = 0;
            while (answer$iv < value$iv22) {
                it = answer$iv++;
                boolean bl3 = false;
                channel.getTranslationList().add(buffer.getFloat());
            }
            value$iv22 = 4;
            answer$iv = 0;
            while (answer$iv < value$iv22) {
                it = answer$iv++;
                boolean bl4 = false;
                channel.getRotationList().add(buffer.getFloat());
            }
            buffer.position(buffer.position() + 64);
        }
        Map $this$flatMap$iv = channels;
        boolean $i$f$flatMap = false;
        Map bl = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry answer$iv = element$iv$iv = iterator.next();
            boolean bl5 = false;
            String name = (String)answer$iv.getKey();
            BoneChannel channel = (BoneChannel)answer$iv.getValue();
            ListAnimationKeyFrameIndexer indexer = new ListAnimationKeyFrameIndexer((FloatList)channel.getIndexList());
            Object[] objectArray = new SimpleAnimationChannel[]{AnimationChannelKt.Vector3fSimpleAnimationChannel(AnimationChannel.Type.Translation.INSTANCE, null, name, HumanoidTag.Companion.fromPmxJapanese(name), indexer, (AnimationKeyFrameData<Vector3f>)AnimationKeyFrameDataKt.ofVector3f(AnimationKeyFrameData.Companion, (FloatList)channel.getTranslationList(), 1), AnimationInterpolation.LINEAR), AnimationChannelKt.QuaternionfSimpleAnimationChannel(AnimationChannel.Type.Rotation.INSTANCE, null, name, HumanoidTag.Companion.fromPmxJapanese(name), indexer, (AnimationKeyFrameData<Quaternionf>)AnimationKeyFrameDataKt.ofQuaternionf(AnimationKeyFrameData.Companion, (FloatList)channel.getRotationList(), 1), AnimationInterpolation.LINEAR)};
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final ModelFileLoader.Result load(ByteBuffer buffer) {
        String modelName = this.loadHeader(buffer);
        List<AnimationChannel<?>> boneChannels = this.loadBone(buffer);
        return new ModelFileLoader.Result(null, null, CollectionsKt.listOf((Object)new Animation(null, boneChannels, 1, null)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ModelFileLoader.Result load(@NotNull Path path, @NotNull Path basePath) {
        ModelFileLoader.Result result;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Object object = new OpenOption[]{StandardOpenOption.READ};
        object = FileChannel.open(path, object);
        Throwable throwable = null;
        try {
            ByteBuffer byteBuffer;
            Object $this$load_u24lambda_u2410_u24lambda_u248;
            FileChannel channel = (FileChannel)object;
            boolean bl = false;
            long fileSize = channel.size();
            Object object2 = INSTANCE;
            try {
                $this$load_u24lambda_u2410_u24lambda_u248 = object2;
                boolean bl2 = false;
                $this$load_u24lambda_u2410_u24lambda_u248 = Result.constructor-impl((Object)channel.map(FileChannel.MapMode.READ_ONLY, 0L, fileSize));
            }
            catch (Throwable bl2) {
                $this$load_u24lambda_u2410_u24lambda_u248 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object2 = $this$load_u24lambda_u2410_u24lambda_u248;
            MappedByteBuffer mappedByteBuffer = (MappedByteBuffer)(Result.isFailure-impl((Object)object2) ? null : object2);
            if (mappedByteBuffer != null) {
                byteBuffer = mappedByteBuffer;
            } else {
                VmdLoader $this$load_u24lambda_u2410_u24lambda_u249 = INSTANCE;
                boolean bl3 = false;
                if (fileSize > 0x2000000L) {
                    throw new VmdLoadException("VMD animation size too large: maximum allowed is 32M, current is " + fileSize);
                }
                int fileSize2 = (int)fileSize;
                ByteBuffer buffer = ByteBuffer.allocate(fileSize2);
                Intrinsics.checkNotNull((Object)channel);
                ReadableByteChannel readableByteChannel = channel;
                Intrinsics.checkNotNull((Object)buffer);
                ReadUtilKt.readAll(readableByteChannel, buffer);
                buffer.flip();
                if (channel.position() != (long)fileSize2) {
                    throw new VmdLoadException("Not read to file's end, maybe a bug?");
                }
                byteBuffer = buffer;
            }
            ByteBuffer buffer = byteBuffer;
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            Intrinsics.checkNotNull((Object)buffer);
            result = INSTANCE.load(buffer);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return result;
    }

    private static final boolean loadHeader$compareSignature(byte[] target, byte[] source) {
        boolean bl;
        block4: {
            if (target.length < source.length) {
                return false;
            }
            Iterable $this$all$iv = (Iterable)RangesKt.until((int)0, (int)source.length);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator = $this$all$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    if (source[it] == target[it]) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    static {
        Object object = "Vocaloid Motion Data file";
        byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        OLD_VMD_SIGNATURE = byArray;
        object = "Vocaloid Motion Data 0002";
        byte[] byArray2 = ((String)object).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        NEW_VMD_SIGNATURE = byArray2;
        object = new byte[2][];
        object[0] = OLD_VMD_SIGNATURE;
        object[1] = NEW_VMD_SIGNATURE;
        VMD_SIGNATURES = CollectionsKt.listOf((Object[])((Object[])object));
        extensions = CollectionsKt.listOf((Object)"vmd");
        Iterator iterator = ((Iterable)VMD_SIGNATURES).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        byte[] it = (byte[])iterator.next();
        boolean bl = false;
        int n = it.length;
        while (iterator.hasNext()) {
            byte[] it2 = (byte[])iterator.next();
            $i$a$-maxOf-VmdLoader$probeLength$1 = false;
            int n2 = it2.length;
            if (n >= n2) continue;
            n = n2;
        }
        probeLength = n;
        abilities = CollectionsKt.listOf((Object)((Object)ModelFileLoader.Ability.ANIMATION));
        SHIFT_JIS = Charset.forName("Shift-JIS");
        decoder = SHIFT_JIS.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\f"}, d2={"Ltop/fifthlight/renderer/model/vmd/VmdLoader$BoneChannel;", "", "<init>", "()V", "indexList", "Lit/unimi/dsi/fastutil/floats/FloatArrayList;", "getIndexList", "()Lit/unimi/dsi/fastutil/floats/FloatArrayList;", "translationList", "getTranslationList", "rotationList", "getRotationList", "model_model-vmd-model-vmd"})
    private static final class BoneChannel {
        @NotNull
        private final FloatArrayList indexList = new FloatArrayList();
        @NotNull
        private final FloatArrayList translationList = new FloatArrayList();
        @NotNull
        private final FloatArrayList rotationList = new FloatArrayList();

        @NotNull
        public final FloatArrayList getIndexList() {
            return this.indexList;
        }

        @NotNull
        public final FloatArrayList getTranslationList() {
            return this.translationList;
        }

        @NotNull
        public final FloatArrayList getRotationList() {
            return this.rotationList;
        }
    }
}

