/*
 * Decompiled with CFR 0.152.
 */
package com.zerofall.ezstorage.block;

import com.zerofall.ezstorage.EZStorage;
import com.zerofall.ezstorage.block.EZBlockContainer;
import com.zerofall.ezstorage.integration.IntegrationUtils;
import com.zerofall.ezstorage.network.server.MsgStorage;
import com.zerofall.ezstorage.tileentity.TileEntityStorageCore;
import com.zerofall.ezstorage.util.EZInventory;
import com.zerofall.ezstorage.util.EZInventoryManager;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class BlockStorageCore
extends EZBlockContainer {
    public BlockStorageCore() {
        super("storage_core", Material.wood);
        this.setResistance(6000.0f);
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new TileEntityStorageCore();
    }

    @Override
    public void breakBlock(World worldIn, int x, int y, int z, Block blockBroken, int meta) {
        TileEntity te = worldIn.getTileEntity(x, y, z);
        if (te instanceof TileEntityStorageCore) {
            TileEntityStorageCore core = (TileEntityStorageCore)te;
            EZInventory inventory = EZInventoryManager.getInventory(core.inventoryId);
            if (inventory != null) {
                EZInventoryManager.deleteInventory(inventory);
            }
        }
        super.breakBlock(worldIn, x, y, z, blockBroken, meta);
    }

    public boolean onBlockActivated(World worldIn, int x, int y, int z, EntityPlayer player, int side, float subX, float subY, float subZ) {
        if (!worldIn.isRemote && player instanceof EntityPlayerMP) {
            TileEntityStorageCore core;
            EZInventory inventory;
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            TileEntity tileEntity = worldIn.getTileEntity(x, y, z);
            if (tileEntity instanceof TileEntityStorageCore && (inventory = (core = (TileEntityStorageCore)tileEntity).getInventory()) != null) {
                boolean enableCraftingGrid = core.hasCraftBox && !IntegrationUtils.isSpectatorMode((EntityPlayer)playerMP);
                EZStorage.instance.guiHandler.inventoryIds.put((EntityPlayer)playerMP, inventory.id);
                player.openGui((Object)EZStorage.instance, enableCraftingGrid ? 2 : 1, worldIn, x, y, z);
                EZStorage.instance.network.sendTo((IMessage)new MsgStorage(inventory), playerMP);
            }
        }
        return true;
    }
}

