/*
 * Decompiled with CFR 0.152.
 */
package com.zerofall.ezstorage.block;

import com.zerofall.ezstorage.block.BlockStorageCore;
import com.zerofall.ezstorage.block.EZBlock;
import com.zerofall.ezstorage.tileentity.TileEntityStorageCore;
import com.zerofall.ezstorage.util.BlockRef;
import com.zerofall.ezstorage.util.EZStorageUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class StorageMultiblock
extends EZBlock {
    protected StorageMultiblock(String name, Material material) {
        super(name, material);
    }

    public void onBlockDestroyedByPlayer(World worldIn, int x, int y, int z, int meta) {
        super.onBlockDestroyedByPlayer(worldIn, x, y, z, meta);
        this.attemptMultiblock(worldIn, x, y, z, null);
    }

    public void onBlockDestroyedByExplosion(World worldIn, int x, int y, int z, Explosion explosionIn) {
        super.onBlockDestroyedByExplosion(worldIn, x, y, z, explosionIn);
        this.attemptMultiblock(worldIn, x, y, z, null);
    }

    public void onBlockPlacedBy(World worldIn, int x, int y, int z, EntityLivingBase entity, ItemStack itemStack) {
        super.onBlockPlacedBy(worldIn, x, y, z, entity, itemStack);
        this.attemptMultiblock(worldIn, x, y, z, entity);
    }

    public boolean canPlaceBlockAt(World worldIn, int x, int y, int z) {
        if (!worldIn.isRemote) {
            HashSet<TileEntityStorageCore> coreSet = new HashSet<TileEntityStorageCore>();
            BlockRef br = new BlockRef(this, x, y, z);
            this.findMultipleCores(br, worldIn, null, coreSet);
            if (coreSet.size() > 1) {
                return false;
            }
        }
        return super.canPlaceBlockAt(worldIn, x, y, z);
    }

    public void attemptMultiblock(World world, int x, int y, int z, EntityLivingBase entity) {
        BlockRef br;
        TileEntityStorageCore core;
        if (!world.isRemote && !(this instanceof BlockStorageCore) && (core = this.findCore(br = new BlockRef(this, x, y, z), world, null)) != null) {
            core.scanMultiblock(entity);
        }
    }

    public TileEntityStorageCore findCore(BlockRef br, World world, Set<BlockRef> scanned) {
        if (scanned == null) {
            scanned = new HashSet<BlockRef>();
        }
        List<BlockRef> neighbors = EZStorageUtils.getNeighbors(br.posX, br.posY, br.posZ, world);
        for (BlockRef blockRef : neighbors) {
            TileEntityStorageCore entity;
            if (!(blockRef.block instanceof StorageMultiblock)) continue;
            if (blockRef.block instanceof BlockStorageCore) {
                TileEntity te = world.getTileEntity(blockRef.posX, blockRef.posY, blockRef.posZ);
                if (!(te instanceof TileEntityStorageCore)) continue;
                return (TileEntityStorageCore)te;
            }
            if (!scanned.add(blockRef) || (entity = this.findCore(blockRef, world, scanned)) == null) continue;
            return entity;
        }
        return null;
    }

    public void findMultipleCores(BlockRef br, World world, Set<BlockRef> scanned, Set<TileEntityStorageCore> cores) {
        if (scanned == null) {
            scanned = new HashSet<BlockRef>();
        }
        List<BlockRef> neighbors = EZStorageUtils.getNeighbors(br.posX, br.posY, br.posZ, world);
        for (BlockRef blockRef : neighbors) {
            if (!(blockRef.block instanceof StorageMultiblock)) continue;
            if (blockRef.block instanceof BlockStorageCore) {
                TileEntity te = world.getTileEntity(blockRef.posX, blockRef.posY, blockRef.posZ);
                if (!(te instanceof TileEntityStorageCore)) continue;
                cores.add((TileEntityStorageCore)te);
                continue;
            }
            if (!scanned.add(blockRef)) continue;
            this.findMultipleCores(blockRef, world, scanned, cores);
        }
    }
}

