/*
 * Decompiled with CFR 0.152.
 */
package com.zerofall.ezstorage.container;

import com.zerofall.ezstorage.util.EZInventory;
import com.zerofall.ezstorage.util.EZInventoryManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerStorageCore
extends Container {
    public EZInventory inventory = new EZInventory();

    public ContainerStorageCore(EntityPlayer player, EZInventory inventory) {
        this(player);
        this.inventory = inventory;
    }

    public ContainerStorageCore(EntityPlayer player) {
        int startingY = 18;
        int startingX = 8;
        InventoryBasic inventory = new InventoryBasic("Storage Core", false, this.rowCount() * 9);
        for (int i = 0; i < this.rowCount(); ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlotToContainer(new Slot((IInventory)inventory, j + i * 9, startingX + j * 18, startingY + i * 18));
            }
        }
        this.bindPlayerInventory(player.inventory);
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, this.playerInventoryX() + j * 18, this.playerInventoryY() + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlotToContainer(new Slot((IInventory)inventoryPlayer, i, this.playerInventoryX() + i * 18, this.playerInventoryY() + 58));
        }
    }

    public boolean canInteractWith(EntityPlayer playerIn) {
        return true;
    }

    public ItemStack transferStackInSlot(EntityPlayer playerIn, int index) {
        Slot slotObject = (Slot)this.inventorySlots.get(index);
        if (slotObject != null && slotObject.getHasStack()) {
            ItemStack stackInSlot = slotObject.getStack();
            slotObject.putStack(this.inventory.input(stackInSlot));
            EZInventoryManager.sendToClients(this.inventory);
        }
        return null;
    }

    public ItemStack slotClick(int slotId, int clickedButton, int mode, EntityPlayer playerIn) {
        if (slotId < this.rowCount() * 9 && slotId >= 0) {
            return null;
        }
        return super.slotClick(slotId, clickedButton, mode, playerIn);
    }

    public ItemStack customSlotClick(int slotId, int clickedButton, int mode, EntityPlayer playerIn) {
        int itemIndex = slotId;
        ItemStack heldStack = playerIn.inventory.getItemStack();
        if (heldStack == null) {
            ItemStack stack;
            int type = 0;
            if (clickedButton == 1) {
                type = 1;
            }
            if ((stack = this.inventory.getItemsAt(itemIndex, type)) == null) {
                return null;
            }
            if (clickedButton == 0 && mode == 1) {
                if (!this.mergeItemStack(stack, this.rowCount() * 9, this.rowCount() * 9 + 36, true)) {
                    this.inventory.input(stack);
                }
            } else {
                playerIn.inventory.setItemStack(stack);
            }
            return stack;
        }
        playerIn.inventory.setItemStack(this.inventory.input(heldStack));
        return null;
    }

    protected int playerInventoryX() {
        return 8;
    }

    protected int playerInventoryY() {
        return 140;
    }

    protected int rowCount() {
        return 6;
    }

    public void onContainerClosed(EntityPlayer playerIn) {
        super.onContainerClosed(playerIn);
        if (!playerIn.worldObj.isRemote) {
            this.inventory.sort();
            EZInventoryManager.sendToClients(this.inventory);
        }
    }
}

