/*
 * Decompiled with CFR 0.152.
 */
package com.zerofall.ezstorage.gui;

import codechicken.nei.SearchField;
import codechicken.nei.api.ItemFilter;
import com.zerofall.ezstorage.EZStorage;
import com.zerofall.ezstorage.container.ContainerStorageCore;
import com.zerofall.ezstorage.integration.ModIds;
import com.zerofall.ezstorage.network.client.MsgInvSlotClicked;
import com.zerofall.ezstorage.util.EZInventory;
import com.zerofall.ezstorage.util.EZItemRenderer;
import com.zerofall.ezstorage.util.ItemStackCountComparator;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiStorageCore
extends GuiContainer {
    protected static final ResourceLocation creativeInventoryTabs = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    protected static final ResourceLocation searchBar = new ResourceLocation("textures/gui/container/creative_inventory/tab_item_search.png");
    protected static String searchText = "";
    protected EZItemRenderer ezRenderer;
    protected int scrollRow = 0;
    protected float currentScroll;
    protected boolean isScrolling = false;
    protected boolean wasClicking = false;
    protected GuiTextField searchField;
    protected ItemStack mouseOverItem;
    protected List<ItemStack> filteredList;

    public void initGui() {
        super.initGui();
        this.searchField = new GuiTextField(this.fontRendererObj, this.guiLeft + 10, this.guiTop + 6, 80, this.fontRendererObj.FONT_HEIGHT);
        this.searchField.setMaxStringLength(50);
        this.searchField.setEnableBackgroundDrawing(false);
        this.searchField.setTextColor(0xFFFFFF);
        this.searchField.setCanLoseFocus(true);
        this.searchField.setFocused(true);
        this.searchField.setText(searchText);
    }

    public GuiStorageCore(EntityPlayer player, World world, int x, int y, int z) {
        this(new ContainerStorageCore(player), world, x, y, z);
    }

    public GuiStorageCore(ContainerStorageCore containerStorageCore, World world, int x, int y, int z) {
        super((Container)containerStorageCore);
        this.xSize = 195;
        this.ySize = 222;
    }

    public EZInventory getInventory() {
        return ((ContainerStorageCore)this.inventorySlots).inventory;
    }

    protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        this.mc.renderEngine.bindTexture(this.getBackground());
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(x, y, 0, 0, this.xSize, this.ySize);
        this.searchField.setVisible(true);
        this.mc.renderEngine.bindTexture(searchBar);
        this.drawTexturedModalRect(this.guiLeft + 8, this.guiTop + 4, 80, 4, 90, 12);
        this.searchField.drawTextBox();
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        super.drawGuiContainerForegroundLayer(mouseX, mouseY);
        this.handleScrolling(mouseX, mouseY);
        DecimalFormat formatter = new DecimalFormat("#,###");
        String totalCount = formatter.format(this.getInventory().getTotalCount());
        String max = formatter.format(this.getInventory().maxItems);
        String amount = totalCount + "/" + max;
        int stringWidth = this.fontRendererObj.getStringWidth(amount);
        if (stringWidth > 88) {
            float ScaleFactor = 0.7f;
            float RScaleFactor = 1.0f / ScaleFactor;
            GL11.glPushMatrix();
            GL11.glScaled((double)ScaleFactor, (double)ScaleFactor, (double)ScaleFactor);
            int X = (int)((187.0f - (float)stringWidth * ScaleFactor) * RScaleFactor);
            this.fontRendererObj.drawString(amount, X, 10, 0x404040);
            GL11.glPopMatrix();
        } else {
            this.fontRendererObj.drawString(amount, 187 - stringWidth, 6, 0x404040);
        }
        int x = 8;
        int y = 18;
        this.zLevel = 100.0f;
        GuiStorageCore.itemRender.zLevel = 100.0f;
        if (this.ezRenderer == null) {
            this.ezRenderer = new EZItemRenderer();
        }
        this.ezRenderer.zLevel = 200.0f;
        boolean finished = false;
        for (int i = 0; i < this.rowsVisible(); ++i) {
            x = 8;
            for (int j = 0; j < 9; ++j) {
                int index = i * 9 + j;
                if ((index = this.scrollRow * 9 + index) >= this.filteredList.size()) {
                    finished = true;
                    break;
                }
                ItemStack stack = this.filteredList.get(index);
                FontRenderer font = null;
                if (stack != null) {
                    font = stack.getItem().getFontRenderer(stack);
                    if (font == null) {
                        font = this.fontRendererObj;
                    }
                    RenderHelper.enableGUIStandardItemLighting();
                    itemRender.renderItemAndEffectIntoGUI(font, this.mc.getTextureManager(), stack, x, y);
                    this.ezRenderer.renderItemOverlayIntoGUI(font, stack, x, y, "" + stack.stackSize);
                }
                x += 18;
            }
            if (finished) break;
            y += 18;
        }
        int i1 = 175;
        int k = 18;
        int l = k + 108;
        this.mc.getTextureManager().bindTexture(creativeInventoryTabs);
        this.drawTexturedModalRect(i1, k + (int)((float)(l - k - 17) * this.currentScroll), 232, 0, 12, 15);
        this.zLevel = 0.0f;
        GuiStorageCore.itemRender.zLevel = 0.0f;
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        super.drawScreen(mouseX, mouseY, partialTicks);
        this.cacheMouseOverItem(mouseX, mouseY);
    }

    protected void cacheMouseOverItem(int mouseX, int mouseY) {
        ItemStack group;
        Integer slot = this.getSlotAt(mouseX, mouseY);
        if (slot != null && slot < this.filteredList.size() && (group = this.filteredList.get(slot)) != null) {
            this.mouseOverItem = group;
            return;
        }
        this.mouseOverItem = null;
    }

    protected void keyTyped(char typedChar, int keyCode) {
        if (!this.checkHotbarKeys(keyCode)) {
            if (this.searchField.isFocused() && this.searchField.textboxKeyTyped(typedChar, keyCode)) {
                this.updateFilteredItems(true);
            } else {
                super.keyTyped(typedChar, keyCode);
            }
        }
    }

    private void updateFilteredItems(boolean forceFullUpdate) {
        searchText = this.searchField.getText().trim();
        if (this.filteredList == null) {
            this.filteredList = new ArrayList<ItemStack>();
        }
        if (forceFullUpdate || !GuiScreen.isShiftKeyDown()) {
            this.filteredList.clear();
            this.filterItems(searchText, this.getInventory().inventory);
            Collections.sort(this.filteredList, new ItemStackCountComparator());
        } else {
            boolean found;
            ArrayList<ItemStack> listNewStacks = new ArrayList<ItemStack>();
            for (ItemStack stackSrc : this.getInventory().inventory) {
                found = false;
                for (ItemStack stackDest : this.filteredList) {
                    if (!EZInventory.stacksEqual(stackDest, stackSrc)) continue;
                    stackDest.stackSize = stackSrc.stackSize;
                    found = true;
                }
                if (found) continue;
                listNewStacks.add(stackSrc);
            }
            for (ItemStack stackDest : this.filteredList) {
                found = false;
                for (ItemStack stackSrc : this.getInventory().inventory) {
                    if (!EZInventory.stacksEqual(stackDest, stackSrc)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                stackDest.stackSize = 0;
            }
            if (listNewStacks.size() != 0) {
                this.filterItems(searchText, listNewStacks);
            }
        }
    }

    private void filterItems(String searchText, List<ItemStack> input) {
        if (searchText.length() == 0) {
            this.filteredList.addAll(input);
        } else if (ModIds.NEI.isLoaded()) {
            this.filterItemsViaNei(searchText, input);
        } else {
            this.filterItemsViaVanilla(searchText.toLowerCase(), input);
        }
    }

    private void filterItemsViaVanilla(String searchText, List<ItemStack> input) {
        block0: for (ItemStack group : input) {
            List infos = group.getTooltip((EntityPlayer)this.mc.thePlayer, this.mc.gameSettings.advancedItemTooltips);
            for (String info : infos) {
                if (!EnumChatFormatting.getTextWithoutFormattingCodes((String)info).toLowerCase().contains(searchText)) continue;
                this.filteredList.add(group);
                continue block0;
            }
        }
    }

    @Optional.Method(modid="NotEnoughItems")
    private void filterItemsViaNei(String searchText, List<ItemStack> input) {
        ItemFilter filter = SearchField.getFilter((String)searchText);
        for (ItemStack group : input) {
            boolean matches = filter.matches(group);
            if (!matches) continue;
            this.filteredList.add(group);
        }
    }

    private void handleScrolling(int mouseX, int mouseY) {
        boolean flag = Mouse.isButtonDown((int)0);
        int k = this.guiLeft;
        int l = this.guiTop;
        int i1 = k + 175;
        int j1 = l + 18;
        int k1 = i1 + 14;
        int l1 = j1 + 108;
        if (!this.wasClicking && flag && mouseX >= i1 && mouseY >= j1 && mouseX < k1 && mouseY < l1) {
            this.isScrolling = true;
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(mouseY - j1) - 7.5f) / ((float)(l1 - j1) - 15.0f);
            this.currentScroll = MathHelper.clamp_float((float)this.currentScroll, (float)0.0f, (float)1.0f);
            this.scrollTo(this.currentScroll);
        }
    }

    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        Integer slot = this.getSlotAt(mouseX, mouseY);
        if (slot != null) {
            ItemStack group;
            int mode = 0;
            if (GuiScreen.isShiftKeyDown()) {
                mode = 1;
            }
            int index = this.getInventory().slotCount();
            if (slot < this.filteredList.size() && (group = this.filteredList.get(slot)) != null && (index = this.getInventory().getIndexOf(group)) < 0) {
                return;
            }
            EZStorage.instance.network.sendToServer((IMessage)new MsgInvSlotClicked(index, mouseButton, mode));
            ContainerStorageCore container = (ContainerStorageCore)this.inventorySlots;
            container.customSlotClick(index, mouseButton, mode, (EntityPlayer)this.mc.thePlayer);
        } else {
            int elementX = this.searchField.xPosition;
            int elementY = this.searchField.yPosition;
            if (mouseX >= elementX && mouseX <= elementX + this.searchField.width && mouseY >= elementY && mouseY <= elementY + this.searchField.height) {
                if (mouseButton == 1 || GuiScreen.isShiftKeyDown()) {
                    searchText = "";
                    this.searchField.setText(searchText);
                }
                this.searchField.setFocused(true);
            } else {
                this.searchField.setFocused(false);
            }
        }
        super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    private Integer getSlotAt(int x, int y) {
        int row;
        int column;
        int startX = this.guiLeft + 8 - 1;
        int startY = this.guiTop + 18 - 1;
        int clickedX = x - startX;
        int clickedY = y - startY;
        if (clickedX > 0 && clickedY > 0 && (column = clickedX / 18) < 9 && (row = clickedY / 18) < this.rowsVisible()) {
            int slot = row * 9 + column + this.scrollRow * 9;
            return slot;
        }
        return null;
    }

    public void handleMouseInput() {
        super.handleMouseInput();
        int i = Mouse.getEventDWheel();
        if (i != 0) {
            int j = this.getInventory().slotCount() / 9 - this.rowsVisible() + 1;
            if (i > 0) {
                i = 1;
            }
            if (i < 0) {
                i = -1;
            }
            this.currentScroll = (float)((double)this.currentScroll - (double)i / (double)j);
            this.currentScroll = MathHelper.clamp_float((float)this.currentScroll, (float)0.0f, (float)1.0f);
            this.scrollTo(this.currentScroll);
        }
    }

    public void updateScreen() {
        this.updateFilteredItems(false);
        super.updateScreen();
    }

    private void scrollTo(float scroll) {
        int i = (this.getInventory().slotCount() + 8) / 9 - this.rowsVisible();
        int j = (int)((double)(scroll * (float)i) + 0.5);
        if (j < 0) {
            j = 0;
        }
        this.scrollRow = j;
    }

    protected ResourceLocation getBackground() {
        return new ResourceLocation("ezstorage", "textures/gui/storageScrollGui.png");
    }

    public int rowsVisible() {
        return 6;
    }

    public ItemStack getMouseOverItem() {
        return this.mouseOverItem;
    }
}

