/*
 * Decompiled with CFR 0.152.
 */
package com.zerofall.ezstorage.integration.waila;

import com.zerofall.ezstorage.block.BlockStorageCore;
import com.zerofall.ezstorage.tileentity.TileEntityStorageCore;
import com.zerofall.ezstorage.util.EZStorageUtils;
import java.text.DecimalFormat;
import java.util.List;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import tterrag.wailaplugins.api.Plugin;
import tterrag.wailaplugins.plugins.PluginBase;

@Plugin(name="EZStorage", deps={"ezstorage"})
public class WailaPlugins
extends PluginBase {
    private static DecimalFormat formatter = new DecimalFormat("#,###");

    public void load(IWailaRegistrar registerar) {
        super.load(registerar);
        this.registerBody(new Class[]{BlockStorageCore.class});
    }

    public void getBody(ItemStack stack, List<String> tooltip, IWailaDataAccessor accessor) {
        TileEntity tileEntity = accessor.getTileEntity();
        if (tileEntity instanceof TileEntityStorageCore) {
            TileEntityStorageCore core = (TileEntityStorageCore)tileEntity;
            long itemsTotal = core.inventoryItemsStored;
            long itemsMax = core.inventoryItemsMax;
            int typesMax = core.inventoryTypesMax;
            tooltip.add(StatCollector.translateToLocalFormatted((String)"hud.msg.ezstorage.core.itemscount", (Object[])new Object[]{formatter.format(itemsTotal), formatter.format(itemsMax)}));
            if (typesMax != 0 && (long)typesMax < itemsMax) {
                int typesTotal = core.inventoryTypesStored;
                tooltip.add(StatCollector.translateToLocalFormatted((String)"hud.msg.ezstorage.core.typescount", (Object[])new Object[]{formatter.format(typesTotal), formatter.format(typesMax)}));
            }
            if (EZStorageUtils.isShiftDown()) {
                tooltip.add(StatCollector.translateToLocalFormatted((String)"hud.msg.ezstorage.core.inventoryid", (Object[])new Object[]{core.inventoryId}));
            }
        }
    }
}

