/*
 * Decompiled with CFR 0.152.
 */
package com.zerofall.ezstorage.item;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.IBauble;
import baubles.api.expanded.IBaubleExpanded;
import com.gtnewhorizon.gtnhlib.GTNHLib;
import com.zerofall.ezstorage.EZStorage;
import com.zerofall.ezstorage.enums.PortableStoragePanelTier;
import com.zerofall.ezstorage.integration.IntegrationUtils;
import com.zerofall.ezstorage.item.EZItem;
import com.zerofall.ezstorage.network.server.MsgStorage;
import com.zerofall.ezstorage.tileentity.TileEntityStorageCore;
import com.zerofall.ezstorage.util.EZInventory;
import com.zerofall.ezstorage.util.EZInventoryManager;
import com.zerofall.ezstorage.util.EZInventoryReference;
import com.zerofall.ezstorage.util.EZStorageUtils;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

@Optional.InterfaceList(value={@Optional.Interface(modid="Baubles", iface="baubles.api.IBaubles"), @Optional.Interface(modid="Baubles|Expanded", iface="baubles.api.expanded.IBaubleExpanded")})
public class ItemPortableStoragePanel
extends EZItem
implements IBauble,
IBaubleExpanded {
    public ItemPortableStoragePanel() {
        super("portable_storage_terminal");
        this.setMaxStackSize(1);
        this.setMaxDamage(0);
    }

    public int getMetadata(int meta) {
        return meta;
    }

    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int meta, float hitX, float hitY, float hitZ) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityStorageCore) {
            TileEntityStorageCore core = (TileEntityStorageCore)te;
            Item item = itemStack.getItem();
            if (item instanceof ItemPortableStoragePanel) {
                ItemPortableStoragePanel panel = (ItemPortableStoragePanel)item;
                if (!world.isRemote) {
                    panel.setInventoryReference(itemStack, core);
                    if (player instanceof EntityPlayerMP) {
                        EntityPlayerMP playerMP = (EntityPlayerMP)player;
                        GTNHLib.proxy.sendMessageAboveHotbar(playerMP, (IChatComponent)new ChatComponentTranslation("chat.msg.storagecore_connected", new Object[]{core.xCoord, core.yCoord, core.zCoord}), 100, true, true);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public ItemStack onItemRightClick(ItemStack itemStackIn, World worldIn, EntityPlayer player) {
        Item item;
        if (!worldIn.isRemote && (item = itemStackIn.getItem()) instanceof ItemPortableStoragePanel) {
            ItemPortableStoragePanel panel = (ItemPortableStoragePanel)item;
            if (player instanceof EntityPlayerMP) {
                EntityPlayerMP playerMP = (EntityPlayerMP)player;
                boolean found = false;
                boolean inRange = false;
                if (this.validateReference(itemStackIn)) {
                    EZInventoryReference reference = panel.getInventoryReference(itemStackIn);
                    EZInventory inventory = EZInventoryManager.getInventory(reference.inventoryId);
                    if (reference != null && inventory != null) {
                        found = true;
                        if (ItemPortableStoragePanel.isInRange(itemStackIn, reference, playerMP)) {
                            inRange = true;
                            EZStorage.instance.guiHandler.inventoryIds.put((EntityPlayer)playerMP, inventory.id);
                            player.openGui((Object)EZStorage.instance, this.getHasCraftingArea(itemStackIn) && !IntegrationUtils.isSpectatorMode((EntityPlayer)playerMP) ? 2 : 1, (World)reference.getWorld(), reference.blockX, reference.blockY, reference.blockZ);
                            EZStorage.instance.network.sendTo((IMessage)new MsgStorage(inventory), playerMP);
                        }
                    }
                }
                if (!found) {
                    GTNHLib.proxy.sendMessageAboveHotbar(playerMP, (IChatComponent)new ChatComponentTranslation("chat.msg.storagecore_not_found", new Object[0]), 60, true, true);
                } else if (!inRange) {
                    GTNHLib.proxy.sendMessageAboveHotbar(playerMP, (IChatComponent)new ChatComponentTranslation("chat.msg.storagecore_out_of_range", new Object[0]), 60, true, true);
                }
            }
        }
        return itemStackIn;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List<String> tooltip, boolean shiftPressed) {
        Item item = itemStack.getItem();
        if (item instanceof ItemPortableStoragePanel) {
            ItemPortableStoragePanel panel = (ItemPortableStoragePanel)item;
            shiftPressed = EZStorageUtils.isShiftDown();
            PortableStoragePanelTier tier = panel.getTier(itemStack);
            EZInventoryReference reference = panel.getInventoryReference(itemStack);
            boolean hasCrafting = panel.getHasCraftingArea(itemStack);
            boolean connected = reference != null && reference.inventoryId != null;
            String strConnected = connected ? "\u00a72" + StatCollector.translateToLocal((String)"hud.msg.ezstorage.portable.status.connected") + "\u00a7r" : "\u00a74" + StatCollector.translateToLocal((String)"hud.msg.ezstorage.portable.status.notconnected") + "\u00a7r";
            tooltip.add(StatCollector.translateToLocalFormatted((String)"hud.msg.ezstorage.portable.status", (Object[])new Object[]{strConnected}));
            if (reference != null && connected && shiftPressed) {
                tooltip.add("  ID: " + reference.inventoryId);
                tooltip.add("  Dim: " + reference.blockDimId);
                tooltip.add("  X: " + reference.blockX);
                tooltip.add("  Y: " + reference.blockY);
                tooltip.add("  Z: " + reference.blockZ);
            }
            if (tier != null) {
                String strRange = tier.isInfinity ? "\u00a72\u221e" : "\u00a7f" + tier.range;
                tooltip.add(StatCollector.translateToLocalFormatted((String)"hud.msg.ezstorage.portable.range", (Object[])new Object[]{strRange}) + "\u00a7r");
            }
            String strCrafting = hasCrafting ? "\u00a72" + StatCollector.translateToLocal((String)"hud.msg.ezstorage.portable.crafting.enabled") + "\u00a7r" : "\u00a74" + StatCollector.translateToLocal((String)"hud.msg.ezstorage.portable.crafting.disabled") + "\u00a7r";
            tooltip.add(StatCollector.translateToLocalFormatted((String)"hud.msg.ezstorage.portable.crafting", (Object[])new Object[]{strCrafting}));
        }
    }

    public PortableStoragePanelTier getTier(ItemStack stack) {
        return PortableStoragePanelTier.getTierFromMeta(this.getDamage(stack));
    }

    public void setTier(ItemStack itemStack, PortableStoragePanelTier tier) {
        this.setDamage(itemStack, tier.meta);
    }

    public boolean getHasCraftingArea(ItemStack itemStack) {
        NBTTagCompound tag = itemStack.getTagCompound();
        if (tag != null) {
            return tag.getBoolean("hasCraftingArea");
        }
        return false;
    }

    public void setHasCraftingArea(ItemStack itemStack, boolean hasCraftingArea) {
        NBTTagCompound tag = itemStack.getTagCompound();
        if (tag == null) {
            tag = new NBTTagCompound();
            itemStack.setTagCompound(tag);
        }
        tag.setBoolean("hasCraftingArea", hasCraftingArea);
    }

    public EZInventoryReference getInventoryReference(ItemStack itemStack) {
        NBTTagCompound tag = itemStack.getTagCompound();
        if (tag != null && tag.hasKey("reference")) {
            NBTTagCompound tagCore = tag.getCompoundTag("reference");
            String id = tagCore.getString("inventoryId");
            int dimId = tagCore.getInteger("blockDimId");
            int x = tagCore.getInteger("blockX");
            int y = tagCore.getInteger("blockY");
            int z = tagCore.getInteger("blockZ");
            return new EZInventoryReference(id, dimId, x, y, z);
        }
        return null;
    }

    public void setInventoryReference(ItemStack itemStack, TileEntityStorageCore core) {
        if (core == null) {
            NBTTagCompound tag = itemStack.getTagCompound();
            if (tag != null) {
                tag.removeTag("core");
            }
        } else if (core.getWorldObj() != null) {
            NBTTagCompound tag = itemStack.getTagCompound();
            if (tag == null) {
                tag = new NBTTagCompound();
                itemStack.setTagCompound(tag);
            }
            NBTTagCompound tagCore = new NBTTagCompound();
            tagCore.setString("inventoryId", core.getInventory().id);
            tagCore.setInteger("blockDimId", core.getWorldObj().provider.dimensionId);
            tagCore.setInteger("blockX", core.xCoord);
            tagCore.setInteger("blockY", core.yCoord);
            tagCore.setInteger("blockZ", core.zCoord);
            tag.setTag("reference", (NBTBase)tagCore);
        }
    }

    public boolean validateReference(ItemStack itemStackPanel) {
        TileEntity te;
        EZInventoryReference reference = this.getInventoryReference(itemStackPanel);
        if (reference == null) {
            return false;
        }
        WorldServer dim = reference.getWorld();
        if (!(dim == null || !dim.blockExists(reference.blockX, reference.blockY, reference.blockZ) || (te = dim.getTileEntity(reference.blockX, reference.blockY, reference.blockZ)) instanceof TileEntityStorageCore && ((TileEntityStorageCore)te).inventoryId.equals(reference.inventoryId))) {
            this.setInventoryReference(itemStackPanel, null);
            return false;
        }
        return reference.inventoryId != null && !reference.inventoryId.equals("");
    }

    public static boolean isInRange(ItemStack itemStackPanel, EZInventoryReference reference, EntityPlayerMP player) {
        Item item = itemStackPanel.getItem();
        if (!(item instanceof ItemPortableStoragePanel)) {
            return false;
        }
        ItemPortableStoragePanel panel = (ItemPortableStoragePanel)item;
        PortableStoragePanelTier tier = panel.getTier(itemStackPanel);
        if (tier.isInfinity) {
            return true;
        }
        if (reference.blockDimId != player.worldObj.provider.dimensionId) {
            return false;
        }
        double offX = (double)reference.blockX - player.posX;
        double offY = (double)reference.blockY - player.posY;
        double offZ = (double)reference.blockZ - player.posZ;
        double r = offX * offX + offY * offY + offZ * offZ;
        double rangeLimit = tier.range * tier.range;
        return !(r > rangeLimit);
    }

    @Optional.Method(modid="Baubles")
    public boolean canEquip(ItemStack itemStack, EntityLivingBase player) {
        return true;
    }

    @Optional.Method(modid="Baubles")
    public boolean canUnequip(ItemStack itemStack, EntityLivingBase player) {
        return true;
    }

    @Optional.Method(modid="Baubles")
    public BaubleType getBaubleType(ItemStack itemStack) {
        return BaubleType.AMULET;
    }

    @Optional.Method(modid="Baubles")
    public void onEquipped(ItemStack itemStack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public void onUnequipped(ItemStack itemStack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public void onWornTick(ItemStack itemStack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles|Expanded")
    public String[] getBaubleTypes(ItemStack itemStack) {
        return new String[]{"universal", "amulet", "ring", "belt"};
    }

    @Optional.Method(modid="Baubles")
    public static ItemStack getFromBaubles(EntityLivingBase entity) {
        if (!(entity instanceof EntityPlayer)) {
            return null;
        }
        IInventory baubles = BaublesApi.getBaubles((EntityPlayer)((EntityPlayer)entity));
        int invSize = baubles.getSizeInventory();
        for (int i = 0; i < invSize; ++i) {
            ItemStack ring = baubles.getStackInSlot(i);
            if (ring == null || !(ring.getItem() instanceof ItemPortableStoragePanel)) continue;
            return ring;
        }
        return null;
    }
}

