/*
 * Decompiled with CFR 0.152.
 */
package com.zerofall.ezstorage.recipes;

import com.zerofall.ezstorage.enums.PortableStoragePanelTier;
import com.zerofall.ezstorage.init.EZBlocks;
import com.zerofall.ezstorage.item.ItemPortableStoragePanel;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class PortableStoragePanelUpgradeRecipe
implements IRecipe {
    private ItemStack result;

    public boolean matches(InventoryCrafting craftingGridInventory, World world) {
        this.result = null;
        ItemStack panelStack = null;
        ItemPortableStoragePanel panelItem = null;
        boolean hasRedstone = false;
        boolean hasUpgradeItem = false;
        boolean hasCraftingUpgrade = false;
        PortableStoragePanelTier tier = null;
        PortableStoragePanelTier nextTier = null;
        Item upgradeItem = null;
        for (int i = 0; i < craftingGridInventory.getSizeInventory(); ++i) {
            Block slotBlock;
            ItemStack slotStack = craftingGridInventory.getStackInSlot(i);
            if (slotStack == null) continue;
            Item slotItem = slotStack.getItem();
            Block block = slotBlock = slotItem instanceof ItemBlock ? ((ItemBlock)slotItem).field_150939_a : null;
            if (panelStack == null && slotItem instanceof ItemPortableStoragePanel) {
                ItemPortableStoragePanel panel = (ItemPortableStoragePanel)slotItem;
                panelItem = panel;
                panelStack = slotStack;
                tier = panelItem.getTier(panelStack);
                nextTier = PortableStoragePanelTier.getNextTier(tier);
                if (nextTier == null) continue;
                upgradeItem = PortableStoragePanelUpgradeRecipe.getUpgradeItem(nextTier);
                continue;
            }
            if (!hasRedstone && slotBlock == Blocks.redstone_block) {
                hasRedstone = true;
                continue;
            }
            if (!hasUpgradeItem && slotItem == upgradeItem) {
                hasUpgradeItem = true;
                continue;
            }
            if (hasCraftingUpgrade || slotBlock != EZBlocks.crafting_box) break;
            hasCraftingUpgrade = true;
        }
        if (panelStack != null && panelItem != null && hasRedstone) {
            if (hasUpgradeItem && tier != null && nextTier != null) {
                this.result = panelStack.copy();
                panelItem.setTier(this.result, nextTier);
                return true;
            }
            if (hasCraftingUpgrade) {
                this.result = panelStack.copy();
                panelItem.setHasCraftingArea(this.result, true);
                return true;
            }
        }
        return false;
    }

    public ItemStack getCraftingResult(InventoryCrafting p_77572_1_) {
        if (this.result != null) {
            return this.result.copy();
        }
        return null;
    }

    public int getRecipeSize() {
        return 3;
    }

    public ItemStack getRecipeOutput() {
        return this.result;
    }

    private static Item getUpgradeItem(PortableStoragePanelTier tier) {
        switch (tier) {
            case TIER_2: {
                return Items.ender_pearl;
            }
            case TIER_3: {
                return Items.ender_eye;
            }
            case TIER_INFINITY: {
                return Items.nether_star;
            }
        }
        return Items.ender_eye;
    }
}

