/*
 * Decompiled with CFR 0.152.
 */
package com.zerofall.ezstorage.tileentity;

import com.zerofall.ezstorage.configuration.EZConfiguration;
import com.zerofall.ezstorage.tileentity.TileEntityStorageCore;
import com.zerofall.ezstorage.util.EZInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class TileEntityInventoryProxy
extends TileEntity
implements ISidedInventory {
    public TileEntityStorageCore core;

    public EZInventory getInventory() {
        if (this.core != null) {
            return this.core.getInventory();
        }
        return null;
    }

    public int getSizeInventory() {
        EZInventory inventory = this.getInventory();
        if (inventory == null) {
            return 1;
        }
        int size = inventory.inventory.size();
        if (inventory.getTotalCount() < inventory.maxItems && (EZConfiguration.maxItemTypes == 0 || inventory.slotCount() < EZConfiguration.maxItemTypes)) {
            ++size;
        }
        return size;
    }

    public ItemStack getStackInSlot(int index) {
        EZInventory inventory = this.getInventory();
        if (inventory != null && index < inventory.inventory.size()) {
            return inventory.inventory.get(index);
        }
        return null;
    }

    public ItemStack decrStackSize(int index, int count) {
        EZInventory inventory = this.getInventory();
        if (inventory == null) {
            return null;
        }
        ItemStack result = inventory.getItemStackAt(index, count);
        this.core.updateTileEntity();
        return result;
    }

    public void setInventorySlotContents(int index, ItemStack stack) {
        EZInventory inventory = this.getInventory();
        if (inventory == null) {
            return;
        }
        if (stack == null || stack.stackSize == 0) {
            inventory.inventory.remove(index);
        } else if (index >= inventory.inventory.size()) {
            inventory.input(stack);
        } else if (this.isItemValidForSlot(index, stack)) {
            inventory.inventory.set(index, stack);
        } else {
            return;
        }
        this.core.updateTileEntity();
    }

    public int getInventoryStackLimit() {
        EZInventory inventory = this.getInventory();
        if (inventory == null) {
            return 0;
        }
        return (int)Math.min(inventory.maxItems, Integer.MAX_VALUE);
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        ItemStack group;
        EZInventory inventory = this.getInventory();
        if (inventory == null) {
            return false;
        }
        int foundIndex = -1;
        int itemsCount = inventory.inventory.size();
        for (int i = 0; i < itemsCount; ++i) {
            ItemStack group2 = inventory.inventory.get(i);
            if (!EZInventory.stacksEqual(group2, stack)) continue;
            foundIndex = i;
        }
        if (index >= inventory.inventory.size()) {
            return true;
        }
        if (foundIndex == index) {
            return true;
        }
        return index == -1 && ((group = inventory.inventory.get(index)) == null || group.stackSize == 0);
    }

    public boolean canInsertItem(int index, ItemStack stack, int direction) {
        return this.isItemValidForSlot(index, stack);
    }

    public boolean canExtractItem(int index, ItemStack stack, int direction) {
        EZInventory inventory = this.getInventory();
        if (inventory == null) {
            return false;
        }
        if (index >= inventory.inventory.size()) {
            return false;
        }
        ItemStack theGroup = inventory.inventory.get(index);
        return theGroup != null && EZInventory.stacksEqual(theGroup, stack);
    }

    public String getInventoryName() {
        return "proxy_port";
    }

    public int[] getAccessibleSlotsFromSide(int p_94128_1_) {
        int size = this.getSizeInventory();
        int[] slots = new int[size];
        for (int i = 0; i < size; ++i) {
            slots[i] = i;
        }
        return slots;
    }

    public ItemStack getStackInSlotOnClosing(int index) {
        ItemStack stack = this.getStackInSlot(index);
        if (stack != null) {
            this.setInventorySlotContents(index, null);
            this.core.updateTileEntity();
        }
        return stack;
    }

    public boolean hasCustomInventoryName() {
        return false;
    }
}

