/*
 * Decompiled with CFR 0.152.
 */
package com.zerofall.ezstorage.tileentity;

import com.zerofall.ezstorage.block.BlockCraftingBox;
import com.zerofall.ezstorage.block.BlockInputPort;
import com.zerofall.ezstorage.block.BlockStorage;
import com.zerofall.ezstorage.block.BlockStorageCore;
import com.zerofall.ezstorage.block.StorageMultiblock;
import com.zerofall.ezstorage.configuration.EZConfiguration;
import com.zerofall.ezstorage.init.EZBlocks;
import com.zerofall.ezstorage.tileentity.TileEntityInventoryProxy;
import com.zerofall.ezstorage.util.BlockRef;
import com.zerofall.ezstorage.util.EZInventory;
import com.zerofall.ezstorage.util.EZInventoryManager;
import com.zerofall.ezstorage.util.EZStorageUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class TileEntityStorageCore
extends TileEntity {
    private EZInventory inventory;
    Set<BlockRef> multiblock = new HashSet<BlockRef>();
    private boolean firstTick = false;
    public boolean hasCraftBox = false;
    public String inventoryId = "";
    public long inventoryItemsStored;
    public long inventoryItemsMax;
    public int inventoryTypesStored;
    public int inventoryTypesMax;

    public EZInventory getInventory() {
        return this.getInventory(false);
    }

    private EZInventory getInventory(boolean allowCreate) {
        if (this.inventory == null) {
            this.inventory = EZInventoryManager.getInventory(this.inventoryId);
            if (this.inventory == null && allowCreate) {
                this.inventory = EZInventoryManager.createInventory();
                this.inventoryId = this.inventory.id;
            }
        }
        return this.inventory;
    }

    public void updateTileEntity(boolean sendInventoryToClients) {
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        this.markDirty();
        if (sendInventoryToClients) {
            EZInventoryManager.sendToClients(this.inventory, false);
        }
    }

    public void updateTileEntity() {
        this.updateTileEntity(true);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound nbtTag = pkt.func_148857_g();
        this.readFromNBT(nbtTag);
        this.inventoryItemsStored = nbtTag.getLong("inventoryItemsStored");
        this.inventoryItemsMax = nbtTag.getLong("inventoryItemsMax");
        this.inventoryTypesStored = nbtTag.getInteger("inventoryTypesStored");
        this.inventoryTypesMax = nbtTag.getInteger("inventoryTypesMax");
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.writeToNBT(nbtTag);
        EZInventory inventory = this.getInventory(true);
        if (inventory != null) {
            nbtTag.setLong("inventoryItemsStored", inventory.getTotalCount());
            nbtTag.setLong("inventoryItemsMax", inventory.maxItems);
            nbtTag.setInteger("inventoryTypesStored", inventory.slotCount());
            nbtTag.setInteger("inventoryTypesMax", EZConfiguration.maxItemTypes);
        }
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, this.getBlockMetadata(), nbtTag);
    }

    public void writeToNBT(NBTTagCompound paramNBTTagCompound) {
        super.writeToNBT(paramNBTTagCompound);
        paramNBTTagCompound.setString("inventoryId", this.inventoryId);
    }

    public void readFromNBT(NBTTagCompound paramNBTTagCompound) {
        super.readFromNBT(paramNBTTagCompound);
        this.inventoryId = paramNBTTagCompound.getString("inventoryId");
        if (paramNBTTagCompound.hasKey("Internal")) {
            EZInventory inventory = new EZInventory();
            inventory.readFromNBT(paramNBTTagCompound);
            EZInventoryManager.createInventory(inventory);
            this.inventoryId = inventory.id;
        }
    }

    public void scanMultiblock(EntityLivingBase entity) {
        EZInventory inventory = this.getInventory(true);
        inventory.maxItems = 0L;
        this.hasCraftBox = false;
        this.multiblock = new HashSet<BlockRef>();
        BlockRef ref = new BlockRef(this);
        this.multiblock.add(ref);
        this.getValidNeighbors(ref, entity);
        for (BlockRef blockRef : this.multiblock) {
            Block block = blockRef.block;
            if (!(block instanceof BlockStorage)) continue;
            BlockStorage sb = (BlockStorage)block;
            inventory.maxItems += (long)sb.getCapacity();
        }
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
    }

    private void getValidNeighbors(BlockRef br, EntityLivingBase entity) {
        List<BlockRef> neighbors = EZStorageUtils.getNeighbors(br.posX, br.posY, br.posZ, this.worldObj);
        for (BlockRef blockRef : neighbors) {
            TileEntity te;
            if (!(blockRef.block instanceof StorageMultiblock) || !this.multiblock.add(blockRef) || !this.validateSystem(entity)) continue;
            if (blockRef.block instanceof BlockInputPort && (te = this.worldObj.getTileEntity(blockRef.posX, blockRef.posY, blockRef.posZ)) instanceof TileEntityInventoryProxy) {
                TileEntityInventoryProxy teInvProxy = (TileEntityInventoryProxy)te;
                teInvProxy.core = this;
            }
            if (blockRef.block instanceof BlockCraftingBox) {
                this.hasCraftBox = true;
            }
            this.getValidNeighbors(blockRef, entity);
        }
    }

    public boolean validateSystem(EntityLivingBase entity) {
        int count = 0;
        for (BlockRef ref : this.multiblock) {
            if (ref.block instanceof BlockStorageCore) {
                ++count;
            }
            if (count <= 1 || !(this.worldObj.getBlock(this.xCoord, this.yCoord, this.zCoord) instanceof BlockStorageCore)) continue;
            this.worldObj.setBlockToAir(this.xCoord, this.yCoord, this.zCoord);
            this.worldObj.spawnEntityInWorld((Entity)new EntityItem(this.worldObj, (double)this.xCoord, (double)this.yCoord, (double)this.zCoord, new ItemStack(EZBlocks.storage_core)));
            return false;
        }
        return true;
    }

    public boolean isPartOfMultiblock(BlockRef blockRef) {
        return this.multiblock != null && this.multiblock.contains(blockRef);
    }

    public void updateEntity() {
        if (!this.firstTick && this.worldObj != null) {
            this.firstTick = true;
            if (!this.worldObj.isRemote) {
                this.scanMultiblock(null);
            }
        }
    }
}

