/*
 * Decompiled with CFR 0.152.
 */
package com.zerofall.ezstorage.util;

import com.zerofall.ezstorage.configuration.EZConfiguration;
import com.zerofall.ezstorage.util.ItemStackCountComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class EZInventory {
    private boolean hasChanges;
    public List<ItemStack> inventory = new ArrayList<ItemStack>();
    public long maxItems = 0L;
    public String id;
    public boolean disabled;

    public boolean getHasChanges() {
        return this.hasChanges;
    }

    public void setHasChanges() {
        this.hasChanges = true;
    }

    public void resetHasChanges() {
        this.hasChanges = false;
    }

    public ItemStack input(ItemStack itemStack) {
        if (this.getTotalCount() >= this.maxItems) {
            return itemStack;
        }
        long space = this.maxItems - this.getTotalCount();
        int amount = (int)Math.min(space, (long)itemStack.stackSize);
        ItemStack stack = this.mergeStack(itemStack, amount);
        this.setHasChanges();
        return stack;
    }

    public void sort() {
        Collections.sort(this.inventory, new ItemStackCountComparator());
        this.setHasChanges();
    }

    private ItemStack mergeStack(ItemStack itemStack, int amount) {
        boolean found = false;
        for (ItemStack group : this.inventory) {
            if (!EZInventory.stacksEqual(group, itemStack)) continue;
            group.stackSize += amount;
            this.setHasChanges();
            found = true;
            break;
        }
        if (!found) {
            if (EZConfiguration.maxItemTypes != 0 && this.slotCount() > EZConfiguration.maxItemTypes) {
                return null;
            }
            ItemStack copy = itemStack.copy();
            copy.stackSize = amount;
            this.inventory.add(copy);
            this.setHasChanges();
        }
        itemStack.stackSize -= amount;
        if (itemStack.stackSize <= 0) {
            return null;
        }
        return itemStack;
    }

    public ItemStack getItemsAt(int index, int type) {
        if (index >= this.inventory.size()) {
            return null;
        }
        ItemStack group = this.inventory.get(index);
        ItemStack stack = group.copy();
        int size = Math.min(stack.getMaxStackSize(), group.stackSize);
        if (size > 1) {
            if (type == 1) {
                size /= 2;
            } else if (type == 2) {
                size = 1;
            }
        }
        stack.stackSize = size;
        group.stackSize -= size;
        if (group.stackSize <= 0) {
            this.inventory.remove(index);
        }
        this.setHasChanges();
        return stack;
    }

    public ItemStack getItemStackAt(int index, int size) {
        if (index >= this.inventory.size()) {
            return null;
        }
        ItemStack group = this.inventory.get(index);
        ItemStack stack = group.copy();
        if (size > group.stackSize) {
            size = group.stackSize;
        }
        stack.stackSize = size;
        group.stackSize -= size;
        if (group.stackSize <= 0) {
            this.inventory.remove(index);
        }
        this.setHasChanges();
        return stack;
    }

    public ItemStack getItems(ItemStack[] itemStacks) {
        for (ItemStack group : this.inventory) {
            for (ItemStack itemStack : itemStacks) {
                if (!EZInventory.stacksEqual(group, itemStack)) continue;
                if (group.stackSize >= itemStack.stackSize) {
                    ItemStack stack = group.copy();
                    stack.stackSize = itemStack.stackSize;
                    group.stackSize -= itemStack.stackSize;
                    if (group.stackSize <= 0) {
                        this.inventory.remove(group);
                    }
                    this.setHasChanges();
                    return stack;
                }
                return null;
            }
        }
        return null;
    }

    public int getIndexOf(ItemStack itemStack) {
        int index = this.inventory.indexOf(itemStack);
        if (index == -1) {
            for (ItemStack inventoryStack : this.inventory) {
                ++index;
                if (!EZInventory.stacksEqual(itemStack, inventoryStack)) continue;
                return index;
            }
        }
        return index;
    }

    public int slotCount() {
        return this.inventory.size();
    }

    public static boolean stacksEqual(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null && stack2 == null) {
            return true;
        }
        if (stack1 == null || stack2 == null) {
            return false;
        }
        if (stack1.getItem() != stack2.getItem()) {
            return false;
        }
        if (stack1.getItemDamage() != stack2.getItemDamage()) {
            return false;
        }
        NBTTagCompound stack1Tag = stack1.getTagCompound();
        NBTTagCompound stack2Tag = stack2.getTagCompound();
        if (stack1Tag == null && stack2Tag == null) {
            return true;
        }
        if (stack1Tag == null || stack2Tag == null) {
            return false;
        }
        return stack1Tag.equals((Object)stack2Tag);
    }

    public long getTotalCount() {
        long count = 0L;
        for (ItemStack group : this.inventory) {
            count += (long)group.stackSize;
        }
        return count;
    }

    public String toString() {
        return this.inventory.toString();
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.slotCount(); ++i) {
            ItemStack group = this.inventory.get(i);
            if (group == null || group.stackSize <= 0) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            group.writeToNBT(nbttagcompound1);
            nbttagcompound1.setInteger("InternalCount", group.stackSize);
            nbttaglist.appendTag((NBTBase)nbttagcompound1);
        }
        tag.setTag("Internal", (NBTBase)nbttaglist);
        tag.setLong("InternalMax", this.maxItems);
        tag.setBoolean("isDisabled", this.disabled);
    }

    public void readFromNBT(NBTTagCompound tag) {
        NBTTagList nbttaglist = tag.getTagList("Internal", 10);
        if (nbttaglist != null) {
            this.inventory = new ArrayList<ItemStack>();
            for (int i = 0; i < nbttaglist.tagCount(); ++i) {
                NBTTagCompound nbttagcompound1 = nbttaglist.getCompoundTagAt(i);
                ItemStack stack = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbttagcompound1);
                if (nbttagcompound1.hasKey("InternalCount", 3)) {
                    stack.stackSize = nbttagcompound1.getInteger("InternalCount");
                } else if (nbttagcompound1.hasKey("InternalCount", 4)) {
                    stack.stackSize = (int)nbttagcompound1.getLong("InternalCount");
                }
                this.inventory.add(stack);
            }
        }
        this.maxItems = tag.getLong("InternalMax");
        this.disabled = tag.getBoolean("isDisabled");
    }
}

