/*
 * Decompiled with CFR 0.152.
 */
package com.zerofall.ezstorage.util;

import com.zerofall.ezstorage.EZStorage;
import com.zerofall.ezstorage.container.ContainerStorageCore;
import com.zerofall.ezstorage.network.server.MsgStorage;
import com.zerofall.ezstorage.tileentity.TileEntityStorageCore;
import com.zerofall.ezstorage.util.EZInventory;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class EZInventoryManager {
    private static final HashSet<EZInventory> inventories = new HashSet();

    public static EZInventory createInventory() {
        return EZInventoryManager.createInventory(new EZInventory());
    }

    public static EZInventory createInventory(EZInventory inventory) {
        if (!inventories.contains(inventory)) {
            inventory.id = UUID.randomUUID().toString();
            inventories.add(inventory);
        }
        inventory.setHasChanges();
        return inventory;
    }

    public static EZInventory getInventory(String id) {
        EZInventory inventory2;
        for (EZInventory inventory2 : inventories) {
            if (!inventory2.id.equals(id)) continue;
            return inventory2;
        }
        NBTTagCompound tag = EZInventoryManager.readFromFile(EZInventoryManager.getFilePath(id));
        if (tag != null && (inventory2 = new EZInventory()) != null) {
            inventory2.readFromNBT(tag);
            inventory2.resetHasChanges();
            inventory2.id = id;
            inventories.add(inventory2);
            return inventory2;
        }
        return null;
    }

    public static void saveInventories() {
        HashMap<String, NBTTagCompound> cache = new HashMap<String, NBTTagCompound>();
        for (EZInventory inventory : inventories) {
            if (!inventory.getHasChanges()) continue;
            NBTTagCompound tag = new NBTTagCompound();
            inventory.writeToNBT(tag);
            inventory.resetHasChanges();
            cache.put(inventory.id, tag);
        }
        if (!cache.isEmpty()) {
            new Thread(() -> {
                HashSet<EZInventory> hashSet = inventories;
                synchronized (hashSet) {
                    for (Map.Entry kvp : cache.entrySet()) {
                        File file = EZInventoryManager.getFilePath((String)kvp.getKey());
                        EZInventoryManager.saveToFile((NBTTagCompound)kvp.getValue(), file);
                    }
                }
            }).start();
        }
    }

    public static void saveInventory(EZInventory inventory) {
        if (inventories.contains(inventory) && inventory.getHasChanges()) {
            NBTTagCompound tag = new NBTTagCompound();
            inventory.writeToNBT(tag);
            inventory.resetHasChanges();
            File file = EZInventoryManager.getFilePath(inventory.id);
            new Thread(() -> {
                HashSet<EZInventory> hashSet = inventories;
                synchronized (hashSet) {
                    EZInventoryManager.saveToFile(tag, file);
                }
            }).start();
        }
    }

    public static void deleteInventory(EZInventory inventory) {
        if (inventories.remove(inventory)) {
            File file = EZInventoryManager.getFilePath(inventory.id);
            new Thread(() -> {
                HashSet<EZInventory> hashSet = inventories;
                synchronized (hashSet) {
                    file.delete();
                }
            }).start();
        }
    }

    private static File getFilePath(String id) {
        File worldDir = DimensionManager.getCurrentSaveRootDirectory();
        File inventoryDir = new File(worldDir, "ezstorage/inventories");
        inventoryDir.mkdirs();
        return new File(inventoryDir, id.toString() + ".dat");
    }

    private static void saveToFile(NBTTagCompound tag, File file) {
        File fileNew = new File(file + ".new");
        File fileOld = new File(file + ".old");
        try {
            FileOutputStream outputStream = new FileOutputStream(fileNew);
            CompressedStreamTools.writeCompressed((NBTTagCompound)tag, (OutputStream)outputStream);
            outputStream.close();
            if (fileOld.exists()) {
                fileOld.delete();
            }
            file.renameTo(fileOld);
            if (file.exists()) {
                file.delete();
            }
            if (!fileNew.renameTo(file)) {
                throw new IOException("Couldn't rename new temporary file.");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            EZStorage.instance.LOG.warn("Couldn't write inventory to file system.", (Throwable)ex);
        }
    }

    private static NBTTagCompound readFromFile(File file) {
        FileInputStream inputStream;
        File fileOld = new File(file + ".old");
        NBTTagCompound tag = null;
        if (file.exists()) {
            try {
                inputStream = new FileInputStream(file);
                tag = CompressedStreamTools.readCompressed((InputStream)inputStream);
                inputStream.close();
            }
            catch (IOException ex) {
                EZStorage.instance.LOG.warn("Couldn't read inventory file. Try falling back to backup, if exists.", (Throwable)ex);
                ex.printStackTrace();
            }
        }
        if (tag == null && fileOld.exists()) {
            try {
                inputStream = new FileInputStream(fileOld);
                tag = CompressedStreamTools.readCompressed((InputStream)inputStream);
                inputStream.close();
            }
            catch (IOException ex) {
                EZStorage.instance.LOG.warn("Couldn't read inventory backup file.", (Throwable)ex);
                ex.printStackTrace();
            }
        }
        return tag;
    }

    public static void sendToClients(EZInventory inventory) {
        EZInventoryManager.sendToClients(inventory, true);
    }

    public static void sendToClients(EZInventory inventory, boolean checkTileEntities) {
        if (inventory == null || !inventories.contains(inventory)) {
            return;
        }
        MinecraftServer server = MinecraftServer.getServer();
        if (server == null) {
            return;
        }
        for (WorldServer world : server.worldServers) {
            for (EntityPlayer player : world.playerEntities) {
                if (!(player.openContainer instanceof ContainerStorageCore) || !(player instanceof EntityPlayerMP)) continue;
                EntityPlayerMP playerMP = (EntityPlayerMP)player;
                EZStorage.instance.network.sendTo((IMessage)new MsgStorage(inventory), playerMP);
            }
            if (!checkTileEntities) continue;
            for (TileEntity tileEntity : world.loadedTileEntityList) {
                TileEntityStorageCore core;
                if (!(tileEntity instanceof TileEntityStorageCore) || (core = (TileEntityStorageCore)tileEntity).getInventory() != inventory) continue;
                core.updateTileEntity(false);
            }
        }
    }
}

