/*
 * Decompiled with CFR 0.152.
 */
package codes.atomys.advr;

import codes.atomys.advr.config.Configuration;
import java.lang.reflect.Field;

public enum TabPlacement {
    ABOVE(26, 26, 5, 5),
    BELOW(26, 26, 5, 5);

    private final int width;
    private final int height;
    private final int topMargin;
    private final int leftMargin;

    private TabPlacement(int width, int height, int topMargin, int leftMargin) {
        this.width = width;
        this.height = height;
        this.topMargin = topMargin;
        this.leftMargin = leftMargin;
    }

    public int getTabLimit() {
        return this.getDynamicLimit();
    }

    private int getDynamicLimit() {
        String fieldName = this.name().toLowerCase() + "WidgetLimit";
        try {
            Field field = Configuration.class.getField(fieldName);
            return (Integer)field.get(Configuration.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 14;
        }
    }

    public int getTabX(int index) {
        switch (this.ordinal()) {
            case 0: {
                return (this.width + 2) * index;
            }
            case 1: {
                if (Configuration.aboveWidgetLimit <= index) {
                    return (this.width + 2) * (index - Configuration.aboveWidgetLimit);
                }
                return (this.width + 2) * index;
            }
        }
        throw new UnsupportedOperationException("Don't know what this tab type is!" + String.valueOf((Object)this));
    }

    public int getTabY(int index) {
        switch (this.ordinal()) {
            case 0: {
                return -this.height + 4;
            }
            case 1: {
                return -4;
            }
        }
        throw new UnsupportedOperationException("Don't know what this tab type is!" + String.valueOf((Object)this));
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }
}

