package me.emafire003.dev.coloredglowlib.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.LiteralCommandNode;
import me.emafire003.dev.coloredglowlib.compat.permissions.PermissionsChecker;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_7157;

public class CGLCommands {


    //Based on Factions' code https://github.com/ickerio/factions
    public static void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        LiteralCommandNode<class_2168> cgl_commands = class_2170
                .method_9247("cgl")
                .build();

        LiteralCommandNode<class_2168> alias = class_2170
                .method_9247("coloredglowlib")
                .requires(PermissionsChecker.hasPerms("coloredglowlib.commands", 2))
                .build();

        dispatcher.getRoot().addChild(cgl_commands);
        dispatcher.getRoot().addChild(alias);

        CGLCommand[] commands = new CGLCommand[] {
                new SetGlowColorCommand(),
                new SettingsCommand(),
                new ClearGlowColorCommand()
        };

        for (CGLCommand command : commands) {
            cgl_commands.addChild(command.getNode(registryAccess));
            alias.addChild(command.getNode(registryAccess));
        }
    }
}
